/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.image;

import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.runtimes.DockerRuntimeDetailsProvider;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.docker.view.details.image.ImagePullPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/view/details/image/DockerImagesGroupDetailsProvider;", "Lcom/intellij/docker/runtimes/DockerRuntimeDetailsProvider;", "runtime", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "<init>", "(Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;)V", "tabsHelpId", "", "getTabsHelpId", "()Ljava/lang/String;", "provideTabsForTabManager", "", "Lcom/intellij/docker/view/details/DockerDetailsTab;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "ImagePullTab", "intellij.clouds.docker"})
public final class DockerImagesGroupDetailsProvider
implements DockerRuntimeDetailsProvider {
    @NotNull
    private final DockerGroupRuntime.ImagesGroup runtime;
    @NotNull
    private final String tabsHelpId;

    public DockerImagesGroupDetailsProvider(@NotNull DockerGroupRuntime.ImagesGroup runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        this.runtime = runtime;
        this.tabsHelpId = "docker.images.console";
    }

    @Override
    @NotNull
    public String getTabsHelpId() {
        return this.tabsHelpId;
    }

    @Override
    @NotNull
    public List<DockerDetailsTab<?>> provideTabsForTabManager(@NotNull DockerTabManager tabManager) {
        Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
        return CollectionsKt.listOf((Object)new ImagePullTab(tabManager, this.runtime));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u001a\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/docker/view/details/image/DockerImagesGroupDetailsProvider$ImagePullTab;", "Lcom/intellij/docker/view/details/DockerDetailsTab;", "Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "runtime", "<init>", "(Lcom/intellij/docker/view/details/DockerTabManager;Lcom/intellij/docker/runtimes/DockerGroupRuntime$ImagesGroup;)V", "myPanel", "Lcom/intellij/docker/view/details/image/ImagePullPanel;", "getMyPanel", "()Lcom/intellij/docker/view/details/image/ImagePullPanel;", "myPanel$delegate", "Lkotlin/Lazy;", "title", "Ljava/util/function/Supplier;", "", "getTitle", "()Ljava/util/function/Supplier;", "isClosable", "", "()Z", "createComponent", "Ljavax/swing/JComponent;", "pullImage", "Ljava/util/concurrent/CompletableFuture;", "", "Lcom/intellij/docker/agent/progress/DockerResponseItem$AuxDetail;", "tag", "Lcom/intellij/docker/agent/DockerRepoTag;", "dispose", "", "intellij.clouds.docker"})
    public static final class ImagePullTab
    extends DockerDetailsTab<DockerGroupRuntime.ImagesGroup> {
        @NotNull
        private final Lazy myPanel$delegate;
        @NotNull
        private final Supplier<String> title;
        private final boolean isClosable;

        public ImagePullTab(@NotNull DockerTabManager tabManager, @NotNull DockerGroupRuntime.ImagesGroup runtime) {
            Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            super(tabManager, runtime, null, 4, null);
            this.myPanel$delegate = LazyKt.lazy(() -> ImagePullTab.myPanel_delegate$lambda$1(this, runtime));
            Supplier<String> supplier = DockerBundle.messagePointer("DockerImageGroupDetails.ImagePullTab.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            this.title = supplier;
        }

        private final ImagePullPanel getMyPanel() {
            Lazy lazy = this.myPanel$delegate;
            return (ImagePullPanel)lazy.getValue();
        }

        @Override
        @NotNull
        public Supplier<String> getTitle() {
            return this.title;
        }

        @Override
        public boolean isClosable() {
            return this.isClosable;
        }

        @Override
        @NotNull
        protected JComponent createComponent() {
            return this.getMyPanel().getMainPanel$intellij_clouds_docker();
        }

        @NotNull
        public final CompletableFuture<List<DockerResponseItem.AuxDetail>> pullImage(@NotNull DockerRepoTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return this.getMyPanel().pullImage(tag);
        }

        public void dispose() {
        }

        private static final ImagePullPanel myPanel_delegate$lambda$1(ImagePullTab this$0, DockerGroupRuntime.ImagesGroup $runtime) {
            ImagePullPanel imagePullPanel;
            ImagePullPanel it = imagePullPanel = new ImagePullPanel(this$0.getProject(), $runtime);
            boolean bl = false;
            Disposer.register((Disposable)this$0, (Disposable)it);
            return imagePullPanel;
        }
    }
}

