/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.vfs;

import com.intellij.docker.vfs.FileTreePath;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0016J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J\"\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\u001dH\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u00063"}, d2={"Lcom/intellij/docker/vfs/RemoteVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "tempFile", "fileTreePath", "Lcom/intellij/docker/vfs/FileTreePath;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/docker/vfs/FileTreePath;)V", "getTempFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFileTreePath", "()Lcom/intellij/docker/vfs/FileTreePath;", "setFileTreePath", "(Lcom/intellij/docker/vfs/FileTreePath;)V", "getUrl", "", "getPresentableName", "getPath", "getName", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "", "newTimeStamp", "getInputStream", "Ljava/io/InputStream;", "contentsToByteArray", "", "isWritable", "", "isDirectory", "isValid", "getTimeStamp", "getLength", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getModificationStamp", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "exists", "intellij.clouds.docker"})
public final class RemoteVirtualFile
extends VirtualFile {
    @NotNull
    private final VirtualFile tempFile;
    @NotNull
    private FileTreePath fileTreePath;

    public RemoteVirtualFile(@NotNull VirtualFile tempFile, @NotNull FileTreePath fileTreePath) {
        Intrinsics.checkNotNullParameter((Object)tempFile, (String)"tempFile");
        Intrinsics.checkNotNullParameter((Object)fileTreePath, (String)"fileTreePath");
        this.tempFile = tempFile;
        this.fileTreePath = fileTreePath;
    }

    @NotNull
    public final VirtualFile getTempFile() {
        return this.tempFile;
    }

    @NotNull
    public final FileTreePath getFileTreePath() {
        return this.fileTreePath;
    }

    public final void setFileTreePath(@NotNull FileTreePath fileTreePath) {
        Intrinsics.checkNotNullParameter((Object)fileTreePath, (String)"<set-?>");
        this.fileTreePath = fileTreePath;
    }

    @NotNull
    public String getUrl() {
        String string = this.tempFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return string;
    }

    @NotNull
    public String getPresentableName() {
        return this.fileTreePath.getEnvTitle() + ": " + this.fileTreePath.getPath().getFileName();
    }

    @NotNull
    public String getPath() {
        return this.fileTreePath.getPath().toString();
    }

    @NotNull
    public String getName() {
        String string = this.tempFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.tempFile.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        return virtualFileSystem;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.tempFile.getParent();
    }

    @NotNull
    public VirtualFile[] getChildren() {
        VirtualFile[] virtualFileArray = this.tempFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        return virtualFileArray;
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        OutputStream outputStream = this.tempFile.getOutputStream(requestor, newModificationStamp, newTimeStamp);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        return outputStream;
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.tempFile.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.tempFile.contentsToByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
        return byArray;
    }

    public boolean isWritable() {
        return this.tempFile.isWritable();
    }

    public boolean isDirectory() {
        return this.tempFile.isDirectory();
    }

    public boolean isValid() {
        return this.tempFile.isValid();
    }

    public long getTimeStamp() {
        return this.tempFile.getTimeStamp();
    }

    public long getLength() {
        return this.tempFile.getLength();
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.tempFile.refresh(asynchronous, recursive, postRunnable);
    }

    public long getModificationStamp() {
        return this.tempFile.getModificationStamp();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.tempFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return fileType;
    }

    public boolean exists() {
        return this.tempFile.exists();
    }
}

