/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.github.dockerjava.api.model.Mount;
import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.settings.DockerDeviceRequest;
import com.intellij.docker.agent.settings.DockerMount;
import com.intellij.docker.agent.settings.DockerPortSpec;
import com.intellij.docker.agent.util.DockerJavaUtilsKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRunCliParserBase<CMD>
extends CliParserBase<CMD> {
    private File myContextFolder;

    public final void setContextFolder(@Nullable File contextFolder) {
        this.myContextFolder = contextFolder;
    }

    @Override
    protected List<CliParserBase.OptionHandler<CMD>> createAllHandlers() {
        LinkedList<CliParserBase.OptionHandler> result2 = new LinkedList<CliParserBase.OptionHandler>();
        result2.add(this.name(DockerRunCliParserBase.builder13().longOpt("name").hasArg().build()));
        result2.add(this.hostname(DockerRunCliParserBase.builder13("h").longOpt("hostname").hasArg().build()));
        result2.add(this.user(DockerRunCliParserBase.builder13("u").longOpt("user").hasArg().build()));
        result2.add(this.memory(DockerRunCliParserBase.builder13("m").longOpt("memory").hasArg().build()));
        result2.add(this.memoryReservation(DockerRunCliParserBase.builder13().longOpt("memory-reservation").hasArg().build()));
        result2.add(this.kernelMemory(DockerRunCliParserBase.builder13().longOpt("kernel-memory").hasArg().build()));
        result2.add(this.shmSize(DockerRunCliParserBase.builder13().longOpt("shm-size").hasArg().build()));
        result2.add(this.memorySwap(DockerRunCliParserBase.builder13().longOpt("memory-swap").hasArg().build()));
        result2.add(this.memorySwappiness(DockerRunCliParserBase.builder13().longOpt("memory-swappiness").hasArg().build()));
        result2.add(this.cpusetCpus(DockerRunCliParserBase.builder13().longOpt("cpuset-cpus").hasArg().build()));
        result2.add(this.cpuShares(DockerRunCliParserBase.builder13("c").longOpt("cpu-shares").hasArg().build()));
        result2.add(this.cpuPeriod(DockerRunCliParserBase.builder13().longOpt("cpu-period").hasArg().build()));
        result2.add(this.cpuQuota(DockerRunCliParserBase.builder13().longOpt("cpu-quota").hasArg().build()));
        result2.add(this.cpusetMems(DockerRunCliParserBase.builder13().longOpt("cpuset-mems").hasArg().build()));
        result2.add(this.cpus(DockerRunCliParserBase.builder13().longOpt("cpus").hasArg().build()));
        result2.add(this.blkioWeight(DockerRunCliParserBase.builder13().longOpt("blkio-weight").hasArg().build()));
        result2.add(this.oomKillDisable(DockerRunCliParserBase.builder13().longOpt("oom-kill-disable").hasArg().optionalArg(true).build()));
        result2.add(this.attach(DockerRunCliParserBase.builder13("a").longOpt("attach").hasArg().build()));
        result2.add(this.detach(DockerRunCliParserBase.builder13("d").longOpt("detach").optionalArg(true).build()));
        result2.add(this.tty(DockerRunCliParserBase.builder13("t").longOpt("tty").optionalArg(true).build()));
        result2.add(this.interactive(DockerRunCliParserBase.builder13("i").longOpt("interactive").optionalArg(true).build()));
        result2.add(this.env(DockerRunCliParserBase.builder13("e").longOpt("env").hasArg().build()));
        result2.add(this.envFile(DockerRunCliParserBase.builder13().longOpt("env-file").hasArg().build()));
        result2.add(this.entrypoint(DockerRunCliParserBase.builder13().longOpt("entrypoint").hasArg().build()));
        result2.add(this.workingDir(DockerRunCliParserBase.builder13("w").longOpt("workdir").hasArg().build()));
        result2.add(this.expose(DockerRunCliParserBase.builder13().longOpt("expose").hasArg().build()));
        result2.add(this.addHost(DockerRunCliParserBase.builder13().longOpt("add-host").hasArg().build()));
        result2.add(this.volume(DockerRunCliParserBase.builder13("v").longOpt("volume").hasArg().build()));
        result2.add(this.link(DockerRunCliParserBase.builder13().longOpt("link").hasArg().build()));
        result2.add(this.lxcConf(DockerRunCliParserBase.builder13().longOpt("lxc-conf").hasArg().build()));
        result2.add(this.logDriver(DockerRunCliParserBase.builder13().longOpt("log-driver").hasArg().build()));
        result2.add(this.logOpt(DockerRunCliParserBase.builder13().longOpt("log-opt").hasArg().build()));
        result2.add(this.macAddress(DockerRunCliParserBase.builder13().longOpt("mac-address").hasArg().build()));
        result2.add(this.publish(DockerRunCliParserBase.builder13("p").longOpt("publish").hasArg().build()));
        result2.add(this.publishAll(DockerRunCliParserBase.builder13("P").longOpt("publish-all").optionalArg(true).build()));
        result2.add(this.privileged(DockerRunCliParserBase.builder13().longOpt("privileged").hasArg().optionalArg(true).build()));
        result2.add(this.dns(DockerRunCliParserBase.builder13().longOpt("dns").hasArg().build()));
        result2.add(this.dnsSearch(DockerRunCliParserBase.builder13().longOpt("dns-search").hasArg().build()));
        result2.add(this.volumesFrom(DockerRunCliParserBase.builder13().longOpt("volumes-from").hasArg().build()));
        result2.add(this.cidfile(DockerRunCliParserBase.builder13().longOpt("cidfile").hasArg().build()));
        result2.add(this.capAdd(DockerRunCliParserBase.builder13().longOpt("cap-add").hasArg().build()));
        result2.add(this.capDrop(DockerRunCliParserBase.builder13().longOpt("cap-drop").hasArg().build()));
        result2.add(this.restart(DockerRunCliParserBase.builder13().longOpt("restart").hasArg().build()));
        result2.add(this.network(DockerRunCliParserBase.builder13().longOpt("network").hasArg().build()));
        result2.add(this.network(DockerRunCliParserBase.builder13().longOpt("net").hasArg().build()));
        result2.add(this.networkAlias(DockerRunCliParserBase.builder13().longOpt("network-alias").hasArg().build()));
        result2.add(this.label(DockerRunCliParserBase.builder13("l").longOpt("label").hasArg().build()));
        result2.add(this.ip(DockerRunCliParserBase.builder13().longOpt("ip").hasArg().build()));
        result2.add(this.ip6(DockerRunCliParserBase.builder13().longOpt("ip6").hasArg().build()));
        result2.add(this.device(DockerRunCliParserBase.builder13().longOpt("device").hasArg().build()));
        result2.add(this.securityOpt(DockerRunCliParserBase.builder13().longOpt("security-opt").hasArg().build()));
        result2.add(this.runtime(DockerRunCliParserBase.builder13().longOpt("runtime").hasArg().build()));
        result2.add(this.rm(DockerRunCliParserBase.builder13().longOpt("rm").optionalArg(true).build()));
        result2.add(this.ipc(DockerRunCliParserBase.builder13().longOpt("ipc").hasArg().build()));
        result2.add(this.ulimit(DockerRunCliParserBase.builder13().longOpt("ulimit").hasArg().build()));
        result2.add(this.groupAdd(DockerRunCliParserBase.builder13().longOpt("group-add").hasArg().build()));
        result2.add(this.cgroupParent(DockerRunCliParserBase.builder13().longOpt("cgroup-parent").hasArg().build()));
        result2.add(this.sysctl(DockerRunCliParserBase.builder13().longOpt("sysctl").hasArg().build()));
        result2.add(this.gpus(DockerRunCliParserBase.builder13().longOpt("gpus").hasArg().build()));
        result2.add(this.init(DockerRunCliParserBase.builder13().longOpt("init").optionalArg(true).build()));
        result2.add(this.mount(DockerRunCliParserBase.builder13().longOpt("mount").hasArg().build()));
        result2.add(this.platform(DockerRunCliParserBase.builder13().longOpt("platform").hasArg().build()));
        result2.add(this.userns(DockerRunCliParserBase.builder13().longOpt("userns").hasArg().build()));
        return result2.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected File getContextFolder() {
        return this.myContextFolder;
    }

    protected abstract CliParserBase.ListHandler<CMD> mount(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> name(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> hostname(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> user(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memory(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memorySwap(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memorySwappiness(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> memoryReservation(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> kernelMemory(Option var1);

    protected abstract CliParserBase.MemoryOptionHandler<CMD> shmSize(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cpusetCpus(Option var1);

    protected abstract CliParserBase.IntegerOptionHandler<CMD> cpuShares(Option var1);

    protected abstract CliParserBase.LongOptionHandler<CMD> cpuPeriod(Option var1);

    protected abstract CliParserBase.LongOptionHandler<CMD> cpuQuota(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cpusetMems(Option var1);

    protected abstract CliParserBase.DoubleOptionHandler<CMD> cpus(Option var1);

    protected abstract CliParserBase.IntegerOptionHandler<CMD> blkioWeight(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> oomKillDisable(Option var1);

    protected abstract AttachOptionHandler<CMD> attach(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> detach(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> tty(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> interactive(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> env(Option var1);

    protected abstract EnvFileListHandler envFile(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> entrypoint(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> workingDir(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> expose(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> addHost(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> volume(Option var1);

    protected abstract LinkOptionHandler<CMD, ?> link(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> lxcConf(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> logDriver(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> logOpt(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> macAddress(Option var1);

    protected abstract PortBindingOptionHandler<CMD> publish(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> publishAll(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> privileged(Option var1);

    protected abstract CliParserBase.StringListHandler<CMD> dns(Option var1);

    protected abstract CliParserBase.StringListHandler<CMD> dnsSearch(Option var1);

    protected abstract CliParserBase.MappedListHandler<CMD, ?> volumesFrom(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cidfile(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> platform(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> capAdd(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> capDrop(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> restart(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> network(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> networkAlias(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> device(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> ip(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> ip6(Option var1);

    protected abstract CliParserBase.LabelListHandler<CMD> label(Option var1);

    protected abstract CliParserBase.ListHandler<CMD> securityOpt(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> runtime(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> rm(Option var1);

    protected abstract IPCOptionHandler<CMD> ipc(Option var1);

    protected abstract UlimitOptionHandler<CMD> ulimit(Option var1);

    protected abstract CliParserBase.StringListHandler<CMD> groupAdd(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> cgroupParent(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> sysctl(Option var1);

    protected abstract GpuDeviceRequestHandler<CMD> gpus(Option var1);

    protected abstract CliParserBase.BooleanOptionHandler<CMD> init(Option var1);

    protected abstract CliParserBase.SingleValueHandler<CMD> userns(Option var1);

    protected static class AttachOptionHandler<CMD>
    extends CliParserBase.ListHandler<CMD> {
        public static final String STDIN = "stdin";
        public static final String STDOUT = "stdout";
        public static final String STDERR = "stderr";
        private final BiConsumer<? super CMD, ? super Boolean> myAttachStdin;
        private final BiConsumer<? super CMD, ? super Boolean> myAttachStdout;
        private final BiConsumer<? super CMD, ? super Boolean> myAttachStderr;

        public AttachOptionHandler(Option option, BiConsumer<? super CMD, ? super Boolean> attachStdin, BiConsumer<? super CMD, ? super Boolean> attachStdout, BiConsumer<? super CMD, ? super Boolean> attachStderr) {
            super(option);
            this.myAttachStdin = attachStdin;
            this.myAttachStdout = attachStdout;
            this.myAttachStderr = attachStderr;
        }

        @Override
        protected final void handleValueList(String[] values) {
            for (String nextAttach : values) {
                this.handleOneAttach(nextAttach);
            }
        }

        protected void handleOneAttach(String attachTo) {
            if (STDIN.equalsIgnoreCase(attachTo)) {
                this.myAttachStdin.accept(this.getCmd(), Boolean.TRUE);
            } else if (STDOUT.equalsIgnoreCase(attachTo)) {
                this.myAttachStdout.accept(this.getCmd(), Boolean.TRUE);
            } else if (STDERR.equalsIgnoreCase(attachTo)) {
                this.myAttachStderr.accept(this.getCmd(), Boolean.TRUE);
            } else {
                throw new CliParserBase.IllegalOptionException(this.getOption(), attachTo);
            }
        }
    }

    protected abstract class EnvFileListHandler
    extends CliParserBase.ListHandler<CMD> {
        public EnvFileListHandler(Option option) {
            super(option);
        }

        @Override
        protected void handleValueList(String[] values) {
            File contextFolder = DockerRunCliParserBase.this.getContextFolder();
            for (String nextValue : values) {
                File nextFile;
                Path nextPath = Paths.get(nextValue, new String[0]);
                if (!nextPath.isAbsolute() && contextFolder != null) {
                    nextPath = contextFolder.toPath().resolve(nextPath);
                }
                if (!(nextFile = nextPath.toFile()).exists() || !nextFile.isFile()) {
                    throw new CliParserBase.IllegalOptionException("Can't read 'env-file' at " + String.valueOf(nextPath));
                }
                this.handleEnvFile(nextValue, nextFile);
            }
        }

        protected abstract void handleEnvFile(String var1, File var2);
    }

    protected static abstract class LinkOptionHandler<CMD, LINK>
    extends CliParserBase.ListHandler<CMD> {
        private final BiConsumer<? super CMD, ? super List<LINK>> mySetter;

        public LinkOptionHandler(Option option, BiConsumer<? super CMD, ? super List<LINK>> setter) {
            super(option);
            this.mySetter = setter;
        }

        @Override
        protected void handleValueList(String[] values) {
            ArrayList<LINK> links = new ArrayList<LINK>(values.length);
            for (String next : values) {
                String[] parts = next.split(":");
                LINK nextLink = switch (parts.length) {
                    case 1 -> this.createLink(next, next);
                    case 2 -> this.createLink(parts[0], parts[1]);
                    default -> throw new CliParserBase.IllegalOptionException(this.getOption(), next);
                };
                if (nextLink == null) continue;
                links.add(nextLink);
            }
            this.mySetter.accept(this.getCmd(), links);
        }

        protected abstract LINK createLink(String var1, String var2);
    }

    protected static class PortBindingOptionHandler<CMD>
    extends CliParserBase.MappedListHandler<CMD, DockerPortSpec> {
        public PortBindingOptionHandler(Option option, BiConsumer<? super CMD, DockerPortSpec[]> setter) {
            super(option, DockerPortSpec.class, text -> {
                DockerPortSpec result2;
                try {
                    result2 = DockerPortSpec.fromRawString(text);
                }
                catch (IllegalArgumentException e) {
                    throw new CliParserBase.IllegalOptionException(option, (String)text);
                }
                if (!result2.isRangesMatched()) {
                    throw new CliParserBase.IllegalOptionException(option, (String)text);
                }
                return result2;
            }, setter);
        }
    }

    protected static class IPCOptionHandler<CMD>
    extends CliParserBase.SingleValueHandler<CMD> {
        private final BiConsumer<? super CMD, ? super String> mySetter;

        public IPCOptionHandler(Option option, BiConsumer<? super CMD, ? super String> ipcSetter) {
            super(option);
            this.mySetter = ipcSetter;
        }

        @Override
        protected void handleEachValue(String value) {
            assert (value != null);
            this.checkValue(value);
            this.mySetter.accept(this.getCmd(), value);
        }

        protected void checkValue(@NotNull String value) {
            if (value == null) {
                IPCOptionHandler.$$$reportNull$$$0(0);
            }
            if (value.isEmpty()) {
                return;
            }
            if (value.startsWith("container:")) {
                return;
            }
            switch (value) {
                case "none": 
                case "private": 
                case "shareable": 
                case "host": {
                    return;
                }
            }
            throw new CliParserBase.IllegalOptionException(this.getOption(), value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/docker/agent/cli/model/DockerRunCliParserBase$IPCOptionHandler", "checkValue"));
        }
    }

    protected static abstract class UlimitOptionHandler<CMD>
    extends CliParserBase.ListHandler<CMD> {
        public UlimitOptionHandler(Option option) {
            super(option);
        }

        protected abstract void handleUlimits(@NotNull List<CliUlimit> var1);

        @Override
        protected void handleValueList(String[] values) {
            if (values == null || values.length == 0) {
                throw new CliParserBase.IllegalOptionException(this.getOption(), "<no value>");
            }
            ArrayList<CliUlimit> allLimits = new ArrayList<CliUlimit>(values.length);
            for (String next : values) {
                CliUlimit nextLimit = CliUlimit.parseValue(next);
                if (nextLimit == null) {
                    throw new CliParserBase.IllegalOptionException(this.getOption(), next);
                }
                allLimits.add(nextLimit);
            }
            this.handleUlimits(allLimits);
        }

        protected static final class CliUlimit {
            private final String myName;
            private final int mySoft;
            private final int myHard;

            @Nullable
            private static CliUlimit parseValue(@NotNull String value) {
                String[] nameAndLimits;
                if (value == null) {
                    CliUlimit.$$$reportNull$$$0(0);
                }
                if ((nameAndLimits = value.split("=")).length != 2) {
                    return null;
                }
                String name2 = nameAndLimits[0];
                String[] softAndHard = nameAndLimits[1].split(":");
                try {
                    return switch (softAndHard.length) {
                        case 1 -> {
                            int limit = Integer.parseInt(softAndHard[0]);
                            yield new CliUlimit(name2, limit, limit);
                        }
                        case 2 -> {
                            int soft = Integer.parseInt(softAndHard[0]);
                            int hard = Integer.parseInt(softAndHard[1]);
                            yield new CliUlimit(name2, soft, hard);
                        }
                        default -> null;
                    };
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }

            private CliUlimit(String name2, int soft, int hard) {
                this.myName = name2;
                this.mySoft = soft;
                this.myHard = hard;
            }

            public String getName() {
                return this.myName;
            }

            public int getHard() {
                return this.myHard;
            }

            public int getSoft() {
                return this.mySoft;
            }

            public String toString() {
                return this.myName + "=" + this.mySoft + (String)(this.myHard == this.mySoft ? "" : ":" + this.myHard);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/docker/agent/cli/model/DockerRunCliParserBase$UlimitOptionHandler$CliUlimit", "parseValue"));
            }
        }
    }

    protected static abstract class GpuDeviceRequestHandler<CMD>
    extends CliParserBase.SingleValueHandler<CMD> {
        public GpuDeviceRequestHandler(Option option) {
            super(option);
        }

        protected abstract void handleDeviceRequest(String var1, DockerDeviceRequest var2);

        @Override
        protected final void handleEachValue(String value) {
            try {
                DockerDeviceRequest dto = DockerDeviceRequest.Impl.fromString(value).withImplicitCapability("gpu");
                this.handleDeviceRequest(value, dto);
            }
            catch (IllegalArgumentException e) {
                throw new CliParserBase.IllegalOptionException(this.getOption(), value, e);
            }
        }
    }

    protected static class MountOptionHandler<CMD>
    extends CliParserBase.ListHandler<CMD> {
        private final BiConsumer<? super CMD, List<Mount>> myAccept;

        public MountOptionHandler(Option option, BiConsumer<? super CMD, List<Mount>> accept) {
            super(option);
            this.myAccept = accept;
        }

        @Override
        protected void handleValueList(String[] values) {
            this.myAccept.accept(this.getCmd(), Arrays.stream(values).map(v -> DockerJavaUtilsKt.toClientMount(new DockerMount((String)v))).toList());
        }
    }
}

