/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import java.util.Date;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    @NonNls
    private static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @ApiStatus.Internal
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    private static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    private static final String COVERAGE_TYPE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    private static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final RunConfigurationBase<?> myConfiguration;
    private boolean myIsCoverageEnabled;
    private String myRunnerId;
    private CoverageRunner myCachedRunner;
    private boolean myTrackTestFolders;
    private boolean myBranchCoverage;
    private boolean myTrackPerTestCoverage;
    @ApiStatus.Internal
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite myCurrentCoverageSuite;

    @Deprecated
    public CoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> configuration) {
        if (configuration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(0);
        }
        this.myIsCoverageEnabled = false;
        this.myTrackTestFolders = false;
        this.myBranchCoverage = false;
        this.myTrackPerTestCoverage = false;
        this.myConfiguration = configuration;
    }

    public CoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> configuration, @NotNull CoverageRunner runner) {
        if (configuration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(2);
        }
        this.myIsCoverageEnabled = false;
        this.myTrackTestFolders = false;
        this.myBranchCoverage = false;
        this.myTrackPerTestCoverage = false;
        this.myConfiguration = configuration;
        this.setCoverageRunner(runner);
    }

    @NotNull
    public RunConfigurationBase<?> getConfiguration() {
        RunConfigurationBase<?> runConfigurationBase = this.myConfiguration;
        if (runConfigurationBase == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(3);
        }
        return runConfigurationBase;
    }

    public String getName() {
        return this.myConfiguration.getName();
    }

    @ApiStatus.Internal
    @Nullable
    public CoverageRunner getCoverageRunner() {
        if (this.myCachedRunner == null && this.myRunnerId != null) {
            this.myCachedRunner = CoverageRunner.getInstanceById(this.myRunnerId);
        }
        return this.myCachedRunner;
    }

    public void setCoverageRunner(@Nullable CoverageRunner coverageRunner) {
        this.myRunnerId = coverageRunner == null ? null : coverageRunner.getId();
        this.myCachedRunner = coverageRunner;
        this.myCoverageFilePath = null;
    }

    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.myTrackTestFolders = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.myCurrentCoverageSuite;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.myCurrentCoverageSuite = currentCoverageSuite;
    }

    @Deprecated
    public boolean isCoverageEnabled() {
        return this.myIsCoverageEnabled;
    }

    @Deprecated
    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.myIsCoverageEnabled = isCoverageEnabled;
    }

    @Deprecated
    public boolean isBranchCoverageEnabled() {
        return this.myBranchCoverage;
    }

    @Deprecated
    public void setBranchCoverage(boolean branchCoverage) {
        this.myBranchCoverage = branchCoverage;
    }

    @Deprecated
    public boolean isTrackPerTestCoverage() {
        return this.myTrackPerTestCoverage;
    }

    @Deprecated
    @ApiStatus.Internal
    public void setTrackPerTestCoverage(boolean testTracking) {
        this.myTrackPerTestCoverage = testTracking;
    }

    public String createSuiteName() {
        return CoverageBundle.message("coverage.results.suite.name", this.getName());
    }

    public CoverageFileProvider createFileProvider() {
        return new DefaultCoverageFileProvider(this.getCoverageFilePath());
    }

    public long createTimestamp() {
        return new Date().getTime();
    }

    @ApiStatus.Internal
    public void coverageRunnerExtensionRemoved(@NotNull CoverageRunner runner) {
        if (runner == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(4);
        }
        if (runner.getId().equals(this.myRunnerId)) {
            this.myConfiguration.putCopyableUserData(COVERAGE_KEY, null);
            this.myCachedRunner = null;
        }
    }

    @NonNls
    @Nullable
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myIsCoverageEnabled = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        String testTrackingAttribute = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.myTrackPerTestCoverage = testTrackingAttribute != null && Boolean.parseBoolean(testTrackingAttribute);
        this.myBranchCoverage = !Boolean.parseBoolean(element.getAttributeValue(COVERAGE_TYPE_ATTRIBUTE_NAME, "true"));
        String trackTestFolders = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.myTrackTestFolders = trackTestFolders != null && Boolean.parseBoolean(trackTestFolders);
        String runnerId = element.getAttributeValue(COVERAGE_RUNNER);
        if (runnerId != null) {
            this.myRunnerId = runnerId;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myIsCoverageEnabled) {
            element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (this.myTrackPerTestCoverage) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (this.myBranchCoverage) {
            element.setAttribute(COVERAGE_TYPE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (this.myTrackTestFolders) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(true));
        }
        if (this.myRunnerId != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunnerId);
        }
    }

    @NonNls
    @Nullable
    protected String createCoverageFile() {
        CoverageRunner runner = this.getCoverageRunner();
        if (runner == null) {
            return null;
        }
        Path coverageRootPath = Path.of(PathManager.getSystemPath(), "coverage");
        coverageRootPath.toFile().mkdirs();
        String projectName = FileUtil.sanitizeFileName((String)this.myConfiguration.getProject().getName());
        String configName = FileUtil.sanitizeFileName((String)this.myConfiguration.getName());
        String separator = this.coverageFileNameSeparator();
        String extension = runner.getDataFileExtension();
        String path = String.format("%s%s%s.%s", projectName, separator, configName, extension);
        return coverageRootPath.resolve(path).toString();
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }

    public static boolean isApplicableTo(@NotNull RunConfigurationBase<?> runConfiguration) {
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(5);
        }
        return CoverageEnabledConfiguration.getOrNull(runConfiguration) != null || CoverageEnabledConfiguration.getSuitableEngine(runConfiguration) != null;
    }

    @ApiStatus.Internal
    @Nullable
    public static CoverageEnabledConfiguration getOrNull(@NotNull RunConfigurationBase<?> runConfiguration) {
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(6);
        }
        return (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY);
    }

    @NotNull
    public static CoverageEnabledConfiguration getOrCreate(@NotNull RunConfigurationBase<?> runConfiguration) {
        CoverageEnabledConfiguration configuration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(7);
        }
        if ((configuration = CoverageEnabledConfiguration.getOrNull(runConfiguration)) == null) {
            CoverageEngine suitableEngine = CoverageEnabledConfiguration.getSuitableEngine(runConfiguration);
            LOG.assertTrue(suitableEngine != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            configuration = suitableEngine.createCoverageEnabledConfiguration(runConfiguration);
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)configuration);
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration = configuration;
        if (coverageEnabledConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(8);
        }
        return coverageEnabledConfiguration;
    }

    @Nullable
    private static CoverageEngine getSuitableEngine(@NotNull RunConfigurationBase<?> runConfiguration) {
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.$$$reportNull$$$0(9);
        }
        for (CoverageEngine engine : CoverageEngine.EP_NAME.getExtensionList()) {
            if (!engine.isApplicableTo(runConfiguration)) continue;
            return engine;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public boolean canHavePerTestCoverage() {
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!engine.isApplicableTo(this.myConfiguration)) continue;
            return engine.canHavePerTestCoverage(this.myConfiguration);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = COVERAGE_RUNNER;
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "coverageRunnerExtensionRemoved";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrNull";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

