/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Strings {
    private static final Pattern SEVERAL_SPACES = Pattern.compile("[ \\s\\t\\r\\n]{2,}");

    public static boolean eq(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean eq(String str1, String str2, boolean caseSensitive) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return caseSensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
    }

    @NotNull
    public static String ensureStartsWith(@NotNull String str, char c) {
        if (str == null) {
            Strings.$$$reportNull$$$0(0);
        }
        if (str.isEmpty()) {
            String string = Character.toString(c);
            if (string == null) {
                Strings.$$$reportNull$$$0(1);
            }
            return string;
        }
        char c1 = str.charAt(0);
        if (c1 == c) {
            String string = str;
            if (string == null) {
                Strings.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = c + str;
        if (string == null) {
            Strings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String ensureEndsWith(@NotNull String str, char c) {
        int n;
        if (str == null) {
            Strings.$$$reportNull$$$0(4);
        }
        if ((n = str.length()) > 0 && str.charAt(n - 1) == c) {
            String string = str;
            if (string == null) {
                Strings.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = str + c;
        if (string == null) {
            Strings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String removeEnding(@NotNull String str, @NotNull String ending) {
        int m;
        int n;
        if (str == null) {
            Strings.$$$reportNull$$$0(7);
        }
        if (ending == null) {
            Strings.$$$reportNull$$$0(8);
        }
        if ((n = str.length()) > (m = ending.length()) && str.endsWith(ending)) {
            String string = str.substring(0, n - m);
            if (string == null) {
                Strings.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = str;
        if (string == null) {
            Strings.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String rtrim(@NotNull String str) {
        int n;
        int k;
        if (str == null) {
            Strings.$$$reportNull$$$0(11);
        }
        for (k = n = str.length(); k > 0 && Character.isWhitespace(str.charAt(k - 1)); --k) {
        }
        if (k == n) {
            String string = str;
            if (string == null) {
                Strings.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = str.substring(0, k);
        if (string == null) {
            Strings.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String replace(@NotNull String where, @NotNull String what, @NotNull String with) {
        if (where == null) {
            Strings.$$$reportNull$$$0(14);
        }
        if (what == null) {
            Strings.$$$reportNull$$$0(15);
        }
        if (with == null) {
            Strings.$$$reportNull$$$0(16);
        }
        String string = where.replace(what, with);
        if (string == null) {
            Strings.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String repeat(@NotNull String what, @Nullable String delimiter, int count) {
        if (what == null) {
            Strings.$$$reportNull$$$0(18);
        }
        if (count == 0) {
            return "";
        }
        if (count == 1) {
            String string = what;
            if (string == null) {
                Strings.$$$reportNull$$$0(19);
            }
            return string;
        }
        StringBuilder b = new StringBuilder(what.length() + (delimiter == null ? 0 : delimiter.length()) * count);
        b.append(what);
        for (int i = 1; i < count; ++i) {
            if (delimiter != null) {
                b.append(delimiter);
            }
            b.append(what);
        }
        String string = b.toString();
        if (string == null) {
            Strings.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Contract(value="null,_->false")
    public static boolean matches(@Nullable CharSequence string, @NotNull Pattern pattern) {
        if (pattern == null) {
            Strings.$$$reportNull$$$0(21);
        }
        if (string == null) {
            return false;
        }
        return pattern.matcher(string).matches();
    }

    @Contract(value="null,_,_->false")
    public static boolean matches(@Nullable CharSequence string, @NotNull String pattern, boolean caseSensitive) {
        if (pattern == null) {
            Strings.$$$reportNull$$$0(22);
        }
        if (string == null) {
            return false;
        }
        Pattern p = Pattern.compile(pattern, caseSensitive ? 0 : 2);
        return Strings.matches(string, p);
    }

    @Contract(value="!null->!null; null->null")
    public static String upper(@Nullable String string) {
        return string == null ? null : string.toUpperCase();
    }

    @Contract(value="!null->!null; null->null")
    public static String lower(@Nullable String string) {
        return string == null ? null : string.toLowerCase();
    }

    @Contract(value="!null->!null; null->null")
    public static String minimizeSpaces(@Nullable String string) {
        if (string == null) {
            return null;
        }
        String s = string.trim();
        if (s.isEmpty()) {
            return "";
        }
        Matcher m = SEVERAL_SPACES.matcher(s);
        return m.replaceAll(" ");
    }

    @Contract(value="!null,_->!null; null,_->null")
    public static String lastPart(@Nullable String string, char delimiter) {
        if (string == null) {
            return null;
        }
        int pos = string.lastIndexOf(delimiter);
        if (pos >= 0) {
            return string.substring(pos + 1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/util/Strings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ending";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/util/Strings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureStartsWith";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureEndsWith";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEnding";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "rtrim";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureStartsWith";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureEndsWith";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeEnding";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rtrim";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

