---
title: Testimonials
---

You might not be ready to make the jump to Jujutsu yet. It's understandable; new
tools come with new lessons, failures, and ideas to absorb. They require
practice. In order to provide some motivation, we've collected a number of real,
100% authentic testimonials &mdash; from our loving users, our silly developers
&mdash; all to tip the scales and get you on our side!

## What the users have to say

> I've spent many years of my career working on version control. What I like
> most about Jujutsu is how it has non-obvious solutions to UX problems that
> we've run into in the past. What most people may not realize is that there are
> many novel features which all interlock to make it easy to use.
>
> For example, consider Jujutsu's support for automatically rebasing descendants
> of amended revisions. When we implemented that in Mercurial, we ran into an
> issue: what if there's a merge conflict? Our solution was to warn users and
> just not perform the auto-rebase. Now, suddenly, users have to understand that
> there can be old versions of the same revision visible in their log, and learn
> how to fix this state.
>
> In contrast, Jujutsu's solution is to simply make merge conflicts first-class.
> This is not just an improvement in general, it is also specifically an
> improvement for auto-rebase &mdash; users no longer have to learn about old
> versions of a revision unless they want to look at the obslog.
>
> Over and over, I'm struck by how well Jujutsu demonstrates this kind of
> evolved thinking, which as an experienced version control developer I deeply
> appreciate.

&mdash; Rain, engineer at Oxide Computer Company, former VCS developer

> Jujutsu is amazing... I couldn't have come up with anything remotely as
> elegant.
>
> It's so rare that a solution attacks the innermost core of a problem so
> thoroughly, I genuinely feel blessed to be in its presence. And also a bit
> vindicated in not even trying to learn to use any of the tools that felt like
> more crutches stacked upon a sand castle

&mdash; Anonymous user, speaking from the shadows

> It's the easiest time I've ever had learning a tool this deeply this quickly,
> because of the ability to experiment and undo, instead of triple-checking
> before trying a new scary command.

&mdash; Scott Olson, advanced Git user and now a Jujutsu user

> I initially started to use Jujutsu for personal repos, and it has quickly
> gone from "neat, let's try this more" to "very neat, added to my permanent
> config and automatically installed for new machines".

&mdash; Poliorcetics, on GitHub

> when i worked on the rust compiler, my job was to chain together a bunch of
> strange and cursed tools that broke often. jujutsu breaks about half as
> much, so that's pretty good i guess

&mdash; jyn514, Rust contributor

> Jujutsu is pretty cool, you can even keep most of your existing workflows

&mdash; Ben, who doesn't want you keeping your existing workflow

> Wait, it's not called Jujitsu?

&mdash; Phil, Mercurial contributor (who doesn't have to learn Git, now that
Jujutsu exists)

> When I heard about Jujutsu I decided to try it out before forming an opinion.
> Technically it never formed, because I haven't considered going back.

&mdash; gul banana, computer programmer

> muwhahaha, I have corrupted my cofounder and now 100% of brontosource dev is on JJ.

&mdash; Matt Kulunkundis, cofounder BrontoSource

> jj is genuinely the first tool since Rust that has me excited.

&mdash; David Barsky, rust-analyzer and `tokio-rs/tracing` developer

> Today I did some complex surgery on a legacy repo that has been committed to
> for years by a number of individuals with varying hygienic habits. [..]
>
> Now, this still took me about two hours using jj. But at no point did I
> seriously consider physical violence to humans or inanimate objects.
> Everything progressed calmly and methodically. I was able to introspect
> changes before I made them, and when I did screw up… `jj undo` to the
> rescue.

&mdash; An unknown scientist, who couldn't have done it with Git.

> jj was my first exposure to revsets and at first I was
> "why would I ever need that", but now after exercising that math part of my
> brain that's been stale since high school, they're indispensable

&mdash; Marijan Smetko, who previously only knew Git.

> I think my favorite thing about jj is it makes the way I abused Git via
> lazygit the standard way of doing things

&mdash; Isaac Corbrey, reformed Git user

## What the developers have to say

> I've been a FOSS contributor using Git for over 16 years, and Jujutsu
> continues to amaze me every day. It has that sweet simplicity I was fond of in
> Darcs, but it boils down all my most core and fundamental workflows &mdash;
> developed over years of experience &mdash; into a simple set of primitives.
> The internal design is simple and beautiful; it looks like a database, making
> the implementation elegant, safe, and extensible. All this, using the same Git
> repositories my coworkers use.
>
> It's like if you found out one day that you built your entire home on a vein
> of rich gold. Every day I seem to find new and beautiful emergent behaviors,
> all adding up to a tool that is greater than the sum of its parts.

&mdash; Austin Seipp, "No 1. Jujutsu Fan"

> Honestly, I implemented signing support mostly for that sweet dopamine hit
> that you get from the green checkmark on GitHub. Yeah.

&mdash; Anton Bulakh, contributor and dopamine enthusiast

> I'm sometimes still surprised that navigating with `jj next` and `jj prev`
> works.

&mdash; Philip Metzger, author of `jj next` and `jj prev`

> I'm surprised when it works.

&mdash; Martin von Zweigbergk, project creator and leader

## Spread the word yourself

Are you satisfied with Jujutsu? Ready to recommend it to a Jujillion of your
friends and coworkers? Great! The easiest way to help the project grow is word
of mouth. So make sure to talk to them about it and show off your hip new tool.
Maybe post a link to it on your other favorite tool that you love using, Slack?

If you're not sure what to say, we hired the cheapest marketing team we could
find to design a list of Pre-Approved Endorsements in their laboratory. Just
copy and paste these right into a text box! Shilling for an open source project
has never been easier than this.

> Jujutsu is an alright tool. I guess.

> Jujutsu is my favorite software tool of all time. I am saying this for no
> particular reason, definitely not because I was paid to.

> I love Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu. I love
> Jujutsu. I love Jujutsu. I love Jujutsu. I love Jujutsu.
