﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/OutboundCallerConfig.h>
#include <aws/connect/model/OutboundEmailConfig.h>
#include <aws/connect/model/QueueStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>Contains information about a queue.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/Queue">AWS API
 * Reference</a></p>
 */
class Queue {
 public:
  AWS_CONNECT_API Queue() = default;
  AWS_CONNECT_API Queue(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Queue& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the queue.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Queue& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the queue.</p>
   */
  inline const Aws::String& GetQueueArn() const { return m_queueArn; }
  inline bool QueueArnHasBeenSet() const { return m_queueArnHasBeenSet; }
  template <typename QueueArnT = Aws::String>
  void SetQueueArn(QueueArnT&& value) {
    m_queueArnHasBeenSet = true;
    m_queueArn = std::forward<QueueArnT>(value);
  }
  template <typename QueueArnT = Aws::String>
  Queue& WithQueueArn(QueueArnT&& value) {
    SetQueueArn(std::forward<QueueArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for the queue.</p>
   */
  inline const Aws::String& GetQueueId() const { return m_queueId; }
  inline bool QueueIdHasBeenSet() const { return m_queueIdHasBeenSet; }
  template <typename QueueIdT = Aws::String>
  void SetQueueId(QueueIdT&& value) {
    m_queueIdHasBeenSet = true;
    m_queueId = std::forward<QueueIdT>(value);
  }
  template <typename QueueIdT = Aws::String>
  Queue& WithQueueId(QueueIdT&& value) {
    SetQueueId(std::forward<QueueIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the queue.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Queue& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The outbound caller ID name, number, and outbound whisper flow.</p>
   */
  inline const OutboundCallerConfig& GetOutboundCallerConfig() const { return m_outboundCallerConfig; }
  inline bool OutboundCallerConfigHasBeenSet() const { return m_outboundCallerConfigHasBeenSet; }
  template <typename OutboundCallerConfigT = OutboundCallerConfig>
  void SetOutboundCallerConfig(OutboundCallerConfigT&& value) {
    m_outboundCallerConfigHasBeenSet = true;
    m_outboundCallerConfig = std::forward<OutboundCallerConfigT>(value);
  }
  template <typename OutboundCallerConfigT = OutboundCallerConfig>
  Queue& WithOutboundCallerConfig(OutboundCallerConfigT&& value) {
    SetOutboundCallerConfig(std::forward<OutboundCallerConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The outbound email address ID for a specified queue.</p>
   */
  inline const OutboundEmailConfig& GetOutboundEmailConfig() const { return m_outboundEmailConfig; }
  inline bool OutboundEmailConfigHasBeenSet() const { return m_outboundEmailConfigHasBeenSet; }
  template <typename OutboundEmailConfigT = OutboundEmailConfig>
  void SetOutboundEmailConfig(OutboundEmailConfigT&& value) {
    m_outboundEmailConfigHasBeenSet = true;
    m_outboundEmailConfig = std::forward<OutboundEmailConfigT>(value);
  }
  template <typename OutboundEmailConfigT = OutboundEmailConfig>
  Queue& WithOutboundEmailConfig(OutboundEmailConfigT&& value) {
    SetOutboundEmailConfig(std::forward<OutboundEmailConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for the hours of operation.</p>
   */
  inline const Aws::String& GetHoursOfOperationId() const { return m_hoursOfOperationId; }
  inline bool HoursOfOperationIdHasBeenSet() const { return m_hoursOfOperationIdHasBeenSet; }
  template <typename HoursOfOperationIdT = Aws::String>
  void SetHoursOfOperationId(HoursOfOperationIdT&& value) {
    m_hoursOfOperationIdHasBeenSet = true;
    m_hoursOfOperationId = std::forward<HoursOfOperationIdT>(value);
  }
  template <typename HoursOfOperationIdT = Aws::String>
  Queue& WithHoursOfOperationId(HoursOfOperationIdT&& value) {
    SetHoursOfOperationId(std::forward<HoursOfOperationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of contacts that can be in the queue before it is
   * considered full.</p>
   */
  inline int GetMaxContacts() const { return m_maxContacts; }
  inline bool MaxContactsHasBeenSet() const { return m_maxContactsHasBeenSet; }
  inline void SetMaxContacts(int value) {
    m_maxContactsHasBeenSet = true;
    m_maxContacts = value;
  }
  inline Queue& WithMaxContacts(int value) {
    SetMaxContacts(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the queue.</p>
   */
  inline QueueStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(QueueStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline Queue& WithStatus(QueueStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags used to organize, track, or control access for this resource. For
   * example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  Queue& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  Queue& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when this resource was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  Queue& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services Region where this resource was last modified.</p>
   */
  inline const Aws::String& GetLastModifiedRegion() const { return m_lastModifiedRegion; }
  inline bool LastModifiedRegionHasBeenSet() const { return m_lastModifiedRegionHasBeenSet; }
  template <typename LastModifiedRegionT = Aws::String>
  void SetLastModifiedRegion(LastModifiedRegionT&& value) {
    m_lastModifiedRegionHasBeenSet = true;
    m_lastModifiedRegion = std::forward<LastModifiedRegionT>(value);
  }
  template <typename LastModifiedRegionT = Aws::String>
  Queue& WithLastModifiedRegion(LastModifiedRegionT&& value) {
    SetLastModifiedRegion(std::forward<LastModifiedRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_queueArn;
  bool m_queueArnHasBeenSet = false;

  Aws::String m_queueId;
  bool m_queueIdHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  OutboundCallerConfig m_outboundCallerConfig;
  bool m_outboundCallerConfigHasBeenSet = false;

  OutboundEmailConfig m_outboundEmailConfig;
  bool m_outboundEmailConfigHasBeenSet = false;

  Aws::String m_hoursOfOperationId;
  bool m_hoursOfOperationIdHasBeenSet = false;

  int m_maxContacts{0};
  bool m_maxContactsHasBeenSet = false;

  QueueStatus m_status{QueueStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  Aws::String m_lastModifiedRegion;
  bool m_lastModifiedRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
