﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codestar-notifications/CodeStarNotificationsRequest.h>
#include <aws/codestar-notifications/CodeStarNotifications_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace CodeStarNotifications {
namespace Model {

/**
 */
class UnsubscribeRequest : public CodeStarNotificationsRequest {
 public:
  AWS_CODESTARNOTIFICATIONS_API UnsubscribeRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "Unsubscribe"; }

  AWS_CODESTARNOTIFICATIONS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the notification rule.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UnsubscribeRequest& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the Amazon Q Developer in chat applications topic to unsubscribe
   * from the notification rule.</p>
   */
  inline const Aws::String& GetTargetAddress() const { return m_targetAddress; }
  inline bool TargetAddressHasBeenSet() const { return m_targetAddressHasBeenSet; }
  template <typename TargetAddressT = Aws::String>
  void SetTargetAddress(TargetAddressT&& value) {
    m_targetAddressHasBeenSet = true;
    m_targetAddress = std::forward<TargetAddressT>(value);
  }
  template <typename TargetAddressT = Aws::String>
  UnsubscribeRequest& WithTargetAddress(TargetAddressT&& value) {
    SetTargetAddress(std::forward<TargetAddressT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_targetAddress;
  bool m_targetAddressHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeStarNotifications
}  // namespace Aws
