﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeguru-security/model/Vulnerability.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodeGuruSecurity {
namespace Model {

Vulnerability::Vulnerability(JsonView jsonValue) { *this = jsonValue; }

Vulnerability& Vulnerability::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("referenceUrls")) {
    Aws::Utils::Array<JsonView> referenceUrlsJsonList = jsonValue.GetArray("referenceUrls");
    for (unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex) {
      m_referenceUrls.push_back(referenceUrlsJsonList[referenceUrlsIndex].AsString());
    }
    m_referenceUrlsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("relatedVulnerabilities")) {
    Aws::Utils::Array<JsonView> relatedVulnerabilitiesJsonList = jsonValue.GetArray("relatedVulnerabilities");
    for (unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength();
         ++relatedVulnerabilitiesIndex) {
      m_relatedVulnerabilities.push_back(relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString());
    }
    m_relatedVulnerabilitiesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("id")) {
    m_id = jsonValue.GetString("id");
    m_idHasBeenSet = true;
  }
  if (jsonValue.ValueExists("filePath")) {
    m_filePath = jsonValue.GetObject("filePath");
    m_filePathHasBeenSet = true;
  }
  return *this;
}

JsonValue Vulnerability::Jsonize() const {
  JsonValue payload;

  if (m_referenceUrlsHasBeenSet) {
    Aws::Utils::Array<JsonValue> referenceUrlsJsonList(m_referenceUrls.size());
    for (unsigned referenceUrlsIndex = 0; referenceUrlsIndex < referenceUrlsJsonList.GetLength(); ++referenceUrlsIndex) {
      referenceUrlsJsonList[referenceUrlsIndex].AsString(m_referenceUrls[referenceUrlsIndex]);
    }
    payload.WithArray("referenceUrls", std::move(referenceUrlsJsonList));
  }

  if (m_relatedVulnerabilitiesHasBeenSet) {
    Aws::Utils::Array<JsonValue> relatedVulnerabilitiesJsonList(m_relatedVulnerabilities.size());
    for (unsigned relatedVulnerabilitiesIndex = 0; relatedVulnerabilitiesIndex < relatedVulnerabilitiesJsonList.GetLength();
         ++relatedVulnerabilitiesIndex) {
      relatedVulnerabilitiesJsonList[relatedVulnerabilitiesIndex].AsString(m_relatedVulnerabilities[relatedVulnerabilitiesIndex]);
    }
    payload.WithArray("relatedVulnerabilities", std::move(relatedVulnerabilitiesJsonList));
  }

  if (m_idHasBeenSet) {
    payload.WithString("id", m_id);
  }

  if (m_filePathHasBeenSet) {
    payload.WithObject("filePath", m_filePath.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CodeGuruSecurity
}  // namespace Aws
