﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/chime-sdk-voice/model/Capability.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class UpdateProxySessionRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API UpdateProxySessionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateProxySession"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Voice Connector ID.</p>
   */
  inline const Aws::String& GetVoiceConnectorId() const { return m_voiceConnectorId; }
  inline bool VoiceConnectorIdHasBeenSet() const { return m_voiceConnectorIdHasBeenSet; }
  template <typename VoiceConnectorIdT = Aws::String>
  void SetVoiceConnectorId(VoiceConnectorIdT&& value) {
    m_voiceConnectorIdHasBeenSet = true;
    m_voiceConnectorId = std::forward<VoiceConnectorIdT>(value);
  }
  template <typename VoiceConnectorIdT = Aws::String>
  UpdateProxySessionRequest& WithVoiceConnectorId(VoiceConnectorIdT&& value) {
    SetVoiceConnectorId(std::forward<VoiceConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The proxy session ID.</p>
   */
  inline const Aws::String& GetProxySessionId() const { return m_proxySessionId; }
  inline bool ProxySessionIdHasBeenSet() const { return m_proxySessionIdHasBeenSet; }
  template <typename ProxySessionIdT = Aws::String>
  void SetProxySessionId(ProxySessionIdT&& value) {
    m_proxySessionIdHasBeenSet = true;
    m_proxySessionId = std::forward<ProxySessionIdT>(value);
  }
  template <typename ProxySessionIdT = Aws::String>
  UpdateProxySessionRequest& WithProxySessionId(ProxySessionIdT&& value) {
    SetProxySessionId(std::forward<ProxySessionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The proxy session capabilities.</p>
   */
  inline const Aws::Vector<Capability>& GetCapabilities() const { return m_capabilities; }
  inline bool CapabilitiesHasBeenSet() const { return m_capabilitiesHasBeenSet; }
  template <typename CapabilitiesT = Aws::Vector<Capability>>
  void SetCapabilities(CapabilitiesT&& value) {
    m_capabilitiesHasBeenSet = true;
    m_capabilities = std::forward<CapabilitiesT>(value);
  }
  template <typename CapabilitiesT = Aws::Vector<Capability>>
  UpdateProxySessionRequest& WithCapabilities(CapabilitiesT&& value) {
    SetCapabilities(std::forward<CapabilitiesT>(value));
    return *this;
  }
  inline UpdateProxySessionRequest& AddCapabilities(Capability value) {
    m_capabilitiesHasBeenSet = true;
    m_capabilities.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of minutes allowed for the proxy session.</p>
   */
  inline int GetExpiryMinutes() const { return m_expiryMinutes; }
  inline bool ExpiryMinutesHasBeenSet() const { return m_expiryMinutesHasBeenSet; }
  inline void SetExpiryMinutes(int value) {
    m_expiryMinutesHasBeenSet = true;
    m_expiryMinutes = value;
  }
  inline UpdateProxySessionRequest& WithExpiryMinutes(int value) {
    SetExpiryMinutes(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceConnectorId;
  bool m_voiceConnectorIdHasBeenSet = false;

  Aws::String m_proxySessionId;
  bool m_proxySessionIdHasBeenSet = false;

  Aws::Vector<Capability> m_capabilities;
  bool m_capabilitiesHasBeenSet = false;

  int m_expiryMinutes{0};
  bool m_expiryMinutesHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
