﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/budgets/Budgets_EXPORTS.h>
#include <aws/budgets/model/ActionHistoryDetails.h>
#include <aws/budgets/model/ActionStatus.h>
#include <aws/budgets/model/EventType.h>
#include <aws/core/utils/DateTime.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Budgets {
namespace Model {

/**
 * <p>The historical records for a budget action. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/budgets-2016-10-20/ActionHistory">AWS
 * API Reference</a></p>
 */
class ActionHistory {
 public:
  AWS_BUDGETS_API ActionHistory() = default;
  AWS_BUDGETS_API ActionHistory(Aws::Utils::Json::JsonView jsonValue);
  AWS_BUDGETS_API ActionHistory& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BUDGETS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const Aws::Utils::DateTime& GetTimestamp() const { return m_timestamp; }
  inline bool TimestampHasBeenSet() const { return m_timestampHasBeenSet; }
  template <typename TimestampT = Aws::Utils::DateTime>
  void SetTimestamp(TimestampT&& value) {
    m_timestampHasBeenSet = true;
    m_timestamp = std::forward<TimestampT>(value);
  }
  template <typename TimestampT = Aws::Utils::DateTime>
  ActionHistory& WithTimestamp(TimestampT&& value) {
    SetTimestamp(std::forward<TimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of action at the time of the event. </p>
   */
  inline ActionStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ActionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline ActionHistory& WithStatus(ActionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This distinguishes between whether the events are triggered by the user or
   * are generated by the system. </p>
   */
  inline EventType GetEventType() const { return m_eventType; }
  inline bool EventTypeHasBeenSet() const { return m_eventTypeHasBeenSet; }
  inline void SetEventType(EventType value) {
    m_eventTypeHasBeenSet = true;
    m_eventType = value;
  }
  inline ActionHistory& WithEventType(EventType value) {
    SetEventType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the details for the event. </p>
   */
  inline const ActionHistoryDetails& GetActionHistoryDetails() const { return m_actionHistoryDetails; }
  inline bool ActionHistoryDetailsHasBeenSet() const { return m_actionHistoryDetailsHasBeenSet; }
  template <typename ActionHistoryDetailsT = ActionHistoryDetails>
  void SetActionHistoryDetails(ActionHistoryDetailsT&& value) {
    m_actionHistoryDetailsHasBeenSet = true;
    m_actionHistoryDetails = std::forward<ActionHistoryDetailsT>(value);
  }
  template <typename ActionHistoryDetailsT = ActionHistoryDetails>
  ActionHistory& WithActionHistoryDetails(ActionHistoryDetailsT&& value) {
    SetActionHistoryDetails(std::forward<ActionHistoryDetailsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_timestamp{};
  bool m_timestampHasBeenSet = false;

  ActionStatus m_status{ActionStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  EventType m_eventType{EventType::NOT_SET};
  bool m_eventTypeHasBeenSet = false;

  ActionHistoryDetails m_actionHistoryDetails;
  bool m_actionHistoryDetailsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Budgets
}  // namespace Aws
