﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/batch/model/UpdateJobQueueResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Batch::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateJobQueueResult::UpdateJobQueueResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UpdateJobQueueResult& UpdateJobQueueResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("jobQueueName")) {
    m_jobQueueName = jsonValue.GetString("jobQueueName");
    m_jobQueueNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("jobQueueArn")) {
    m_jobQueueArn = jsonValue.GetString("jobQueueArn");
    m_jobQueueArnHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
