/*
 * tkimgDecls.h --
 *
 *  Declarations of functions in the platform independent public TKIMG API.
 *
 */

#ifndef _TKIMGDECLS
#define _TKIMGDECLS

/*
 * WARNING: The contents of this file is automatically generated by the
 * genStubs.tcl script. Any modifications to the function declarations
 * below should be made in the tkimg.decls script.
 */

#include <tk.h>

#ifdef TKIMGAPI
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#else
#   define TKIMGAPI extern
#   undef USE_TKIMG_STUBS
#   define USE_TKIMG_STUBS 1
#endif

EXTERN int Tkimg_Init(Tcl_Interp *interp);
EXTERN int Tkimg_SafeInit(Tcl_Interp *interp);

#if !defined(TCL_SIZE_MAX) && !defined(Tcl_Size)
    typedef int Tcl_Size;
#endif

typedef struct tkimg_MFile {
	Tcl_DString *buffer; /* pointer to dynamical string */
	char *data; /* mmencoded source string */
	int c; /* bits left over from previous char */
	int state; /* decoder state (0-4 or IMG_DONE) */
#if TCL_MAJOR_VERSION > 8
	Tcl_Size length; /* length of physical line already written */
#else
	unsigned int length; /* length of physical line already written */
	int notused; /* just to be sure to always allocate more than enough */
#endif
} tkimg_MFile;

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
TKIMGAPI Tcl_Channel	tkimg_OpenFileChannel(Tcl_Interp *interp,
				const char *fileName, int permissions);
/* 1 */
TKIMGAPI int		tkimg_ReadInit(Tcl_Obj *data, int c,
				tkimg_MFile *handle);
/* 2 */
TKIMGAPI void		tkimg_WriteInit(Tcl_DString *buffer,
				tkimg_MFile *handle);
/* 3 */
TKIMGAPI int		tkimg_Getc(tkimg_MFile *handle);
/* 4 */
TKIMGAPI int		tkimg_Read(tkimg_MFile *handle, char *dst, int count);
/* 5 */
TKIMGAPI int		tkimg_Putc(int c, tkimg_MFile *handle);
/* 6 */
TKIMGAPI int		tkimg_Write(tkimg_MFile *handle, const char *src,
				int count);
/* 7 */
TKIMGAPI void		tkimg_ReadBuffer(int onOff);
/* 8 */
TKIMGAPI size_t		tkimg_Read2(tkimg_MFile *handle, char *dst,
				size_t count);
/* 9 */
TKIMGAPI size_t		tkimg_Write2(tkimg_MFile *handle, const char *src,
				size_t count);
/* 10 */
TKIMGAPI int		tkimg_PhotoPutBlock(Tcl_Interp *interp,
				Tk_PhotoHandle handle,
				Tk_PhotoImageBlock *blockPtr, int x, int y,
				int width, int height, int flags);
/* 11 */
TKIMGAPI int		tkimg_PhotoExpand(Tcl_Interp *interp,
				Tk_PhotoHandle handle, int width, int height);
/* 12 */
TKIMGAPI int		tkimg_PhotoSetSize(Tcl_Interp *interp,
				Tk_PhotoHandle handle, int width, int height);
/* Slot 13 is reserved */
/* Slot 14 is reserved */
/* Slot 15 is reserved */
/* Slot 16 is reserved */
/* Slot 17 is reserved */
/* Slot 18 is reserved */
/* Slot 19 is reserved */
/* Slot 20 is reserved */
/* Slot 21 is reserved */
/* Slot 22 is reserved */
/* Slot 23 is reserved */
/* Slot 24 is reserved */
/* Slot 25 is reserved */
/* Slot 26 is reserved */
/* Slot 27 is reserved */
/* Slot 28 is reserved */
/* Slot 29 is reserved */
/* 30 */
TKIMGAPI const char *	tkimg_GetStringFromObj(Tcl_Obj *objPtr,
				Tcl_Size *lengthPtr);
/* 31 */
TKIMGAPI unsigned char * tkimg_GetByteArrayFromObj(Tcl_Obj *objPtr,
				Tcl_Size *lengthPtr);
/* 32 */
TKIMGAPI int		tkimg_ListObjGetElements(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Tcl_Size *objc,
				Tcl_Obj ***objv);
/* 33 */
TKIMGAPI const char *	tkimg_GetStringFromObj2(Tcl_Obj *objPtr,
				size_t *lengthPtr);
/* 34 */
TKIMGAPI unsigned char * tkimg_GetByteArrayFromObj2(Tcl_Obj *objPtr,
				size_t *lengthPtr);
/* Slot 35 is reserved */
/* Slot 36 is reserved */
/* Slot 37 is reserved */
/* Slot 38 is reserved */
/* Slot 39 is reserved */
/* Slot 40 is reserved */
/* Slot 41 is reserved */
/* Slot 42 is reserved */
/* Slot 43 is reserved */
/* Slot 44 is reserved */
/* Slot 45 is reserved */
/* Slot 46 is reserved */
/* Slot 47 is reserved */
/* Slot 48 is reserved */
/* Slot 49 is reserved */
/* 50 */
TKIMGAPI int		tkimg_IsIntel(void);
/* 51 */
TKIMGAPI void		tkimg_CreateGammaTable(double gammaVal,
				double *gammaTable);
/* 52 */
TKIMGAPI double		tkimg_LookupGammaTable(double val,
				const double *gammaTable);
/* 53 */
TKIMGAPI void		tkimg_UShortToUByte(int n,
				const unsigned short *shortIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 54 */
TKIMGAPI void		tkimg_ShortToUByte(int n, const short *shortIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 55 */
TKIMGAPI void		tkimg_FloatToUByte(int n, const float *floatIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 56 */
TKIMGAPI int		tkimg_ReadUByteRow(tkimg_MFile *handle,
				unsigned char *pixels, int nBytes);
/* 57 */
TKIMGAPI int		tkimg_ReadUShortRow(tkimg_MFile *handle,
				unsigned short *pixels, int nShorts,
				char *buf, int swapBytes);
/* 58 */
TKIMGAPI int		tkimg_ReadShortRow(tkimg_MFile *handle,
				short *pixels, int nShorts, char *buf,
				int swapBytes);
/* 59 */
TKIMGAPI int		tkimg_ReadFloatRow(tkimg_MFile *handle,
				float *pixels, int nFloats, char *buf,
				int swapBytes);
/* 60 */
TKIMGAPI int		tkimg_ReadUByteFile(tkimg_MFile *handle,
				unsigned char *buf, int width, int height,
				int nchan, int verbose, int findMinMax,
				double *minVals, double *maxVals);
/* 61 */
TKIMGAPI int		tkimg_ReadUShortFile(tkimg_MFile *handle,
				unsigned short *buf, int width, int height,
				int nchan, int swapBytes, int verbose,
				int findMinMax, double *minVals,
				double *maxVals, double saturation);
/* 62 */
TKIMGAPI int		tkimg_ReadFloatFile(tkimg_MFile *handle, float *buf,
				int width, int height, int nchan,
				int swapBytes, int verbose, int findMinMax,
				double *minVals, double *maxVals,
				double saturation);
/* 63 */
TKIMGAPI void		tkimg_RemapUShortValues(unsigned short *buf,
				int width, int height, int nchan,
				double *minVals, double *maxVals,
				double agcCutOffPercent, int printAgc);
/* 64 */
TKIMGAPI void		tkimg_RemapFloatValues(float *buf, int width,
				int height, int nchan, double *minVals,
				double *maxVals, double agcCutOffPercent,
				int printAgc);
/* 65 */
TKIMGAPI void		tkimg_UIntToUByte(int n, const unsigned int *intIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 66 */
TKIMGAPI void		tkimg_IntToUByte(int n, const int *intIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 67 */
TKIMGAPI int		tkimg_ReadUIntRow(tkimg_MFile *handle,
				unsigned int *pixels, int nInts, char *buf,
				int swapBytes);
/* 68 */
TKIMGAPI int		tkimg_ReadIntRow(tkimg_MFile *handle, int *pixels,
				int nInts, char *buf, int swapBytes);
/* 69 */
TKIMGAPI int		tkimg_ReadUIntFile(tkimg_MFile *handle,
				unsigned int *buf, int width, int height,
				int nchan, int swapBytes, int verbose,
				int findMinMax, double *minVals,
				double *maxVals, double saturation);
/* 70 */
TKIMGAPI void		tkimg_RemapUIntValues(unsigned int *buf, int width,
				int height, int nchan, double *minVals,
				double *maxVals, double agcCutOffPercent,
				int printAgc);
/* 71 */
TKIMGAPI void		tkimg_DoubleToUByte(int n, const double *doubleIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 72 */
TKIMGAPI int		tkimg_ReadDoubleRow(tkimg_MFile *handle,
				double *pixels, int nDoubles, char *buf,
				int swapBytes);
/* 73 */
TKIMGAPI int		tkimg_ReadDoubleFile(tkimg_MFile *handle,
				double *buf, int width, int height,
				int nchan, int swapBytes, int verbose,
				int findMinMax, double *minVals,
				double *maxVals, double saturation);
/* 74 */
TKIMGAPI void		tkimg_RemapDoubleValues(double *buf, int width,
				int height, int nchan, double *minVals,
				double *maxVals, double agcCutOffPercent,
				int printAgc);

typedef struct TkimgStubs {
    int magic;
    const struct TkimgStubHooks *hooks;

    Tcl_Channel (*tkimg_OpenFileChannelPtr) (Tcl_Interp *interp, const char *fileName, int permissions); /* 0 */
    int (*tkimg_ReadInitPtr) (Tcl_Obj *data, int c, tkimg_MFile *handle); /* 1 */
    void (*tkimg_WriteInitPtr) (Tcl_DString *buffer, tkimg_MFile *handle); /* 2 */
    int (*tkimg_GetcPtr) (tkimg_MFile *handle); /* 3 */
    int (*tkimg_ReadPtr) (tkimg_MFile *handle, char *dst, int count); /* 4 */
    int (*tkimg_PutcPtr) (int c, tkimg_MFile *handle); /* 5 */
    int (*tkimg_WritePtr) (tkimg_MFile *handle, const char *src, int count); /* 6 */
    void (*tkimg_ReadBufferPtr) (int onOff); /* 7 */
    size_t (*tkimg_Read2Ptr) (tkimg_MFile *handle, char *dst, size_t count); /* 8 */
    size_t (*tkimg_Write2Ptr) (tkimg_MFile *handle, const char *src, size_t count); /* 9 */
    int (*tkimg_PhotoPutBlockPtr) (Tcl_Interp *interp, Tk_PhotoHandle handle, Tk_PhotoImageBlock *blockPtr, int x, int y, int width, int height, int flags); /* 10 */
    int (*tkimg_PhotoExpandPtr) (Tcl_Interp *interp, Tk_PhotoHandle handle, int width, int height); /* 11 */
    int (*tkimg_PhotoSetSizePtr) (Tcl_Interp *interp, Tk_PhotoHandle handle, int width, int height); /* 12 */
    void (*reserved13)(void);
    void (*reserved14)(void);
    void (*reserved15)(void);
    void (*reserved16)(void);
    void (*reserved17)(void);
    void (*reserved18)(void);
    void (*reserved19)(void);
    void (*reserved20)(void);
    void (*reserved21)(void);
    void (*reserved22)(void);
    void (*reserved23)(void);
    void (*reserved24)(void);
    void (*reserved25)(void);
    void (*reserved26)(void);
    void (*reserved27)(void);
    void (*reserved28)(void);
    void (*reserved29)(void);
    const char * (*tkimg_GetStringFromObjPtr) (Tcl_Obj *objPtr, Tcl_Size *lengthPtr); /* 30 */
    unsigned char * (*tkimg_GetByteArrayFromObjPtr) (Tcl_Obj *objPtr, Tcl_Size *lengthPtr); /* 31 */
    int (*tkimg_ListObjGetElementsPtr) (Tcl_Interp *interp, Tcl_Obj *objPtr, Tcl_Size *objc, Tcl_Obj ***objv); /* 32 */
    const char * (*tkimg_GetStringFromObj2Ptr) (Tcl_Obj *objPtr, size_t *lengthPtr); /* 33 */
    unsigned char * (*tkimg_GetByteArrayFromObj2Ptr) (Tcl_Obj *objPtr, size_t *lengthPtr); /* 34 */
    void (*reserved35)(void);
    void (*reserved36)(void);
    void (*reserved37)(void);
    void (*reserved38)(void);
    void (*reserved39)(void);
    void (*reserved40)(void);
    void (*reserved41)(void);
    void (*reserved42)(void);
    void (*reserved43)(void);
    void (*reserved44)(void);
    void (*reserved45)(void);
    void (*reserved46)(void);
    void (*reserved47)(void);
    void (*reserved48)(void);
    void (*reserved49)(void);
    int (*tkimg_IsIntelPtr) (void); /* 50 */
    void (*tkimg_CreateGammaTablePtr) (double gammaVal, double *gammaTable); /* 51 */
    double (*tkimg_LookupGammaTablePtr) (double val, const double *gammaTable); /* 52 */
    void (*tkimg_UShortToUBytePtr) (int n, const unsigned short *shortIn, const double *gammaTable, unsigned char *ubOut); /* 53 */
    void (*tkimg_ShortToUBytePtr) (int n, const short *shortIn, const double *gammaTable, unsigned char *ubOut); /* 54 */
    void (*tkimg_FloatToUBytePtr) (int n, const float *floatIn, const double *gammaTable, unsigned char *ubOut); /* 55 */
    int (*tkimg_ReadUByteRowPtr) (tkimg_MFile *handle, unsigned char *pixels, int nBytes); /* 56 */
    int (*tkimg_ReadUShortRowPtr) (tkimg_MFile *handle, unsigned short *pixels, int nShorts, char *buf, int swapBytes); /* 57 */
    int (*tkimg_ReadShortRowPtr) (tkimg_MFile *handle, short *pixels, int nShorts, char *buf, int swapBytes); /* 58 */
    int (*tkimg_ReadFloatRowPtr) (tkimg_MFile *handle, float *pixels, int nFloats, char *buf, int swapBytes); /* 59 */
    int (*tkimg_ReadUByteFilePtr) (tkimg_MFile *handle, unsigned char *buf, int width, int height, int nchan, int verbose, int findMinMax, double *minVals, double *maxVals); /* 60 */
    int (*tkimg_ReadUShortFilePtr) (tkimg_MFile *handle, unsigned short *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 61 */
    int (*tkimg_ReadFloatFilePtr) (tkimg_MFile *handle, float *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 62 */
    void (*tkimg_RemapUShortValuesPtr) (unsigned short *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 63 */
    void (*tkimg_RemapFloatValuesPtr) (float *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 64 */
    void (*tkimg_UIntToUBytePtr) (int n, const unsigned int *intIn, const double *gammaTable, unsigned char *ubOut); /* 65 */
    void (*tkimg_IntToUBytePtr) (int n, const int *intIn, const double *gammaTable, unsigned char *ubOut); /* 66 */
    int (*tkimg_ReadUIntRowPtr) (tkimg_MFile *handle, unsigned int *pixels, int nInts, char *buf, int swapBytes); /* 67 */
    int (*tkimg_ReadIntRowPtr) (tkimg_MFile *handle, int *pixels, int nInts, char *buf, int swapBytes); /* 68 */
    int (*tkimg_ReadUIntFilePtr) (tkimg_MFile *handle, unsigned int *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 69 */
    void (*tkimg_RemapUIntValuesPtr) (unsigned int *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 70 */
    void (*tkimg_DoubleToUBytePtr) (int n, const double *doubleIn, const double *gammaTable, unsigned char *ubOut); /* 71 */
    int (*tkimg_ReadDoubleRowPtr) (tkimg_MFile *handle, double *pixels, int nDoubles, char *buf, int swapBytes); /* 72 */
    int (*tkimg_ReadDoubleFilePtr) (tkimg_MFile *handle, double *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 73 */
    void (*tkimg_RemapDoubleValuesPtr) (double *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 74 */
} TkimgStubs;

#ifdef __cplusplus
extern "C" {
#endif
TKIMGAPI const TkimgStubs *tkimgStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TKIMG_STUBS)

/*
 * Inline function declarations:
 */

#define tkimg_OpenFileChannel \
	(tkimgStubsPtr->tkimg_OpenFileChannelPtr) /* 0 */
#define tkimg_ReadInit \
	(tkimgStubsPtr->tkimg_ReadInitPtr) /* 1 */
#define tkimg_WriteInit \
	(tkimgStubsPtr->tkimg_WriteInitPtr) /* 2 */
#define tkimg_Getc \
	(tkimgStubsPtr->tkimg_GetcPtr) /* 3 */
#define tkimg_Read \
	(tkimgStubsPtr->tkimg_ReadPtr) /* 4 */
#define tkimg_Putc \
	(tkimgStubsPtr->tkimg_PutcPtr) /* 5 */
#define tkimg_Write \
	(tkimgStubsPtr->tkimg_WritePtr) /* 6 */
#define tkimg_ReadBuffer \
	(tkimgStubsPtr->tkimg_ReadBufferPtr) /* 7 */
#define tkimg_Read2 \
	(tkimgStubsPtr->tkimg_Read2Ptr) /* 8 */
#define tkimg_Write2 \
	(tkimgStubsPtr->tkimg_Write2Ptr) /* 9 */
#define tkimg_PhotoPutBlock \
	(tkimgStubsPtr->tkimg_PhotoPutBlockPtr) /* 10 */
#define tkimg_PhotoExpand \
	(tkimgStubsPtr->tkimg_PhotoExpandPtr) /* 11 */
#define tkimg_PhotoSetSize \
	(tkimgStubsPtr->tkimg_PhotoSetSizePtr) /* 12 */
/* Slot 13 is reserved */
/* Slot 14 is reserved */
/* Slot 15 is reserved */
/* Slot 16 is reserved */
/* Slot 17 is reserved */
/* Slot 18 is reserved */
/* Slot 19 is reserved */
/* Slot 20 is reserved */
/* Slot 21 is reserved */
/* Slot 22 is reserved */
/* Slot 23 is reserved */
/* Slot 24 is reserved */
/* Slot 25 is reserved */
/* Slot 26 is reserved */
/* Slot 27 is reserved */
/* Slot 28 is reserved */
/* Slot 29 is reserved */
#define tkimg_GetStringFromObj \
	(tkimgStubsPtr->tkimg_GetStringFromObjPtr) /* 30 */
#define tkimg_GetByteArrayFromObj \
	(tkimgStubsPtr->tkimg_GetByteArrayFromObjPtr) /* 31 */
#define tkimg_ListObjGetElements \
	(tkimgStubsPtr->tkimg_ListObjGetElementsPtr) /* 32 */
#define tkimg_GetStringFromObj2 \
	(tkimgStubsPtr->tkimg_GetStringFromObj2Ptr) /* 33 */
#define tkimg_GetByteArrayFromObj2 \
	(tkimgStubsPtr->tkimg_GetByteArrayFromObj2Ptr) /* 34 */
/* Slot 35 is reserved */
/* Slot 36 is reserved */
/* Slot 37 is reserved */
/* Slot 38 is reserved */
/* Slot 39 is reserved */
/* Slot 40 is reserved */
/* Slot 41 is reserved */
/* Slot 42 is reserved */
/* Slot 43 is reserved */
/* Slot 44 is reserved */
/* Slot 45 is reserved */
/* Slot 46 is reserved */
/* Slot 47 is reserved */
/* Slot 48 is reserved */
/* Slot 49 is reserved */
#define tkimg_IsIntel \
	(tkimgStubsPtr->tkimg_IsIntelPtr) /* 50 */
#define tkimg_CreateGammaTable \
	(tkimgStubsPtr->tkimg_CreateGammaTablePtr) /* 51 */
#define tkimg_LookupGammaTable \
	(tkimgStubsPtr->tkimg_LookupGammaTablePtr) /* 52 */
#define tkimg_UShortToUByte \
	(tkimgStubsPtr->tkimg_UShortToUBytePtr) /* 53 */
#define tkimg_ShortToUByte \
	(tkimgStubsPtr->tkimg_ShortToUBytePtr) /* 54 */
#define tkimg_FloatToUByte \
	(tkimgStubsPtr->tkimg_FloatToUBytePtr) /* 55 */
#define tkimg_ReadUByteRow \
	(tkimgStubsPtr->tkimg_ReadUByteRowPtr) /* 56 */
#define tkimg_ReadUShortRow \
	(tkimgStubsPtr->tkimg_ReadUShortRowPtr) /* 57 */
#define tkimg_ReadShortRow \
	(tkimgStubsPtr->tkimg_ReadShortRowPtr) /* 58 */
#define tkimg_ReadFloatRow \
	(tkimgStubsPtr->tkimg_ReadFloatRowPtr) /* 59 */
#define tkimg_ReadUByteFile \
	(tkimgStubsPtr->tkimg_ReadUByteFilePtr) /* 60 */
#define tkimg_ReadUShortFile \
	(tkimgStubsPtr->tkimg_ReadUShortFilePtr) /* 61 */
#define tkimg_ReadFloatFile \
	(tkimgStubsPtr->tkimg_ReadFloatFilePtr) /* 62 */
#define tkimg_RemapUShortValues \
	(tkimgStubsPtr->tkimg_RemapUShortValuesPtr) /* 63 */
#define tkimg_RemapFloatValues \
	(tkimgStubsPtr->tkimg_RemapFloatValuesPtr) /* 64 */
#define tkimg_UIntToUByte \
	(tkimgStubsPtr->tkimg_UIntToUBytePtr) /* 65 */
#define tkimg_IntToUByte \
	(tkimgStubsPtr->tkimg_IntToUBytePtr) /* 66 */
#define tkimg_ReadUIntRow \
	(tkimgStubsPtr->tkimg_ReadUIntRowPtr) /* 67 */
#define tkimg_ReadIntRow \
	(tkimgStubsPtr->tkimg_ReadIntRowPtr) /* 68 */
#define tkimg_ReadUIntFile \
	(tkimgStubsPtr->tkimg_ReadUIntFilePtr) /* 69 */
#define tkimg_RemapUIntValues \
	(tkimgStubsPtr->tkimg_RemapUIntValuesPtr) /* 70 */
#define tkimg_DoubleToUByte \
	(tkimgStubsPtr->tkimg_DoubleToUBytePtr) /* 71 */
#define tkimg_ReadDoubleRow \
	(tkimgStubsPtr->tkimg_ReadDoubleRowPtr) /* 72 */
#define tkimg_ReadDoubleFile \
	(tkimgStubsPtr->tkimg_ReadDoubleFilePtr) /* 73 */
#define tkimg_RemapDoubleValues \
	(tkimgStubsPtr->tkimg_RemapDoubleValuesPtr) /* 74 */

#endif /* defined(USE_TKIMG_STUBS) */

/* !END!: Do not edit above this line. */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKIMGDECLS */
