// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package medicalimaging

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCopyImageSet = "CopyImageSet"

// CopyImageSetRequest generates a "aws/request.Request" representing the
// client's request for the CopyImageSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyImageSet for more information on using the CopyImageSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyImageSetRequest method.
//	req, resp := client.CopyImageSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/CopyImageSet
func (c *MedicalImaging) CopyImageSetRequest(input *CopyImageSetInput) (req *request.Request, output *CopyImageSetOutput) {
	op := &request.Operation{
		Name:       opCopyImageSet,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{sourceImageSetId}/copyImageSet",
	}

	if input == nil {
		input = &CopyImageSetInput{}
	}

	output = &CopyImageSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CopyImageSet API operation for AWS Health Imaging.
//
// Copy an image set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation CopyImageSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ServiceQuotaExceededException
//     The request caused a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/CopyImageSet
func (c *MedicalImaging) CopyImageSet(input *CopyImageSetInput) (*CopyImageSetOutput, error) {
	req, out := c.CopyImageSetRequest(input)
	return out, req.Send()
}

// CopyImageSetWithContext is the same as CopyImageSet with the addition of
// the ability to pass a context and additional request options.
//
// See CopyImageSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) CopyImageSetWithContext(ctx aws.Context, input *CopyImageSetInput, opts ...request.Option) (*CopyImageSetOutput, error) {
	req, out := c.CopyImageSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatastore = "CreateDatastore"

// CreateDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatastore for more information on using the CreateDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDatastoreRequest method.
//	req, resp := client.CreateDatastoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/CreateDatastore
func (c *MedicalImaging) CreateDatastoreRequest(input *CreateDatastoreInput) (req *request.Request, output *CreateDatastoreOutput) {
	op := &request.Operation{
		Name:       opCreateDatastore,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore",
	}

	if input == nil {
		input = &CreateDatastoreInput{}
	}

	output = &CreateDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatastore API operation for AWS Health Imaging.
//
// Create a data store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation CreateDatastore for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ServiceQuotaExceededException
//     The request caused a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/CreateDatastore
func (c *MedicalImaging) CreateDatastore(input *CreateDatastoreInput) (*CreateDatastoreOutput, error) {
	req, out := c.CreateDatastoreRequest(input)
	return out, req.Send()
}

// CreateDatastoreWithContext is the same as CreateDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) CreateDatastoreWithContext(ctx aws.Context, input *CreateDatastoreInput, opts ...request.Option) (*CreateDatastoreOutput, error) {
	req, out := c.CreateDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatastore = "DeleteDatastore"

// DeleteDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatastore for more information on using the DeleteDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDatastoreRequest method.
//	req, resp := client.DeleteDatastoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/DeleteDatastore
func (c *MedicalImaging) DeleteDatastoreRequest(input *DeleteDatastoreInput) (req *request.Request, output *DeleteDatastoreOutput) {
	op := &request.Operation{
		Name:       opDeleteDatastore,
		HTTPMethod: "DELETE",
		HTTPPath:   "/datastore/{datastoreId}",
	}

	if input == nil {
		input = &DeleteDatastoreInput{}
	}

	output = &DeleteDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDatastore API operation for AWS Health Imaging.
//
// Delete a data store.
//
// Before a data store can be deleted, you must first delete all image sets
// within it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation DeleteDatastore for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/DeleteDatastore
func (c *MedicalImaging) DeleteDatastore(input *DeleteDatastoreInput) (*DeleteDatastoreOutput, error) {
	req, out := c.DeleteDatastoreRequest(input)
	return out, req.Send()
}

// DeleteDatastoreWithContext is the same as DeleteDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) DeleteDatastoreWithContext(ctx aws.Context, input *DeleteDatastoreInput, opts ...request.Option) (*DeleteDatastoreOutput, error) {
	req, out := c.DeleteDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteImageSet = "DeleteImageSet"

// DeleteImageSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImageSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteImageSet for more information on using the DeleteImageSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteImageSetRequest method.
//	req, resp := client.DeleteImageSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/DeleteImageSet
func (c *MedicalImaging) DeleteImageSetRequest(input *DeleteImageSetInput) (req *request.Request, output *DeleteImageSetOutput) {
	op := &request.Operation{
		Name:       opDeleteImageSet,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{imageSetId}/deleteImageSet",
	}

	if input == nil {
		input = &DeleteImageSetInput{}
	}

	output = &DeleteImageSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteImageSet API operation for AWS Health Imaging.
//
// Delete an image set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation DeleteImageSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/DeleteImageSet
func (c *MedicalImaging) DeleteImageSet(input *DeleteImageSetInput) (*DeleteImageSetOutput, error) {
	req, out := c.DeleteImageSetRequest(input)
	return out, req.Send()
}

// DeleteImageSetWithContext is the same as DeleteImageSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteImageSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) DeleteImageSetWithContext(ctx aws.Context, input *DeleteImageSetInput, opts ...request.Option) (*DeleteImageSetOutput, error) {
	req, out := c.DeleteImageSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDICOMImportJob = "GetDICOMImportJob"

// GetDICOMImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetDICOMImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDICOMImportJob for more information on using the GetDICOMImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDICOMImportJobRequest method.
//	req, resp := client.GetDICOMImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetDICOMImportJob
func (c *MedicalImaging) GetDICOMImportJobRequest(input *GetDICOMImportJobInput) (req *request.Request, output *GetDICOMImportJobOutput) {
	op := &request.Operation{
		Name:       opGetDICOMImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/getDICOMImportJob/datastore/{datastoreId}/job/{jobId}",
	}

	if input == nil {
		input = &GetDICOMImportJobInput{}
	}

	output = &GetDICOMImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDICOMImportJob API operation for AWS Health Imaging.
//
// Get the import job properties to learn more about the job or job progress.
//
// The jobStatus refers to the execution of the import job. Therefore, an import
// job can return a jobStatus as COMPLETED even if validation issues are discovered
// during the import process. If a jobStatus returns as COMPLETED, we still
// recommend you review the output manifests written to S3, as they provide
// details on the success or failure of individual P10 object imports.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation GetDICOMImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetDICOMImportJob
func (c *MedicalImaging) GetDICOMImportJob(input *GetDICOMImportJobInput) (*GetDICOMImportJobOutput, error) {
	req, out := c.GetDICOMImportJobRequest(input)
	return out, req.Send()
}

// GetDICOMImportJobWithContext is the same as GetDICOMImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetDICOMImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) GetDICOMImportJobWithContext(ctx aws.Context, input *GetDICOMImportJobInput, opts ...request.Option) (*GetDICOMImportJobOutput, error) {
	req, out := c.GetDICOMImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatastore = "GetDatastore"

// GetDatastoreRequest generates a "aws/request.Request" representing the
// client's request for the GetDatastore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatastore for more information on using the GetDatastore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDatastoreRequest method.
//	req, resp := client.GetDatastoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetDatastore
func (c *MedicalImaging) GetDatastoreRequest(input *GetDatastoreInput) (req *request.Request, output *GetDatastoreOutput) {
	op := &request.Operation{
		Name:       opGetDatastore,
		HTTPMethod: "GET",
		HTTPPath:   "/datastore/{datastoreId}",
	}

	if input == nil {
		input = &GetDatastoreInput{}
	}

	output = &GetDatastoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatastore API operation for AWS Health Imaging.
//
// Get data store properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation GetDatastore for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetDatastore
func (c *MedicalImaging) GetDatastore(input *GetDatastoreInput) (*GetDatastoreOutput, error) {
	req, out := c.GetDatastoreRequest(input)
	return out, req.Send()
}

// GetDatastoreWithContext is the same as GetDatastore with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatastore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) GetDatastoreWithContext(ctx aws.Context, input *GetDatastoreInput, opts ...request.Option) (*GetDatastoreOutput, error) {
	req, out := c.GetDatastoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImageFrame = "GetImageFrame"

// GetImageFrameRequest generates a "aws/request.Request" representing the
// client's request for the GetImageFrame operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImageFrame for more information on using the GetImageFrame
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImageFrameRequest method.
//	req, resp := client.GetImageFrameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetImageFrame
func (c *MedicalImaging) GetImageFrameRequest(input *GetImageFrameInput) (req *request.Request, output *GetImageFrameOutput) {
	op := &request.Operation{
		Name:       opGetImageFrame,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{imageSetId}/getImageFrame",
	}

	if input == nil {
		input = &GetImageFrameInput{}
	}

	output = &GetImageFrameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetImageFrame API operation for AWS Health Imaging.
//
// Get an image frame (pixel data) for an image set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation GetImageFrame for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetImageFrame
func (c *MedicalImaging) GetImageFrame(input *GetImageFrameInput) (*GetImageFrameOutput, error) {
	req, out := c.GetImageFrameRequest(input)
	return out, req.Send()
}

// GetImageFrameWithContext is the same as GetImageFrame with the addition of
// the ability to pass a context and additional request options.
//
// See GetImageFrame for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) GetImageFrameWithContext(ctx aws.Context, input *GetImageFrameInput, opts ...request.Option) (*GetImageFrameOutput, error) {
	req, out := c.GetImageFrameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImageSet = "GetImageSet"

// GetImageSetRequest generates a "aws/request.Request" representing the
// client's request for the GetImageSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImageSet for more information on using the GetImageSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImageSetRequest method.
//	req, resp := client.GetImageSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetImageSet
func (c *MedicalImaging) GetImageSetRequest(input *GetImageSetInput) (req *request.Request, output *GetImageSetOutput) {
	op := &request.Operation{
		Name:       opGetImageSet,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{imageSetId}/getImageSet",
	}

	if input == nil {
		input = &GetImageSetInput{}
	}

	output = &GetImageSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetImageSet API operation for AWS Health Imaging.
//
// Get image set properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation GetImageSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetImageSet
func (c *MedicalImaging) GetImageSet(input *GetImageSetInput) (*GetImageSetOutput, error) {
	req, out := c.GetImageSetRequest(input)
	return out, req.Send()
}

// GetImageSetWithContext is the same as GetImageSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetImageSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) GetImageSetWithContext(ctx aws.Context, input *GetImageSetInput, opts ...request.Option) (*GetImageSetOutput, error) {
	req, out := c.GetImageSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImageSetMetadata = "GetImageSetMetadata"

// GetImageSetMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetImageSetMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImageSetMetadata for more information on using the GetImageSetMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetImageSetMetadataRequest method.
//	req, resp := client.GetImageSetMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetImageSetMetadata
func (c *MedicalImaging) GetImageSetMetadataRequest(input *GetImageSetMetadataInput) (req *request.Request, output *GetImageSetMetadataOutput) {
	op := &request.Operation{
		Name:       opGetImageSetMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{imageSetId}/getImageSetMetadata",
	}

	if input == nil {
		input = &GetImageSetMetadataInput{}
	}

	output = &GetImageSetMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetImageSetMetadata API operation for AWS Health Imaging.
//
// Get metadata attributes for an image set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation GetImageSetMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/GetImageSetMetadata
func (c *MedicalImaging) GetImageSetMetadata(input *GetImageSetMetadataInput) (*GetImageSetMetadataOutput, error) {
	req, out := c.GetImageSetMetadataRequest(input)
	return out, req.Send()
}

// GetImageSetMetadataWithContext is the same as GetImageSetMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetImageSetMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) GetImageSetMetadataWithContext(ctx aws.Context, input *GetImageSetMetadataInput, opts ...request.Option) (*GetImageSetMetadataOutput, error) {
	req, out := c.GetImageSetMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDICOMImportJobs = "ListDICOMImportJobs"

// ListDICOMImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDICOMImportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDICOMImportJobs for more information on using the ListDICOMImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDICOMImportJobsRequest method.
//	req, resp := client.ListDICOMImportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListDICOMImportJobs
func (c *MedicalImaging) ListDICOMImportJobsRequest(input *ListDICOMImportJobsInput) (req *request.Request, output *ListDICOMImportJobsOutput) {
	op := &request.Operation{
		Name:       opListDICOMImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/listDICOMImportJobs/datastore/{datastoreId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDICOMImportJobsInput{}
	}

	output = &ListDICOMImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDICOMImportJobs API operation for AWS Health Imaging.
//
// List import jobs created for a specific data store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation ListDICOMImportJobs for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListDICOMImportJobs
func (c *MedicalImaging) ListDICOMImportJobs(input *ListDICOMImportJobsInput) (*ListDICOMImportJobsOutput, error) {
	req, out := c.ListDICOMImportJobsRequest(input)
	return out, req.Send()
}

// ListDICOMImportJobsWithContext is the same as ListDICOMImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDICOMImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListDICOMImportJobsWithContext(ctx aws.Context, input *ListDICOMImportJobsInput, opts ...request.Option) (*ListDICOMImportJobsOutput, error) {
	req, out := c.ListDICOMImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDICOMImportJobsPages iterates over the pages of a ListDICOMImportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDICOMImportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDICOMImportJobs operation.
//	pageNum := 0
//	err := client.ListDICOMImportJobsPages(params,
//	    func(page *medicalimaging.ListDICOMImportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MedicalImaging) ListDICOMImportJobsPages(input *ListDICOMImportJobsInput, fn func(*ListDICOMImportJobsOutput, bool) bool) error {
	return c.ListDICOMImportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDICOMImportJobsPagesWithContext same as ListDICOMImportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListDICOMImportJobsPagesWithContext(ctx aws.Context, input *ListDICOMImportJobsInput, fn func(*ListDICOMImportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDICOMImportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDICOMImportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDICOMImportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatastores = "ListDatastores"

// ListDatastoresRequest generates a "aws/request.Request" representing the
// client's request for the ListDatastores operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatastores for more information on using the ListDatastores
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDatastoresRequest method.
//	req, resp := client.ListDatastoresRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListDatastores
func (c *MedicalImaging) ListDatastoresRequest(input *ListDatastoresInput) (req *request.Request, output *ListDatastoresOutput) {
	op := &request.Operation{
		Name:       opListDatastores,
		HTTPMethod: "GET",
		HTTPPath:   "/datastore",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatastoresInput{}
	}

	output = &ListDatastoresOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatastores API operation for AWS Health Imaging.
//
// List data stores.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation ListDatastores for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListDatastores
func (c *MedicalImaging) ListDatastores(input *ListDatastoresInput) (*ListDatastoresOutput, error) {
	req, out := c.ListDatastoresRequest(input)
	return out, req.Send()
}

// ListDatastoresWithContext is the same as ListDatastores with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatastores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListDatastoresWithContext(ctx aws.Context, input *ListDatastoresInput, opts ...request.Option) (*ListDatastoresOutput, error) {
	req, out := c.ListDatastoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatastoresPages iterates over the pages of a ListDatastores operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatastores method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDatastores operation.
//	pageNum := 0
//	err := client.ListDatastoresPages(params,
//	    func(page *medicalimaging.ListDatastoresOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MedicalImaging) ListDatastoresPages(input *ListDatastoresInput, fn func(*ListDatastoresOutput, bool) bool) error {
	return c.ListDatastoresPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatastoresPagesWithContext same as ListDatastoresPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListDatastoresPagesWithContext(ctx aws.Context, input *ListDatastoresInput, fn func(*ListDatastoresOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatastoresInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatastoresRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatastoresOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListImageSetVersions = "ListImageSetVersions"

// ListImageSetVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListImageSetVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListImageSetVersions for more information on using the ListImageSetVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListImageSetVersionsRequest method.
//	req, resp := client.ListImageSetVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListImageSetVersions
func (c *MedicalImaging) ListImageSetVersionsRequest(input *ListImageSetVersionsInput) (req *request.Request, output *ListImageSetVersionsOutput) {
	op := &request.Operation{
		Name:       opListImageSetVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{imageSetId}/listImageSetVersions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListImageSetVersionsInput{}
	}

	output = &ListImageSetVersionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListImageSetVersions API operation for AWS Health Imaging.
//
// List image set versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation ListImageSetVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListImageSetVersions
func (c *MedicalImaging) ListImageSetVersions(input *ListImageSetVersionsInput) (*ListImageSetVersionsOutput, error) {
	req, out := c.ListImageSetVersionsRequest(input)
	return out, req.Send()
}

// ListImageSetVersionsWithContext is the same as ListImageSetVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListImageSetVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListImageSetVersionsWithContext(ctx aws.Context, input *ListImageSetVersionsInput, opts ...request.Option) (*ListImageSetVersionsOutput, error) {
	req, out := c.ListImageSetVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListImageSetVersionsPages iterates over the pages of a ListImageSetVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListImageSetVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListImageSetVersions operation.
//	pageNum := 0
//	err := client.ListImageSetVersionsPages(params,
//	    func(page *medicalimaging.ListImageSetVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MedicalImaging) ListImageSetVersionsPages(input *ListImageSetVersionsInput, fn func(*ListImageSetVersionsOutput, bool) bool) error {
	return c.ListImageSetVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListImageSetVersionsPagesWithContext same as ListImageSetVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListImageSetVersionsPagesWithContext(ctx aws.Context, input *ListImageSetVersionsInput, fn func(*ListImageSetVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListImageSetVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListImageSetVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListImageSetVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListTagsForResource
func (c *MedicalImaging) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Health Imaging.
//
// Lists all tags associated with a medical imaging resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/ListTagsForResource
func (c *MedicalImaging) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchImageSets = "SearchImageSets"

// SearchImageSetsRequest generates a "aws/request.Request" representing the
// client's request for the SearchImageSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchImageSets for more information on using the SearchImageSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchImageSetsRequest method.
//	req, resp := client.SearchImageSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/SearchImageSets
func (c *MedicalImaging) SearchImageSetsRequest(input *SearchImageSetsInput) (req *request.Request, output *SearchImageSetsOutput) {
	op := &request.Operation{
		Name:       opSearchImageSets,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/searchImageSets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchImageSetsInput{}
	}

	output = &SearchImageSetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchImageSets API operation for AWS Health Imaging.
//
// Search image sets based on defined input attributes.
//
// SearchImageSets accepts a single search query parameter and returns a paginated
// response of all image sets that have the matching criteria. All date range
// queries must be input as (lowerBound, upperBound).
//
// By default, SearchImageSets uses the updatedAt field for sorting in descending
// order from newest to oldest.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation SearchImageSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/SearchImageSets
func (c *MedicalImaging) SearchImageSets(input *SearchImageSetsInput) (*SearchImageSetsOutput, error) {
	req, out := c.SearchImageSetsRequest(input)
	return out, req.Send()
}

// SearchImageSetsWithContext is the same as SearchImageSets with the addition of
// the ability to pass a context and additional request options.
//
// See SearchImageSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) SearchImageSetsWithContext(ctx aws.Context, input *SearchImageSetsInput, opts ...request.Option) (*SearchImageSetsOutput, error) {
	req, out := c.SearchImageSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchImageSetsPages iterates over the pages of a SearchImageSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchImageSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchImageSets operation.
//	pageNum := 0
//	err := client.SearchImageSetsPages(params,
//	    func(page *medicalimaging.SearchImageSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MedicalImaging) SearchImageSetsPages(input *SearchImageSetsInput, fn func(*SearchImageSetsOutput, bool) bool) error {
	return c.SearchImageSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchImageSetsPagesWithContext same as SearchImageSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) SearchImageSetsPagesWithContext(ctx aws.Context, input *SearchImageSetsInput, fn func(*SearchImageSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchImageSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchImageSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchImageSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartDICOMImportJob = "StartDICOMImportJob"

// StartDICOMImportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDICOMImportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDICOMImportJob for more information on using the StartDICOMImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDICOMImportJobRequest method.
//	req, resp := client.StartDICOMImportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/StartDICOMImportJob
func (c *MedicalImaging) StartDICOMImportJobRequest(input *StartDICOMImportJobInput) (req *request.Request, output *StartDICOMImportJobOutput) {
	op := &request.Operation{
		Name:       opStartDICOMImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/startDICOMImportJob/datastore/{datastoreId}",
	}

	if input == nil {
		input = &StartDICOMImportJobInput{}
	}

	output = &StartDICOMImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDICOMImportJob API operation for AWS Health Imaging.
//
// Start importing bulk data into an ACTIVE data store. The import job imports
// DICOM P10 files found in the S3 prefix specified by the inputS3Uri parameter.
// The import job stores processing results in the file specified by the outputS3Uri
// parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation StartDICOMImportJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ServiceQuotaExceededException
//     The request caused a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/StartDICOMImportJob
func (c *MedicalImaging) StartDICOMImportJob(input *StartDICOMImportJobInput) (*StartDICOMImportJobOutput, error) {
	req, out := c.StartDICOMImportJobRequest(input)
	return out, req.Send()
}

// StartDICOMImportJobWithContext is the same as StartDICOMImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDICOMImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) StartDICOMImportJobWithContext(ctx aws.Context, input *StartDICOMImportJobInput, opts ...request.Option) (*StartDICOMImportJobOutput, error) {
	req, out := c.StartDICOMImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/TagResource
func (c *MedicalImaging) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Health Imaging.
//
// Adds a user-specifed key and value tag to a medical imaging resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/TagResource
func (c *MedicalImaging) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/UntagResource
func (c *MedicalImaging) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Health Imaging.
//
// Removes tags from a medical imaging resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/UntagResource
func (c *MedicalImaging) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateImageSetMetadata = "UpdateImageSetMetadata"

// UpdateImageSetMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateImageSetMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateImageSetMetadata for more information on using the UpdateImageSetMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateImageSetMetadataRequest method.
//	req, resp := client.UpdateImageSetMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/UpdateImageSetMetadata
func (c *MedicalImaging) UpdateImageSetMetadataRequest(input *UpdateImageSetMetadataInput) (req *request.Request, output *UpdateImageSetMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateImageSetMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/datastore/{datastoreId}/imageSet/{imageSetId}/updateImageSetMetadata",
	}

	if input == nil {
		input = &UpdateImageSetMetadataInput{}
	}

	output = &UpdateImageSetMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("runtime-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateImageSetMetadata API operation for AWS Health Imaging.
//
// Update image set metadata attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Health Imaging's
// API operation UpdateImageSetMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to throttling.
//
//   - ConflictException
//     Updating or deleting a resource can cause an inconsistent state.
//
//   - AccessDeniedException
//     The user does not have sufficient access to perform this action.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the service.
//
//   - InternalServerException
//     An unexpected error occurred during processing of the request.
//
//   - ResourceNotFoundException
//     The request references a resource which does not exist.
//
//   - ServiceQuotaExceededException
//     The request caused a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/medical-imaging-2023-07-19/UpdateImageSetMetadata
func (c *MedicalImaging) UpdateImageSetMetadata(input *UpdateImageSetMetadataInput) (*UpdateImageSetMetadataOutput, error) {
	req, out := c.UpdateImageSetMetadataRequest(input)
	return out, req.Send()
}

// UpdateImageSetMetadataWithContext is the same as UpdateImageSetMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateImageSetMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MedicalImaging) UpdateImageSetMetadataWithContext(ctx aws.Context, input *UpdateImageSetMetadataInput, opts ...request.Option) (*UpdateImageSetMetadataOutput, error) {
	req, out := c.UpdateImageSetMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The user does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Copy the destination image set.
type CopyDestinationImageSet struct {
	_ struct{} `type:"structure"`

	// The image set identifier for the destination image set.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The latest version identifier for the destination image set.
	//
	// LatestVersionId is a required field
	LatestVersionId *string `locationName:"latestVersionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyDestinationImageSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyDestinationImageSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyDestinationImageSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyDestinationImageSet"}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.LatestVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LatestVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageSetId sets the ImageSetId field's value.
func (s *CopyDestinationImageSet) SetImageSetId(v string) *CopyDestinationImageSet {
	s.ImageSetId = &v
	return s
}

// SetLatestVersionId sets the LatestVersionId field's value.
func (s *CopyDestinationImageSet) SetLatestVersionId(v string) *CopyDestinationImageSet {
	s.LatestVersionId = &v
	return s
}

// Copy the image set properties of the destination image set.
type CopyDestinationImageSetProperties struct {
	_ struct{} `type:"structure"`

	// The timestamp when the destination image set properties were created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) assigned to the destination image set.
	ImageSetArn *string `locationName:"imageSetArn" type:"string"`

	// The image set identifier of the copied image set properties.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The image set state of the destination image set properties.
	ImageSetState *string `locationName:"imageSetState" type:"string" enum:"ImageSetState"`

	// The image set workflow status of the destination image set properties.
	ImageSetWorkflowStatus *string `locationName:"imageSetWorkflowStatus" type:"string" enum:"ImageSetWorkflowStatus"`

	// The latest version identifier for the destination image set properties.
	//
	// LatestVersionId is a required field
	LatestVersionId *string `locationName:"latestVersionId" type:"string" required:"true"`

	// The timestamp when the destination image set properties were last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyDestinationImageSetProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyDestinationImageSetProperties) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CopyDestinationImageSetProperties) SetCreatedAt(v time.Time) *CopyDestinationImageSetProperties {
	s.CreatedAt = &v
	return s
}

// SetImageSetArn sets the ImageSetArn field's value.
func (s *CopyDestinationImageSetProperties) SetImageSetArn(v string) *CopyDestinationImageSetProperties {
	s.ImageSetArn = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *CopyDestinationImageSetProperties) SetImageSetId(v string) *CopyDestinationImageSetProperties {
	s.ImageSetId = &v
	return s
}

// SetImageSetState sets the ImageSetState field's value.
func (s *CopyDestinationImageSetProperties) SetImageSetState(v string) *CopyDestinationImageSetProperties {
	s.ImageSetState = &v
	return s
}

// SetImageSetWorkflowStatus sets the ImageSetWorkflowStatus field's value.
func (s *CopyDestinationImageSetProperties) SetImageSetWorkflowStatus(v string) *CopyDestinationImageSetProperties {
	s.ImageSetWorkflowStatus = &v
	return s
}

// SetLatestVersionId sets the LatestVersionId field's value.
func (s *CopyDestinationImageSetProperties) SetLatestVersionId(v string) *CopyDestinationImageSetProperties {
	s.LatestVersionId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CopyDestinationImageSetProperties) SetUpdatedAt(v time.Time) *CopyDestinationImageSetProperties {
	s.UpdatedAt = &v
	return s
}

// Copy image set information.
type CopyImageSetInformation struct {
	_ struct{} `type:"structure"`

	// The destination image set.
	DestinationImageSet *CopyDestinationImageSet `locationName:"destinationImageSet" type:"structure"`

	// The source image set.
	//
	// SourceImageSet is a required field
	SourceImageSet *CopySourceImageSetInformation `locationName:"sourceImageSet" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyImageSetInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyImageSetInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyImageSetInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyImageSetInformation"}
	if s.SourceImageSet == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageSet"))
	}
	if s.DestinationImageSet != nil {
		if err := s.DestinationImageSet.Validate(); err != nil {
			invalidParams.AddNested("DestinationImageSet", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceImageSet != nil {
		if err := s.SourceImageSet.Validate(); err != nil {
			invalidParams.AddNested("SourceImageSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationImageSet sets the DestinationImageSet field's value.
func (s *CopyImageSetInformation) SetDestinationImageSet(v *CopyDestinationImageSet) *CopyImageSetInformation {
	s.DestinationImageSet = v
	return s
}

// SetSourceImageSet sets the SourceImageSet field's value.
func (s *CopyImageSetInformation) SetSourceImageSet(v *CopySourceImageSetInformation) *CopyImageSetInformation {
	s.SourceImageSet = v
	return s
}

type CopyImageSetInput struct {
	_ struct{} `type:"structure" payload:"CopyImageSetInformation"`

	// Copy image set information.
	//
	// CopyImageSetInformation is a required field
	CopyImageSetInformation *CopyImageSetInformation `locationName:"copyImageSetInformation" type:"structure" required:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The source image set identifier.
	//
	// SourceImageSetId is a required field
	SourceImageSetId *string `location:"uri" locationName:"sourceImageSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyImageSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyImageSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyImageSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyImageSetInput"}
	if s.CopyImageSetInformation == nil {
		invalidParams.Add(request.NewErrParamRequired("CopyImageSetInformation"))
	}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.SourceImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageSetId"))
	}
	if s.SourceImageSetId != nil && len(*s.SourceImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceImageSetId", 1))
	}
	if s.CopyImageSetInformation != nil {
		if err := s.CopyImageSetInformation.Validate(); err != nil {
			invalidParams.AddNested("CopyImageSetInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyImageSetInformation sets the CopyImageSetInformation field's value.
func (s *CopyImageSetInput) SetCopyImageSetInformation(v *CopyImageSetInformation) *CopyImageSetInput {
	s.CopyImageSetInformation = v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *CopyImageSetInput) SetDatastoreId(v string) *CopyImageSetInput {
	s.DatastoreId = &v
	return s
}

// SetSourceImageSetId sets the SourceImageSetId field's value.
func (s *CopyImageSetInput) SetSourceImageSetId(v string) *CopyImageSetInput {
	s.SourceImageSetId = &v
	return s
}

type CopyImageSetOutput struct {
	_ struct{} `type:"structure"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The properties of the destination image set.
	//
	// DestinationImageSetProperties is a required field
	DestinationImageSetProperties *CopyDestinationImageSetProperties `locationName:"destinationImageSetProperties" type:"structure" required:"true"`

	// The properties of the source image set.
	//
	// SourceImageSetProperties is a required field
	SourceImageSetProperties *CopySourceImageSetProperties `locationName:"sourceImageSetProperties" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyImageSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyImageSetOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *CopyImageSetOutput) SetDatastoreId(v string) *CopyImageSetOutput {
	s.DatastoreId = &v
	return s
}

// SetDestinationImageSetProperties sets the DestinationImageSetProperties field's value.
func (s *CopyImageSetOutput) SetDestinationImageSetProperties(v *CopyDestinationImageSetProperties) *CopyImageSetOutput {
	s.DestinationImageSetProperties = v
	return s
}

// SetSourceImageSetProperties sets the SourceImageSetProperties field's value.
func (s *CopyImageSetOutput) SetSourceImageSetProperties(v *CopySourceImageSetProperties) *CopyImageSetOutput {
	s.SourceImageSetProperties = v
	return s
}

// Copy source image set information.
type CopySourceImageSetInformation struct {
	_ struct{} `type:"structure"`

	// The latest version identifier for the source image set.
	//
	// LatestVersionId is a required field
	LatestVersionId *string `locationName:"latestVersionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySourceImageSetInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySourceImageSetInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySourceImageSetInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopySourceImageSetInformation"}
	if s.LatestVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LatestVersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatestVersionId sets the LatestVersionId field's value.
func (s *CopySourceImageSetInformation) SetLatestVersionId(v string) *CopySourceImageSetInformation {
	s.LatestVersionId = &v
	return s
}

// Copy source image set properties.
type CopySourceImageSetProperties struct {
	_ struct{} `type:"structure"`

	// The timestamp when the source image set properties were created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) assigned to the source image set.
	ImageSetArn *string `locationName:"imageSetArn" type:"string"`

	// The image set identifier for the copied source image set.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The image set state of the copied source image set.
	ImageSetState *string `locationName:"imageSetState" type:"string" enum:"ImageSetState"`

	// The workflow status of the copied source image set.
	ImageSetWorkflowStatus *string `locationName:"imageSetWorkflowStatus" type:"string" enum:"ImageSetWorkflowStatus"`

	// The latest version identifier for the copied source image set.
	//
	// LatestVersionId is a required field
	LatestVersionId *string `locationName:"latestVersionId" type:"string" required:"true"`

	// The timestamp when the source image set properties were updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySourceImageSetProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySourceImageSetProperties) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CopySourceImageSetProperties) SetCreatedAt(v time.Time) *CopySourceImageSetProperties {
	s.CreatedAt = &v
	return s
}

// SetImageSetArn sets the ImageSetArn field's value.
func (s *CopySourceImageSetProperties) SetImageSetArn(v string) *CopySourceImageSetProperties {
	s.ImageSetArn = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *CopySourceImageSetProperties) SetImageSetId(v string) *CopySourceImageSetProperties {
	s.ImageSetId = &v
	return s
}

// SetImageSetState sets the ImageSetState field's value.
func (s *CopySourceImageSetProperties) SetImageSetState(v string) *CopySourceImageSetProperties {
	s.ImageSetState = &v
	return s
}

// SetImageSetWorkflowStatus sets the ImageSetWorkflowStatus field's value.
func (s *CopySourceImageSetProperties) SetImageSetWorkflowStatus(v string) *CopySourceImageSetProperties {
	s.ImageSetWorkflowStatus = &v
	return s
}

// SetLatestVersionId sets the LatestVersionId field's value.
func (s *CopySourceImageSetProperties) SetLatestVersionId(v string) *CopySourceImageSetProperties {
	s.LatestVersionId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CopySourceImageSetProperties) SetUpdatedAt(v time.Time) *CopySourceImageSetProperties {
	s.UpdatedAt = &v
	return s
}

type CreateDatastoreInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for API idempotency.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The data store name.
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) assigned to the Key Management Service (KMS)
	// key for accessing encrypted data.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`

	// The tags provided when creating a data store.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatastoreInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreName", 1))
	}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDatastoreInput) SetClientToken(v string) *CreateDatastoreInput {
	s.ClientToken = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *CreateDatastoreInput) SetDatastoreName(v string) *CreateDatastoreInput {
	s.DatastoreName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateDatastoreInput) SetKmsKeyArn(v string) *CreateDatastoreInput {
	s.KmsKeyArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDatastoreInput) SetTags(v map[string]*string) *CreateDatastoreInput {
	s.Tags = v
	return s
}

type CreateDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The data store status.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `locationName:"datastoreStatus" type:"string" required:"true" enum:"DatastoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *CreateDatastoreOutput) SetDatastoreId(v string) *CreateDatastoreOutput {
	s.DatastoreId = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *CreateDatastoreOutput) SetDatastoreStatus(v string) *CreateDatastoreOutput {
	s.DatastoreStatus = &v
	return s
}

// Properties of the import job.
type DICOMImportJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that grants permissions to access medical
	// imaging resources.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"20" type:"string" required:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The timestamp for when the import job was ended.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp"`

	// The input prefix path for the S3 bucket that contains the DICOM P10 files
	// to be imported.
	//
	// InputS3Uri is a required field
	InputS3Uri *string `locationName:"inputS3Uri" min:"1" type:"string" required:"true"`

	// The import job identifier.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// The import job name.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The filters for listing import jobs based on status.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"JobStatus"`

	// The error message thrown if an import job fails.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The output prefix of the S3 bucket to upload the results of the DICOM import
	// job.
	//
	// OutputS3Uri is a required field
	OutputS3Uri *string `locationName:"outputS3Uri" min:"1" type:"string" required:"true"`

	// The timestamp for when the import job was submitted.
	SubmittedAt *time.Time `locationName:"submittedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMImportJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMImportJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DICOMImportJobProperties) SetDataAccessRoleArn(v string) *DICOMImportJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DICOMImportJobProperties) SetDatastoreId(v string) *DICOMImportJobProperties {
	s.DatastoreId = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *DICOMImportJobProperties) SetEndedAt(v time.Time) *DICOMImportJobProperties {
	s.EndedAt = &v
	return s
}

// SetInputS3Uri sets the InputS3Uri field's value.
func (s *DICOMImportJobProperties) SetInputS3Uri(v string) *DICOMImportJobProperties {
	s.InputS3Uri = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DICOMImportJobProperties) SetJobId(v string) *DICOMImportJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DICOMImportJobProperties) SetJobName(v string) *DICOMImportJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DICOMImportJobProperties) SetJobStatus(v string) *DICOMImportJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DICOMImportJobProperties) SetMessage(v string) *DICOMImportJobProperties {
	s.Message = &v
	return s
}

// SetOutputS3Uri sets the OutputS3Uri field's value.
func (s *DICOMImportJobProperties) SetOutputS3Uri(v string) *DICOMImportJobProperties {
	s.OutputS3Uri = &v
	return s
}

// SetSubmittedAt sets the SubmittedAt field's value.
func (s *DICOMImportJobProperties) SetSubmittedAt(v time.Time) *DICOMImportJobProperties {
	s.SubmittedAt = &v
	return s
}

// Summary of import job.
type DICOMImportJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that grants permissions to access medical
	// imaging resources.
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"20" type:"string"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The timestamp when an import job ended.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp"`

	// The import job identifier.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// The import job name.
	//
	// JobName is a required field
	JobName *string `locationName:"jobName" min:"1" type:"string" required:"true"`

	// The filters for listing import jobs based on status.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"JobStatus"`

	// The error message thrown if an import job fails.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The timestamp when an import job was submitted.
	SubmittedAt *time.Time `locationName:"submittedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMImportJobSummary) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DICOMImportJobSummary) SetDataAccessRoleArn(v string) *DICOMImportJobSummary {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DICOMImportJobSummary) SetDatastoreId(v string) *DICOMImportJobSummary {
	s.DatastoreId = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *DICOMImportJobSummary) SetEndedAt(v time.Time) *DICOMImportJobSummary {
	s.EndedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DICOMImportJobSummary) SetJobId(v string) *DICOMImportJobSummary {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DICOMImportJobSummary) SetJobName(v string) *DICOMImportJobSummary {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DICOMImportJobSummary) SetJobStatus(v string) *DICOMImportJobSummary {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DICOMImportJobSummary) SetMessage(v string) *DICOMImportJobSummary {
	s.Message = &v
	return s
}

// SetSubmittedAt sets the SubmittedAt field's value.
func (s *DICOMImportJobSummary) SetSubmittedAt(v time.Time) *DICOMImportJobSummary {
	s.SubmittedAt = &v
	return s
}

// The aggregated structure to store DICOM study date and study time for search
// capabilities.
type DICOMStudyDateAndTime struct {
	_ struct{} `type:"structure"`

	// The DICOM study date provided in yyMMdd format.
	//
	// DICOMStudyDate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMStudyDateAndTime's
	// String and GoString methods.
	//
	// DICOMStudyDate is a required field
	DICOMStudyDate *string `type:"string" required:"true" sensitive:"true"`

	// The DICOM study time provided in HHmmss.FFFFFF format.
	//
	// DICOMStudyTime is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMStudyDateAndTime's
	// String and GoString methods.
	DICOMStudyTime *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMStudyDateAndTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMStudyDateAndTime) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DICOMStudyDateAndTime) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DICOMStudyDateAndTime"}
	if s.DICOMStudyDate == nil {
		invalidParams.Add(request.NewErrParamRequired("DICOMStudyDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDICOMStudyDate sets the DICOMStudyDate field's value.
func (s *DICOMStudyDateAndTime) SetDICOMStudyDate(v string) *DICOMStudyDateAndTime {
	s.DICOMStudyDate = &v
	return s
}

// SetDICOMStudyTime sets the DICOMStudyTime field's value.
func (s *DICOMStudyDateAndTime) SetDICOMStudyTime(v string) *DICOMStudyDateAndTime {
	s.DICOMStudyTime = &v
	return s
}

// The DICOM attributes returned as a part of a response. Each image set has
// these properties as part of a search result.
type DICOMTags struct {
	_ struct{} `type:"structure"`

	// The accession number for the DICOM study.
	//
	// DICOMAccessionNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMAccessionNumber *string `type:"string" sensitive:"true"`

	// The total number of instances in the DICOM study.
	DICOMNumberOfStudyRelatedInstances *int64 `type:"integer"`

	// The total number of series in the DICOM study.
	DICOMNumberOfStudyRelatedSeries *int64 `type:"integer"`

	// The patient birth date.
	//
	// DICOMPatientBirthDate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMPatientBirthDate *string `type:"string" sensitive:"true"`

	// The unique identifier for a patient in a DICOM Study.
	//
	// DICOMPatientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMPatientId *string `type:"string" sensitive:"true"`

	// The patient name.
	//
	// DICOMPatientName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMPatientName *string `type:"string" sensitive:"true"`

	// The patient sex.
	//
	// DICOMPatientSex is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMPatientSex *string `type:"string" sensitive:"true"`

	// The DICOM provided identifier for the series Body Part Examined.
	//
	// DICOMSeriesBodyPart is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMSeriesBodyPart *string `type:"string" sensitive:"true"`

	// The DICOM provided identifier for the Series Instance UID.
	//
	// DICOMSeriesInstanceUID is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMSeriesInstanceUID *string `type:"string" sensitive:"true"`

	// The DICOM provided identifier for the series Modality.
	//
	// DICOMSeriesModality is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMSeriesModality *string `type:"string" sensitive:"true"`

	// The DICOM provided identifier for the Series Number.
	//
	// DICOMSeriesNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMSeriesNumber *int64 `type:"integer" sensitive:"true"`

	// The study date.
	//
	// DICOMStudyDate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMStudyDate *string `type:"string" sensitive:"true"`

	// The DICOM provided Study Description.
	//
	// DICOMStudyDescription is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMStudyDescription *string `type:"string" sensitive:"true"`

	// The DICOM provided identifier for the Study ID.
	//
	// DICOMStudyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMStudyId *string `type:"string" sensitive:"true"`

	// The DICOM provided identifier for the Study Instance UID.
	//
	// DICOMStudyInstanceUID is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMStudyInstanceUID *string `type:"string" sensitive:"true"`

	// The study time.
	//
	// DICOMStudyTime is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMTags's
	// String and GoString methods.
	DICOMStudyTime *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMTags) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMTags) GoString() string {
	return s.String()
}

// SetDICOMAccessionNumber sets the DICOMAccessionNumber field's value.
func (s *DICOMTags) SetDICOMAccessionNumber(v string) *DICOMTags {
	s.DICOMAccessionNumber = &v
	return s
}

// SetDICOMNumberOfStudyRelatedInstances sets the DICOMNumberOfStudyRelatedInstances field's value.
func (s *DICOMTags) SetDICOMNumberOfStudyRelatedInstances(v int64) *DICOMTags {
	s.DICOMNumberOfStudyRelatedInstances = &v
	return s
}

// SetDICOMNumberOfStudyRelatedSeries sets the DICOMNumberOfStudyRelatedSeries field's value.
func (s *DICOMTags) SetDICOMNumberOfStudyRelatedSeries(v int64) *DICOMTags {
	s.DICOMNumberOfStudyRelatedSeries = &v
	return s
}

// SetDICOMPatientBirthDate sets the DICOMPatientBirthDate field's value.
func (s *DICOMTags) SetDICOMPatientBirthDate(v string) *DICOMTags {
	s.DICOMPatientBirthDate = &v
	return s
}

// SetDICOMPatientId sets the DICOMPatientId field's value.
func (s *DICOMTags) SetDICOMPatientId(v string) *DICOMTags {
	s.DICOMPatientId = &v
	return s
}

// SetDICOMPatientName sets the DICOMPatientName field's value.
func (s *DICOMTags) SetDICOMPatientName(v string) *DICOMTags {
	s.DICOMPatientName = &v
	return s
}

// SetDICOMPatientSex sets the DICOMPatientSex field's value.
func (s *DICOMTags) SetDICOMPatientSex(v string) *DICOMTags {
	s.DICOMPatientSex = &v
	return s
}

// SetDICOMSeriesBodyPart sets the DICOMSeriesBodyPart field's value.
func (s *DICOMTags) SetDICOMSeriesBodyPart(v string) *DICOMTags {
	s.DICOMSeriesBodyPart = &v
	return s
}

// SetDICOMSeriesInstanceUID sets the DICOMSeriesInstanceUID field's value.
func (s *DICOMTags) SetDICOMSeriesInstanceUID(v string) *DICOMTags {
	s.DICOMSeriesInstanceUID = &v
	return s
}

// SetDICOMSeriesModality sets the DICOMSeriesModality field's value.
func (s *DICOMTags) SetDICOMSeriesModality(v string) *DICOMTags {
	s.DICOMSeriesModality = &v
	return s
}

// SetDICOMSeriesNumber sets the DICOMSeriesNumber field's value.
func (s *DICOMTags) SetDICOMSeriesNumber(v int64) *DICOMTags {
	s.DICOMSeriesNumber = &v
	return s
}

// SetDICOMStudyDate sets the DICOMStudyDate field's value.
func (s *DICOMTags) SetDICOMStudyDate(v string) *DICOMTags {
	s.DICOMStudyDate = &v
	return s
}

// SetDICOMStudyDescription sets the DICOMStudyDescription field's value.
func (s *DICOMTags) SetDICOMStudyDescription(v string) *DICOMTags {
	s.DICOMStudyDescription = &v
	return s
}

// SetDICOMStudyId sets the DICOMStudyId field's value.
func (s *DICOMTags) SetDICOMStudyId(v string) *DICOMTags {
	s.DICOMStudyId = &v
	return s
}

// SetDICOMStudyInstanceUID sets the DICOMStudyInstanceUID field's value.
func (s *DICOMTags) SetDICOMStudyInstanceUID(v string) *DICOMTags {
	s.DICOMStudyInstanceUID = &v
	return s
}

// SetDICOMStudyTime sets the DICOMStudyTime field's value.
func (s *DICOMTags) SetDICOMStudyTime(v string) *DICOMTags {
	s.DICOMStudyTime = &v
	return s
}

// The object containing removableAttributes and updatableAttributes.
type DICOMUpdates struct {
	_ struct{} `type:"structure"`

	// The DICOM tags to be removed from ImageSetMetadata.
	//
	// RemovableAttributes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMUpdates's
	// String and GoString methods.
	//
	// RemovableAttributes is automatically base64 encoded/decoded by the SDK.
	RemovableAttributes []byte `locationName:"removableAttributes" min:"1" type:"blob" sensitive:"true"`

	// The DICOM tags that need to be updated in ImageSetMetadata.
	//
	// UpdatableAttributes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DICOMUpdates's
	// String and GoString methods.
	//
	// UpdatableAttributes is automatically base64 encoded/decoded by the SDK.
	UpdatableAttributes []byte `locationName:"updatableAttributes" min:"1" type:"blob" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DICOMUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DICOMUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DICOMUpdates"}
	if s.RemovableAttributes != nil && len(s.RemovableAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemovableAttributes", 1))
	}
	if s.UpdatableAttributes != nil && len(s.UpdatableAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdatableAttributes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRemovableAttributes sets the RemovableAttributes field's value.
func (s *DICOMUpdates) SetRemovableAttributes(v []byte) *DICOMUpdates {
	s.RemovableAttributes = v
	return s
}

// SetUpdatableAttributes sets the UpdatableAttributes field's value.
func (s *DICOMUpdates) SetUpdatableAttributes(v []byte) *DICOMUpdates {
	s.UpdatableAttributes = v
	return s
}

// The properties associated with the data store.
type DatastoreProperties struct {
	_ struct{} `type:"structure"`

	// The timestamp when the data store was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) for the data store.
	DatastoreArn *string `locationName:"datastoreArn" type:"string"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The data store name.
	//
	// DatastoreName is a required field
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// The data store status.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `locationName:"datastoreStatus" type:"string" required:"true" enum:"DatastoreStatus"`

	// The Amazon Resource Name (ARN) assigned to the Key Management Service (KMS)
	// key for accessing encrypted data.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`

	// The timestamp when the data store was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreProperties) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DatastoreProperties) SetCreatedAt(v time.Time) *DatastoreProperties {
	s.CreatedAt = &v
	return s
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *DatastoreProperties) SetDatastoreArn(v string) *DatastoreProperties {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DatastoreProperties) SetDatastoreId(v string) *DatastoreProperties {
	s.DatastoreId = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreProperties) SetDatastoreName(v string) *DatastoreProperties {
	s.DatastoreName = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DatastoreProperties) SetDatastoreStatus(v string) *DatastoreProperties {
	s.DatastoreStatus = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *DatastoreProperties) SetKmsKeyArn(v string) *DatastoreProperties {
	s.KmsKeyArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DatastoreProperties) SetUpdatedAt(v time.Time) *DatastoreProperties {
	s.UpdatedAt = &v
	return s
}

// List of summaries of data stores.
type DatastoreSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp when the data store was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) for the data store.
	DatastoreArn *string `locationName:"datastoreArn" type:"string"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The data store name.
	//
	// DatastoreName is a required field
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// The data store status.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `locationName:"datastoreStatus" type:"string" required:"true" enum:"DatastoreStatus"`

	// The timestamp when the data store was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatastoreSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DatastoreSummary) SetCreatedAt(v time.Time) *DatastoreSummary {
	s.CreatedAt = &v
	return s
}

// SetDatastoreArn sets the DatastoreArn field's value.
func (s *DatastoreSummary) SetDatastoreArn(v string) *DatastoreSummary {
	s.DatastoreArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DatastoreSummary) SetDatastoreId(v string) *DatastoreSummary {
	s.DatastoreId = &v
	return s
}

// SetDatastoreName sets the DatastoreName field's value.
func (s *DatastoreSummary) SetDatastoreName(v string) *DatastoreSummary {
	s.DatastoreName = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DatastoreSummary) SetDatastoreStatus(v string) *DatastoreSummary {
	s.DatastoreStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DatastoreSummary) SetUpdatedAt(v time.Time) *DatastoreSummary {
	s.UpdatedAt = &v
	return s
}

type DeleteDatastoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatastoreInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteDatastoreInput) SetDatastoreId(v string) *DeleteDatastoreInput {
	s.DatastoreId = &v
	return s
}

type DeleteDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The data store status.
	//
	// DatastoreStatus is a required field
	DatastoreStatus *string `locationName:"datastoreStatus" type:"string" required:"true" enum:"DatastoreStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteDatastoreOutput) SetDatastoreId(v string) *DeleteDatastoreOutput {
	s.DatastoreId = &v
	return s
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *DeleteDatastoreOutput) SetDatastoreStatus(v string) *DeleteDatastoreOutput {
	s.DatastoreStatus = &v
	return s
}

type DeleteImageSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `location:"uri" locationName:"imageSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImageSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImageSetInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.ImageSetId != nil && len(*s.ImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteImageSetInput) SetDatastoreId(v string) *DeleteImageSetInput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *DeleteImageSetInput) SetImageSetId(v string) *DeleteImageSetInput {
	s.ImageSetId = &v
	return s
}

type DeleteImageSetOutput struct {
	_ struct{} `type:"structure"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The image set state.
	//
	// ImageSetState is a required field
	ImageSetState *string `locationName:"imageSetState" type:"string" required:"true" enum:"ImageSetState"`

	// The image set workflow status.
	//
	// ImageSetWorkflowStatus is a required field
	ImageSetWorkflowStatus *string `locationName:"imageSetWorkflowStatus" type:"string" required:"true" enum:"ImageSetWorkflowStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteImageSetOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *DeleteImageSetOutput) SetDatastoreId(v string) *DeleteImageSetOutput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *DeleteImageSetOutput) SetImageSetId(v string) *DeleteImageSetOutput {
	s.ImageSetId = &v
	return s
}

// SetImageSetState sets the ImageSetState field's value.
func (s *DeleteImageSetOutput) SetImageSetState(v string) *DeleteImageSetOutput {
	s.ImageSetState = &v
	return s
}

// SetImageSetWorkflowStatus sets the ImageSetWorkflowStatus field's value.
func (s *DeleteImageSetOutput) SetImageSetWorkflowStatus(v string) *DeleteImageSetOutput {
	s.ImageSetWorkflowStatus = &v
	return s
}

type GetDICOMImportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The import job identifier.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDICOMImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDICOMImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDICOMImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDICOMImportJobInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *GetDICOMImportJobInput) SetDatastoreId(v string) *GetDICOMImportJobInput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetDICOMImportJobInput) SetJobId(v string) *GetDICOMImportJobInput {
	s.JobId = &v
	return s
}

type GetDICOMImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the import job.
	//
	// JobProperties is a required field
	JobProperties *DICOMImportJobProperties `locationName:"jobProperties" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDICOMImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDICOMImportJobOutput) GoString() string {
	return s.String()
}

// SetJobProperties sets the JobProperties field's value.
func (s *GetDICOMImportJobOutput) SetJobProperties(v *DICOMImportJobProperties) *GetDICOMImportJobOutput {
	s.JobProperties = v
	return s
}

type GetDatastoreInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatastoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatastoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDatastoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDatastoreInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *GetDatastoreInput) SetDatastoreId(v string) *GetDatastoreInput {
	s.DatastoreId = &v
	return s
}

type GetDatastoreOutput struct {
	_ struct{} `type:"structure"`

	// The data store properties.
	//
	// DatastoreProperties is a required field
	DatastoreProperties *DatastoreProperties `locationName:"datastoreProperties" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatastoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDatastoreOutput) GoString() string {
	return s.String()
}

// SetDatastoreProperties sets the DatastoreProperties field's value.
func (s *GetDatastoreOutput) SetDatastoreProperties(v *DatastoreProperties) *GetDatastoreOutput {
	s.DatastoreProperties = v
	return s
}

type GetImageFrameInput struct {
	_ struct{} `type:"structure" payload:"ImageFrameInformation"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// Information about the image frame (pixel data) identifier.
	//
	// ImageFrameInformation is a required field
	ImageFrameInformation *ImageFrameInformation `locationName:"imageFrameInformation" type:"structure" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `location:"uri" locationName:"imageSetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageFrameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageFrameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageFrameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImageFrameInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.ImageFrameInformation == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageFrameInformation"))
	}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.ImageSetId != nil && len(*s.ImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageSetId", 1))
	}
	if s.ImageFrameInformation != nil {
		if err := s.ImageFrameInformation.Validate(); err != nil {
			invalidParams.AddNested("ImageFrameInformation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *GetImageFrameInput) SetDatastoreId(v string) *GetImageFrameInput {
	s.DatastoreId = &v
	return s
}

// SetImageFrameInformation sets the ImageFrameInformation field's value.
func (s *GetImageFrameInput) SetImageFrameInformation(v *ImageFrameInformation) *GetImageFrameInput {
	s.ImageFrameInformation = v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *GetImageFrameInput) SetImageSetId(v string) *GetImageFrameInput {
	s.ImageSetId = &v
	return s
}

type GetImageFrameOutput struct {
	_ struct{} `type:"structure" payload:"ImageFrameBlob"`

	// The format in which the image frame information is returned to the customer.
	// Default is application/octet-stream.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The blob containing the aggregated image frame information.
	//
	// ImageFrameBlob is a required field
	ImageFrameBlob io.ReadCloser `locationName:"imageFrameBlob" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageFrameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageFrameOutput) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *GetImageFrameOutput) SetContentType(v string) *GetImageFrameOutput {
	s.ContentType = &v
	return s
}

// SetImageFrameBlob sets the ImageFrameBlob field's value.
func (s *GetImageFrameOutput) SetImageFrameBlob(v io.ReadCloser) *GetImageFrameOutput {
	s.ImageFrameBlob = v
	return s
}

type GetImageSetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `location:"uri" locationName:"imageSetId" type:"string" required:"true"`

	// The image set version identifier.
	VersionId *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImageSetInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.ImageSetId != nil && len(*s.ImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *GetImageSetInput) SetDatastoreId(v string) *GetImageSetInput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *GetImageSetInput) SetImageSetId(v string) *GetImageSetInput {
	s.ImageSetId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetImageSetInput) SetVersionId(v string) *GetImageSetInput {
	s.VersionId = &v
	return s
}

type GetImageSetMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `location:"uri" locationName:"imageSetId" type:"string" required:"true"`

	// The image set version identifier.
	VersionId *string `location:"querystring" locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImageSetMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImageSetMetadataInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.ImageSetId != nil && len(*s.ImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *GetImageSetMetadataInput) SetDatastoreId(v string) *GetImageSetMetadataInput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *GetImageSetMetadataInput) SetImageSetId(v string) *GetImageSetMetadataInput {
	s.ImageSetId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetImageSetMetadataInput) SetVersionId(v string) *GetImageSetMetadataInput {
	s.VersionId = &v
	return s
}

type GetImageSetMetadataOutput struct {
	_ struct{} `type:"structure" payload:"ImageSetMetadataBlob"`

	// The compression format in which image set metadata attributes are returned.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The format in which the study metadata is returned to the customer. Default
	// is text/plain.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The blob containing the aggregated metadata information for the image set.
	//
	// ImageSetMetadataBlob is a required field
	ImageSetMetadataBlob io.ReadCloser `locationName:"imageSetMetadataBlob" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetMetadataOutput) GoString() string {
	return s.String()
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *GetImageSetMetadataOutput) SetContentEncoding(v string) *GetImageSetMetadataOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetImageSetMetadataOutput) SetContentType(v string) *GetImageSetMetadataOutput {
	s.ContentType = &v
	return s
}

// SetImageSetMetadataBlob sets the ImageSetMetadataBlob field's value.
func (s *GetImageSetMetadataOutput) SetImageSetMetadataBlob(v io.ReadCloser) *GetImageSetMetadataOutput {
	s.ImageSetMetadataBlob = v
	return s
}

type GetImageSetOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when image set properties were created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The timestamp when the image set properties were deleted.
	DeletedAt *time.Time `locationName:"deletedAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) assigned to the image set.
	ImageSetArn *string `locationName:"imageSetArn" type:"string"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The image set state.
	//
	// ImageSetState is a required field
	ImageSetState *string `locationName:"imageSetState" type:"string" required:"true" enum:"ImageSetState"`

	// The image set workflow status.
	ImageSetWorkflowStatus *string `locationName:"imageSetWorkflowStatus" type:"string" enum:"ImageSetWorkflowStatus"`

	// The error message thrown if an image set action fails.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The timestamp when image set properties were updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The image set version identifier.
	//
	// VersionId is a required field
	VersionId *string `locationName:"versionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetImageSetOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetImageSetOutput) SetCreatedAt(v time.Time) *GetImageSetOutput {
	s.CreatedAt = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *GetImageSetOutput) SetDatastoreId(v string) *GetImageSetOutput {
	s.DatastoreId = &v
	return s
}

// SetDeletedAt sets the DeletedAt field's value.
func (s *GetImageSetOutput) SetDeletedAt(v time.Time) *GetImageSetOutput {
	s.DeletedAt = &v
	return s
}

// SetImageSetArn sets the ImageSetArn field's value.
func (s *GetImageSetOutput) SetImageSetArn(v string) *GetImageSetOutput {
	s.ImageSetArn = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *GetImageSetOutput) SetImageSetId(v string) *GetImageSetOutput {
	s.ImageSetId = &v
	return s
}

// SetImageSetState sets the ImageSetState field's value.
func (s *GetImageSetOutput) SetImageSetState(v string) *GetImageSetOutput {
	s.ImageSetState = &v
	return s
}

// SetImageSetWorkflowStatus sets the ImageSetWorkflowStatus field's value.
func (s *GetImageSetOutput) SetImageSetWorkflowStatus(v string) *GetImageSetOutput {
	s.ImageSetWorkflowStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *GetImageSetOutput) SetMessage(v string) *GetImageSetOutput {
	s.Message = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetImageSetOutput) SetUpdatedAt(v time.Time) *GetImageSetOutput {
	s.UpdatedAt = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetImageSetOutput) SetVersionId(v string) *GetImageSetOutput {
	s.VersionId = &v
	return s
}

// Information about the image frame (pixel data) identifier.
type ImageFrameInformation struct {
	_ struct{} `type:"structure"`

	// The image frame (pixel data) identifier.
	//
	// ImageFrameId is a required field
	ImageFrameId *string `locationName:"imageFrameId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageFrameInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageFrameInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageFrameInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImageFrameInformation"}
	if s.ImageFrameId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageFrameId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageFrameId sets the ImageFrameId field's value.
func (s *ImageFrameInformation) SetImageFrameId(v string) *ImageFrameInformation {
	s.ImageFrameId = &v
	return s
}

// The image set properties.
type ImageSetProperties struct {
	_ struct{} `type:"structure"`

	// The timestamp when the image set properties were created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The timestamp when the image set properties were deleted.
	DeletedAt *time.Time `locationName:"deletedAt" type:"timestamp"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The image set state.
	//
	// ImageSetState is a required field
	ImageSetState *string `locationName:"imageSetState" type:"string" required:"true" enum:"ImageSetState"`

	// The image set workflow status.
	ImageSetWorkflowStatus *string `type:"string" enum:"ImageSetWorkflowStatus"`

	// The error message thrown if an image set action fails.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The timestamp when the image set properties were updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The image set version identifier.
	//
	// VersionId is a required field
	VersionId *string `locationName:"versionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSetProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSetProperties) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ImageSetProperties) SetCreatedAt(v time.Time) *ImageSetProperties {
	s.CreatedAt = &v
	return s
}

// SetDeletedAt sets the DeletedAt field's value.
func (s *ImageSetProperties) SetDeletedAt(v time.Time) *ImageSetProperties {
	s.DeletedAt = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *ImageSetProperties) SetImageSetId(v string) *ImageSetProperties {
	s.ImageSetId = &v
	return s
}

// SetImageSetState sets the ImageSetState field's value.
func (s *ImageSetProperties) SetImageSetState(v string) *ImageSetProperties {
	s.ImageSetState = &v
	return s
}

// SetImageSetWorkflowStatus sets the ImageSetWorkflowStatus field's value.
func (s *ImageSetProperties) SetImageSetWorkflowStatus(v string) *ImageSetProperties {
	s.ImageSetWorkflowStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ImageSetProperties) SetMessage(v string) *ImageSetProperties {
	s.Message = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ImageSetProperties) SetUpdatedAt(v time.Time) *ImageSetProperties {
	s.UpdatedAt = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ImageSetProperties) SetVersionId(v string) *ImageSetProperties {
	s.VersionId = &v
	return s
}

// Summary of the image set metadata.
type ImageSetsMetadataSummary struct {
	_ struct{} `type:"structure"`

	// The time an image set is created. Sample creation date is provided in 1985-04-12T23:20:50.52Z
	// format.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The DICOM tags associated with the image set.
	DICOMTags *DICOMTags `type:"structure"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The time an image set was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`

	// The image set version.
	Version *int64 `locationName:"version" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSetsMetadataSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSetsMetadataSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ImageSetsMetadataSummary) SetCreatedAt(v time.Time) *ImageSetsMetadataSummary {
	s.CreatedAt = &v
	return s
}

// SetDICOMTags sets the DICOMTags field's value.
func (s *ImageSetsMetadataSummary) SetDICOMTags(v *DICOMTags) *ImageSetsMetadataSummary {
	s.DICOMTags = v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *ImageSetsMetadataSummary) SetImageSetId(v string) *ImageSetsMetadataSummary {
	s.ImageSetId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ImageSetsMetadataSummary) SetUpdatedAt(v time.Time) *ImageSetsMetadataSummary {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ImageSetsMetadataSummary) SetVersion(v int64) *ImageSetsMetadataSummary {
	s.Version = &v
	return s
}

// An unexpected error occurred during processing of the request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDICOMImportJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The filters for listing import jobs based on status.
	JobStatus *string `location:"querystring" locationName:"jobStatus" type:"string" enum:"JobStatus"`

	// The max results count. The upper bound is determined by load testing.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to request the list of import jobs on the next
	// page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDICOMImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDICOMImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDICOMImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDICOMImportJobsInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ListDICOMImportJobsInput) SetDatastoreId(v string) *ListDICOMImportJobsInput {
	s.DatastoreId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ListDICOMImportJobsInput) SetJobStatus(v string) *ListDICOMImportJobsInput {
	s.JobStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDICOMImportJobsInput) SetMaxResults(v int64) *ListDICOMImportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDICOMImportJobsInput) SetNextToken(v string) *ListDICOMImportJobsInput {
	s.NextToken = &v
	return s
}

type ListDICOMImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job summaries.
	//
	// JobSummaries is a required field
	JobSummaries []*DICOMImportJobSummary `locationName:"jobSummaries" type:"list" required:"true"`

	// The pagination token used to retrieve the list of import jobs on the next
	// page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDICOMImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDICOMImportJobsOutput) GoString() string {
	return s.String()
}

// SetJobSummaries sets the JobSummaries field's value.
func (s *ListDICOMImportJobsOutput) SetJobSummaries(v []*DICOMImportJobSummary) *ListDICOMImportJobsOutput {
	s.JobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDICOMImportJobsOutput) SetNextToken(v string) *ListDICOMImportJobsOutput {
	s.NextToken = &v
	return s
}

type ListDatastoresInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store status.
	DatastoreStatus *string `location:"querystring" locationName:"datastoreStatus" type:"string" enum:"DatastoreStatus"`

	// Valid Range: Minimum value of 1. Maximum value of 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to request the list of data stores on the next
	// page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatastoresInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatastoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatastoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatastoresInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreStatus sets the DatastoreStatus field's value.
func (s *ListDatastoresInput) SetDatastoreStatus(v string) *ListDatastoresInput {
	s.DatastoreStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatastoresInput) SetMaxResults(v int64) *ListDatastoresInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatastoresInput) SetNextToken(v string) *ListDatastoresInput {
	s.NextToken = &v
	return s
}

type ListDatastoresOutput struct {
	_ struct{} `type:"structure"`

	// The list of summaries of data stores.
	DatastoreSummaries []*DatastoreSummary `locationName:"datastoreSummaries" type:"list"`

	// The pagination token used to retrieve the list of data stores on the next
	// page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatastoresOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatastoresOutput) GoString() string {
	return s.String()
}

// SetDatastoreSummaries sets the DatastoreSummaries field's value.
func (s *ListDatastoresOutput) SetDatastoreSummaries(v []*DatastoreSummary) *ListDatastoresOutput {
	s.DatastoreSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatastoresOutput) SetNextToken(v string) *ListDatastoresOutput {
	s.NextToken = &v
	return s
}

type ListImageSetVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `location:"uri" locationName:"imageSetId" type:"string" required:"true"`

	// The max results count.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token used to request the list of image set versions on the
	// next page.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageSetVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageSetVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListImageSetVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListImageSetVersionsInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.ImageSetId != nil && len(*s.ImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageSetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *ListImageSetVersionsInput) SetDatastoreId(v string) *ListImageSetVersionsInput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *ListImageSetVersionsInput) SetImageSetId(v string) *ListImageSetVersionsInput {
	s.ImageSetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListImageSetVersionsInput) SetMaxResults(v int64) *ListImageSetVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImageSetVersionsInput) SetNextToken(v string) *ListImageSetVersionsInput {
	s.NextToken = &v
	return s
}

type ListImageSetVersionsOutput struct {
	_ struct{} `type:"structure"`

	// Lists all properties associated with an image set.
	//
	// ImageSetPropertiesList is a required field
	ImageSetPropertiesList []*ImageSetProperties `locationName:"imageSetPropertiesList" type:"list" required:"true"`

	// The pagination token used to retrieve the list of image set versions on the
	// next page.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageSetVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListImageSetVersionsOutput) GoString() string {
	return s.String()
}

// SetImageSetPropertiesList sets the ImageSetPropertiesList field's value.
func (s *ListImageSetVersionsOutput) SetImageSetPropertiesList(v []*ImageSetProperties) *ListImageSetVersionsOutput {
	s.ImageSetPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListImageSetVersionsOutput) SetNextToken(v string) *ListImageSetVersionsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the medical imaging resource to list tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of all tags associated with a medical imaging resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Contains DICOMUpdates.
type MetadataUpdates struct {
	_ struct{} `type:"structure"`

	// The object containing removableAttributes and updatableAttributes.
	DICOMUpdates *DICOMUpdates `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetadataUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MetadataUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetadataUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetadataUpdates"}
	if s.DICOMUpdates != nil {
		if err := s.DICOMUpdates.Validate(); err != nil {
			invalidParams.AddNested("DICOMUpdates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDICOMUpdates sets the DICOMUpdates field's value.
func (s *MetadataUpdates) SetDICOMUpdates(v *DICOMUpdates) *MetadataUpdates {
	s.DICOMUpdates = v
	return s
}

// The request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The search input attribute value.
type SearchByAttributeValue struct {
	_ struct{} `type:"structure"`

	// The created at time of the image set provided for search.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The DICOM accession number for search.
	//
	// DICOMAccessionNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchByAttributeValue's
	// String and GoString methods.
	DICOMAccessionNumber *string `type:"string" sensitive:"true"`

	// The patient ID input for search.
	//
	// DICOMPatientId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchByAttributeValue's
	// String and GoString methods.
	DICOMPatientId *string `type:"string" sensitive:"true"`

	// The Series Instance UID input for search.
	//
	// DICOMSeriesInstanceUID is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchByAttributeValue's
	// String and GoString methods.
	DICOMSeriesInstanceUID *string `type:"string" sensitive:"true"`

	// The aggregated structure containing DICOM study date and study time for search.
	DICOMStudyDateAndTime *DICOMStudyDateAndTime `type:"structure"`

	// The DICOM study ID for search.
	//
	// DICOMStudyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchByAttributeValue's
	// String and GoString methods.
	DICOMStudyId *string `type:"string" sensitive:"true"`

	// The DICOM study instance UID for search.
	//
	// DICOMStudyInstanceUID is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchByAttributeValue's
	// String and GoString methods.
	DICOMStudyInstanceUID *string `type:"string" sensitive:"true"`

	// The timestamp input for search.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchByAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchByAttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchByAttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchByAttributeValue"}
	if s.DICOMStudyDateAndTime != nil {
		if err := s.DICOMStudyDateAndTime.Validate(); err != nil {
			invalidParams.AddNested("DICOMStudyDateAndTime", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SearchByAttributeValue) SetCreatedAt(v time.Time) *SearchByAttributeValue {
	s.CreatedAt = &v
	return s
}

// SetDICOMAccessionNumber sets the DICOMAccessionNumber field's value.
func (s *SearchByAttributeValue) SetDICOMAccessionNumber(v string) *SearchByAttributeValue {
	s.DICOMAccessionNumber = &v
	return s
}

// SetDICOMPatientId sets the DICOMPatientId field's value.
func (s *SearchByAttributeValue) SetDICOMPatientId(v string) *SearchByAttributeValue {
	s.DICOMPatientId = &v
	return s
}

// SetDICOMSeriesInstanceUID sets the DICOMSeriesInstanceUID field's value.
func (s *SearchByAttributeValue) SetDICOMSeriesInstanceUID(v string) *SearchByAttributeValue {
	s.DICOMSeriesInstanceUID = &v
	return s
}

// SetDICOMStudyDateAndTime sets the DICOMStudyDateAndTime field's value.
func (s *SearchByAttributeValue) SetDICOMStudyDateAndTime(v *DICOMStudyDateAndTime) *SearchByAttributeValue {
	s.DICOMStudyDateAndTime = v
	return s
}

// SetDICOMStudyId sets the DICOMStudyId field's value.
func (s *SearchByAttributeValue) SetDICOMStudyId(v string) *SearchByAttributeValue {
	s.DICOMStudyId = &v
	return s
}

// SetDICOMStudyInstanceUID sets the DICOMStudyInstanceUID field's value.
func (s *SearchByAttributeValue) SetDICOMStudyInstanceUID(v string) *SearchByAttributeValue {
	s.DICOMStudyInstanceUID = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SearchByAttributeValue) SetUpdatedAt(v time.Time) *SearchByAttributeValue {
	s.UpdatedAt = &v
	return s
}

// The search criteria.
type SearchCriteria struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The filters for the search criteria.
	Filters []*SearchFilter `locationName:"filters" min:"1" type:"list"`

	// The sort input for search criteria.
	Sort *Sort `locationName:"sort" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchCriteria"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Sort != nil {
		if err := s.Sort.Validate(); err != nil {
			invalidParams.AddNested("Sort", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchCriteria) SetFilters(v []*SearchFilter) *SearchCriteria {
	s.Filters = v
	return s
}

// SetSort sets the Sort field's value.
func (s *SearchCriteria) SetSort(v *Sort) *SearchCriteria {
	s.Sort = v
	return s
}

// The search filter.
type SearchFilter struct {
	_ struct{} `type:"structure"`

	// The search filter operator for imageSetDateTime.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"Operator"`

	// The search filter values.
	//
	// Values is a required field
	Values []*SearchByAttributeValue `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchFilter"}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}
	if s.Values != nil {
		for i, v := range s.Values {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Values", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperator sets the Operator field's value.
func (s *SearchFilter) SetOperator(v string) *SearchFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchFilter) SetValues(v []*SearchByAttributeValue) *SearchFilter {
	s.Values = v
	return s
}

type SearchImageSetsInput struct {
	_ struct{} `type:"structure" payload:"SearchCriteria"`

	// The identifier of the data store where the image sets reside.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The maximum number of results that can be returned in a search.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token used for pagination of results returned in the response. Use the
	// token returned from the previous request to continue results where the previous
	// request ended.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The search criteria that filters by applying a maximum of 1 item to SearchByAttribute.
	//
	// SearchCriteria is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SearchImageSetsInput's
	// String and GoString methods.
	SearchCriteria *SearchCriteria `locationName:"searchCriteria" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchImageSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchImageSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchImageSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchImageSetsInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SearchCriteria != nil {
		if err := s.SearchCriteria.Validate(); err != nil {
			invalidParams.AddNested("SearchCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *SearchImageSetsInput) SetDatastoreId(v string) *SearchImageSetsInput {
	s.DatastoreId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchImageSetsInput) SetMaxResults(v int64) *SearchImageSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchImageSetsInput) SetNextToken(v string) *SearchImageSetsInput {
	s.NextToken = &v
	return s
}

// SetSearchCriteria sets the SearchCriteria field's value.
func (s *SearchImageSetsInput) SetSearchCriteria(v *SearchCriteria) *SearchImageSetsInput {
	s.SearchCriteria = v
	return s
}

type SearchImageSetsOutput struct {
	_ struct{} `type:"structure"`

	// The model containing the image set results.
	//
	// ImageSetsMetadataSummaries is a required field
	ImageSetsMetadataSummaries []*ImageSetsMetadataSummary `locationName:"imageSetsMetadataSummaries" type:"list" required:"true"`

	// The token for pagination results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The sort order for image set search results.
	Sort *Sort `locationName:"sort" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchImageSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchImageSetsOutput) GoString() string {
	return s.String()
}

// SetImageSetsMetadataSummaries sets the ImageSetsMetadataSummaries field's value.
func (s *SearchImageSetsOutput) SetImageSetsMetadataSummaries(v []*ImageSetsMetadataSummary) *SearchImageSetsOutput {
	s.ImageSetsMetadataSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchImageSetsOutput) SetNextToken(v string) *SearchImageSetsOutput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *SearchImageSetsOutput) SetSort(v *Sort) *SearchImageSetsOutput {
	s.Sort = v
	return s
}

// The request caused a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Sort search results.
type Sort struct {
	_ struct{} `type:"structure"`

	// The sort field for search criteria.
	//
	// SortField is a required field
	SortField *string `locationName:"sortField" type:"string" required:"true" enum:"SortField"`

	// The sort order for search criteria.
	//
	// SortOrder is a required field
	SortOrder *string `locationName:"sortOrder" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sort) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Sort"}
	if s.SortField == nil {
		invalidParams.Add(request.NewErrParamRequired("SortField"))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSortField sets the SortField field's value.
func (s *Sort) SetSortField(v string) *Sort {
	s.SortField = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Sort) SetSortOrder(v string) *Sort {
	s.SortOrder = &v
	return s
}

type StartDICOMImportJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for API idempotency.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that grants permission to
	// access medical imaging resources.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"20" type:"string" required:"true"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The account ID of the source S3 bucket owner.
	InputOwnerAccountId *string `locationName:"inputOwnerAccountId" min:"12" type:"string"`

	// The input prefix path for the S3 bucket that contains the DICOM files to
	// be imported.
	//
	// InputS3Uri is a required field
	InputS3Uri *string `locationName:"inputS3Uri" min:"1" type:"string" required:"true"`

	// The import job name.
	JobName *string `locationName:"jobName" min:"1" type:"string"`

	// The output prefix of the S3 bucket to upload the results of the DICOM import
	// job.
	//
	// OutputS3Uri is a required field
	OutputS3Uri *string `locationName:"outputS3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDICOMImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDICOMImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDICOMImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDICOMImportJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.InputOwnerAccountId != nil && len(*s.InputOwnerAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("InputOwnerAccountId", 12))
	}
	if s.InputS3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("InputS3Uri"))
	}
	if s.InputS3Uri != nil && len(*s.InputS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputS3Uri", 1))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputS3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputS3Uri"))
	}
	if s.OutputS3Uri != nil && len(*s.OutputS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputS3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartDICOMImportJobInput) SetClientToken(v string) *StartDICOMImportJobInput {
	s.ClientToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartDICOMImportJobInput) SetDataAccessRoleArn(v string) *StartDICOMImportJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartDICOMImportJobInput) SetDatastoreId(v string) *StartDICOMImportJobInput {
	s.DatastoreId = &v
	return s
}

// SetInputOwnerAccountId sets the InputOwnerAccountId field's value.
func (s *StartDICOMImportJobInput) SetInputOwnerAccountId(v string) *StartDICOMImportJobInput {
	s.InputOwnerAccountId = &v
	return s
}

// SetInputS3Uri sets the InputS3Uri field's value.
func (s *StartDICOMImportJobInput) SetInputS3Uri(v string) *StartDICOMImportJobInput {
	s.InputS3Uri = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartDICOMImportJobInput) SetJobName(v string) *StartDICOMImportJobInput {
	s.JobName = &v
	return s
}

// SetOutputS3Uri sets the OutputS3Uri field's value.
func (s *StartDICOMImportJobInput) SetOutputS3Uri(v string) *StartDICOMImportJobInput {
	s.OutputS3Uri = &v
	return s
}

type StartDICOMImportJobOutput struct {
	_ struct{} `type:"structure"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The import job identifier.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// The import job status.
	//
	// JobStatus is a required field
	JobStatus *string `locationName:"jobStatus" type:"string" required:"true" enum:"JobStatus"`

	// The timestamp when the import job was submitted.
	//
	// SubmittedAt is a required field
	SubmittedAt *time.Time `locationName:"submittedAt" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDICOMImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDICOMImportJobOutput) GoString() string {
	return s.String()
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *StartDICOMImportJobOutput) SetDatastoreId(v string) *StartDICOMImportJobOutput {
	s.DatastoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *StartDICOMImportJobOutput) SetJobId(v string) *StartDICOMImportJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartDICOMImportJobOutput) SetJobStatus(v string) *StartDICOMImportJobOutput {
	s.JobStatus = &v
	return s
}

// SetSubmittedAt sets the SubmittedAt field's value.
func (s *StartDICOMImportJobOutput) SetSubmittedAt(v time.Time) *StartDICOMImportJobOutput {
	s.SubmittedAt = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the medical imaging resource that tags
	// are being added to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The user-specified key and value tag pairs added to a medical imaging resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the medical imaging resource that tags
	// are being removed from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys for the tags to be removed from the medical imaging resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateImageSetMetadataInput struct {
	_ struct{} `type:"structure" payload:"UpdateImageSetMetadataUpdates"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `location:"uri" locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `location:"uri" locationName:"imageSetId" type:"string" required:"true"`

	// The latest image set version identifier.
	//
	// LatestVersionId is a required field
	LatestVersionId *string `location:"querystring" locationName:"latestVersion" type:"string" required:"true"`

	// Update image set metadata updates.
	//
	// UpdateImageSetMetadataUpdates is a required field
	UpdateImageSetMetadataUpdates *MetadataUpdates `locationName:"updateImageSetMetadataUpdates" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImageSetMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImageSetMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateImageSetMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateImageSetMetadataInput"}
	if s.DatastoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("DatastoreId"))
	}
	if s.DatastoreId != nil && len(*s.DatastoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatastoreId", 1))
	}
	if s.ImageSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageSetId"))
	}
	if s.ImageSetId != nil && len(*s.ImageSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageSetId", 1))
	}
	if s.LatestVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("LatestVersionId"))
	}
	if s.UpdateImageSetMetadataUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateImageSetMetadataUpdates"))
	}
	if s.UpdateImageSetMetadataUpdates != nil {
		if err := s.UpdateImageSetMetadataUpdates.Validate(); err != nil {
			invalidParams.AddNested("UpdateImageSetMetadataUpdates", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *UpdateImageSetMetadataInput) SetDatastoreId(v string) *UpdateImageSetMetadataInput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *UpdateImageSetMetadataInput) SetImageSetId(v string) *UpdateImageSetMetadataInput {
	s.ImageSetId = &v
	return s
}

// SetLatestVersionId sets the LatestVersionId field's value.
func (s *UpdateImageSetMetadataInput) SetLatestVersionId(v string) *UpdateImageSetMetadataInput {
	s.LatestVersionId = &v
	return s
}

// SetUpdateImageSetMetadataUpdates sets the UpdateImageSetMetadataUpdates field's value.
func (s *UpdateImageSetMetadataInput) SetUpdateImageSetMetadataUpdates(v *MetadataUpdates) *UpdateImageSetMetadataInput {
	s.UpdateImageSetMetadataUpdates = v
	return s
}

type UpdateImageSetMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when image set metadata was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The data store identifier.
	//
	// DatastoreId is a required field
	DatastoreId *string `locationName:"datastoreId" type:"string" required:"true"`

	// The image set identifier.
	//
	// ImageSetId is a required field
	ImageSetId *string `locationName:"imageSetId" type:"string" required:"true"`

	// The image set state.
	//
	// ImageSetState is a required field
	ImageSetState *string `locationName:"imageSetState" type:"string" required:"true" enum:"ImageSetState"`

	// The image set workflow status.
	ImageSetWorkflowStatus *string `locationName:"imageSetWorkflowStatus" type:"string" enum:"ImageSetWorkflowStatus"`

	// The latest image set version identifier.
	//
	// LatestVersionId is a required field
	LatestVersionId *string `locationName:"latestVersionId" type:"string" required:"true"`

	// The error message thrown if an update image set metadata action fails.
	Message *string `locationName:"message" min:"1" type:"string"`

	// The timestamp when image set metadata was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImageSetMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateImageSetMetadataOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateImageSetMetadataOutput) SetCreatedAt(v time.Time) *UpdateImageSetMetadataOutput {
	s.CreatedAt = &v
	return s
}

// SetDatastoreId sets the DatastoreId field's value.
func (s *UpdateImageSetMetadataOutput) SetDatastoreId(v string) *UpdateImageSetMetadataOutput {
	s.DatastoreId = &v
	return s
}

// SetImageSetId sets the ImageSetId field's value.
func (s *UpdateImageSetMetadataOutput) SetImageSetId(v string) *UpdateImageSetMetadataOutput {
	s.ImageSetId = &v
	return s
}

// SetImageSetState sets the ImageSetState field's value.
func (s *UpdateImageSetMetadataOutput) SetImageSetState(v string) *UpdateImageSetMetadataOutput {
	s.ImageSetState = &v
	return s
}

// SetImageSetWorkflowStatus sets the ImageSetWorkflowStatus field's value.
func (s *UpdateImageSetMetadataOutput) SetImageSetWorkflowStatus(v string) *UpdateImageSetMetadataOutput {
	s.ImageSetWorkflowStatus = &v
	return s
}

// SetLatestVersionId sets the LatestVersionId field's value.
func (s *UpdateImageSetMetadataOutput) SetLatestVersionId(v string) *UpdateImageSetMetadataOutput {
	s.LatestVersionId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *UpdateImageSetMetadataOutput) SetMessage(v string) *UpdateImageSetMetadataOutput {
	s.Message = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateImageSetMetadataOutput) SetUpdatedAt(v time.Time) *UpdateImageSetMetadataOutput {
	s.UpdatedAt = &v
	return s
}

// The input fails to satisfy the constraints set by the service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DatastoreStatusCreating is a DatastoreStatus enum value
	DatastoreStatusCreating = "CREATING"

	// DatastoreStatusCreateFailed is a DatastoreStatus enum value
	DatastoreStatusCreateFailed = "CREATE_FAILED"

	// DatastoreStatusActive is a DatastoreStatus enum value
	DatastoreStatusActive = "ACTIVE"

	// DatastoreStatusDeleting is a DatastoreStatus enum value
	DatastoreStatusDeleting = "DELETING"

	// DatastoreStatusDeleted is a DatastoreStatus enum value
	DatastoreStatusDeleted = "DELETED"
)

// DatastoreStatus_Values returns all elements of the DatastoreStatus enum
func DatastoreStatus_Values() []string {
	return []string{
		DatastoreStatusCreating,
		DatastoreStatusCreateFailed,
		DatastoreStatusActive,
		DatastoreStatusDeleting,
		DatastoreStatusDeleted,
	}
}

const (
	// ImageSetStateActive is a ImageSetState enum value
	ImageSetStateActive = "ACTIVE"

	// ImageSetStateLocked is a ImageSetState enum value
	ImageSetStateLocked = "LOCKED"

	// ImageSetStateDeleted is a ImageSetState enum value
	ImageSetStateDeleted = "DELETED"
)

// ImageSetState_Values returns all elements of the ImageSetState enum
func ImageSetState_Values() []string {
	return []string{
		ImageSetStateActive,
		ImageSetStateLocked,
		ImageSetStateDeleted,
	}
}

const (
	// ImageSetWorkflowStatusCreated is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusCreated = "CREATED"

	// ImageSetWorkflowStatusCopied is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusCopied = "COPIED"

	// ImageSetWorkflowStatusCopying is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusCopying = "COPYING"

	// ImageSetWorkflowStatusCopyingWithReadOnlyAccess is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusCopyingWithReadOnlyAccess = "COPYING_WITH_READ_ONLY_ACCESS"

	// ImageSetWorkflowStatusCopyFailed is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusCopyFailed = "COPY_FAILED"

	// ImageSetWorkflowStatusUpdating is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusUpdating = "UPDATING"

	// ImageSetWorkflowStatusUpdated is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusUpdated = "UPDATED"

	// ImageSetWorkflowStatusUpdateFailed is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusUpdateFailed = "UPDATE_FAILED"

	// ImageSetWorkflowStatusDeleting is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusDeleting = "DELETING"

	// ImageSetWorkflowStatusDeleted is a ImageSetWorkflowStatus enum value
	ImageSetWorkflowStatusDeleted = "DELETED"
)

// ImageSetWorkflowStatus_Values returns all elements of the ImageSetWorkflowStatus enum
func ImageSetWorkflowStatus_Values() []string {
	return []string{
		ImageSetWorkflowStatusCreated,
		ImageSetWorkflowStatusCopied,
		ImageSetWorkflowStatusCopying,
		ImageSetWorkflowStatusCopyingWithReadOnlyAccess,
		ImageSetWorkflowStatusCopyFailed,
		ImageSetWorkflowStatusUpdating,
		ImageSetWorkflowStatusUpdated,
		ImageSetWorkflowStatusUpdateFailed,
		ImageSetWorkflowStatusDeleting,
		ImageSetWorkflowStatusDeleted,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCompleted,
		JobStatusFailed,
	}
}

const (
	// OperatorEqual is a Operator enum value
	OperatorEqual = "EQUAL"

	// OperatorBetween is a Operator enum value
	OperatorBetween = "BETWEEN"
)

// Operator_Values returns all elements of the Operator enum
func Operator_Values() []string {
	return []string{
		OperatorEqual,
		OperatorBetween,
	}
}

const (
	// SortFieldUpdatedAt is a SortField enum value
	SortFieldUpdatedAt = "updatedAt"

	// SortFieldCreatedAt is a SortField enum value
	SortFieldCreatedAt = "createdAt"

	// SortFieldDicomstudyDateAndTime is a SortField enum value
	SortFieldDicomstudyDateAndTime = "DICOMStudyDateAndTime"
)

// SortField_Values returns all elements of the SortField enum
func SortField_Values() []string {
	return []string{
		SortFieldUpdatedAt,
		SortFieldCreatedAt,
		SortFieldDicomstudyDateAndTime,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}
