/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.notifications;

import com.intellij.kotlin.jupyter.core.jupyter.actions.KotlinNotebookRestartStatus;
import com.intellij.kotlin.jupyter.core.notifications.NotificationsKt;
import com.intellij.kotlin.jupyter.core.projectModel.KotlinNotebookRestartNeededNotificationService;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookPostStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "installProjectOptionsListener", "showOutdatedKernelWarningIfNeeded", "resetScriptDefinitionAndShowKernelRestartNeededWarning", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookPostStartupActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.installProjectOptionsListener(project);
        this.showOutdatedKernelWarningIfNeeded(project);
        return Unit.INSTANCE;
    }

    private final void installProjectOptionsListener(Project project) {
        KotlinNotebookProjectOptionsProvider projectOptions = KotlinNotebookProjectOptionsProvider.Companion.getInstance(project);
        projectOptions.addListener((EventListener)new KotlinNotebookProjectOptionsProvider.Listener(projectOptions, this, project){
            final /* synthetic */ KotlinNotebookProjectOptionsProvider $projectOptions;
            final /* synthetic */ KotlinNotebookPostStartupActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.$projectOptions = $projectOptions;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void onKernelVersionChanged() {
                this.$projectOptions.setIgnoreOutdatedKernelVersion$intellij_kotlin_jupyter_core(false);
                KotlinNotebookPostStartupActivity.access$showOutdatedKernelWarningIfNeeded(this.this$0, this.$project);
            }

            public void onExtraCompilerArgumentsChanged() {
                KotlinNotebookPostStartupActivity.access$resetScriptDefinitionAndShowKernelRestartNeededWarning(this.this$0, this.$project);
            }
        }, projectOptions);
        KotlinNotebookApplicationOptions.INSTANCE.get().addListener((EventListener)new KotlinNotebookApplicationOptionsProvider.Listener(this, project){
            final /* synthetic */ KotlinNotebookPostStartupActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void onReplCompilerModeChanged() {
                KotlinNotebookPostStartupActivity.access$resetScriptDefinitionAndShowKernelRestartNeededWarning(this.this$0, this.$project);
            }
        }, projectOptions);
    }

    private final void showOutdatedKernelWarningIfNeeded(Project project) {
        NotificationsKt.getNotebookNotifications(project).showOutdatedKernelWarningIfNeeded();
    }

    private final void resetScriptDefinitionAndShowKernelRestartNeededWarning(Project project) {
        JupyterCompilerService.Companion.getInstance(project).resetScriptDefinition();
        KotlinNotebookRestartNeededNotificationService.Companion.getInstance(project).notifyAll(new KotlinNotebookRestartStatus.Needed(KotlinNotebookBundle.message("kotlin.notebook.kernel.settings.changed.hint.text", new Object[0])));
    }

    public static final /* synthetic */ void access$showOutdatedKernelWarningIfNeeded(KotlinNotebookPostStartupActivity $this, Project project) {
        $this.showOutdatedKernelWarningIfNeeded(project);
    }

    public static final /* synthetic */ void access$resetScriptDefinitionAndShowKernelRestartNeededWarning(KotlinNotebookPostStartupActivity $this, Project project) {
        $this.resetScriptDefinitionAndShowKernelRestartNeededWarning(project);
    }
}

