/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.AutoSelectListener;
import com.intellij.database.schemaEditor.ui.DbCollectionEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.ManualPopupButton;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DbKeyColumnsEditor<E extends BasicElement, C extends DbKeyColumnsModelApplier.KeyColumn>
extends DbCollectionEditor<E, C> {
    public DbKeyColumnsEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbCollectionModelState<C>> model) {
        if (controller == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
    }

    public KeyColumnEditor createEditor() {
        return new KeyColumnEditor();
    }

    @Override
    protected void render(@NotNull SimpleColoredComponent c2, @NotNull @NlsSafe C value) {
        if (c2 == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(2);
        }
        if (value == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(3);
        }
        this.renderName(c2, ((DbKeyColumnsModelApplier.KeyColumn)value).name.getValue());
    }

    @NotNull
    public static EditorTextField createColumnNameEditor(final @NotNull DbEditorController controller, final @NotNull Supplier<? extends ElementIdentity<?>> holderSupplier) {
        if (controller == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(4);
        }
        if (holderSupplier == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(5);
        }
        TextFieldWithCompletion field = new TextFieldWithCompletion(controller.getProject(), (TextCompletionProvider)new TextFieldWithAutoCompletionListProvider<String>(null){

            public boolean isDumbAware() {
                return true;
            }

            @NotNull
            protected String getLookupString(@NotNull String item) {
                if (item == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = item;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
                if (prefix == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new CamelHumpMatcher(prefix, false);
            }

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List<String> list = this.getItems();
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private List<String> getItems() {
                ElementIdentity identity = (ElementIdentity)holderSupplier.get();
                if (identity == null) {
                    return Collections.emptyList();
                }
                DbEditorModelController modelController = controller.getModelController();
                DbStructureObjectModelState state = modelController.getStructureNodeModelState(identity);
                if (state != null) {
                    DbModelRef columns = state.getFamily(ObjectKind.COLUMN);
                    return JBIterable.from(columns == null ? null : columns.getState().getIterable()).map(c2 -> ((DbStructureObjectModelState)c2.getState()).getObjectRef().getState()).filterMap(c2 -> c2.isDropped() ? null : c2.getProperties().getName()).toList();
                }
                ElementOwner original = modelController.getMatcher().getOriginalOwner();
                BasicElement orig = original == null ? null : original.find(identity);
                return JBIterable.from(orig == null ? null : orig.familyOf(ObjectKind.COLUMN)).map(DasUtil::getName).toList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbKeyColumnsEditor$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbKeyColumnsEditor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItems";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPrefixMatcher";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        }, "", true, true, false);
        ManualPopupButton.INSTANCE.install((EditorTextField)field, false);
        AutoSelectListener.INSTANCE.install((JComponent)field);
        TextFieldWithCompletion textFieldWithCompletion = field;
        if (textFieldWithCompletion == null) {
            DbKeyColumnsEditor.$$$reportNull$$$0(6);
        }
        return textFieldWithCompletion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holderSupplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbKeyColumnsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbKeyColumnsEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnNameEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createColumnNameEditor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public class KeyColumnEditor
    extends DbCollectionEditor.BaseItemEditor<C> {
        private C prev;
        protected final EditorTextField myNameField;

        public KeyColumnEditor() {
            this.myNameField = DbKeyColumnsEditor.createColumnNameEditor(DbKeyColumnsEditor.this.getController(), () -> DbKeyColumnsEditor.this.getController().getParent(DbKeyColumnsEditor.this.getIdentity()));
        }

        @Override
        protected final JComponent createComponent() {
            List<Pair<@Nls String, JComponent>> components = this.createComponents();
            JComponent component = this.createComponent(components.size());
            for (int i = 0; i < components.size(); ++i) {
                this.addRow(component, i, (String)components.get((int)i).first, (JComponent)components.get((int)i).second);
            }
            return component;
        }

        protected List<Pair<@Nls String, JComponent>> createComponents() {
            ArrayList<Pair<String, JComponent>> res2 = new ArrayList<Pair<String, JComponent>>();
            res2.add(Pair.create((Object)DatabaseBundle.message((String)"DbObjectEditor.label.column.name", (Object[])new Object[0]), (Object)this.myNameField));
            return res2;
        }

        @Override
        public void set(C item) {
            this.prev = item;
            this.myNameField.setText(this.extractNameText(item));
        }

        @NotNull
        protected String extractNameText(C item) {
            String string = ((DbKeyColumnsModelApplier.KeyColumn)item).name.getValue();
            if (string == null) {
                KeyColumnEditor.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public C get() {
            DbKeyColumnsModelApplier.KeyColumn column = (DbKeyColumnsModelApplier.KeyColumn)((DbCollectionModelState)DbKeyColumnsEditor.this.getState()).getItemFactory().createItem(this.prev);
            String text = this.myNameField.getText();
            column.name.setValue(this.extractNameText(text), NamingServices.getNamingService((Dbms)DbKeyColumnsEditor.this.getDbms()));
            return column;
        }

        protected String extractNameText(String text) {
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/ui/DbKeyColumnsEditor$KeyColumnEditor", "extractNameText"));
        }
    }
}

