/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent.storage.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.platform.trace.consent.model.TraceStateEvent;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001d\u0010\f\u001a\u0004\u0018\u00010\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/trace/consent/storage/serialization/TraceStateEventSerializer;", "", "<init>", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "machineId", "", "getMachineId", "()Ljava/lang/String;", "machineId$delegate", "Lkotlin/Lazy;", "encryptionSupport", "Lcom/intellij/util/proxy/PropertiesEncryptionSupport;", "getEncryptionSupport", "()Lcom/intellij/util/proxy/PropertiesEncryptionSupport;", "encryptionSupport$delegate", "serialize", "event", "Lcom/intellij/platform/trace/consent/model/TraceStateEvent;", "serializeEncrypted", "encrypt", "data", "machineIdToAESKey", "Ljavax/crypto/spec/SecretKeySpec;", "intellij.platform.trace.consent"})
@SourceDebugExtension(value={"SMAP\nTraceStateEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceStateEventSerializer.kt\ncom/intellij/platform/trace/consent/storage/serialization/TraceStateEventSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class TraceStateEventSerializer {
    @NotNull
    public static final TraceStateEventSerializer INSTANCE = new TraceStateEventSerializer();
    @NotNull
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    @NotNull
    private static final Lazy machineId$delegate = LazyKt.lazy(TraceStateEventSerializer::machineId_delegate$lambda$0);
    @NotNull
    private static final Lazy encryptionSupport$delegate = LazyKt.lazy(TraceStateEventSerializer::encryptionSupport_delegate$lambda$0);

    private TraceStateEventSerializer() {
    }

    @Nullable
    public final String getMachineId() {
        Lazy lazy = machineId$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final PropertiesEncryptionSupport getEncryptionSupport() {
        Lazy lazy = encryptionSupport$delegate;
        return (PropertiesEncryptionSupport)lazy.getValue();
    }

    private final String serialize(TraceStateEvent event) {
        ObjectNode objectNode;
        ObjectNode $this$serialize_u24lambda_u240 = objectNode = jsonMapper.createObjectNode();
        boolean bl = false;
        $this$serialize_u24lambda_u240.put("ideName", event.getIdeName());
        $this$serialize_u24lambda_u240.put("ideVersion", event.getIdeVersion());
        $this$serialize_u24lambda_u240.put("consentType", event.getConsentType().toString());
        $this$serialize_u24lambda_u240.put("consentState", event.getConsentState().toString());
        $this$serialize_u24lambda_u240.put("timestamp", event.getTimestamp());
        $this$serialize_u24lambda_u240.put("previousConsentState", String.valueOf((Object)event.getPreviousConsentState()));
        $this$serialize_u24lambda_u240.put("previousConsentTimestamp", event.getPreviousConsentTimestamp());
        $this$serialize_u24lambda_u240.put("projectIdHash", event.getProjectIdHash());
        $this$serialize_u24lambda_u240.put("isLicenseChange", event.isLicenseChange());
        String string = objectNode.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String serializeEncrypted(@NotNull TraceStateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.encrypt(this.serialize(event));
    }

    private final String encrypt(String data) {
        Object object;
        block3: {
            block2: {
                object = this.getEncryptionSupport();
                if (object == null) break block2;
                PropertiesEncryptionSupport it = object;
                boolean bl = false;
                Base64 base64 = (Base64)Base64.Default;
                byte[] byArray = data.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = it.encrypt(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encrypt(...)");
                String string = Base64.encode$default((Base64)base64, (byte[])byArray2, (int)0, (int)0, (int)6, null);
                object = string;
                if (string != null) break block3;
            }
            object = data;
        }
        return object;
    }

    private final SecretKeySpec machineIdToAESKey(String machineId) {
        MessageDigest sha = MessageDigest.getInstance("SHA-256");
        String string = machineId;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] validAesKey = sha.digest(byArray);
        return new SecretKeySpec(validAesKey, "AES");
    }

    private static final String machineId_delegate$lambda$0() {
        return MachineIdManager.INSTANCE.getAnonymizedMachineId("TRACE STATE EVENT");
    }

    private static final PropertiesEncryptionSupport encryptionSupport_delegate$lambda$0() {
        PropertiesEncryptionSupport propertiesEncryptionSupport;
        String string = INSTANCE.getMachineId();
        if (string != null) {
            String it = string;
            boolean bl = false;
            propertiesEncryptionSupport = new PropertiesEncryptionSupport((Key)INSTANCE.machineIdToAESKey(it));
        } else {
            propertiesEncryptionSupport = null;
        }
        return propertiesEncryptionSupport;
    }
}

