/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.backend.split;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Ports;
import com.intellij.docker.agent.impl.DockerAgentContainerInfo;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteProcess;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ContainerPortForwardingCollector;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortBinding;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/backend/split/DockerPortForwardingCollector;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ContainerPortForwardingCollector;", "<init>", "()V", "collectForwardedPortsForRemoteProcess", "", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortBinding;", "remoteProcess", "Lcom/intellij/remote/RemoteProcess;", "getPortType", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortType;", "Lcom/github/dockerjava/api/model/ExposedPort;", "Companion", "intellij.docker.backend.split"})
@SourceDebugExtension(value={"SMAP\nDockerPortForwardingCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerPortForwardingCollector.kt\ncom/intellij/docker/backend/split/DockerPortForwardingCollector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n67#2,4:66\n60#2,5:96\n23#2:101\n136#3,9:70\n216#3:79\n217#3:94\n145#3:95\n11879#4,9:80\n13805#4:89\n13806#4:91\n11888#4:92\n1#5:90\n1#5:93\n*S KotlinDebug\n*F\n+ 1 DockerPortForwardingCollector.kt\ncom/intellij/docker/backend/split/DockerPortForwardingCollector\n*L\n23#1:66,4\n52#1:96,5\n18#1:101\n33#1:70,9\n33#1:79\n33#1:94\n33#1:95\n35#1:80,9\n35#1:89\n35#1:91\n35#1:92\n35#1:90\n33#1:93\n*E\n"})
final class DockerPortForwardingCollector
implements ContainerPortForwardingCollector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PortBinding> collectForwardedPortsForRemoteProcess(@NotNull RemoteProcess remoteProcess) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)remoteProcess, (String)"remoteProcess");
        DockerExecProcess dockerExecProcess = remoteProcess instanceof DockerExecProcess ? (DockerExecProcess)remoteProcess : null;
        if (dockerExecProcess == null) {
            DockerPortForwardingCollector it = this;
            boolean bl = false;
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Docker Port Forwarding Collector. Skip collecting forwarded ports for process of type: " + remoteProcess.getClass().getSimpleName());
            }
            return CollectionsKt.emptyList();
        }
        DockerExecProcess dockerExecProcess2 = dockerExecProcess;
        DockerAgentContainerInfo dockerAgentContainerInfo = dockerExecProcess2.getApplicationRuntime().getAgentContainer().getInfo();
        if (dockerAgentContainerInfo == null) {
            return CollectionsKt.emptyList();
        }
        DockerAgentContainerInfo containerInfo = dockerAgentContainerInfo;
        Map map = containerInfo.getInspection().getHostConfig().getPortBindings().getBindings();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBindings(...)");
        Map it = map;
        boolean $i$f$mapNotNull = false;
        void $this$trace$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            PortBinding it$iv$iv;
            PortType portType;
            void $this$mapNotNullTo$iv$iv2;
            Ports.Binding[] bindingsForPort;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl3 = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            ExposedPort exposedPort = (ExposedPort)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Ports.Binding[] $this$mapNotNull$iv2 = bindingsForPort = (Ports.Binding[])v;
            boolean $i$f$mapNotNull2 = false;
            Ports.Binding[] bindingArray = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            int n = ((void)$this$forEach$iv$iv$iv2).length;
            for (int i = 0; i < n; ++i) {
                InetSocketAddress inetSocketAddress;
                void element$iv$iv$iv2;
                void element$iv$iv2 = element$iv$iv$iv2 = $this$forEach$iv$iv$iv2[i];
                boolean bl4 = false;
                void binding = element$iv$iv2;
                boolean bl5 = false;
                String string = binding.getHostPortSpec();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostPortSpec(...)");
                Integer n2 = StringsKt.toIntOrNull((String)string);
                if (n2 == null) {
                    inetSocketAddress = null;
                } else {
                    int hostPort = n2;
                    String string2 = binding.getHostIp();
                    if (string2 == null) {
                        string2 = "127.0.0.1";
                    }
                    String hostAddress = string2;
                    inetSocketAddress = new InetSocketAddress(hostAddress, hostPort);
                }
                if (inetSocketAddress == null) continue;
                InetSocketAddress it$iv$iv2 = inetSocketAddress;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List bindings = (List)destination$iv$iv2;
            if ((this.getPortType(exposedPort) == null ? null : new PortBinding(exposedPort.getPort(), portType, "127.0.0.1", bindings)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List portBindings = (List)destination$iv$iv;
        return portBindings;
    }

    private final PortType getPortType(ExposedPort $this$getPortType) {
        PortType portType;
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Read port type for Docker exposed port: " + $this$getPortType.getPort() + ", protocol: " + $this$getPortType.getProtocol(), e$iv);
        }
        InternetProtocol internetProtocol = $this$getPortType.getProtocol();
        if ((internetProtocol == null ? -1 : WhenMappings.$EnumSwitchMapping$0[internetProtocol.ordinal()]) == 1) {
            portType = PortType.TCP;
        } else {
            logger.info("Unsupported protocol: " + $this$getPortType.getProtocol() + " for Docker exposed port: " + $this$getPortType.getPort());
            portType = null;
        }
        return portType;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DockerPortForwardingCollector.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/backend/split/DockerPortForwardingCollector$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.docker.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InternetProtocol.values().length];
            try {
                nArray[InternetProtocol.TCP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

