/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Triple;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class PublishActionUtil {
    private PublishActionUtil() {
    }

    public static boolean hasAnyServers(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed() || project.isDefault()) {
            return false;
        }
        return GroupedServersConfigManager.getInstance(project).hasServers(true);
    }

    @Nullable
    public static Trinity<VirtualFile, WebServerConfig, DeploymentPathMapping> findMappingForSingleFile(AnActionEvent e, boolean needsDirectory, boolean ignoreExcludedPaths) {
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files == null || files.length != 1 || files[0] == null || needsDirectory != files[0].isDirectory()) {
            return null;
        }
        Project project = e.getProject();
        Pair<WebServerConfig, DeploymentPathMapping> pair = PublishActionUtil.findMappingFor(files[0], project, ignoreExcludedPaths);
        return pair == null ? null : Trinity.create((Object)files[0], (Object)((WebServerConfig)pair.getFirst()), (Object)((DeploymentPathMapping)pair.getSecond()));
    }

    public static VirtualFile @Nullable [] getVirtualFiles(AnActionEvent e) {
        @NotNull VirtualFile @Nullable [] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = VirtualFileUtil.originalFileOrSelf((VirtualFile)files[i]);
        }
        return files;
    }

    @Nullable
    public static Pair<WebServerConfig, DeploymentPathMapping> findMappingFor(@Nullable VirtualFile file, @Nullable Project project, boolean ignoreExcludedPaths) {
        if (file == null || project == null || project.isDisposed() || project.isDefault()) {
            return null;
        }
        PublishConfig publishConfig2 = PublishConfig.getInstance(project);
        List<WebServerConfig> defaultServers = publishConfig2.findDefaultServers();
        if (defaultServers.isEmpty()) {
            return null;
        }
        for (WebServerConfig server : defaultServers) {
            DeploymentPathMapping mapping;
            if (!server.needsTransfer() || server.getFileTransferConfig().validateFast() != null || (mapping = (DeploymentPathMapping)publishConfig2.getNearestMappingForLocal(file.getPath(), false, true, false, server, ignoreExcludedPaths).getFirst()) == null || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            return Pair.create((Object)server, (Object)mapping);
        }
        return null;
    }

    @Nullable
    public static Pair<WebServerConfig, DeploymentPathMapping> findMappingFor(@Nullable VirtualFile file, @NotNull WebServerConfig server, @NotNull PublishConfig config, boolean ignoreExcludedPaths) {
        if (server == null) {
            PublishActionUtil.$$$reportNull$$$0(0);
        }
        if (config == null) {
            PublishActionUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            return null;
        }
        if (!server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
            return null;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)config.getNearestMappingForLocal(file.getPath(), false, true, false, server, ignoreExcludedPaths).getFirst();
        if (mapping != null && !StringUtil.isEmpty((String)mapping.getDeployPath())) {
            return Pair.create((Object)server, (Object)mapping);
        }
        return null;
    }

    @Nullable
    public static WebServerConfig.RemotePath findDeployPathFor(@NotNull VirtualFile file, @Nullable Project project, boolean ignoreExcludedPaths) {
        Pair<WebServerConfig, DeploymentPathMapping> mapping;
        if (file == null) {
            PublishActionUtil.$$$reportNull$$$0(2);
        }
        return (mapping = PublishActionUtil.findMappingFor(file, project, ignoreExcludedPaths)) != null ? ((DeploymentPathMapping)mapping.second).mapToDeployPath(file.getPath(), (Mappable)mapping.first, file.isDirectory()) : null;
    }

    public static boolean checkMapping(PublishConfig publishConfig2, WebServerConfig server, String path, boolean allowChild) {
        return publishConfig2.getNearestMappingForLocal(path, false, true, false, (Mappable)server).getFirst() != null || allowChild && !((List)publishConfig2.getChildMappingsForLocal(path, true, false, (Mappable)server).getFirst()).isEmpty();
    }

    public static TransferTask.ListBased.ResultWithErrors scanFiles(ExecutionContext context, Collection<? extends VirtualFile> roots) throws FileSystemException {
        ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
        DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
        for (VirtualFile virtualFile : roots) {
            FileObject source = DeploymentPathUtils.getLocalFile(virtualFile.getPath());
            DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processOutgoing(source, result, context);
            errors.addAll(e);
        }
        return new TransferTask.ListBased.ResultWithErrors(result, errors);
    }

    public static Promise<WebServerGroupingWrap> chooseServerFromWraps(PublishConfig publishConfig2, Collection<? extends WebServerGroupingWrap> wraps, AnActionEvent event, @NlsContexts.PopupTitle String popupMessage, final boolean allowToChooseGroup) {
        ArrayList<? extends WebServerGroupingWrap> sorted = new ArrayList<WebServerGroupingWrap>(wraps);
        sorted.sort((o1, o2) -> {
            boolean isProjectLevel2;
            boolean isProjectLevel1 = o1.isProjectLevel();
            if (isProjectLevel1 != (isProjectLevel2 = o2.isProjectLevel())) {
                return isProjectLevel1 ? -1 : 1;
            }
            if (o1.isSingleServer() != o2.isSingleServer()) {
                return o1.isSingleServer() ? 1 : -1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        final String defaultServerOrGroupName = publishConfig2.getDefaultServerOrGroupName();
        final AsyncPromise result = new AsyncPromise();
        ListPopupImpl popup = new ListPopupImpl(event.getProject(), (ListPopupStep)new ChooseServerStep(sorted, popupMessage){
            WebServerGroupingWrap server;

            @Nullable
            public Runnable getFinalRunnable() {
                if (this.server != null) {
                    result.setResult((Object)this.server);
                }
                return super.getFinalRunnable();
            }

            public PopupStep<?> onChosen(Triple<WebServerGroupingWrap, WebServerConfig, Boolean> selectedValue, boolean finalChoice) {
                if (selectedValue.getFirst() != null) {
                    this.server = (WebServerGroupingWrap)selectedValue.getFirst();
                } else if (selectedValue.getSecond() != null) {
                    this.server = WebServerGroupingWrap.wrap((WebServerConfig)selectedValue.getSecond());
                }
                return FINAL_CHOICE;
            }

            public boolean isSelectable(Triple<WebServerGroupingWrap, WebServerConfig, Boolean> value) {
                return allowToChooseGroup || value.getSecond() != null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public void canceled() {
                result.cancel();
            }
        }){

            protected ListCellRenderer<?> getListElementRenderer() {
                return new PopupListElementRenderer<Triple<WebServerGroupingWrap, WebServerConfig, Boolean>>((ListPopupImpl)this){

                    protected void customizeComponent(JList<? extends Triple<WebServerGroupingWrap, WebServerConfig, Boolean>> list, Triple<WebServerGroupingWrap, WebServerConfig, Boolean> value, boolean isSelected) {
                        super.customizeComponent(list, value, isSelected);
                        if (value == null) {
                            return;
                        }
                        if (defaultServerOrGroupName != null) {
                            String name = null;
                            if (value.getFirst() != null) {
                                name = ((WebServerGroupingWrap)value.getFirst()).getName();
                            } else if (value.getSecond() != null) {
                                name = ((WebServerConfig)value.getSecond()).getName();
                            }
                            if (defaultServerOrGroupName.equals(name)) {
                                this.myTextLabel.setText(String.format("<html><b>%s</b></html>", this.myTextLabel.getText()));
                            }
                        }
                        if (value.getSecond() != null && value.getThird() == Boolean.TRUE) {
                            Icon icon = this.getItemIcon(value, isSelected);
                            int width = icon == null ? 0 : icon.getIconWidth();
                            this.myTextLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)width));
                        } else {
                            this.myTextLabel.setBorder((Border)JBUI.Borders.empty());
                        }
                    }
                };
            }
        };
        InputEvent inputEvent = event.getInputEvent();
        Project project = event.getProject();
        if (inputEvent instanceof KeyEvent || project == null) {
            popup.showInBestPositionFor(event.getDataContext());
        } else {
            PointerInfo info = MouseInfo.getPointerInfo();
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(project);
            if (info != null && ideFrame != null) {
                popup.showInScreenCoordinates((Component)ideFrame.getComponent(), info.getLocation());
            } else {
                result.setResult(null);
            }
        }
        return result;
    }

    public static boolean canUploadToDefaultServer(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PublishActionUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PublishActionUtil.$$$reportNull$$$0(4);
        }
        return PublishActionUtil.findMappingFor(file, project, false) != null;
    }

    public static Promise<Void> uploadToDefaultServer(@NotNull Project project, final VirtualFile ... files) {
        PublishConfig config;
        List<WebServerConfig> servers;
        if (project == null) {
            PublishActionUtil.$$$reportNull$$$0(5);
        }
        if (files == null) {
            PublishActionUtil.$$$reportNull$$$0(6);
        }
        if ((servers = (config = PublishConfig.getInstance(project)).findValidDefaultTransferableServers()).isEmpty()) {
            return Promises.rejectedPromise();
        }
        AutoUploadComponent.saveDocumentsSilently(project, Arrays.asList(files));
        ArrayList<AsyncPromise> promises = new ArrayList<AsyncPromise>(servers.size());
        for (WebServerConfig server : servers) {
            String title = WDBundle.message("upload.to", server.getName());
            FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, config.getTraceLevel());
            Deployable deployable = Deployable.create(server, project);
            final AsyncPromise result = new AsyncPromise();
            promises.add(result);
            new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, config, deployable, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

                @Override
                @NotNull
                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles(context, Arrays.asList(files));
                    if (resultWithErrors == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return resultWithErrors;
                }

                @Override
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (this.doRun(indicator)) {
                        result.setResult(null);
                    } else {
                        result.setError(WDBundle.message("rejected", new Object[0]));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil$3";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "buildOperationsList";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "run";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1 -> new IllegalArgumentException(string);
                    };
                }
            }.queue();
        }
        return Promises.all(promises);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMappingFor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findDeployPathFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canUploadToDefaultServer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "uploadToDefaultServer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChooseServerStep
    extends BaseListPopupStep<Triple<WebServerGroupingWrap, WebServerConfig, Boolean>> {
        private ChooseServerStep(List<WebServerGroupingWrap> wraps, @NlsContexts.PopupTitle String aTitle) {
            ArrayList<Icon> icons = new ArrayList<Icon>();
            ArrayList<Triple> aValues = new ArrayList<Triple>();
            for (WebServerGroupingWrap wrap : wraps) {
                if (wrap.isSingleServer()) {
                    WebServerConfig server = wrap.getAsSingleServer();
                    aValues.add(new Triple(null, (Object)server, (Object)false));
                    icons.add(server.getIcon());
                    continue;
                }
                aValues.add(new Triple((Object)wrap, null, null));
                icons.add(AllIcons.Webreferences.Server);
                for (WebServerConfig server : wrap.getServers()) {
                    if (!server.needsTransfer()) continue;
                    aValues.add(new Triple(null, (Object)server, (Object)true));
                    icons.add(server.getIcon());
                }
            }
            this.init(aTitle, aValues, icons);
        }

        @NotNull
        public String getTextFor(Triple<WebServerGroupingWrap, WebServerConfig, Boolean> server) {
            String name = "";
            if (server.getFirst() != null) {
                name = ((WebServerGroupingWrap)server.getFirst()).getName();
            } else if (server.getSecond() != null) {
                name = ((WebServerConfig)server.getSecond()).getName();
            }
            String string = ChooseServerStep.numberingText(this.getValues().indexOf(server), name);
            if (string == null) {
                ChooseServerStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isMnemonicsNavigationEnabled() {
            return true;
        }

        private static String numberingText(int n, String text) {
            text = n < 9 ? "&" + (n + 1) + ". " + (String)text : (n == 9 ? "&0. " + (String)text : "&" + (char)(65 + n - 10) + ". " + (String)text);
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/PublishActionUtil$ChooseServerStep", "getTextFor"));
        }
    }
}

