/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.target.TargetBasedSdkAdditionalData;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.TargetAwarePathMappingProvider;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.PublishConfigMappingProvider;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.target.webDeployment.WebDeploymentTargetEnvironmentConfiguration;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0014H\u0002J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00162\r\u0010\u0017\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugins/remotesdk/PublishConfigTargetAwareMappingProvider;", "Lcom/intellij/remote/TargetAwarePathMappingProvider;", "<init>", "()V", "accepts", "", "data", "Lcom/intellij/execution/target/TargetBasedSdkAdditionalData;", "collectMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "webConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "publishConfig", "Lcom/jetbrains/plugins/webDeployment/config/PublishConfig;", "getPathMappingSettings", "Lcom/intellij/util/PathMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getPathMappingsForDeploymentConfigurations", "Lcom/intellij/remote/RemoteCredentials;", "normalizeHost", "", "host", "Lorg/jetbrains/annotations/NonNls;", "intellij.remoteRun"})
public final class PublishConfigTargetAwareMappingProvider
extends TargetAwarePathMappingProvider {
    public boolean accepts(@NotNull TargetBasedSdkAdditionalData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data.getTargetEnvironmentConfiguration() instanceof WebDeploymentTargetEnvironmentConfiguration;
    }

    private final List<PathMappingSettings.PathMapping> collectMappings(WebServerConfig webConfig, PublishConfig publishConfig) {
        ArrayList<PathMappingSettings.PathMapping> result = new ArrayList<PathMappingSettings.PathMapping>();
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        for (DeploymentPathMapping mapping : mappings) {
            String rootFolder = webConfig.getFileTransferConfig().getRootFolder();
            Object object = rootFolder;
            Intrinsics.checkNotNull((Object)object);
            String string = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)object, (String)"\\", (String)"/", (boolean)false, (int)4, null))).toString();
            object = new char[1];
            object[0] = 47;
            rootFolder = StringsKt.trimEnd((String)string, (char[])object);
            object = mapping.getLocalPath();
            if (object == null || object.length() == 0 || (object = (CharSequence)mapping.getDeployPath()) == null || object.length() == 0) continue;
            result.add(new PathMappingSettings.PathMapping(mapping.getLocalPath(), PublishConfigMappingProvider.resolveDeployPath(rootFolder, mapping.getDeployPath())));
        }
        return result;
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(@NotNull Project project, @NotNull TargetBasedSdkAdditionalData data) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = data.getTargetEnvironmentConfiguration();
        Intrinsics.checkNotNull((Object)targetEnvironmentConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.plugins.remotesdk.target.webDeployment.WebDeploymentTargetEnvironmentConfiguration");
        WebDeploymentTargetEnvironmentConfiguration targetEnvironmentConfiguration2 = (WebDeploymentTargetEnvironmentConfiguration)targetEnvironmentConfiguration;
        RemoteCredentials credentials = targetEnvironmentConfiguration2.findRemoteCredentials(project);
        if (credentials == null) {
            return new PathMappingSettings();
        }
        return this.getPathMappingsForDeploymentConfigurations(project, credentials);
    }

    private final PathMappingSettings getPathMappingsForDeploymentConfigurations(Project project, RemoteCredentials data) {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            if (!Intrinsics.areEqual((Object)this.normalizeHost(webConfig.getFileTransferConfig().getHost()), (Object)this.normalizeHost(data.getHost()))) continue;
            Intrinsics.checkNotNull((Object)webConfig);
            Intrinsics.checkNotNull((Object)publishConfig);
            mappingSettings.addAll(this.collectMappings(webConfig, publishConfig));
        }
        return mappingSettings;
    }

    private final String normalizeHost(String host) {
        return Intrinsics.areEqual((Object)"localhost", (Object)host) ? "127.0.0.1" : host;
    }
}

