/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.diagrams.usages;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.diagrams.DiagramsUiBundle;
import com.intellij.microservices.diagrams.model.MsDiagramEndpoint;
import com.intellij.microservices.diagrams.model.MsDiagramExternalEndpoint;
import com.intellij.microservices.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.diagrams.usages.DummyUsageGroup;
import com.intellij.microservices.diagrams.usages.MsDiagramRequestUsage;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageGroupingRulesDefaultRanks;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0014\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/microservices/diagrams/usages/MsDiagramTargetEndpointGroupingRule;", "Lcom/intellij/usages/rules/SingleParentUsageGroupingRule;", "Lcom/intellij/usages/rules/UsageGroupingRuleEx;", "<init>", "()V", "getParentGroupFor", "Lcom/intellij/usages/UsageGroup;", "usage", "Lcom/intellij/usages/Usage;", "targets", "", "Lcom/intellij/usages/UsageTarget;", "(Lcom/intellij/usages/Usage;[Lcom/intellij/usages/UsageTarget;)Lcom/intellij/usages/UsageGroup;", "getRank", "", "getIcon", "Ljavax/swing/Icon;", "getTitle", "", "MsDiagramTargetEndpointGroup", "intellij.microservices.diagrams"})
@SourceDebugExtension(value={"SMAP\nMsDiagramTargetEndpointGroupingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsDiagramTargetEndpointGroupingRule.kt\ncom/intellij/microservices/diagrams/usages/MsDiagramTargetEndpointGroupingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class MsDiagramTargetEndpointGroupingRule
extends SingleParentUsageGroupingRule
implements UsageGroupingRuleEx {
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        MsDiagramTargetEndpointGroup msDiagramTargetEndpointGroup;
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        Object object = usage instanceof MsDiagramRequestUsage ? (MsDiagramRequestUsage)usage : null;
        if (object != null && (object = object.getRequest()) != null && (object = ((MsDiagramRequest)object).getTarget()) != null) {
            MsDiagramRequestUsage it = object;
            boolean bl = false;
            msDiagramTargetEndpointGroup = new MsDiagramTargetEndpointGroup((MsDiagramEndpoint)((Object)it));
        } else {
            msDiagramTargetEndpointGroup = null;
        }
        return msDiagramTargetEndpointGroup;
    }

    public int getRank() {
        return UsageGroupingRulesDefaultRanks.AFTER_MODULE.getAbsoluteRank();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Ide.IncomingChangesOn;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IncomingChangesOn");
        return icon;
    }

    @NotNull
    public String getTitle() {
        return DiagramsUiBundle.message("microservices.diagrams.webservices.group.by.request.targets", new Object[0]);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\n\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/diagrams/usages/MsDiagramTargetEndpointGroupingRule$MsDiagramTargetEndpointGroup;", "Lcom/intellij/microservices/diagrams/usages/DummyUsageGroup;", "endpoint", "Lcom/intellij/microservices/diagrams/model/MsDiagramEndpoint;", "<init>", "(Lcom/intellij/microservices/diagrams/model/MsDiagramEndpoint;)V", "getEndpoint", "()Lcom/intellij/microservices/diagrams/model/MsDiagramEndpoint;", "compareTo", "", "other", "Lcom/intellij/usages/UsageGroup;", "getIcon", "Ljavax/swing/Icon;", "getPresentableGroupText", "", "Lcom/intellij/openapi/util/NlsSafe;", "component1", "copy", "equals", "", "", "hashCode", "toString", "intellij.microservices.diagrams"})
    private static final class MsDiagramTargetEndpointGroup
    extends DummyUsageGroup {
        @NotNull
        private final MsDiagramEndpoint endpoint;

        public MsDiagramTargetEndpointGroup(@NotNull MsDiagramEndpoint endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.endpoint = endpoint;
        }

        @NotNull
        public final MsDiagramEndpoint getEndpoint() {
            return this.endpoint;
        }

        public int compareTo(@Nullable UsageGroup other) {
            MsDiagramTargetEndpointGroup msDiagramTargetEndpointGroup = other instanceof MsDiagramTargetEndpointGroup ? (MsDiagramTargetEndpointGroup)other : null;
            if (msDiagramTargetEndpointGroup == null) {
                return 1;
            }
            MsDiagramTargetEndpointGroup that = msDiagramTargetEndpointGroup;
            return this.endpoint.getName().compareTo(that.endpoint.getName());
        }

        @Nullable
        public Icon getIcon() {
            Icon icon;
            MsDiagramEndpoint msDiagramEndpoint = this.endpoint;
            if (msDiagramEndpoint instanceof MsDiagramExternalEndpoint) {
                icon = AllIcons.Nodes.PpWeb;
            } else if (msDiagramEndpoint instanceof MsDiagramWebservice) {
                icon = AllIcons.Ide.IncomingChangesOn;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return icon;
        }

        @NotNull
        public String getPresentableGroupText() {
            return this.endpoint.getName();
        }

        @NotNull
        public final MsDiagramEndpoint component1() {
            return this.endpoint;
        }

        @NotNull
        public final MsDiagramTargetEndpointGroup copy(@NotNull MsDiagramEndpoint endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            return new MsDiagramTargetEndpointGroup(endpoint);
        }

        public static /* synthetic */ MsDiagramTargetEndpointGroup copy$default(MsDiagramTargetEndpointGroup msDiagramTargetEndpointGroup, MsDiagramEndpoint msDiagramEndpoint, int n, Object object) {
            if ((n & 1) != 0) {
                msDiagramEndpoint = msDiagramTargetEndpointGroup.endpoint;
            }
            return msDiagramTargetEndpointGroup.copy(msDiagramEndpoint);
        }

        @NotNull
        public String toString() {
            return "MsDiagramTargetEndpointGroup(endpoint=" + this.endpoint + ")";
        }

        public int hashCode() {
            return this.endpoint.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MsDiagramTargetEndpointGroup)) {
                return false;
            }
            MsDiagramTargetEndpointGroup msDiagramTargetEndpointGroup = (MsDiagramTargetEndpointGroup)other;
            return Intrinsics.areEqual((Object)this.endpoint, (Object)msDiagramTargetEndpointGroup.endpoint);
        }
    }
}

