/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.nodejs.jest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunConfigurationProducer;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.KotlinJSRunConfigurationDataProvider;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.TestElementInfo;
import org.jetbrains.kotlin.idea.ultimate.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.ultimate.nodejs.jest.JestConfigData;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/jest/KotlinJestRunConfigurationProducer;", "Lcom/intellij/javascript/jest/JestRunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/tooling/KotlinJSRunConfigurationDataProvider;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/jest/JestConfigData;", "<init>", "()V", "createTestElementRunInfo", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/TestElementInfo;", "Lcom/intellij/javascript/jest/JestRunSettings;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/jest/JestTestElementInfo;", "configData", "originalSettings", "isForTests", "", "()Z", "getConfigurationData", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromCompatibleContext", "configuration", "Lcom/intellij/javascript/jest/JestRunConfiguration;", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "kotlin-ultimate.javascript.nodeJs"})
@SourceDebugExtension(value={"SMAP\nKotlinJestRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJestRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/ultimate/nodejs/jest/KotlinJestRunConfigurationProducer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,125:1\n19985#2,2:126\n*S KotlinDebug\n*F\n+ 1 KotlinJestRunConfigurationProducer.kt\norg/jetbrains/kotlin/idea/ultimate/nodejs/jest/KotlinJestRunConfigurationProducer\n*L\n87#1:126,2\n*E\n"})
public final class KotlinJestRunConfigurationProducer
extends JestRunConfigurationProducer
implements KotlinJSRunConfigurationDataProvider<JestConfigData> {
    private final TestElementInfo<JestRunSettings> createTestElementRunInfo(JestConfigData configData, JestRunSettings originalSettings) {
        JestRunSettings jestRunSettings;
        Project project = configData.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (StringsKt.isBlank((CharSequence)originalSettings.getWorkingDirSystemDependentPath())) {
            String string = FileUtil.toSystemDependentName((String)project2.getBaseDir().getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            String workingDir = string;
            jestRunSettings = originalSettings.toBuilder().setWorkingDir(workingDir).build();
        } else {
            jestRunSettings = originalSettings;
        }
        JestRunSettings settings2 = jestRunSettings;
        JestRunSettings.Builder builder2 = settings2.toBuilder();
        builder2.setTestFilePath(configData.getJsOutputFilePath());
        TestElementPath testElementPath = configData.getTestElementPath();
        if (testElementPath instanceof TestElementPath.BySuite) {
            TestElementPath testElementPath2 = configData.getTestElementPath();
            List<String> suiteNames = ((TestElementPath.BySuite)testElementPath2).component1();
            String testName = ((TestElementPath.BySuite)testElementPath2).component2();
            if (testName == null) {
                builder2.setScopeKind(JestScopeKind.SUITE);
                v3 = builder2.setTestNames(suiteNames);
            } else {
                builder2.setScopeKind(JestScopeKind.TEST);
                v3 = builder2.setTestNames(CollectionsKt.plus((Collection)suiteNames, (Object)testName));
            }
        } else if (testElementPath instanceof TestElementPath.BySingleFile) {
            v3 = builder2.setScopeKind(JestScopeKind.TEST_FILE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        builder2.setEnvData(NodeJsUtilKt.getNodeJsEnvironmentVars(configData.getModule(), true));
        return new TestElementInfo<JestRunSettings>(builder2.build(), configData.getElement());
    }

    @Override
    public boolean isForTests() {
        return true;
    }

    @Override
    @Nullable
    public JestConfigData getConfigurationData(@NotNull ConfigurationContext context2) {
        boolean bl;
        Module module;
        PsiElement element;
        block7: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            PsiElement psiElement = context2.getPsiLocation();
            if (psiElement == null) {
                return null;
            }
            element = psiElement;
            Module module2 = context2.getModule();
            if (module2 == null || (module2 = JsUtilsKt.asJsModule(module2)) == null) {
                return null;
            }
            module = module2;
            if (KotlinFacetUtils.isNewMultiPlatformModule(module)) {
                return null;
            }
            VirtualFile[] $this$none$iv = ProjectRootsUtilKt.getSourceRoots(module);
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$none$iv[j];
                boolean bl2 = false;
                if (!this.isTestRunnerAvailableFor(element, context2)) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (bl) {
            return null;
        }
        String string = JsUtilsKt.getJsTestOutputFilePath(module);
        if (string == null) {
            return null;
        }
        String testFilePath = string;
        TestElementPath testElementPath = TestElementPath.Companion.forElement(element, module);
        if (testElementPath == null) {
            return null;
        }
        TestElementPath testElementPath2 = testElementPath;
        return new JestConfigData(element, module, testFilePath, testElementPath2);
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JestConfigData jestConfigData = this.getConfigurationData(context2);
        if (jestConfigData == null) {
            return false;
        }
        JestConfigData configData = jestConfigData;
        JestRunSettings jestRunSettings = configuration2.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        JestRunSettings thisRunSettings = this.createTestElementRunInfo(configData, jestRunSettings).component1();
        JestRunSettings jestRunSettings2 = configuration2.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings2, (String)"getRunSettings(...)");
        JestRunSettings thatRunSettings = jestRunSettings2;
        if (!Intrinsics.areEqual((Object)thisRunSettings.getConfigFileSystemDependentPath(), (Object)thatRunSettings.getConfigFileSystemDependentPath())) {
            return false;
        }
        if (thatRunSettings.getScopeKind() != thisRunSettings.getScopeKind()) {
            return false;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[thisRunSettings.getScopeKind().ordinal()]) {
            case 1 -> true;
            case 2 -> Intrinsics.areEqual((Object)thisRunSettings.getTestFileSystemDependentPath(), (Object)thatRunSettings.getTestFileSystemDependentPath());
            case 3, 4 -> {
                if (Intrinsics.areEqual((Object)thisRunSettings.getTestFileSystemDependentPath(), (Object)thatRunSettings.getTestFileSystemDependentPath()) && Intrinsics.areEqual((Object)thisRunSettings.getTestNames(), (Object)thatRunSettings.getTestNames())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        JestConfigData jestConfigData = this.getConfigurationData(context2);
        if (jestConfigData == null) {
            return false;
        }
        JestConfigData configData = jestConfigData;
        JestRunSettings jestRunSettings = configuration2.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        TestElementInfo<JestRunSettings> testElementInfo = this.createTestElementRunInfo(configData, jestRunSettings);
        JestRunSettings runSettings = testElementInfo.component1();
        PsiElement enclosingTestElement = testElementInfo.component2();
        configuration2.setRunSettings(runSettings);
        sourceElement.set((Object)enclosingTestElement);
        configuration2.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JestScopeKind.values().length];
            try {
                nArray[JestScopeKind.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JestScopeKind.TEST_FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JestScopeKind.SUITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JestScopeKind.TEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

