/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.DefaultConsoleFiltersProvider;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.kotlin.commonNative.debugger.KonanInstaller;
import com.jetbrains.kotlin.commonNative.debugger.KonanInstallerKt;
import com.jetbrains.kotlin.commonNative.debugger.KonanLocalDebugProcess;
import com.jetbrains.mpp.KonanCommandLineState;
import com.jetbrains.mpp.KonanRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/mpp/KonanLauncher;", "Lcom/jetbrains/cidr/execution/CidrLauncher;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createProcess", "Lcom/intellij/execution/process/ProcessHandler;", "state", "Lcom/intellij/execution/configurations/CommandLineState;", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getProject", "usePty", "", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configuration", "Lcom/jetbrains/mpp/KonanRunConfiguration;", "kotlin-ultimate.ultimate-native"})
public final class KonanLauncher
extends CidrLauncher {
    @NotNull
    private final Project project;

    public KonanLauncher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected ProcessHandler createProcess(@NotNull CommandLineState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        KonanCommandLineState konanCommandLineState = state instanceof KonanCommandLineState ? (KonanCommandLineState)state : null;
        if (konanCommandLineState == null) {
            throw new IllegalStateException(Reflection.getOrCreateKotlinClass(KonanLauncher.class) + " is supposed to launch only " + Reflection.getOrCreateKotlinClass(KonanCommandLineState.class));
        }
        KonanCommandLineState konanState = konanCommandLineState;
        boolean usePty = this.usePty();
        GeneralCommandLine cl = this.createCommandLine(usePty, konanState.getConfiguration());
        return (ProcessHandler)LocalHost.INSTANCE.createProcessBuilder().withColoredOutput(true).withPty(usePty).build(cl);
    }

    @NotNull
    protected XDebugProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        KonanCommandLineState konanCommandLineState = state instanceof KonanCommandLineState ? (KonanCommandLineState)state : null;
        if (konanCommandLineState == null) {
            throw new IllegalStateException(Reflection.getOrCreateKotlinClass(KonanLauncher.class) + " is supposed to launch only " + Reflection.getOrCreateKotlinClass(KonanCommandLineState.class));
        }
        KonanCommandLineState konanState = konanCommandLineState;
        Object object = CidrCoroutineHelper.runOnEDT(() -> KonanLauncher.createDebugProcess$lambda$0(konanState, session2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runOnEDT(...)");
        return (XDebugProcess)object;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    private final boolean usePty() {
        Application application = ApplicationManager.getApplication();
        return PtyCommandLine.isEnabled() || application.isInternal() || application.isUnitTestMode();
    }

    private final GeneralCommandLine createCommandLine(boolean usePty, KonanRunConfiguration configuration2) throws ExecutionException {
        Object object = ApplicationManager.getApplication().runReadAction(() -> KonanLauncher.createCommandLine$lambda$0(usePty, configuration2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        return (GeneralCommandLine)object;
    }

    private static final KonanLocalDebugProcess createDebugProcess$lambda$0(KonanCommandLineState $konanState, XDebugSession $session) {
        RunParameters runParameters = (RunParameters)KonanInstallerKt.createRunParameters($konanState.getConfiguration());
        TextConsoleBuilder textConsoleBuilder = $konanState.getConsoleBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"getConsoleBuilder(...)");
        return new KonanLocalDebugProcess(runParameters, $session, textConsoleBuilder, (ConsoleFilterProvider)new DefaultConsoleFiltersProvider());
    }

    private static final GeneralCommandLine createCommandLine$lambda$0(boolean $usePty, KonanRunConfiguration $configuration) {
        GeneralCommandLine cl = $usePty ? (GeneralCommandLine)new PtyCommandLine() : new GeneralCommandLine();
        new KonanInstaller($configuration).configureCommandLine(cl);
        return cl;
    }
}

