/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSHighlightVisitorBase;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "<init>", "()V", "myCachedVisitor", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "myOwnerForCachedVisitor", "Lcom/intellij/psi/PsiElement;", "myHolder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "createElementVisitor", "owner", "holder", "suitableForFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "analyze", "updateWholeFile", "action", "Ljava/lang/Runnable;", "Companion", "intellij.javascript.analysis.impl"})
public abstract class JSHighlightVisitorBase
implements HighlightVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JSElementVisitor myCachedVisitor;
    @Nullable
    private PsiElement myOwnerForCachedVisitor;
    @Nullable
    private HighlightInfoHolder myHolder;
    @NotNull
    private static final Class<? extends PsiElement>[] OWNER_CLASSES;

    @NotNull
    public abstract JSElementVisitor createElementVisitor(@NotNull PsiElement var1, @NotNull HighlightInfoHolder var2);

    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof JSFile || JavaScriptIndex.getFileTypesToIndexJS().contains(psiFile.getFileType());
    }

    public void visit(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Class<? extends PsiElement>[] classArray = OWNER_CLASSES;
        PsiElement owner = PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])Arrays.copyOf(classArray, classArray.length));
        JSElementVisitor visitor = this.myCachedVisitor;
        HighlightInfoHolder holder = this.myHolder;
        if (owner != this.myOwnerForCachedVisitor && owner != null && holder != null) {
            this.myCachedVisitor = visitor = this.createElementVisitor(owner, holder);
            this.myOwnerForCachedVisitor = owner;
        }
        if (visitor != null) {
            element2.accept((PsiElementVisitor)visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.myHolder = holder;
        this.myOwnerForCachedVisitor = null;
        this.myCachedVisitor = null;
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
            this.myOwnerForCachedVisitor = null;
            this.myCachedVisitor = null;
        }
        return true;
    }

    static {
        Class[] classArray = new Class[]{JSFile.class, JSEmbeddedContent.class};
        OWNER_CLASSES = classArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/highlighting/JSHighlightVisitorBase$Companion;", "", "<init>", "()V", "OWNER_CLASSES", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "[Ljava/lang/Class;", "intellij.javascript.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

