/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.cli.model.DockerCliOption;
import com.intellij.docker.agent.cli.model.DockerRunCliValidator;
import com.intellij.docker.agent.cli.model.NormalizedCommandLine;
import com.intellij.docker.deployment.ui.completion.DockerCliCompletionProvider;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerCliOptionsField
extends TextFieldWithCompletion {
    private final NormalizedCommandLine.CliValidator myValidator;

    protected DockerCliOptionsField(Project project, @NotNull NormalizedCommandLine.CliValidator validator, Map<String, DockerCliOption> model) {
        if (validator == null) {
            DockerCliOptionsField.$$$reportNull$$$0(0);
        }
        super(project, (TextCompletionProvider)new DockerCliCompletionProvider(validator, model), "", true, true, false, true);
        this.myValidator = validator;
        new ExpandableEditorSupport((EditorTextField)this, string -> {
            List list = (List)ParametersListUtil.DEFAULT_LINE_PARSER.apply(string);
            try {
                list = new DockerRunCliValidator().tryValidateCliOptions((String[])list.toArray(String[]::new)).groupByOptions();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return list;
        }, ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    @NotNull
    protected NormalizedCommandLine.CliValidator getValidator() {
        NormalizedCommandLine.CliValidator cliValidator = this.myValidator;
        if (cliValidator == null) {
            DockerCliOptionsField.$$$reportNull$$$0(1);
        }
        return cliValidator;
    }

    public abstract void resetEditorFrom(@NotNull DockerDeploymentConfiguration var1);

    public abstract void clearValue(@NotNull DockerDeploymentConfiguration var1);

    public void applyValueTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerCliOptionsField.$$$reportNull$$$0(2);
        }
        this.storeRawText(configuration);
        try {
            this.getParsedOptions();
        }
        catch (ParseException e) {
            this.handleParseException(e);
        }
        catch (CliParserBase.IllegalOptionException e) {
            throw new RuntimeConfigurationWarning(e.getMessage());
        }
    }

    protected abstract void storeRawText(@NotNull DockerDeploymentConfiguration var1);

    protected void handleParseException(ParseException e) throws ConfigurationException {
        throw new RuntimeConfigurationWarning(DockerBundle.message((String)"DockerCliOptionsField.onParseError", (Object[])new Object[]{e.getMessage()}));
    }

    @Nullable
    public ValidationInfo createValidationInfo() {
        try {
            this.getParsedOptions();
            return null;
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            return new ValidationInfo(e.getLocalizedMessage(), (JComponent)((Object)this));
        }
        catch (RuntimeException e) {
            Logger.getInstance(DockerCliOptionsField.class).error("unexpected error for options: `" + this.getText() + "`");
            return new ValidationInfo(e.getLocalizedMessage(), (JComponent)((Object)this));
        }
    }

    @Nullable
    public NormalizedCommandLine getParsedOptions() throws ParseException, CliParserBase.IllegalOptionException {
        String optionsLine = this.getText();
        if (StringUtil.isEmptyOrSpaces((String)optionsLine)) {
            return null;
        }
        return this.myValidator.tryValidateCliOptions(optionsLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerCliOptionsField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerCliOptionsField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyValueTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

