#pragma once

#include "biboumi.h"

#ifdef BOTAN_FOUND

#include <botan/tls_policy.h>

class BiboumiTLSPolicy: public Botan::TLS::Text_Policy
{
public:
  BiboumiTLSPolicy():
      Botan::TLS::Text_Policy({})
  {}
  bool load(const std::string& filename);
  void load(std::istream& iss);

  BiboumiTLSPolicy(const BiboumiTLSPolicy &) = delete;
  BiboumiTLSPolicy(BiboumiTLSPolicy &&) = delete;
  BiboumiTLSPolicy &operator=(const BiboumiTLSPolicy &) = delete;
  BiboumiTLSPolicy &operator=(BiboumiTLSPolicy &&) = delete;

  bool require_cert_revocation_info() const override;
  bool verify_certificate{true};
protected:
  bool req_cert_revocation_info{true};
private:
  // Copied from botan-3's src/lib/utils/read_cfg.cpp
  // These were made internal in v3, but they are in use by biboumi so they have
  // to be vendored in
  static std::map<std::string, std::string> read_cfg(std::istream& is);
  static std::string clean_ws(std::string_view s);
};

#endif
