/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PythonSdkConfigurationKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import java.awt.event.ActionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0018\u00010\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/configuration/PythonLocalInterpreterConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;)V", "initialSdkHomePath", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/Nullable;", "interpreterPath", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "isSdkAssociatedWithOtherPathInitiallyAndReset", "", "wasSdkAssociatedWithPathInitially", "isSdkAssociatedWithPath", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPythonLocalInterpreterConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonLocalInterpreterConfigurable.kt\ncom/jetbrains/python/configuration/PythonLocalInterpreterConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class PythonLocalInterpreterConfigurable
extends BoundConfigurable {
    @NotNull
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final Sdk sdk;
    @Nullable
    private final String initialSdkHomePath;
    @NotNull
    private final AtomicProperty<String> interpreterPath;
    private boolean isSdkAssociatedWithOtherPathInitiallyAndReset;
    private final boolean wasSdkAssociatedWithPathInitially;
    private boolean isSdkAssociatedWithPath;

    public PythonLocalInterpreterConfigurable(@NotNull Project project, @Nullable Module module2, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        String string = sdk2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(string, null, 2, null);
        this.project = project;
        this.module = module2;
        this.sdk = sdk2;
        this.initialSdkHomePath = this.sdk.getHomePath();
        String string2 = this.sdk.getHomePath();
        if (string2 == null) {
            string2 = "";
        }
        this.interpreterPath = new AtomicProperty((Object)string2);
        String string3 = PySdkExtKt.getAssociatedModulePath(this.sdk);
        this.isSdkAssociatedWithPath = this.wasSdkAssociatedWithPathInitially = string3 != null ? !StringsKt.isBlank((CharSequence)string3) : false;
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> PythonLocalInterpreterConfigurable.createPanel$lambda$8(this, arg_0));
    }

    public void apply() {
        super.apply();
        SdkModificator sdkModificator = this.sdk.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"getSdkModificator(...)");
        SdkModificator sdkModificator2 = sdkModificator;
        if (!Intrinsics.areEqual((Object)this.interpreterPath.get(), (Object)this.initialSdkHomePath)) {
            sdkModificator2.setHomePath((String)this.interpreterPath.get());
        }
        if (this.isSdkAssociatedWithOtherPathInitiallyAndReset || this.wasSdkAssociatedWithPathInitially != this.isSdkAssociatedWithPath) {
            if (this.isSdkAssociatedWithPath) {
                if (this.module != null) {
                    PythonSdkConfigurationKt.associateWithModule(sdkModificator2, this.module);
                } else {
                    PythonSdkConfigurationKt.associateWithProject(sdkModificator2, this.project);
                }
            } else {
                PythonSdkConfigurationKt.resetAssociatedModulePath(sdkModificator2);
            }
        }
        WriteAction.run(() -> PythonLocalInterpreterConfigurable.apply$lambda$9(sdkModificator2));
        if (!Intrinsics.areEqual((Object)this.initialSdkHomePath, (Object)this.sdk.getHomePath())) {
            PythonSdkUpdater.updateVersionAndPathsSynchronouslyAndScheduleRemaining(this.sdk, this.project);
        }
    }

    private static final String createPanel$lambda$8$lambda$1$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final Unit createPanel$lambda$8$lambda$1(PythonLocalInterpreterConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = PythonSdkType.getInstance().getHomeChooserDescriptor().withTitle(PyBundle.message("sdk.edit.dialog.specify.interpreter.path", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        TextFieldWithBrowseButtonKt.bindText((Cell)$this$row.textFieldWithBrowseButton(fileChooserDescriptor, this$0.project, PythonLocalInterpreterConfigurable::createPanel$lambda$8$lambda$1$lambda$0), (ObservableMutableProperty)((ObservableMutableProperty)this$0.interpreterPath)).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$8$lambda$4$lambda$3(PythonLocalInterpreterConfigurable this$0) {
        return this$0.isSdkAssociatedWithOtherPathInitiallyAndReset;
    }

    private static final Unit createPanel$lambda$8$lambda$4(Ref.ObjectRef $associateSdkWithProjectCheckBox, String $sdkAssociatedModulePath, PythonLocalInterpreterConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{FileUtil.toSystemDependentName((String)$sdkAssociatedModulePath)};
        String string = PyBundle.message("sdk.edit.dialog.associate.virtual.env.with.path", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $associateSdkWithProjectCheckBox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return PythonLocalInterpreterConfigurable.access$isSdkAssociatedWithPath$p((PythonLocalInterpreterConfigurable)((Object)this.receiver));
            }

            public void set(Object value) {
                PythonLocalInterpreterConfigurable.access$setSdkAssociatedWithPath$p((PythonLocalInterpreterConfigurable)((Object)this.receiver), (Boolean)value);
            }
        })).onIsModified(() -> PythonLocalInterpreterConfigurable.createPanel$lambda$8$lambda$4$lambda$3(this$0)).enabled(false);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$8$lambda$6$lambda$5(PythonLocalInterpreterConfigurable this$0, Row $this_row, Ref.ObjectRef $associateSdkWithProjectCheckBox, ActionEvent it) {
        Cell cell;
        Cell cell2;
        Cell cell3;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.isSdkAssociatedWithPath = false;
        this$0.isSdkAssociatedWithOtherPathInitiallyAndReset = true;
        $this_row.visible(false);
        if ($associateSdkWithProjectCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"associateSdkWithProjectCheckBox");
            cell3 = null;
        } else {
            cell3 = (Cell)$associateSdkWithProjectCheckBox.element;
        }
        ((JBCheckBox)cell3.getComponent()).setText(PyBundle.message("form.edit.sdk.associate.this.virtual.environment.with.current.project", new Object[0]));
        if ($associateSdkWithProjectCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"associateSdkWithProjectCheckBox");
            cell2 = null;
        } else {
            cell2 = (Cell)$associateSdkWithProjectCheckBox.element;
        }
        ((JBCheckBox)cell2.getComponent()).setSelected(false);
        if ($associateSdkWithProjectCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"associateSdkWithProjectCheckBox");
            cell = null;
        } else {
            cell = (Cell)$associateSdkWithProjectCheckBox.element;
        }
        cell.enabled(true);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$8$lambda$6(PythonLocalInterpreterConfigurable this$0, Ref.ObjectRef $associateSdkWithProjectCheckBox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message("python.interpreter.local.configurable.remove.association", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, arg_0 -> PythonLocalInterpreterConfigurable.createPanel$lambda$8$lambda$6$lambda$5(this$0, $this$row, $associateSdkWithProjectCheckBox, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$8$lambda$7(PythonLocalInterpreterConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PyBundle.message("form.edit.sdk.associate.this.virtual.environment.with.current.project", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return PythonLocalInterpreterConfigurable.access$isSdkAssociatedWithPath$p((PythonLocalInterpreterConfigurable)((Object)this.receiver));
            }

            public void set(Object value) {
                PythonLocalInterpreterConfigurable.access$setSdkAssociatedWithPath$p((PythonLocalInterpreterConfigurable)((Object)this.receiver), (Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$8(PythonLocalInterpreterConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = PyBundle.message("form.edit.sdk.interpreter.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> PythonLocalInterpreterConfigurable.createPanel$lambda$8$lambda$1(this$0, arg_0));
        PythonSdkFlavor<?> sdkFlavor = PythonSdkFlavor.getPlatformIndependentFlavor(this$0.sdk.getHomePath());
        if (sdkFlavor instanceof VirtualEnvSdkFlavor || sdkFlavor instanceof CondaEnvSdkFlavor) {
            String projectBasePath;
            String sdkAssociatedModulePath = PySdkExtKt.getAssociatedModulePath(this$0.sdk);
            String string2 = this$0.project.getBasePath();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                v2 = FileUtil.toSystemIndependentName((String)it);
            } else {
                v2 = projectBasePath = null;
            }
            if (sdkAssociatedModulePath != null && !Intrinsics.areEqual((Object)sdkAssociatedModulePath, (Object)projectBasePath)) {
                Ref.ObjectRef associateSdkWithProjectCheckBox = new Ref.ObjectRef();
                Panel.row$default((Panel)$this$panel, null, arg_0 -> PythonLocalInterpreterConfigurable.createPanel$lambda$8$lambda$4(associateSdkWithProjectCheckBox, sdkAssociatedModulePath, this$0, arg_0), (int)1, null);
                v3 = Panel.row$default((Panel)$this$panel, null, arg_0 -> PythonLocalInterpreterConfigurable.createPanel$lambda$8$lambda$6(this$0, associateSdkWithProjectCheckBox, arg_0), (int)1, null);
            } else {
                v3 = Panel.row$default((Panel)$this$panel, null, arg_0 -> PythonLocalInterpreterConfigurable.createPanel$lambda$8$lambda$7(this$0, arg_0), (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$9(SdkModificator $sdkModificator) {
        $sdkModificator.commitChanges();
    }

    public static final /* synthetic */ boolean access$isSdkAssociatedWithPath$p(PythonLocalInterpreterConfigurable $this) {
        return $this.isSdkAssociatedWithPath;
    }

    public static final /* synthetic */ void access$setSdkAssociatedWithPath$p(PythonLocalInterpreterConfigurable $this, boolean bl) {
        $this.isSdkAssociatedWithPath = bl;
    }
}

