/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.services.systemPython.impl.providers;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.python.community.services.systemPython.SystemPythonProvider;
import com.intellij.python.community.services.systemPython.impl.providers.UtilsKt;
import com.intellij.python.community.services.systemPython.impl.providers.WindowsSystemPythonProvider;
import com.jetbrains.python.Result;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.WinAppxToolsKt;
import com.jetbrains.python.sdk.WinRegistryService;
import com.jetbrains.python.venvReader.ResolveUtilKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u001a\u001a,\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u001c\u0012\u0004\u0012\u00020\u001f0\u001bj\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u001c` 2\u0006\u0010!\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/python/community/services/systemPython/impl/providers/WindowsSystemPythonProvider;", "Lcom/intellij/python/community/services/systemPython/SystemPythonProvider;", "winRegistryBase", "Lcom/jetbrains/python/sdk/WinRegistryService;", "<init>", "(Lcom/jetbrains/python/sdk/WinRegistryService;)V", "getWinRegistryBase", "()Lcom/jetbrains/python/sdk/WinRegistryService;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "names", "", "", "REG_ROOTS", "", "[Ljava/lang/String;", "REGISTRY_MAP", "", "winRegistry", "Lkotlin/Lazy;", "getWinRegistry", "()Lkotlin/Lazy;", "APPX_PRODUCT", "pythonVersionedExePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "findSystemPythons", "Lcom/jetbrains/python/Result;", "", "Ljava/nio/file/Path;", "Lcom/jetbrains/python/PythonBinary;", "Lcom/jetbrains/python/errorProcessing/PyError;", "Lcom/jetbrains/python/errorProcessing/PyResult;", "eelApi", "Lcom/intellij/platform/eel/EelApi;", "(Lcom/intellij/platform/eel/EelApi;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPythonsFromRegistry", "getPythonsFromStore", "intellij.python.community.services.systemPython"})
@SourceDebugExtension(value={"SMAP\nWindowsSystemPythonProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSystemPythonProvider.kt\ncom/intellij/python/community/services/systemPython/impl/providers/WindowsSystemPythonProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1#2:121\n1563#3:122\n1634#3,3:123\n*S KotlinDebug\n*F\n+ 1 WindowsSystemPythonProvider.kt\ncom/intellij/python/community/services/systemPython/impl/providers/WindowsSystemPythonProvider\n*L\n111#1:122\n111#1:123,3\n*E\n"})
public final class WindowsSystemPythonProvider
implements SystemPythonProvider {
    @Nullable
    private final WinRegistryService winRegistryBase;
    @NotNull
    private final Logger LOGGER;
    @NotNull
    private final List<String> names;
    @NotNull
    private final String[] REG_ROOTS;
    @NotNull
    private final Map<String, String> REGISTRY_MAP;
    @NotNull
    private final Lazy<WinRegistryService> winRegistry;
    @NotNull
    private final String APPX_PRODUCT;
    private final Pattern pythonVersionedExePattern;

    public WindowsSystemPythonProvider(@Nullable WinRegistryService winRegistryBase) {
        this.winRegistryBase = winRegistryBase;
        Logger logger = Logger.getInstance(WindowsSystemPythonProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOGGER = logger;
        Object[] objectArray = new String[]{"pypy.exe", "python.exe"};
        this.names = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER"};
        this.REG_ROOTS = objectArray;
        objectArray = new Pair[]{TuplesKt.to((Object)"Python", (Object)"python.exe"), TuplesKt.to((Object)"IronPython", (Object)"ipy.exe")};
        this.REGISTRY_MAP = MapsKt.mapOf((Pair[])objectArray);
        this.winRegistry = LazyKt.lazy(() -> WindowsSystemPythonProvider.winRegistry$lambda$0(this));
        this.APPX_PRODUCT = "Python";
        this.pythonVersionedExePattern = Pattern.compile("python[0-9.]*?\\.exe$");
    }

    public /* synthetic */ WindowsSystemPythonProvider(WinRegistryService winRegistryService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            winRegistryService = null;
        }
        this(winRegistryService);
    }

    @Nullable
    public final WinRegistryService getWinRegistryBase() {
        return this.winRegistryBase;
    }

    @NotNull
    public final Lazy<WinRegistryService> getWinRegistry() {
        return this.winRegistry;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object findSystemPythons(@NotNull EelApi eelApi, @NotNull Continuation<? super Result<? extends Set<? extends Path>, ? extends PyError>> $completion) {
        if (!($completion instanceof findSystemPythons.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ WindowsSystemPythonProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findSystemPythons(null, (Continuation<? super Result<? extends Set<? extends Path>, ? extends PyError>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!Intrinsics.areEqual((Object)eelApi, (Object)EelProviderUtil.getLocalEel()) || !EelPlatformKt.isWindows((EelPlatform)eelApi.getPlatform()) || UtilsKt.useLegacyPythonProvider()) {
                    return Result.Companion.success(SetsKt.emptySet());
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends Path>>, Object>(this, null){
                    int label;
                    final /* synthetic */ WindowsSystemPythonProvider this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    Set candidates = new LinkedHashSet<E>();
                                    for (String name2 : WindowsSystemPythonProvider.access$getNames$p(this.this$0)) {
                                        void $this$filterTo$iv$iv;
                                        void $this$filter$iv;
                                        void $this$mapNotNullTo$iv$iv;
                                        Iterable $this$mapNotNull$iv;
                                        List list = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)name2);
                                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllExeFilesInPath(...)");
                                        Iterable iterable = list;
                                        boolean $i$f$mapNotNull = false;
                                        void var8_9 = $this$mapNotNull$iv;
                                        Collection destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$mapNotNullTo = false;
                                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                        boolean $i$f$forEach = false;
                                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                                        while (iterator.hasNext()) {
                                            Path it$iv$iv;
                                            T element$iv$iv$iv;
                                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                                            boolean bl = false;
                                            File it = (File)element$iv$iv;
                                            boolean bl2 = false;
                                            if (it.toPath() == null) continue;
                                            boolean bl3 = false;
                                            destination$iv$iv.add(it$iv$iv);
                                        }
                                        $this$mapNotNull$iv = (List)destination$iv$iv;
                                        boolean $i$f$filter = false;
                                        $this$mapNotNullTo$iv$iv = $this$filter$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$filterTo = false;
                                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                                            Path it = (Path)element$iv$iv;
                                            boolean bl = false;
                                            if (!(!PythonSdkUtil.isConda(((Object)it).toString()))) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        Set binaries = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                        candidates.addAll(binaries);
                                    }
                                    candidates.addAll(WindowsSystemPythonProvider.access$getPythonsFromStore(this.this$0));
                                    candidates.addAll(WindowsSystemPythonProvider.access$getPythonsFromRegistry(this.this$0));
                                    return candidates;
                                }
                                catch (RuntimeException e) {
                                    WindowsSystemPythonProvider.access$getLOGGER$p(this.this$0).error("Failed to discover Windows system pythons", (Throwable)e);
                                    return SetsKt.emptySet();
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Set<? extends Path>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                eelApi = (EelApi)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                pythons = (Set)v0;
                return Result.Companion.success(pythons);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Set<Path> getPythonsFromRegistry() {
        Set candidates = new LinkedHashSet();
        for (String regRoot : this.REG_ROOTS) {
            for (Map.Entry<String, String> entry : this.REGISTRY_MAP.entrySet()) {
                String productId = entry.getKey();
                String exe = entry.getValue();
                String companiesPath = regRoot + "\\SOFTWARE\\" + productId;
                String companiesPathWow = regRoot + "\\SOFTWARE\\Wow6432Node\\" + productId;
                String[] stringArray = new String[]{companiesPath, companiesPathWow};
                for (String path2 : stringArray) {
                    for (String company : ((WinRegistryService)this.winRegistry.getValue()).listBranches(path2)) {
                        String pathToCompany = path2 + "\\" + company;
                        for (String version2 : ((WinRegistryService)this.winRegistry.getValue()).listBranches(pathToCompany)) {
                            Path path3;
                            Path path4;
                            String folder = ((WinRegistryService)this.winRegistry.getValue()).getDefaultKey(pathToCompany + "\\" + version2 + "\\InstallPath");
                            Path path5 = ResolveUtilKt.tryResolvePath(folder);
                            if (path5 == null || (path4 = path5.resolve(exe)) == null) continue;
                            Path p0 = path3 = path4;
                            boolean $i$f$getPythonsFromRegistry$exists = false;
                            boolean bl = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            Path path6 = Files.exists(p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path3 : null;
                            if (path6 == null) continue;
                            Path it = path6;
                            boolean bl2 = false;
                            candidates.add(it);
                        }
                    }
                }
            }
        }
        return candidates;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Path> getPythonsFromStore() {
        Object object;
        try {
            void $this$mapTo$iv$iv;
            Pattern pattern = this.pythonVersionedExePattern;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"pythonVersionedExePattern");
            object = pattern;
            Iterable $this$map$iv = WinAppxToolsKt.getAppxFiles(this.APPX_PRODUCT, new Regex((Pattern)object));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toAbsolutePath());
            }
            object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        catch (Exception e) {
            this.LOGGER.debug("Error getting Python from Windows Store", (Throwable)e);
            object = SetsKt.emptySet();
        }
        return object;
    }

    private static final WinRegistryService winRegistry$lambda$0(WindowsSystemPythonProvider this$0) {
        WinRegistryService winRegistryService = this$0.winRegistryBase;
        if (winRegistryService == null) {
            winRegistryService = (WinRegistryService)ApplicationManager.getApplication().getService(WinRegistryService.class);
        }
        return winRegistryService;
    }

    public WindowsSystemPythonProvider() {
        this(null, 1, null);
    }

    public static final /* synthetic */ List access$getNames$p(WindowsSystemPythonProvider $this) {
        return $this.names;
    }

    public static final /* synthetic */ Set access$getPythonsFromStore(WindowsSystemPythonProvider $this) {
        return $this.getPythonsFromStore();
    }

    public static final /* synthetic */ Set access$getPythonsFromRegistry(WindowsSystemPythonProvider $this) {
        return $this.getPythonsFromRegistry();
    }

    public static final /* synthetic */ Logger access$getLOGGER$p(WindowsSystemPythonProvider $this) {
        return $this.LOGGER;
    }
}

