/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.refactoring;

import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PuppetRenameInputValidator
implements RenameInputValidator {
    private static final Pattern KEYWORDS = Pattern.compile("and|case|class|default|define|else|elsif|if|in|import|inherits|node|or|undef|unless");
    private static final Pattern VALID_NAME = Pattern.compile("(::)?[a-z][\\-a-zA-Z0-9_]*(::[a-z][\\-a-zA-Z0-9_]*)*");
    private static final Pattern VALID_REF_NAME = Pattern.compile("(::)?[A-Z][\\-a-zA-Z0-9_]*(::[A-Z][\\-a-zA-Z0-9_]*)*");
    private static final Pattern VALID_VAR_NAME = Pattern.compile("(::)?[a-zA-Z0-9_]+(::[a-zA-Z0-9_]+)*");

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ObjectPattern objectPattern = PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("puppet.named.element"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element.getLanguage() == PuppetLanguage.INSTANCE && element instanceof PsiNameIdentifierOwner;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/puppet/ide/refactoring/PuppetRenameInputValidator$1", "accepts"));
            }
        });
        if (objectPattern == null) {
            PuppetRenameInputValidator.$$$reportNull$$$0(0);
        }
        return objectPattern;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            PuppetRenameInputValidator.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PuppetRenameInputValidator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PuppetRenameInputValidator.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)newName)) {
            return false;
        }
        if (element instanceof PuppetVariable) {
            return !StringUtil.isCapitalized((String)newName) && !PuppetRenameInputValidator.isKeyword(newName) && VALID_VAR_NAME.matcher(newName).matches();
        }
        return true;
    }

    private static boolean isKeyword(@NotNull String name) {
        if (name == null) {
            PuppetRenameInputValidator.$$$reportNull$$$0(4);
        }
        return KEYWORDS.matcher(name).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/refactoring/PuppetRenameInputValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/refactoring/PuppetRenameInputValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

