/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe;

import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ConcatKt;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.SchemaKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.ValueColumn;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ColumnGroupImpl;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.FrameColumnImpl;
import org.jetbrains.kotlinx.dataframe.impl.columns.ValueColumnImpl;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u001a*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001aJ\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H&J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00a6\u0002J\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\b\u001a\u00020\tH\u00a6\u0002J%\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0096\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "T", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "distinct", "get", "indices", "", "", "range", "Lkotlin/ranges/IntRange;", "getValue", "thisRef", "", "property", "Lkotlin/reflect/KProperty;", "hasNulls", "", "iterator", "", "rename", "newName", "", "resolveSingle", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "Companion", "core"})
public interface DataColumn<T>
extends BaseColumn<T> {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.DataColumn$Companion.$$INSTANCE;

    public boolean hasNulls();

    @Override
    @NotNull
    public DataColumn<T> distinct();

    @Override
    @NotNull
    public DataColumn<T> get(@NotNull Iterable<Integer> var1);

    @Override
    @NotNull
    public DataColumn<T> rename(@NotNull String var1);

    @Override
    @Nullable
    public ColumnWithPath<T> resolveSingle(@NotNull ColumnResolutionContext var1);

    @Override
    @NotNull
    public DataColumn<T> getValue(@Nullable Object var1, @NotNull KProperty<?> var2);

    @NotNull
    public Iterator<T> iterator();

    @Override
    @NotNull
    public DataColumn<T> get(@NotNull IntRange var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ7\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0006\b\u0001\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u0086\bJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000f\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0011J@\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0013\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00110\t2\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0013\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019JK\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u001c\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\u001eJ7\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u001c\"\u0006\b\u0001\u0010\u0005\u0018\u00012\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u0086\bJ9\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\n\u0012\u0002\b\u00030\u0004j\u0002`$2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/dataframe/DataColumn$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "T", "name", "", "values", "", "type", "Lkotlin/reflect/KType;", "infer", "Lorg/jetbrains/kotlinx/dataframe/api/Infer;", "createColumnGroup", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;", "df", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "createFrameColumn", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "groups", "schema", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "startIndices", "", "", "createValueColumn", "Lorg/jetbrains/kotlinx/dataframe/columns/ValueColumn;", "defaultValue", "(Ljava/lang/String;Ljava/util/List;Lkotlin/reflect/KType;Lorg/jetbrains/kotlinx/dataframe/api/Infer;Ljava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/columns/ValueColumn;", "createWithTypeInference", "nullable", "", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "empty", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final <T> ValueColumn<T> createValueColumn(@NotNull String name, @NotNull List<? extends T> values2, @NotNull KType type, @NotNull Infer infer, @Nullable T defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)infer), (String)"infer");
            return new ValueColumnImpl(values2, name, TypeUtilsKt.getValuesType(values2, type, infer), defaultValue, null, 16, null);
        }

        public static /* synthetic */ ValueColumn createValueColumn$default(Companion companion, String string, List list, KType kType, Infer infer, Object object, int n, Object object2) {
            if ((n & 8) != 0) {
                infer = Infer.None;
            }
            if ((n & 0x10) != 0) {
                object = null;
            }
            return companion.createValueColumn(string, list, kType, infer, object);
        }

        public final /* synthetic */ <T> ValueColumn<T> createValueColumn(String name, List<? extends T> values2, Infer infer) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)((Object)infer), (String)"infer");
            boolean $i$f$createValueColumn = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            return org.jetbrains.kotlinx.dataframe.DataColumn$Companion.createValueColumn$default(this, name, values2, TypeUtilsKt.getValuesType(values2, null, infer), null, null, 24, null);
        }

        public static /* synthetic */ ValueColumn createValueColumn$default(Companion $this, String name, List values2, Infer infer, int n, Object object) {
            if ((n & 4) != 0) {
                infer = Infer.None;
            }
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)((Object)infer), (String)"infer");
            boolean $i$f$createValueColumn = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            return org.jetbrains.kotlinx.dataframe.DataColumn$Companion.createValueColumn$default($this, name, values2, TypeUtilsKt.getValuesType(values2, null, infer), null, null, 24, null);
        }

        @NotNull
        public final <T> ColumnGroup<T> createColumnGroup(@NotNull String name, @NotNull DataFrame<? extends T> df2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(df2, (String)"df");
            return new ColumnGroupImpl<T>(name, df2);
        }

        @NotNull
        public final <T> FrameColumn<T> createFrameColumn(@NotNull String name, @NotNull DataFrame<? extends T> df2, @NotNull Iterable<Integer> startIndices2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(df2, (String)"df");
            Intrinsics.checkNotNullParameter(startIndices2, (String)"startIndices");
            return new FrameColumnImpl(name, SequencesKt.toList(UtilsKt.splitByIndices(df2, (Sequence<Integer>)CollectionsKt.asSequence(startIndices2))), LazyKt.lazy((Function0)((Function0)new Function0<DataFrameSchema>(df2){
                final /* synthetic */ DataFrame<T> $df;
                {
                    this.$df = $df;
                    super(0);
                }

                @NotNull
                public final DataFrameSchema invoke() {
                    return SchemaKt.schema(this.$df);
                }
            })), null, 8, null);
        }

        @NotNull
        public final <T> FrameColumn<T> createFrameColumn(@NotNull String name, @NotNull List<? extends DataFrame<? extends T>> groups2, @Nullable Lazy<? extends DataFrameSchema> schema2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(groups2, (String)"groups");
            return new FrameColumnImpl(name, groups2, schema2, null, 8, null);
        }

        public static /* synthetic */ FrameColumn createFrameColumn$default(Companion companion, String string, List list, Lazy lazy, int n, Object object) {
            if ((n & 4) != 0) {
                lazy = null;
            }
            return companion.createFrameColumn(string, list, (Lazy<? extends DataFrameSchema>)lazy);
        }

        @NotNull
        public final <T> DataColumn<T> createWithTypeInference(@NotNull String name, @NotNull List<? extends T> values2, @Nullable Boolean nullable) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            return ConstructorsKt.guessColumnType$default(name, values2, null, false, null, nullable, 28, null);
        }

        public static /* synthetic */ DataColumn createWithTypeInference$default(Companion companion, String string, List list, Boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = null;
            }
            return companion.createWithTypeInference(string, list, bl);
        }

        @NotNull
        public final <T> DataColumn<T> create(@NotNull String name, @NotNull List<? extends T> values2, @NotNull KType type, @NotNull Infer infer) {
            DataColumn dataColumn;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)infer), (String)"infer");
            switch (WhenMappings.$EnumSwitchMapping$0[org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.toColumnKind(type).ordinal()]) {
                case 1: {
                    dataColumn = org.jetbrains.kotlinx.dataframe.DataColumn$Companion.createValueColumn$default(this, name, values2, type, infer, null, 16, null);
                    break;
                }
                case 2: {
                    dataColumn = CastKt.cast(TypeConversionsKt.asDataColumn(this.createColumnGroup(name, ConcatKt.concatRows((Iterable)values2))));
                    break;
                }
                case 3: {
                    dataColumn = CastKt.cast(TypeConversionsKt.asDataColumn(org.jetbrains.kotlinx.dataframe.DataColumn$Companion.createFrameColumn$default(this, name, values2, null, 4, null)));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return dataColumn;
        }

        public static /* synthetic */ DataColumn create$default(Companion companion, String string, List list, KType kType, Infer infer, int n, Object object) {
            if ((n & 8) != 0) {
                infer = Infer.None;
            }
            return companion.create(string, list, kType, infer);
        }

        public final /* synthetic */ <T> DataColumn<T> create(String name, List<? extends T> values2, Infer infer) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)((Object)infer), (String)"infer");
            boolean $i$f$create = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            return this.create(name, values2, null, infer);
        }

        public static /* synthetic */ DataColumn create$default(Companion $this, String name, List values2, Infer infer, int n, Object object) {
            if ((n & 4) != 0) {
                infer = Infer.None;
            }
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            Intrinsics.checkNotNullParameter((Object)((Object)infer), (String)"infer");
            boolean $i$f$create = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            return $this.create(name, values2, null, infer);
        }

        @NotNull
        public final DataColumn<?> empty(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return org.jetbrains.kotlinx.dataframe.DataColumn$Companion.createValueColumn$default(this, name, CollectionsKt.emptyList(), Reflection.typeOf(Unit.class), null, null, 24, null);
        }

        public static /* synthetic */ DataColumn empty$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.empty(string);
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ColumnKind.values().length];
                try {
                    nArray[ColumnKind.Value.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnKind.Group.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ColumnKind.Frame.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static <T> boolean hasNulls(@NotNull DataColumn<? extends T> $this) {
            return $this.type().isMarkedNullable();
        }

        @Nullable
        public static <T> ColumnWithPath<T> resolveSingle(@NotNull DataColumn<? extends T> $this, @NotNull ColumnResolutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.addPath((BaseColumn)$this);
        }

        @NotNull
        public static <T> DataColumn<T> getValue(@NotNull DataColumn<? extends T> $this, @Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            BaseColumn<? extends T> baseColumn = BaseColumn.DefaultImpls.getValue($this, thisRef, property);
            Intrinsics.checkNotNull(baseColumn, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<T of org.jetbrains.kotlinx.dataframe.DataColumn>");
            return (DataColumn)baseColumn;
        }

        @NotNull
        public static <T> Iterator<T> iterator(@NotNull DataColumn<? extends T> $this) {
            return $this.values().iterator();
        }

        @NotNull
        public static <T> BaseColumn<T> get(@NotNull DataColumn<? extends T> $this, int firstIndex, int ... otherIndices) {
            Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
            return BaseColumn.DefaultImpls.get((BaseColumn)$this, firstIndex, otherIndices);
        }

        public static <T> T get(@NotNull DataColumn<? extends T> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return BaseColumn.DefaultImpls.get((BaseColumn)$this, row);
        }

        public static <T> T getValue(@NotNull DataColumn<? extends T> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return BaseColumn.DefaultImpls.getValue((BaseColumn)$this, row);
        }

        @NotNull
        public static <T> List<T> toList(@NotNull DataColumn<? extends T> $this) {
            return BaseColumn.DefaultImpls.toList((BaseColumn)$this);
        }

        @NotNull
        public static <T> ColumnPath path(@NotNull DataColumn<? extends T> $this) {
            return BaseColumn.DefaultImpls.path((BaseColumn)$this);
        }

        @Nullable
        public static <T> T getValueOrNull(@NotNull DataColumn<? extends T> $this, @NotNull DataRow<?> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            return BaseColumn.DefaultImpls.getValueOrNull((BaseColumn)$this, row);
        }

        @NotNull
        public static <T> List<ColumnWithPath<T>> resolve(@NotNull DataColumn<? extends T> $this, @NotNull ColumnResolutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return BaseColumn.DefaultImpls.resolve((BaseColumn)$this, context);
        }
    }
}

