/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.util.DasUtil;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface BasicMixinForeignKey
extends DasForeignKey {
    default public boolean isReferencingAnotherSchema() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicReference ref = self.getRefTableRef();
        if (ref == null) {
            return false;
        }
        @Nullable BasicMajorObject majorObject = self.getMajorObject();
        if (majorObject == null) {
            return false;
        }
        BasicSchema mySchema = majorObject.getSchema();
        if (mySchema == null) {
            return false;
        }
        String refSchemaName = ref.getParentName();
        if (refSchemaName == null && !ref.isPortable()) {
            BasicTable refTable = self.getRefTable();
            refSchemaName = refTable == null ? null : refTable.getSchemaName();
        }
        return refSchemaName != null && !refSchemaName.equals(mySchema.getName());
    }

    @Nullable
    default public BasicSchema getRefSchema() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicTable table = self.getRefTable();
        if (table != null) {
            return table.getSchema();
        }
        BasicReference ref = self.getRefTableRef();
        if (ref == null || ref.getName() == null) {
            return null;
        }
        if (ref.getParentName() == null) {
            return self.getSchema();
        }
        return null;
    }

    default public @Unmodifiable @NotNull List<? extends BasicLikeColumn> getRefCols() {
        BasicForeignKey self = (BasicForeignKey)this;
        List<String> refColNames = self.getRefColNames();
        if (refColNames.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicMixinForeignKey.$$$reportNull$$$0(0);
            }
            return list;
        }
        BasicTable refTable = self.getRefTable();
        if (refTable == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicMixinForeignKey.$$$reportNull$$$0(1);
            }
            return list;
        }
        PositioningNamingFamily<? extends BasicTableOrViewColumn> columns = refTable.getColumns();
        List list = ContainerUtil.map(refColNames, columns::get);
        if (list == null) {
            BasicMixinForeignKey.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    default public MultiRef<? extends BasicLikeColumn> getRefColumns() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicTable refTable = self.getRefTable();
        MultiRef multiRef = DasUtil.asRef(self.getRefColNames(), Functions.id(), c2 -> refTable == null ? null : (BasicTableOrViewColumn)refTable.getColumns().get((String)c2));
        if (multiRef == null) {
            BasicMixinForeignKey.$$$reportNull$$$0(3);
        }
        return multiRef;
    }

    @Nullable
    default public String getRefSchemaName() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicReference ref = self.getRefTableRef();
        if (ref == null) {
            return null;
        }
        String schemaName = ref.getParentName();
        if (schemaName != null) {
            return schemaName;
        }
        BasicSchema sc = this.getRefSchema();
        return sc == null ? null : sc.getName();
    }

    @Override
    @Deprecated
    default public String getRefTableName() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicReference ref = self.getRefTableRef();
        return ref == null ? null : ref.getName(self.getRefTable());
    }

    @Override
    @Deprecated
    default public String getRefTableSchema() {
        return this.getRefSchemaName();
    }

    @Override
    @Deprecated
    default public String getRefTableCatalog() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicTable refTable = self.getRefTable();
        return DasUtil.getCatalog(refTable);
    }

    @Override
    @Deprecated
    default public DasForeignKey.RuleAction getUpdateRule() {
        return BasicMixinForeignKey.getAction(((BasicForeignKey)this).getOnUpdate());
    }

    @Override
    @Deprecated
    default public DasForeignKey.RuleAction getDeleteRule() {
        return BasicMixinForeignKey.getAction(((BasicForeignKey)this).getOnDelete());
    }

    @NotNull
    public static DasForeignKey.RuleAction getAction(CascadeRule update) {
        DasForeignKey.RuleAction ruleAction = switch (update) {
            case CascadeRule.restrict -> DasForeignKey.RuleAction.RESTRICT;
            case CascadeRule.set_null -> DasForeignKey.RuleAction.SET_NULL;
            case CascadeRule.set_default -> DasForeignKey.RuleAction.SET_DEFAULT;
            case CascadeRule.cascade -> DasForeignKey.RuleAction.CASCADE;
            default -> DasForeignKey.RuleAction.NO_ACTION;
        };
        if (ruleAction == null) {
            BasicMixinForeignKey.$$$reportNull$$$0(4);
        }
        return ruleAction;
    }

    @Override
    @Deprecated
    default public DasForeignKey.Deferrability getDeferrability() {
        BasicForeignKey self = (BasicForeignKey)this;
        return self.isDeferrable() ? (self.isInitiallyDeferred() ? DasForeignKey.Deferrability.INITIALLY_DEFERRED : DasForeignKey.Deferrability.INITIALLY_IMMEDIATE) : DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/model/basic/BasicMixinForeignKey";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefCols";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefColumns";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

