/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedisErrorHandler
extends BaseDatabaseErrorHandler {
    @Override
    @NotNull
    protected ErrorInfo getErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
        String origMsg;
        if (original == null) {
            RedisErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            RedisErrorHandler.$$$reportNull$$$0(1);
        }
        if ((origMsg = GridUtilCore.getMessage((Throwable)original)).contains("Query contains an unknown command: --")) {
            return new RedisColumnHintErrorInfo(dataSource, original, cause);
        }
        if (origMsg.contains("Query contains an unknown command") || origMsg.contains("Query does not contain a keyword for the command") || origMsg.contains("Query contains an unknown keyword for the command")) {
            return new RedisUnknownCommandErrorInfo(dataSource, original, cause);
        }
        if (origMsg.contains("Unable to get the server mode")) {
            return new RedisModeRetrievingErrorInfo(dataSource, original, cause);
        }
        if (origMsg.contains("does not match the server mode")) {
            return new RedisModeMatchingErrorInfo(dataSource, original, cause);
        }
        String causeMsg = GridUtilCore.getMessage((Throwable)cause);
        if (causeMsg.contains("Port forwarding is not specified for")) {
            return new RedisPortForwardingErrorInfo(dataSource, original, cause);
        }
        ErrorInfo errorInfo = super.getErrorInfo(dataSource, original, cause);
        if (errorInfo == null) {
            RedisErrorHandler.$$$reportNull$$$0(2);
        }
        return errorInfo;
    }

    @Override
    public int getErrorOffset(@NotNull Project project, @NotNull ErrorInfo errorInfo, @NotNull String queryText) {
        if (project == null) {
            RedisErrorHandler.$$$reportNull$$$0(3);
        }
        if (errorInfo == null) {
            RedisErrorHandler.$$$reportNull$$$0(4);
        }
        if (queryText == null) {
            RedisErrorHandler.$$$reportNull$$$0(5);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redis/RedisErrorHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class RedisColumnHintErrorInfo
    extends RedisOutdatedDriverErrorInfo {
        RedisColumnHintErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RedisColumnHintErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RedisColumnHintErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                RedisColumnHintErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RedisColumnHintErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(DatabaseBundle.message("error.message.start.redis.unsupported.queries.with.column.hints", new Object[0]));
            super.fillInfoData(sb, fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisColumnHintErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RedisUnknownCommandErrorInfo
    extends RedisOutdatedDriverErrorInfo {
        RedisUnknownCommandErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RedisUnknownCommandErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RedisUnknownCommandErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                RedisUnknownCommandErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RedisUnknownCommandErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(GridUtilCore.getMessage((Throwable)this.myOriginal));
            super.fillInfoData(sb, fixes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisUnknownCommandErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RedisModeRetrievingErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        private static final String VERIFY_CONNECTION_MODE = "verifyConnectionMode";

        RedisModeRetrievingErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RedisModeRetrievingErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RedisModeRetrievingErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                RedisModeRetrievingErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RedisModeRetrievingErrorInfo.$$$reportNull$$$0(3);
            }
            String origMsg = GridUtilCore.getMessage((Throwable)this.myOriginal);
            sb.append(origMsg);
            sb.append("\n");
            sb.append(DatabaseBundle.message("error.message.redis.disable.connection.mode.verification", new Object[0]));
            RedisModeRetrievingErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.setDriverProperty(this.getDataSource(), DatabaseBundle.message("error.message.redis.disable.connection.mode.verification.fix", new Object[0]), VERIFY_CONNECTION_MODE, "false")));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisModeRetrievingErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RedisModeMatchingErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        RedisModeMatchingErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            String urlPrefix;
            String newUrl;
            if (sb == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(3);
            }
            String origMsg = GridUtilCore.getMessage((Throwable)this.myOriginal);
            sb.append(origMsg);
            LocalDataSource dataSource = this.getDataSource();
            if (dataSource == null) {
                return;
            }
            String url = dataSource.getUrl();
            if (url == null) {
                return;
            }
            Pattern pattern = Pattern.compile("Please change the URL prefix to \"(.+)\"");
            Matcher matcher = pattern.matcher(origMsg);
            if (matcher.find() && !(newUrl = RedisModeMatchingErrorInfo.tryFixUrlPrefix(url, urlPrefix = matcher.group(1))).equals(url)) {
                RedisModeMatchingErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.setUrl(dataSource, DatabaseBundle.message("error.message.redis.incorrect.mode.fix", urlPrefix), newUrl)));
            }
        }

        @NotNull
        private static String tryFixUrlPrefix(@NotNull String url, @NotNull String urlPrefix) {
            String separator;
            int index;
            if (url == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(4);
            }
            if (urlPrefix == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(5);
            }
            if ((index = url.indexOf(separator = "://")) == -1) {
                String string = url;
                if (string == null) {
                    RedisModeMatchingErrorInfo.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = urlPrefix + url.substring(index + separator.length());
            if (string == null) {
                RedisModeMatchingErrorInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlPrefix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisModeMatchingErrorInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisModeMatchingErrorInfo";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryFixUrlPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillInfoData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "tryFixUrlPrefix";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class RedisPortForwardingErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        RedisPortForwardingErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RedisPortForwardingErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RedisPortForwardingErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                RedisPortForwardingErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RedisPortForwardingErrorInfo.$$$reportNull$$$0(3);
            }
            String causeMsg = GridUtilCore.getMessage((Throwable)this.myCause);
            sb.append(causeMsg);
            LocalDataSource dataSource = this.getDataSource();
            if (dataSource == null) {
                return;
            }
            DataSourceSshTunnelConfiguration ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration(dataSource);
            if (ssh == null) {
                return;
            }
            sb.append("\n");
            sb.append(DatabaseBundle.message("error.message.redis.missed.port.forwarding", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisPortForwardingErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class RedisOutdatedDriverErrorInfo
    extends BaseDatabaseErrorHandler.DatabaseErrorInfo {
        RedisOutdatedDriverErrorInfo(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause) {
            if (original == null) {
                RedisOutdatedDriverErrorInfo.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                RedisOutdatedDriverErrorInfo.$$$reportNull$$$0(1);
            }
            super(dataSource, original, cause);
        }

        @Override
        protected void fillInfoData(@Nls @NotNull StringBuilder sb, @NotNull List<ErrorInfo.Fix> fixes) {
            if (sb == null) {
                RedisOutdatedDriverErrorInfo.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                RedisOutdatedDriverErrorInfo.$$$reportNull$$$0(3);
            }
            sb.append(" ").append(DatabaseBundle.message("error.message.tail.redis.switch.to.latest.driver", new Object[0]));
            LocalDataSource dataSource = this.getDataSource();
            if (dataSource == null) {
                return;
            }
            DatabaseDriver driver = dataSource.getDatabaseDriver();
            if (driver == null) {
                return;
            }
            DatabaseArtifactList artifactList = DatabaseArtifactLoader.getInstance().getDefaultArtifactList();
            boolean downloaded = DatabaseDriverUtils.isDriverFilesUpToDate(artifactList, driver, driver.getArtifacts());
            RedisOutdatedDriverErrorInfo.addFix(fixes, (Function<? super DatabaseFixFactory, ? extends ErrorInfo.Fix>)((Function)f -> f.switchToLatestDriver(dataSource, downloaded)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/redis/RedisErrorHandler$RedisOutdatedDriverErrorInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillInfoData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

