/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.base.introspector.AuditFacade;
import com.intellij.database.remote.jdba.RemoteCursor;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdba.RemoteSeance;
import com.intellij.database.remote.jdba.RemoteSession;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.core.ParameterDef;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateCursor;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateFacade;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateSeance;
import com.intellij.database.remote.jdba.intermediate.PrimeIntermediateSession;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0005#$%&'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J1\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\n\b\u0000\u0010\u001c*\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001f2\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateFacade;", "remoteFacade", "Lcom/intellij/database/remote/jdba/RemoteFacade;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "<init>", "(Lcom/intellij/database/remote/jdba/RemoteFacade;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "openedSessions", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lkotlin/collections/ArrayList;", "openSession", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSession;", "getConnectionInfo", "Lcom/intellij/database/remote/jdba/core/ConnectionInfo;", "kotlin.jvm.PlatformType", "reconnect", "", "detachFromDB", "disconnect", "closeOpenedSessions", "connect", "isConnected", "", "getSpecificService", "I", "", "serviceClass", "Ljava/lang/Class;", "serviceName", "", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "Session", "Seance", "Cursor", "OneTimeInvocation", "intellij.database.dialects.base"})
public final class AuditFacade
implements PrimeIntermediateFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteFacade remoteFacade;
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final ArrayList<Session> openedSessions;

    public AuditFacade(@NotNull RemoteFacade remoteFacade, @NotNull DatabaseConnectionCore connection) {
        Intrinsics.checkNotNullParameter((Object)remoteFacade, (String)"remoteFacade");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.remoteFacade = remoteFacade;
        this.connection = connection;
        this.openedSessions = new ArrayList();
    }

    @NotNull
    public final DatabaseConnectionCore getConnection() {
        return this.connection;
    }

    @NotNull
    public PrimeIntermediateSession openSession() {
        RemoteSession remoteSession = this.remoteFacade.openSession();
        Intrinsics.checkNotNullExpressionValue((Object)remoteSession, (String)"openSession(...)");
        Session opened2 = new Session(remoteSession, this.connection, (Function1<? super Session, Unit>)((Function1)arg_0 -> AuditFacade.openSession$lambda$0(this, arg_0)));
        ((Collection)this.openedSessions).add(opened2);
        return opened2;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.remoteFacade.getConnectionInfo();
    }

    public void reconnect() {
        this.remoteFacade.reconnect();
    }

    public void detachFromDB() {
        this.closeOpenedSessions();
        this.remoteFacade.detachFromDB();
    }

    public void disconnect() {
        this.closeOpenedSessions();
        this.remoteFacade.disconnect();
    }

    private final void closeOpenedSessions() {
        Iterator<Session> iterator = this.openedSessions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Session> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Session openedSession;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            openedSession.disconnect();
        }
        this.openedSessions.clear();
    }

    public void connect() {
        this.remoteFacade.connect();
    }

    public boolean isConnected() {
        return this.remoteFacade.isConnected();
    }

    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        String string = "not implemented yet";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private static final Unit openSession$lambda$0(AuditFacade this$0, Session it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)this$0.openedSessions).remove(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Companion;", "", "<init>", "()V", "runReporting", "T", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "runnable", "Lkotlin/Function0;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "castTo", "C", "clazz", "Ljava/lang/Class;", "obj", "(Ljava/lang/Class;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.database.dialects.base"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T runReporting(DatabaseConnectionCore connection, SmartStatementMark mark2, Function0<? extends T> runnable) {
            try {
                return (T)runnable.invoke();
            }
            catch (Throwable t) {
                connection.getAuditService().error(t, mark2);
                throw t;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Contract(value="_,!null->!null; _,null->null")
        @Nullable
        public final <C> C castTo(@NotNull Class<C> clazz, @Nullable Object obj2) throws ClassCastException {
            Object object;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            if (obj2 == null) {
                object = null;
                return (C)object;
            }
            Class<?> objectClass = obj2.getClass();
            if (clazz.isAssignableFrom(objectClass)) {
                object = obj2;
                return (C)object;
            }
            String kind = clazz.isInterface() ? "interface" : "class";
            String string = "cannot cast object of class %s to %s %s.";
            Object[] objectArray = new Object[]{objectClass.getName(), kind, clazz.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String msg = string2;
            throw new ClassCastException(msg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BI\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\u0006\u0010\u001c\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "T", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateCursor;", "remoteCursor", "Lcom/intellij/database/remote/jdba/RemoteCursor;", "resultsClosingInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "disposalCallback", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/database/remote/jdba/RemoteCursor;Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function1;)V", "fetch", "()Ljava/lang/Object;", "hasRows", "", "getColumnNames", "", "", "()[Ljava/lang/String;", "setCollectLimit", "limit", "", "close", "disconnect", "intellij.database.dialects.base"})
    private static final class Cursor<T>
    implements PrimeIntermediateCursor<T> {
        @NotNull
        private final RemoteCursor<T> remoteCursor;
        @Nullable
        private final OneTimeInvocation resultsClosingInvocation;
        @NotNull
        private final Session session;
        @NotNull
        private final SmartStatementMark mark;
        @NotNull
        private final Function1<Cursor<T>, Unit> disposalCallback;

        public Cursor(@NotNull RemoteCursor<T> remoteCursor, @Nullable OneTimeInvocation resultsClosingInvocation, @NotNull Session session, @NotNull SmartStatementMark mark2, @NotNull Function1<? super Cursor<T>, Unit> disposalCallback) {
            Intrinsics.checkNotNullParameter(remoteCursor, (String)"remoteCursor");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.remoteCursor = remoteCursor;
            this.resultsClosingInvocation = resultsClosingInvocation;
            this.session = session;
            this.mark = mark2;
            this.disposalCallback = disposalCallback;
        }

        public T fetch() {
            return (T)Companion.runReporting(this.session.getConnection(), this.mark, () -> Cursor.fetch$lambda$0(this));
        }

        public boolean hasRows() {
            return this.remoteCursor.hasRows();
        }

        @NotNull
        public String[] getColumnNames() {
            String[] stringArray = this.remoteCursor.getColumnNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getColumnNames(...)");
            return stringArray;
        }

        public void setCollectLimit(int limit) {
            this.remoteCursor.setCollectLimit(limit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.remoteCursor.close();
            }
        }

        public final void disconnect() {
            block1: {
                if (this.session.isClosed()) break block1;
                OneTimeInvocation oneTimeInvocation = this.resultsClosingInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
            }
        }

        private static final Object fetch$lambda$0(Cursor this$0) {
            Object result2 = this$0.remoteCursor.fetch();
            return result2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "", "invoker", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "invoked", "", "run", "intellij.database.dialects.base"})
    private static final class OneTimeInvocation {
        @NotNull
        private final Function0<Unit> invoker;
        private boolean invoked;

        public OneTimeInvocation(@NotNull Function0<Unit> invoker) {
            Intrinsics.checkNotNullParameter(invoker, (String)"invoker");
            this.invoker = invoker;
        }

        public final void run() {
            if (this.invoked) {
                return;
            }
            this.invoked = true;
            this.invoker.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0019\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ0\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\n\b\u0000\u0010!*\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H!0%H\u0016J\b\u0010&\u001a\u00020#H\u0016J\u001d\u0010'\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020#H\u0016J\b\u0010,\u001a\u00020\nH\u0016J\u0006\u0010-\u001a\u00020\nJ\b\u0010.\u001a\u00020\nH\u0002J\b\u0010/\u001a\u00020\nH\u0002J1\u00100\u001a\u0004\u0018\u0001H1\"\n\b\u0000\u00101*\u0004\u0018\u00010\u000f2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u00104\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR&\u0010\u001b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "remoteSeance", "Lcom/intellij/database/remote/jdba/RemoteSeance;", "session", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "sql", "", "disposalCallback", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/database/remote/jdba/RemoteSeance;Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "parameters", "", "", "[Ljava/lang/Object;", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "myResultSetInvocation", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$OneTimeInvocation;", "myStatementInvocation", "mark", "com/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance$mark$1;", "openedCursors", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Cursor;", "Lkotlin/collections/ArrayList;", "openCursor", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateCursor;", "R", "parameterPosition", "", "layout", "Lcom/intellij/database/remote/jdba/core/ResultLayout;", "getAffectedRowsCount", "setInParameters", "([Ljava/lang/Object;)V", "close", "setPackLimit", "packLimit", "execute", "disconnect", "before", "beforePrepared", "getSpecificService", "I", "serviceClass", "Ljava/lang/Class;", "serviceName", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "intellij.database.dialects.base"})
    @SourceDebugExtension(value={"SMAP\nAuditFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditFacade.kt\ncom/intellij/database/dialects/base/introspector/AuditFacade$Seance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
    private static final class Seance
    implements PrimeIntermediateSeance {
        @NotNull
        private final RemoteSeance remoteSeance;
        @NotNull
        private final Session session;
        @NotNull
        private final String sql;
        @NotNull
        private final Function1<Seance, Unit> disposalCallback;
        @Nullable
        private Object[] parameters;
        @Nullable
        private RemoteResultSet resultSet;
        @Nullable
        private RemoteStatement statement;
        @Nullable
        private OneTimeInvocation myResultSetInvocation;
        @Nullable
        private OneTimeInvocation myStatementInvocation;
        @NotNull
        private final mark.1 mark;
        @NotNull
        private final ArrayList<Cursor<?>> openedCursors;

        public Seance(@NotNull RemoteSeance remoteSeance, @NotNull Session session, @NotNull String sql, @NotNull Function1<? super Seance, Unit> disposalCallback) {
            RemoteStatement x;
            Intrinsics.checkNotNullParameter((Object)remoteSeance, (String)"remoteSeance");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.remoteSeance = remoteSeance;
            this.session = session;
            this.sql = sql;
            this.disposalCallback = disposalCallback;
            this.mark = new SmartStatementMark.RunnableMark(this){
                final /* synthetic */ Seance this$0;
                {
                    this.this$0 = $receiver;
                }

                public DatabaseDepartment getDepartment() {
                    return DGDepartment.INTROSPECTION;
                }

                public SmartStatementSource getSource() {
                    return SmartStatementSource.SYSTEM;
                }

                public boolean cancel() {
                    if (Seance.access$getStatement$p(this.this$0) == null) {
                        return true;
                    }
                    return JdbcNativeUtil.getBooleanSafe(() -> mark.1.cancel$lambda$0(this.this$0));
                }

                private static final Boolean cancel$lambda$0(Seance this$0) {
                    RemoteStatement remoteStatement = Seance.access$getStatement$p(this$0);
                    Intrinsics.checkNotNull((Object)remoteStatement);
                    remoteStatement.cancel();
                    return true;
                }
            };
            this.openedCursors = new ArrayList();
            RemoteStatement remoteStatement = this.statement = (x = this.remoteSeance.getStatement());
            if (remoteStatement != null) {
                RemoteStatement it = remoteStatement;
                boolean bl = false;
                this.myStatementInvocation = new OneTimeInvocation((Function0<Unit>)((Function0)() -> Seance.lambda$1$lambda$0(this, it)));
            }
            if (this.statement != null) {
                AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                RemoteStatement remoteStatement2 = this.statement;
                Intrinsics.checkNotNull((Object)remoteStatement2);
                advancedAuditService.statementOpened(remoteStatement2, this.mark);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public <R> PrimeIntermediateCursor<R> openCursor(int parameterPosition, @NotNull ResultLayout<R> layout) {
            Intrinsics.checkNotNullParameter(layout, (String)"layout");
            try {
                RemoteCursor remoteCursor = this.remoteSeance.openCursor(parameterPosition, layout);
                Intrinsics.checkNotNullExpressionValue((Object)remoteCursor, (String)"openCursor(...)");
                Cursor cursor = new Cursor(remoteCursor, this.myResultSetInvocation, this.session, this.mark, arg_0 -> Seance.openCursor$lambda$2(this, arg_0));
                ((Collection)this.openedCursors).add(cursor);
                PrimeIntermediateCursor primeIntermediateCursor = cursor;
                return primeIntermediateCursor;
            }
            finally {
                if (this.resultSet != null) {
                    AdvancedAuditService advancedAuditService = this.session.getConnection().getAuditService();
                    RemoteResultSet remoteResultSet = this.resultSet;
                    Intrinsics.checkNotNull((Object)remoteResultSet);
                    advancedAuditService.resultsOpened(remoteResultSet, this.mark);
                }
            }
        }

        public int getAffectedRowsCount() {
            return this.remoteSeance.getAffectedRowsCount();
        }

        public void setInParameters(@NotNull Object[] parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.remoteSeance.setInParameters(parameters);
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.remoteSeance.close();
            }
        }

        public void setPackLimit(int packLimit) {
            this.remoteSeance.setPackLimit(packLimit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                Unit cfr_ignored_0 = (Unit)Companion.runReporting(this.session.getConnection(), this.mark, () -> Seance.execute$lambda$6(this));
            }
            finally {
                this.session.getConnection().getAuditService().afterStatement(this.mark);
            }
        }

        public final void disconnect() {
            block3: {
                Iterator<Cursor<?>> iterator = this.openedCursors.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<Cursor<?>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Cursor<?> openedCursor;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    openedCursor.disconnect();
                }
                this.openedCursors.clear();
                if (this.session.isClosed()) {
                    return;
                }
                OneTimeInvocation oneTimeInvocation = this.myResultSetInvocation;
                if (oneTimeInvocation != null) {
                    oneTimeInvocation.run();
                }
                OneTimeInvocation oneTimeInvocation2 = this.myStatementInvocation;
                if (oneTimeInvocation2 == null) break block3;
                oneTimeInvocation2.run();
            }
        }

        private final void before() {
            if (this.parameters != null) {
                this.beforePrepared();
                return;
            }
            this.session.getConnection().getAuditService().beforeSimpleStatement(this.sql, this.mark);
        }

        private final void beforePrepared() {
            StatementParameters builder = new StatementParameters();
            Intrinsics.checkNotNull((Object)this.parameters);
            for (Object value : this.parameters) {
                builder.obj(value);
            }
            this.session.getConnection().getAuditService().beforeParameterizedStatement(builder.asData(this.sql), this.mark);
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            return switch (serviceName) {
                case "jdbc-result-set" -> Companion.castTo(serviceClass, this.resultSet);
                case "jdbc-statement" -> Companion.castTo(serviceClass, this.statement);
                case "jdbc-connection" -> this.session.getSpecificService(serviceClass, serviceName);
                default -> null;
            };
        }

        private static final Unit lambda$1$lambda$0(Seance this$0, RemoteStatement $it) {
            this$0.session.getConnection().getAuditService().beforeStatementClosing($it, this$0.mark);
            return Unit.INSTANCE;
        }

        private static final Unit openCursor$lambda$2(Seance this$0, Cursor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ((Collection)this$0.openedCursors).remove(it);
            return Unit.INSTANCE;
        }

        private static final Unit execute$lambda$6$lambda$3(Seance this$0) {
            this$0.remoteSeance.execute();
            return Unit.INSTANCE;
        }

        private static final Unit execute$lambda$6$lambda$5$lambda$4(Seance this$0, RemoteResultSet $it) {
            this$0.session.getConnection().getAuditService().resultsProcessed(this$0.mark);
            this$0.session.getConnection().getAuditService().beforeResultsClosing($it, this$0.mark);
            return Unit.INSTANCE;
        }

        private static final Unit execute$lambda$6(Seance this$0) {
            Unit unit;
            this$0.before();
            this$0.mark.run(() -> Seance.execute$lambda$6$lambda$3(this$0));
            int count = this$0.getAffectedRowsCount();
            if (count > 0) {
                this$0.session.getConnection().getAuditService().updateCount(count, this$0.mark);
            }
            RemoteResultSet remoteResultSet = this$0.resultSet = this$0.remoteSeance.getDefaultResultSet();
            if (remoteResultSet != null) {
                RemoteResultSet it = remoteResultSet;
                boolean bl = false;
                this$0.myResultSetInvocation = new OneTimeInvocation((Function0<Unit>)((Function0)() -> Seance.execute$lambda$6$lambda$5$lambda$4(this$0, it)));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public static final /* synthetic */ RemoteStatement access$getStatement$p(Seance $this) {
            return $this.statement;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0006\u0010\u001c\u001a\u00020\bJ1\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\n\b\u0000\u0010\u001e*\u0004\u0018\u00010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!2\u0006\u0010\"\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/base/introspector/AuditFacade$Session;", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSession;", "remoteSession", "Lcom/intellij/database/remote/jdba/RemoteSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "disposalCallback", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/database/remote/jdba/RemoteSession;Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lkotlin/jvm/functions/Function1;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "openedSeances", "Ljava/util/ArrayList;", "Lcom/intellij/database/dialects/base/introspector/AuditFacade$Seance;", "Lkotlin/collections/ArrayList;", "openSeance", "Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "statementText", "", "outParameters", "", "Lcom/intellij/database/remote/jdba/core/ParameterDef;", "(Ljava/lang/String;[Lcom/intellij/database/remote/jdba/core/ParameterDef;)Lcom/intellij/database/remote/jdba/intermediate/PrimeIntermediateSeance;", "isClosed", "", "close", "disconnect", "getSpecificService", "I", "", "serviceClass", "Ljava/lang/Class;", "serviceName", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "intellij.database.dialects.base"})
    private static final class Session
    implements PrimeIntermediateSession {
        @NotNull
        private final RemoteSession remoteSession;
        @NotNull
        private final DatabaseConnectionCore connection;
        @NotNull
        private final Function1<Session, Unit> disposalCallback;
        @NotNull
        private final ArrayList<Seance> openedSeances;

        public Session(@NotNull RemoteSession remoteSession, @NotNull DatabaseConnectionCore connection, @NotNull Function1<? super Session, Unit> disposalCallback) {
            Intrinsics.checkNotNullParameter((Object)remoteSession, (String)"remoteSession");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter(disposalCallback, (String)"disposalCallback");
            this.remoteSession = remoteSession;
            this.connection = connection;
            this.disposalCallback = disposalCallback;
            this.openedSeances = new ArrayList();
        }

        @NotNull
        public final DatabaseConnectionCore getConnection() {
            return this.connection;
        }

        @NotNull
        public PrimeIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameters) {
            Intrinsics.checkNotNullParameter((Object)statementText, (String)"statementText");
            RemoteSeance remoteSeance = this.remoteSession.openSeance(statementText, outParameters);
            Intrinsics.checkNotNullExpressionValue((Object)remoteSeance, (String)"openSeance(...)");
            Seance seance = new Seance(remoteSeance, this, statementText, (Function1<? super Seance, Unit>)((Function1)arg_0 -> Session.openSeance$lambda$0(this, arg_0)));
            ((Collection)this.openedSeances).add(seance);
            return seance;
        }

        public boolean isClosed() {
            return this.remoteSession.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                this.disposalCallback.invoke((Object)this);
                this.disconnect();
            }
            finally {
                this.remoteSession.close();
            }
        }

        public final void disconnect() {
            Iterator<Seance> iterator = this.openedSeances.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Seance> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Seance openedSeance;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                openedSeance.disconnect();
            }
            this.openedSeances.clear();
        }

        @Nullable
        public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            String string = serviceName;
            return (I)(Intrinsics.areEqual((Object)string, (Object)"jdbc-connection") ? Companion.castTo(serviceClass, this.connection) : (Intrinsics.areEqual((Object)string, (Object)"jdbc-metadata") ? Companion.castTo(serviceClass, this.connection.getRemoteMetaData()) : null));
        }

        private static final Unit openSeance$lambda$0(Session this$0, Seance it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ((Collection)this$0.openedSeances).remove(it);
            return Unit.INSTANCE;
        }
    }
}

