/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSrcFileSystemCore
extends NewVirtualFileSystem {
    public static final String APP_PROJECT_ID = "app";

    public static <R> R processPath(@NotNull VirtualFile file, @NotNull ItemProcessor<R> processor) {
        if (file == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(1);
        }
        return DbSrcFileSystemCore.processPath(file.getPath(), processor);
    }

    public static <R> R processPath(@NotNull String path, @NotNull ItemProcessor<R> processor) {
        Project project;
        Iterator<String> it;
        if (path == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(3);
        }
        if (!(it = DbSrcUtilsCore.splitPath(path).iterator()).hasNext()) {
            return processor.processRoot();
        }
        String projectStr = it.next();
        boolean isApp = projectStr.equals(APP_PROJECT_ID);
        Project project2 = project = isApp ? null : ProjectManager.getInstance().findOpenProjectByHash(projectStr);
        if (project == null && !isApp) {
            return processor.processOutOfDate();
        }
        if (!it.hasNext()) {
            return processor.processProject(project);
        }
        String dsId = it.next();
        if (!it.hasNext()) {
            return processor.processDataSource(project, dsId);
        }
        return DbSrcFileSystemCore.processPathInner(project, dsId, null, it, processor);
    }

    private static <R> R processPathInner(@Nullable Project p2, @NotNull String dsId, @Nullable ObjectPath parent, @NotNull Iterator<String> it, @NotNull ItemProcessor<R> processor) {
        String id;
        boolean last;
        String group;
        ObjectKind kind;
        if (dsId == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(4);
        }
        if (it == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            DbSrcFileSystemCore.$$$reportNull$$$0(6);
        }
        if ((kind = DbSrcUtilsCore.findKind(group = DbSrcFileSystemCore.unescapeGroup(it.next()))) == null) {
            return processor.processInvalidFolder(p2, dsId, parent, null, group);
        }
        if (!it.hasNext()) {
            return processor.processFolder(p2, dsId, parent, kind);
        }
        String name2 = it.next();
        ItemType type = ItemType.identify(name2);
        boolean bl = last = !it.hasNext();
        if (!last && type != null) {
            return processor.processInvalidFolder(p2, dsId, parent, kind, name2);
        }
        int len = name2.length() - (type == null ? 0 : type.ext.length());
        int pt = name2.indexOf(64);
        String string = id = pt == -1 ? null : DbSrcFileSystemCore.unescapeName(name2.substring(pt + 1, len));
        if (pt != -1) {
            len = pt;
        }
        name2 = DbSrcFileSystemCore.unescapeName(name2.substring(0, len));
        ObjectPath cur = ObjectPath.create(name2, kind, true, id, parent);
        if (type != null) {
            return processor.processFile(p2, dsId, cur, type);
        }
        if (last) {
            return processor.processFolder(p2, dsId, cur, null);
        }
        return DbSrcFileSystemCore.processPathInner(p2, dsId, cur, it, processor);
    }

    private static String unescapeName(String s) {
        if (s == null) {
            return null;
        }
        return DbSrcUtilsCore.unescapeChars(StringUtil.trimEnd((String)s, (String)"&"));
    }

    private static String unescapeGroup(String s) {
        return DbSrcUtilsCore.unescapeChars(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystemCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processPathInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ItemProcessor<R> {
        public R processRoot() {
            return null;
        }

        public R processOutOfDate() {
            return null;
        }

        public R processProject(@Nullable Project project) {
            return null;
        }

        public R processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(0);
            }
            return null;
        }

        public R processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(1);
            }
            return null;
        }

        public R processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull ItemType type) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(2);
            }
            if (path == null) {
                ItemProcessor.$$$reportNull$$$0(3);
            }
            if (type == null) {
                ItemProcessor.$$$reportNull$$$0(4);
            }
            return null;
        }

        public R processInvalidFolder(@Nullable Project p2, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group, @NotNull String invalid) {
            if (dataSourceId == null) {
                ItemProcessor.$$$reportNull$$$0(5);
            }
            if (invalid == null) {
                ItemProcessor.$$$reportNull$$$0(6);
            }
            return this.processOutOfDate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSourceId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invalid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystemCore$ItemProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFolder";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFile";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processInvalidFolder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ItemType implements ItemTypeOrFolder
    {
        SRC(".sql"),
        ORIG(".orig.sql"),
        USER_BASE(".base.sql");

        public static final ItemTypeOrFolder FOLDER;
        public final String ext;

        private ItemType(String ext) {
            if (ext == null) {
                ItemType.$$$reportNull$$$0(0);
            }
            this.ext = ext;
        }

        @NotNull
        public String trim(@NotNull String name2) {
            if (name2 == null) {
                ItemType.$$$reportNull$$$0(1);
            }
            String string = StringUtil.trimEnd((String)name2, (String)this.ext);
            if (string == null) {
                ItemType.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean is(@NotNull String name2) {
            if (name2 == null) {
                ItemType.$$$reportNull$$$0(3);
            }
            return ItemType.identify(name2) == this;
        }

        @Nullable
        public static ItemType identify(@NotNull String name2) {
            if (name2 == null) {
                ItemType.$$$reportNull$$$0(4);
            }
            ItemType[] values = ItemType.values();
            for (int i2 = values.length - 1; i2 >= 0; --i2) {
                if (!name2.endsWith(values[i2].ext)) continue;
                return values[i2];
            }
            return null;
        }

        static {
            FOLDER = new ItemTypeOrFolder(){

                public String toString() {
                    return "FOLDER";
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ext";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystemCore$ItemType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcFileSystemCore$ItemType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "is";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "identify";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ItemTypeOrFolder {
    }
}

