/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.textmate.joni.JoniRegexFactory;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateCachingSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerCore;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcherImpl;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextmateToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.regex.CachingRegexFactory;
import org.jetbrains.plugins.textmate.regex.RememberingLastMatchRegexFactory;

public class TextMateHighlightingLexer
extends LexerBase {
    private final TextMateLexerCore myLexer;
    private final Queue<TextmateToken> currentLineTokens;
    private CharSequence myBuffer;
    private int myEndOffset;
    private int myCurrentOffset;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;
    private boolean myRestartable;

    public TextMateHighlightingLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, int lineLimit) {
        if (languageDescriptor == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(0);
        }
        this.currentLineTokens = new LinkedList<TextmateToken>();
        CachingRegexFactory regexFactory = new CachingRegexFactory(new RememberingLastMatchRegexFactory(new JoniRegexFactory()));
        TextMateSelectorCachingWeigher weigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
        TextMateCachingSyntaxMatcher syntaxMatcher = new TextMateCachingSyntaxMatcher(new TextMateSyntaxMatcherImpl(regexFactory, weigher));
        this.myLexer = new TextMateLexerCore(languageDescriptor, syntaxMatcher, lineLimit, false);
    }

    public TextMateHighlightingLexer(@NotNull TextMateLanguageDescriptor languageDescriptor, @NotNull TextMateSyntaxMatcher syntaxMatcher, int lineLimit) {
        if (languageDescriptor == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(1);
        }
        if (syntaxMatcher == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(2);
        }
        this.currentLineTokens = new LinkedList<TextmateToken>();
        this.myLexer = new TextMateLexerCore(languageDescriptor, syntaxMatcher, lineLimit, false);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(3);
        }
        this.myBuffer = buffer;
        this.myCurrentOffset = startOffset;
        this.myTokenStart = startOffset;
        this.myEndOffset = endOffset;
        this.currentLineTokens.clear();
        this.myLexer.init(this.myBuffer, startOffset);
        this.advance();
    }

    public int getState() {
        return this.myRestartable ? 0 : 1;
    }

    @Nullable
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            TextMateHighlightingLexer.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    public void advance() {
        if (this.myCurrentOffset >= this.myEndOffset) {
            this.updateState(null, this.myEndOffset);
            return;
        }
        if (this.currentLineTokens.isEmpty()) {
            Application app = ApplicationManager.getApplication();
            Runnable checkCancelledCallback = app == null || app.isUnitTestMode() ? null : () -> ProgressManager.checkCanceled();
            this.currentLineTokens.addAll(this.myLexer.advanceLine(checkCancelledCallback));
        }
        this.updateState(this.currentLineTokens.poll(), this.myLexer.getCurrentOffset());
    }

    protected void updateState(@Nullable TextmateToken token, int fallbackOffset) {
        if (token != null) {
            this.myTokenType = token.getScope() == TextMateScope.WHITESPACE ? TokenType.WHITE_SPACE : new TextMateElementType(token.getScope());
            this.myTokenStart = token.getStartOffset();
            this.myTokenEnd = Math.min(token.getEndOffset(), this.myEndOffset);
            this.myCurrentOffset = token.getEndOffset();
            this.myRestartable = token.getRestartable();
        } else {
            this.myTokenType = null;
            this.myTokenStart = fallbackOffset;
            this.myTokenEnd = fallbackOffset;
            this.myCurrentOffset = fallbackOffset;
            this.myRestartable = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxMatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateHighlightingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/lexer/TextMateHighlightingLexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

