/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.maven;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.java.library.LibraryWithMavenCoordinatesProperties;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.BuildSystemDependenciesModelBase;
import com.intellij.packageChecker.java.ProjectDependenciesModels;
import com.intellij.packageChecker.maven.MavenBuildFileProvider;
import com.intellij.packageChecker.maven.MavenBuildFileProviderKt;
import com.intellij.packageChecker.maven.MavenFilesModificationTracker;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.model.ProjectSnapshot;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.service.PackageCheckerDisposable;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J$\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0014J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010\u0003\u001a\u00020/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0002J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/packageChecker/maven/MavenProjectDependenciesModel;", "Lorg/jetbrains/idea/maven/project/MavenImportListener;", "Lcom/intellij/packageChecker/java/BuildSystemDependenciesModelBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "()V", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "collectDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "mavenDependencies", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactNode;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "parentDependencyContext", "Lcom/intellij/packageChecker/toolwindow/DependencyContext;", "findPackageDeclaration", "Lcom/intellij/psi/PsiElement;", "pkg", "Lcom/intellij/packageChecker/model/Package;", "importFinished", "", "importedProjects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "newModules", "", "getAllModules", "", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "supports", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "declaredDependencies", "Lcom/intellij/packageChecker/model/ProjectSnapshot;", "scanProjectLibraries", "getMavenCoordinates", "Lcom/intellij/java/library/MavenCoordinates;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "toPackages", "allCoordinates", "", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "intellij.packageChecker.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectDependenciesModel.kt\ncom/intellij/packageChecker/maven/MavenProjectDependenciesModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,175:1\n1617#2,9:176\n1869#2:185\n1870#2:187\n1626#2:188\n1617#2,9:189\n1869#2:198\n1870#2:200\n1626#2:201\n1617#2,9:204\n1869#2:213\n1870#2:215\n1626#2:216\n1#3:186\n1#3:199\n1#3:214\n30#4,2:202\n*S KotlinDebug\n*F\n+ 1 MavenProjectDependenciesModel.kt\ncom/intellij/packageChecker/maven/MavenProjectDependenciesModel\n*L\n50#1:176,9\n50#1:185\n50#1:187\n50#1:188\n83#1:189,9\n83#1:198\n83#1:200\n83#1:201\n168#1:204,9\n168#1:213\n168#1:215\n168#1:216\n50#1:186\n83#1:199\n168#1:214\n123#1:202,2\n*E\n"})
public final class MavenProjectDependenciesModel
extends BuildSystemDependenciesModelBase
implements MavenImportListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @Nullable
    private final MavenProjectsManager mavenProjectsManager;

    public MavenProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.mavenProjectsManager = this.supports(this.project) ? MavenProjectsManager.getInstance((Project)this.project) : null;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        this.init();
        Disposer.register((Disposable)PackageCheckerDisposable.Companion.getInstance(this.project), (Disposable)this);
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Dependency> collectDependencies(List<? extends MavenArtifactNode> mavenDependencies, VirtualFile file, Module module, DependencyContext parentDependencyContext) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = mavenDependencies;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Dependency dependency;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifactNode it = (MavenArtifactNode)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            MavenArtifact mavenArtifact = it.getArtifact();
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"getArtifact(...)");
            if (MavenBuildFileProviderKt.createPackage(mavenArtifact, this.project) == null) {
                dependency = null;
            } else {
                Package pkg;
                DependencyContext dependencyContext = parentDependencyContext;
                if (dependencyContext == null) {
                    dependencyContext = new DependencyContext(this.project, module, file, null, (Function3<? super VirtualFile, ? super Module, ? super Package, ? extends PsiElement>)((Function3)(arg_0, arg_1, arg_2) -> MavenProjectDependenciesModel.collectDependencies$lambda$1$lambda$0(this, arg_0, arg_1, arg_2)));
                }
                DependencyContext dependencyContext2 = dependencyContext;
                List list = it.getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
                dependency = new Dependency(pkg, this.collectDependencies(list, file, module, dependencyContext2), dependencyContext2);
            }
            if (dependency == null) continue;
            Dependency it$iv$iv = dependency;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    static /* synthetic */ Set collectDependencies$default(MavenProjectDependenciesModel mavenProjectDependenciesModel, List list, VirtualFile virtualFile, Module module, DependencyContext dependencyContext, int n, Object object) {
        if ((n & 8) != 0) {
            dependencyContext = null;
        }
        return mavenProjectDependenciesModel.collectDependencies(list, virtualFile, module, dependencyContext);
    }

    private final PsiElement findPackageDeclaration(VirtualFile file, Module module, Package pkg) {
        PsiElement psiElement;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile psiFile = VirtualFileUtil.findPsiFile((VirtualFile)file, (Project)project);
        if (psiFile != null) {
            Object v2;
            block3: {
                PsiFile psiFile2 = psiFile;
                boolean bl = false;
                Iterable iterable = this.declaredDependencies(psiFile2);
                for (Object t : iterable) {
                    PackageDeclaration packageDeclaration = (PackageDeclaration)t;
                    boolean bl2 = false;
                    if (!packageDeclaration.getPkg().matches(pkg)) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            PackageDeclaration packageDeclaration = v2;
            psiElement = packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
        Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
        Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
        this.logger.info("import finished:" + CollectionsKt.joinToString$default((Iterable)importedProjects, null, null, null, (int)0, null, MavenProjectDependenciesModel::importFinished$lambda$4, (int)31, null));
        this.refresh(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        void $this$mapNotNullTo$iv$iv;
        this.logger.info("Start collecting all modules");
        MavenProjectsManager mavenProjectsManager = this.mavenProjectsManager;
        if ((mavenProjectsManager != null ? mavenProjectsManager.getProjectsTree() : null) == null) {
            return CollectionsKt.emptyList();
        }
        List list = this.mavenProjectsManager.getNonIgnoredProjects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNonIgnoredProjects(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MutableModuleModel mutableModuleModel;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenProject mavenProject = (MavenProject)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            if ((Module)ReadAction.compute(() -> MavenProjectDependenciesModel.getAllModules$lambda$6$lambda$5(mavenProject, this)) == null) {
                mutableModuleModel = null;
            } else {
                MutableModuleModel newModel;
                Module module;
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject.getMavenId().getKey(), (String)"getKey(...)");
                VirtualFile buildFile = mavenProject.getFile();
                if (this.logger.isDebugEnabled()) {
                    String moduleId;
                    this.logger.debug("Module: " + moduleId + ", platform module: " + module.getName() + ", buildFile: " + buildFile);
                }
                Set collectDependencies = MavenProjectDependenciesModel.collectDependencies$default(this, mavenProject.getDependencyTree(), mavenProject.getFile(), module, null, 8, null);
                String string = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                mutableModuleModel = newModel = new MutableModuleModel(string, module, buildFile, CollectionsKt.toSet((Iterable)collectDependencies), this.project);
            }
            if (mutableModuleModel == null) continue;
            MutableModuleModel it$iv$iv = mutableModuleModel;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List moduleModels = (List)destination$iv$iv;
        this.logger.info("Finish collecting all modules, count of found modules: " + moduleModels.size());
        return moduleModels;
    }

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectDependenciesModels.INSTANCE.isProjectOfSystem(project, ProjectDependenciesModels.INSTANCE.getMAVEN_SYSTEM_ID());
    }

    @Override
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return ((MavenBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(MavenBuildFileProvider.class, (AreaInstance)this.project)).supports(psiFile);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((MavenBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(MavenBuildFileProvider.class, (AreaInstance)this.project)).supports(module);
    }

    @Override
    @NotNull
    protected ModificationTracker getModificationTracker(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MavenFilesModificationTracker> serviceClass$iv = MavenFilesModificationTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ModificationTracker)object;
    }

    @Override
    @NotNull
    public List<Package> declaredDependencies(@NotNull ProjectSnapshot project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.scanProjectLibraries();
    }

    private final List<Package> scanProjectLibraries() {
        Set allCoordinates = new LinkedHashSet();
        OrderEnumerator.orderEntries((Project)this.project).forEachLibrary(arg_0 -> MavenProjectDependenciesModel.scanProjectLibraries$lambda$8(arg_0 -> MavenProjectDependenciesModel.scanProjectLibraries$lambda$7(this, allCoordinates, arg_0), arg_0));
        return this.toPackages(allCoordinates);
    }

    private final MavenCoordinates getMavenCoordinates(Library library) {
        LibraryProperties libraryProperties;
        if (library instanceof LibraryEx && (libraryProperties = ((LibraryEx)library).getProperties()) instanceof LibraryWithMavenCoordinatesProperties) {
            return ((LibraryWithMavenCoordinatesProperties)libraryProperties).getMavenCoordinates();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Package> toPackages(Collection<UnifiedCoordinates> allCoordinates) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = allCoordinates;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            String version;
            String artifactId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UnifiedCoordinates it = (UnifiedCoordinates)element$iv$iv;
            boolean bl2 = false;
            if ((it.getArtifactId() == null ? null : (it.getVersion() == null ? null : Package.Companion.create(this.project, PackageType.maven, it.getGroupId(), artifactId, version))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final PsiElement collectDependencies$lambda$1$lambda$0(MavenProjectDependenciesModel this$0, VirtualFile f, Module m, Package p) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this$0.findPackageDeclaration(f, m, p);
    }

    private static final CharSequence importFinished$lambda$4(MavenProject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDisplayName();
    }

    private static final Module getAllModules$lambda$6$lambda$5(MavenProject $mavenProject, MavenProjectDependenciesModel this$0) {
        if (!$mavenProject.getFile().isValid()) {
            return null;
        }
        return ProjectFileIndex.getInstance((Project)this$0.project).getModuleForFile($mavenProject.getFile());
    }

    private static final boolean scanProjectLibraries$lambda$7(MavenProjectDependenciesModel this$0, Set $allCoordinates, Library lib) {
        Intrinsics.checkNotNull((Object)lib);
        MavenCoordinates gav = this$0.getMavenCoordinates(lib);
        if (gav != null) {
            $allCoordinates.add(new UnifiedCoordinates(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()));
        }
        return true;
    }

    private static final boolean scanProjectLibraries$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

