/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.run;

import com.google.common.net.HostAndPort;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.django.DjangoRunnerUtilsKt;
import com.intellij.python.django.run.DjangoServerRunCommandLineState;
import com.intellij.python.django.run.DjangoServerRunConfigurationEditor;
import com.intellij.python.django.run.DjangoServerRunConfigurationFragmentedEditor;
import com.intellij.python.django.run.EditDjangoSettingsFix;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.run.AbstractServerPythonRunConfiguration;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DjangoServerRunConfiguration
extends AbstractServerPythonRunConfiguration<DjangoServerRunConfiguration> {
    @NonNls
    private static final String ATTR_PORT = "port";
    @NonNls
    private static final String ATTR_HOST = "host";
    @NonNls
    private static final String ATTR_ADDITIONAL_OPTIONS = "additionalOptions";
    @NonNls
    private static final String ATTR_BROWSER_URL = "browserUrl";
    @NonNls
    private static final String RUN_TEST_SERVER = "runTestServer";
    @NonNls
    private static final String RUN_NO_RELOAD = "runNoReload";
    @NonNls
    private static final String ATTR_USE_CUSTOM_RUN_COMMAND = "useCustomRunCommand";
    @NonNls
    private static final String ATTR_CUSTOM_RUN_COMMAND = "customRunCommand";
    private Integer myPort = 8000;
    private String myHost = "";
    private String myAdditionalOptions = "";
    private String myBrowserUrl = null;
    private boolean myRunTestServer = false;
    private boolean myRunNoReload = false;
    private boolean myUseCustomRunCommand = false;
    private String myCustomRunCommand = "";

    public DjangoServerRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.setUnbufferedEnv();
    }

    public List<Module> getValidModules() {
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : super.getValidModules()) {
            if (!DjangoFacet.isPresent((Module)module)) continue;
            result.add(module);
        }
        return result;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Module module;
        if (executor == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(1);
        }
        if ((module = this.getConfigurationModule().getModule()) == null || !DjangoFacet.isPresent((Module)module)) {
            throw new ExecutionException(DjangoBundle.message((String)"django.please.select.django.module", (Object[])new Object[0]));
        }
        if (this.isUseCustomRunCommand() && this.getCustomRunCommand().trim().isEmpty()) {
            throw new ExecutionException(DjangoBundle.message((String)"django.please.specify.run.command", (Object[])new Object[0]));
        }
        return new DjangoServerRunCommandLineState(this, env);
    }

    protected SettingsEditor<DjangoServerRunConfiguration> createConfigurationEditor() {
        if (Registry.is((String)"django.new.run.config", (boolean)false)) {
            return new DjangoServerRunConfigurationFragmentedEditor(this);
        }
        return new DjangoServerRunConfigurationEditor(this);
    }

    protected boolean isNewUiSupported() {
        return Registry.is((String)"django.new.run.config", (boolean)false);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        String s = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_PORT);
        this.myPort = !StringUtil.isEmpty((String)s) ? Integer.valueOf(Integer.parseInt(s)) : null;
        this.myHost = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_HOST);
        this.myAdditionalOptions = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS);
        String url = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_BROWSER_URL);
        s = JDOMExternalizerUtil.readField((Element)element, (String)RUN_TEST_SERVER);
        this.myRunTestServer = !StringUtil.isEmpty((String)s) ? Boolean.parseBoolean(s) : false;
        s = JDOMExternalizerUtil.readField((Element)element, (String)RUN_NO_RELOAD);
        this.myRunNoReload = !StringUtil.isEmpty((String)s) ? Boolean.parseBoolean(s) : false;
        this.myBrowserUrl = url != null && !url.isEmpty() ? url : null;
        this.myCustomRunCommand = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_CUSTOM_RUN_COMMAND);
        this.myUseCustomRunCommand = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)ATTR_USE_CUSTOM_RUN_COMMAND));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        if (this.myPort != null) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_PORT, (String)Integer.toString(this.myPort));
        }
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_HOST, (String)this.myHost);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS, (String)this.myAdditionalOptions);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_BROWSER_URL, (String)this.myBrowserUrl);
        JDOMExternalizerUtil.writeField((Element)element, (String)RUN_TEST_SERVER, (String)Boolean.toString(this.myRunTestServer));
        JDOMExternalizerUtil.writeField((Element)element, (String)RUN_NO_RELOAD, (String)Boolean.toString(this.myRunNoReload));
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_USE_CUSTOM_RUN_COMMAND, (String)Boolean.toString(this.myUseCustomRunCommand));
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_CUSTOM_RUN_COMMAND, (String)this.myCustomRunCommand);
    }

    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdkHome) {
        if (StringUtil.isNotEmpty((String)this.myHost) && this.myPort != null) {
            commandLine.putUserData(PyRemoteProcessStarter.WEB_SERVER_HOST_AND_PORT, (Object)HostAndPort.fromParts((String)this.myHost, (int)this.myPort));
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        VirtualFile projectRoot;
        Module module = this.getConfigurationModule().getModule();
        if (module == null || !DjangoFacet.isPresent((Module)module)) {
            DjangoRunnerUtilsKt.reportNoDjangoOnModule(this.getProject());
            return;
        }
        if (this.isUseCustomRunCommand() && this.getCustomRunCommand().trim().isEmpty()) {
            throw new RuntimeConfigurationError(DjangoBundle.message((String)"django.please.specify.run.command", (Object[])new Object[0]));
        }
        if (this.getPort() != null && (this.getPort() < 0 || this.getPort() > 65535)) {
            throw new RuntimeConfigurationError(DjangoBundle.message((String)"django.port.number.is.not.within.acceptable.range", (Object[])new Object[0]));
        }
        String projectRootString = DjangoUtil.getProjectRoot((Module)module);
        if (projectRootString != null && (projectRoot = VirtualFileUtil.findFile((String)projectRootString)) == null) {
            RuntimeConfigurationError exc = new RuntimeConfigurationError(DjangoBundle.message((String)"django.project.root.not.configured", (Object[])new Object[0]));
            if (PlatformUtils.isPyCharm()) {
                exc.setQuickFix((ConfigurationQuickFix)new EditDjangoSettingsFix(this.getProject()));
            }
            throw exc;
        }
        if (!DjangoServerRunConfiguration.isRemoteSdkSelected(this.getInterpreterPath()) && !DjangoUtil.isDjangoAvailable((Module)module, (String)this.getInterpreterPath())) {
            throw new RuntimeConfigurationError(DjangoBundle.message((String)"django.is.not.importable.in.this.environment", (Object[])new Object[0]));
        }
    }

    public boolean canRunWithCoverage() {
        return false;
    }

    public static boolean isRemoteSdkSelected(String sdkHome) {
        Sdk sdk = PythonSdkUtil.findSdkByPath((String)sdkHome);
        return PythonSdkUtil.isRemote((Sdk)sdk);
    }

    public boolean isRunNoReload() {
        return this.myRunNoReload;
    }

    public void setRunNoReload(boolean runNoReload) {
        this.myRunNoReload = runNoReload;
        if (runNoReload) {
            this.myRunTestServer = false;
        }
    }

    public Integer getPort() {
        return this.myPort;
    }

    public void setPort(Integer port) {
        this.myPort = port;
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    public String getAdditionalOptions() {
        return this.myAdditionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.myAdditionalOptions = additionalOptions;
    }

    public String getBrowserUrl() {
        return this.myBrowserUrl;
    }

    public void setBrowserUrl(String browserUrl) {
        this.myBrowserUrl = browserUrl;
        if (this.myBrowserUrl == null || this.myBrowserUrl.isEmpty()) {
            this.setLaunchJavascriptDebugger(false);
        }
    }

    public boolean isRunTestServer() {
        return this.myRunTestServer;
    }

    public void setRunTestServer(boolean runTestServer) {
        this.myRunTestServer = runTestServer;
        if (runTestServer) {
            this.myCustomRunCommand = "";
            this.myUseCustomRunCommand = false;
            this.myRunNoReload = false;
        }
    }

    public boolean isUseCustomRunCommand() {
        return this.myUseCustomRunCommand;
    }

    public void setUseCustomRunCommand(boolean useCustomRunCommand) {
        this.myUseCustomRunCommand = useCustomRunCommand;
        if (useCustomRunCommand) {
            this.myRunTestServer = false;
        }
    }

    public String getCustomRunCommand() {
        return this.myCustomRunCommand;
    }

    public void setCustomRunCommand(String customRunCommand) {
        this.myCustomRunCommand = customRunCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/run/DjangoServerRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

