/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.codeInsight.djangoForms;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.python.django.codeInsight.djangoForms.DjangoFormFieldReference;
import com.intellij.python.django.codeInsight.djangoForms.DjangoFormWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoFormsReferenceProvider
extends PsiReferenceProvider {
    public static final PsiReferenceProvider INSTANCE = new DjangoFormsReferenceProvider();

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(0);
        }
        return target instanceof PyTargetExpression;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(2);
        }
        TypeEvalContext evalContext = TypeEvalContext.codeAnalysis((Project)element.getParent().getProject(), (PsiFile)element.getContainingFile());
        if (!(element instanceof StringLiteralExpression)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoFormsReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        StringLiteralExpression elementStringLiteral = (StringLiteralExpression)element;
        String stringValue = elementStringLiteral.getStringValue();
        if (stringValue.trim().contains(" ")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoFormsReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<Boolean, PyTypedElement> fieldsAndPossibleForm = DjangoFormsReferenceProvider.getReferenceForCleanedDataOrForm(elementStringLiteral, evalContext);
        if (fieldsAndPossibleForm == null) {
            fieldsAndPossibleForm = DjangoFormsReferenceProvider.getReferenceForMetaFields(elementStringLiteral, evalContext);
        }
        if (fieldsAndPossibleForm == null) {
            fieldsAndPossibleForm = DjangoFormsReferenceProvider.getReferenceForInitialFields(elementStringLiteral, evalContext);
        }
        if (fieldsAndPossibleForm != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new DjangoFormFieldReference(elementStringLiteral, (Boolean)fieldsAndPossibleForm.first, (PyTypedElement)fieldsAndPossibleForm.second, evalContext)};
            if (psiReferenceArray == null) {
                DjangoFormsReferenceProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    private static Pair<Boolean, PyTypedElement> getReferenceForInitialFields(@NotNull StringLiteralExpression literal, @NotNull TypeEvalContext context) {
        if (literal == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(7);
        }
        if (context == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(8);
        }
        if (!DjangoFormsReferenceProvider.isDictWithFieldKeys((PsiElement)literal)) {
            return null;
        }
        PyArgumentList argumentList = (PyArgumentList)new PsiQuery((PsiElement)literal).ancestors(PyKeywordArgument.class).ancestors(PyArgumentList.class).getFirstElement();
        if (argumentList == null) {
            return null;
        }
        PyCallExpression callExpression = argumentList.getCallExpression();
        if (callExpression == null) {
            return null;
        }
        PyExpression callee = callExpression.getCallee();
        if (callee == null) {
            return null;
        }
        if (!DjangoFormsReferenceProvider.isForm(context, (PyTypedElement)callee)) {
            return null;
        }
        return Pair.create((Object)true, (Object)callee);
    }

    @Nullable
    private static Pair<Boolean, PyTypedElement> getReferenceForMetaFields(@NotNull StringLiteralExpression element, @NotNull TypeEvalContext evalContext) {
        Pair fieldAndClass;
        if (element == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(9);
        }
        if (evalContext == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(10);
        }
        if ((fieldAndClass = DjangoFormWrapper.getFromBinding(o -> o.getFormFieldForLiteral(element, evalContext))) == null) {
            return null;
        }
        String fieldName = (String)fieldAndClass.first;
        PyTypedElement possibleForm = (PyTypedElement)fieldAndClass.second;
        boolean fieldsBasedFields = Arrays.asList(DjangoFormWrapper.FIELD_BASED_META_FIELDS).contains(fieldName);
        boolean dictWithFieldKeys = DjangoFormsReferenceProvider.isMetaFieldDictWithFieldKeys((PsiElement)element, fieldName);
        if (!fieldsBasedFields && !dictWithFieldKeys) {
            return null;
        }
        DjangoFormWrapper form = DjangoFormWrapper.getInstanceIfForm(possibleForm, evalContext);
        if (form == null) {
            return null;
        }
        if ("localized_fields".equals(fieldName) || dictWithFieldKeys) {
            return Pair.create((Object)true, (Object)possibleForm);
        }
        return Pair.create((Object)false, (Object)possibleForm);
    }

    private static boolean isMetaFieldDictWithFieldKeys(@NotNull PsiElement psiElement, @NotNull String fieldName) {
        if (psiElement == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(11);
        }
        if (fieldName == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(12);
        }
        if (!Arrays.asList(DjangoFormWrapper.META_FIELDS_DICT_FIELD_KEY).contains(fieldName)) {
            return false;
        }
        return DjangoFormsReferenceProvider.isDictWithFieldKeys(psiElement);
    }

    private static boolean isDictWithFieldKeys(@NotNull PsiElement psiElement) {
        PsiElement parentExpression;
        if (psiElement == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(13);
        }
        if ((parentExpression = psiElement.getParent()) instanceof PyKeyValueExpression) {
            PyKeyValueExpression keyValueExpression = (PyKeyValueExpression)parentExpression;
            return keyValueExpression.getKey().equals(psiElement);
        }
        if (parentExpression instanceof PyDictLiteralExpression) {
            return true;
        }
        return parentExpression instanceof PySetLiteralExpression && parentExpression.getChildren().length == 1;
    }

    @Nullable
    private static Pair<Boolean, PyTypedElement> getReferenceForCleanedDataOrForm(@NotNull StringLiteralExpression element, @NotNull TypeEvalContext evalContext) {
        PyExpression possibleForm;
        PsiElement parent;
        if (element == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(14);
        }
        if (evalContext == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(15);
        }
        if ((parent = element.getParent()) instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpression = (PySubscriptionExpression)parent;
            possibleForm = DjangoFormsReferenceProvider.getPossibleFormFromSubscription(subscriptionExpression);
        } else if (parent instanceof PyArgumentList) {
            PyArgumentList argumentList = (PyArgumentList)parent;
            possibleForm = DjangoFormsReferenceProvider.getPossibleFormFromCall(argumentList, element);
        } else {
            return null;
        }
        if (possibleForm == null) {
            return null;
        }
        if (!DjangoFormsReferenceProvider.isForm(evalContext, (PyTypedElement)possibleForm)) {
            return null;
        }
        return Pair.create((Object)true, (Object)possibleForm);
    }

    @Nullable
    private static PyExpression getPossibleFormFromCall(@NotNull PyArgumentList argumentList, @NotNull StringLiteralExpression literalToAddReference) {
        PyExpression[] arguments;
        if (argumentList == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(16);
        }
        if (literalToAddReference == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(17);
        }
        if ((arguments = argumentList.getArguments()).length <= 0 || !arguments[0].equals(literalToAddReference)) {
            return null;
        }
        PyCallExpression callExpression = argumentList.getCallExpression();
        if (callExpression == null) {
            return null;
        }
        PyReferenceExpression callee = (PyReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getCallee(), PyReferenceExpression.class);
        if (callee == null || !"add_error".equals(callee.getName())) {
            return null;
        }
        return callee.getQualifier();
    }

    @Nullable
    private static PyExpression getPossibleFormFromSubscription(@NotNull PySubscriptionExpression subscriptionExpression) {
        PyExpression rootOperand;
        if (subscriptionExpression == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(18);
        }
        if (ArrayUtil.contains((String)(rootOperand = subscriptionExpression.getRootOperand()).getName(), (String[])DjangoFormWrapper.FIELD_BASED_FORM_FIELDS)) {
            if (!(rootOperand instanceof PyQualifiedExpression)) {
                return null;
            }
            PyExpression qualifier = ((PyQualifiedExpression)rootOperand).getQualifier();
            if (qualifier == null) {
                return null;
            }
            return qualifier;
        }
        return rootOperand;
    }

    static boolean isForm(@NotNull TypeEvalContext evalContext, @NotNull PyTypedElement possibleForm) {
        if (evalContext == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(19);
        }
        if (possibleForm == null) {
            DjangoFormsReferenceProvider.$$$reportNull$$$0(20);
        }
        return DjangoFormWrapper.getFormWrapper(evalContext, possibleForm) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/codeInsight/djangoForms/DjangoFormsReferenceProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalToAddReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subscriptionExpression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/codeInsight/djangoForms/DjangoFormsReferenceProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceForInitialFields";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceForMetaFields";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMetaFieldDictWithFieldKeys";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDictWithFieldKeys";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceForCleanedDataOrForm";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFormFromCall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFormFromSubscription";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isForm";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

