/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.platform.a11y;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.platform.a11y.AccessibilityController;
import androidx.compose.ui.platform.a11y.ProgressBarAccessibleValue;
import androidx.compose.ui.platform.a11y.RadioButtonAccessibleValue;
import androidx.compose.ui.platform.a11y.ToggleableAccessibleValue;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.ProgressBarRangeInfo;
import androidx.compose.ui.semantics.Role;
import androidx.compose.ui.semantics.ScrollAxisRange;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.state.ToggleableState;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.accessibility.AccessibleValue;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.BreakIterator;
import org.jetbrains.skiko.HardwareLayerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\t\u0010\u0013\u001a\u00020\u0014X\u0082\u0004R\u001f\u0010\u0015\u001a\u00060\u0016R\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/Accessible;", "Ljava/awt/Component;", "semanticsNode", "Landroidx/compose/ui/semantics/SemanticsNode;", "controller", "Landroidx/compose/ui/platform/a11y/AccessibilityController;", "<init>", "(Landroidx/compose/ui/semantics/SemanticsNode;Landroidx/compose/ui/platform/a11y/AccessibilityController;)V", "value", "getSemanticsNode", "()Landroidx/compose/ui/semantics/SemanticsNode;", "setSemanticsNode", "(Landroidx/compose/ui/semantics/SemanticsNode;)V", "cachedSemanticsConfig", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "semanticsConfig", "getSemanticsConfig", "()Landroidx/compose/ui/semantics/SemanticsConfiguration;", "isNativelyInitialized", "Lkotlinx/atomicfu/AtomicBoolean;", "composeAccessibleContext", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "getComposeAccessibleContext", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "composeAccessibleContext$delegate", "Lkotlin/Lazy;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "ComposeAccessibleComponent", "ui"})
@StabilityInferred(parameters=0)
public final class ComposeAccessible
extends Component
implements Accessible {
    @NotNull
    private final AccessibilityController controller;
    @NotNull
    private SemanticsNode semanticsNode;
    @Nullable
    private SemanticsConfiguration cachedSemanticsConfig;
    private volatile /* synthetic */ int isNativelyInitialized$volatile;
    @NotNull
    private final Lazy composeAccessibleContext$delegate;
    private boolean removed;
    private static final /* synthetic */ AtomicIntegerFieldUpdater isNativelyInitialized$volatile$FU;
    public static final int $stable;

    public ComposeAccessible(@NotNull SemanticsNode semanticsNode, @NotNull AccessibilityController controller) {
        Intrinsics.checkNotNullParameter((Object)semanticsNode, (String)"semanticsNode");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.controller = controller;
        this.semanticsNode = semanticsNode;
        this.composeAccessibleContext$delegate = LazyKt.lazy(() -> ComposeAccessible.composeAccessibleContext_delegate$lambda$1(this));
    }

    @NotNull
    public final SemanticsNode getSemanticsNode() {
        return this.semanticsNode;
    }

    public final void setSemanticsNode(@NotNull SemanticsNode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.semanticsNode = value;
        this.cachedSemanticsConfig = null;
    }

    private final SemanticsConfiguration getSemanticsConfig() {
        SemanticsConfiguration semanticsConfiguration = this.cachedSemanticsConfig;
        if (semanticsConfiguration == null) {
            SemanticsConfiguration semanticsConfiguration2;
            SemanticsConfiguration it = semanticsConfiguration2 = this.semanticsNode.getConfig();
            boolean bl = false;
            this.cachedSemanticsConfig = it;
            semanticsConfiguration = semanticsConfiguration2;
        }
        return semanticsConfiguration;
    }

    private final /* synthetic */ int isNativelyInitialized$volatile() {
        return this.isNativelyInitialized$volatile;
    }

    private final /* synthetic */ void setNativelyInitialized$volatile(int value) {
        this.isNativelyInitialized$volatile = value;
    }

    @NotNull
    public final ComposeAccessibleComponent getComposeAccessibleContext() {
        Lazy lazy = this.composeAccessibleContext$delegate;
        return (ComposeAccessibleComponent)lazy.getValue();
    }

    public final boolean getRemoved() {
        return this.removed;
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    @Nullable
    public AccessibleContext getAccessibleContext() {
        if (this.removed) {
            return null;
        }
        if (ComposeAccessible.isNativelyInitialized$volatile$FU.compareAndSet(this, 0, 1)) {
            HardwareLayerKt.nativeInitializeAccessible((Accessible)this);
        }
        return this.getComposeAccessibleContext();
    }

    private static final ComposeAccessibleComponent composeAccessibleContext_delegate$lambda$1(ComposeAccessible this$0) {
        return this$0.new ComposeAccessibleComponent();
    }

    static {
        isNativelyInitialized$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(ComposeAccessible.class, "isNativelyInitialized$volatile");
        $stable = 8;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0006\u00a8\u0001\u00a9\u0001\u00aa\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020\u000eH\u0002J\u0013\u0010G\u001a\u00020H*\u00020IH\u0002\u00a2\u0006\u0004\bJ\u0010KJ\u0013\u0010L\u001a\u00020\u0013*\u00020MH\u0002\u00a2\u0006\u0004\bN\u0010OJ\f\u0010P\u001a\u00020Q*\u00020RH\u0002J\u0013\u0010S\u001a\u00020I*\u00020HH\u0002\u00a2\u0006\u0004\bT\u0010UJ\u0013\u0010V\u001a\u00020W*\u00020XH\u0002\u00a2\u0006\u0004\bY\u0010ZJ\n\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\n\u0010]\u001a\u0004\u0018\u00010\\H\u0016J\n\u0010^\u001a\u0004\u0018\u00010<H\u0016J\n\u0010_\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010a\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010b\u001a\u0004\u0018\u00010cH\u0016J\b\u0010d\u001a\u00020\u0013H\u0016J\b\u0010e\u001a\u00020\u0013H\u0016J\u0012\u0010f\u001a\u0004\u0018\u00010<2\u0006\u0010g\u001a\u00020\u0013H\u0016J\b\u0010h\u001a\u00020iH\u0016J\b\u0010j\u001a\u00020IH\u0016J\b\u0010k\u001a\u00020IH\u0016J\b\u0010l\u001a\u00020QH\u0016J\b\u0010m\u001a\u00020WH\u0016J\b\u0010n\u001a\u00020\u000eH\u0016J\b\u0010o\u001a\u00020\u000eH\u0016J\b\u0010p\u001a\u00020\u000eH\u0016J\u0011\u0010q\u001a\u00020\u000e2\u0006\u0010r\u001a\u00020IH\u0096\u0002J\u0012\u0010s\u001a\u0004\u0018\u00010<2\u0006\u0010r\u001a\u00020IH\u0016J\b\u0010t\u001a\u00020\u000eH\u0016J\b\u0010u\u001a\u00020vH\u0016J\u0012\u0010w\u001a\u00020v2\b\u0010x\u001a\u0004\u0018\u00010yH\u0016J\u0012\u0010z\u001a\u00020v2\b\u0010x\u001a\u0004\u0018\u00010yH\u0016J\b\u0010{\u001a\u00020|H\u0016J\b\u0010}\u001a\u00020~H\u0016J\f\u0010\u007f\u001a\u00020v*\u00020~H\u0002J\r\u0010\u0080\u0001\u001a\u00020v*\u00020~H\u0002J\r\u0010\u0081\u0001\u001a\u00020v*\u00020~H\u0002J\f\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0089\u0001H\u0016J\f\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016J\u0014\u0010\u008c\u0001\u001a\u00020v2\t\u0010\u008d\u0001\u001a\u0004\u0018\u00010QH\u0016J\u0014\u0010\u008e\u0001\u001a\u00020v2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010WH\u0016J\u0013\u0010\u0090\u0001\u001a\u00020v2\b\u0010r\u001a\u0004\u0018\u00010IH\u0016J\n\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0016J\u0015\u0010\u0093\u0001\u001a\u00020v2\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016J\n\u0010\u0095\u0001\u001a\u00030\u0092\u0001H\u0016J\u0015\u0010\u0096\u0001\u001a\u00020v2\n\u0010\u0094\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016J\n\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0016J\u0015\u0010\u0099\u0001\u001a\u00020v2\n\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0098\u0001H\u0016J\n\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0016J\u0015\u0010\u009d\u0001\u001a\u00020v2\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009c\u0001H\u0016J\u0016\u0010\u009f\u0001\u001a\u00030\u00a0\u00012\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009c\u0001H\u0016J\u0012\u0010\u00a1\u0001\u001a\u00020v2\u0007\u0010\u00a2\u0001\u001a\u00020\u000eH\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020v2\u0007\u0010\u00a2\u0001\u001a\u00020\u000eH\u0016J\t\u0010\u00a4\u0001\u001a\u00020\u0013H\u0016J\u0011\u0010\u00a5\u0001\u001a\u00020\\2\u0006\u0010g\u001a\u00020\u0013H\u0016J\u0011\u0010\u00a6\u0001\u001a\u00020\u000e2\u0006\u0010g\u001a\u00020\u0013H\u0016J\u0013\u0010\u00a7\u0001\u001a\u00020\\*\b\u0012\u0004\u0012\u00020\u00160;H\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR%\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R1\u0010\u0011\u001a\"\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0013\u0010*\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)RI\u0010,\u001a:\u00124\u00122\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(1\u0012\u0013\u0012\u00110.\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u000e0-\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0010R\u0011\u00104\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0013\u0010?\u001a\u0004\u0018\u00010@8F\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0013\u0010C\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u001fR\u0013\u0010D\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001fR\u0010\u0010`\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\u0082\u0001\u001a\u000e\u0018\u00010\u0083\u0001R\u00070\u0000R\u00030\u0084\u00018BX\u0082\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u0087\u0001\u0010\u0088\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\u00a8\u0006\u00ab\u0001"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Ljavax/accessibility/AccessibleContext;", "Ljavax/accessibility/AccessibleComponent;", "Ljavax/accessibility/AccessibleAction;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible;)V", "textSelectionRange", "Landroidx/compose/ui/text/TextRange;", "getTextSelectionRange-MzsxiRA", "()Landroidx/compose/ui/text/TextRange;", "setText", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function1;", "Landroidx/compose/ui/text/AnnotatedString;", "", "getSetText", "()Landroidx/compose/ui/semantics/AccessibilityAction;", "setSelection", "Lkotlin/Function3;", "", "getSetSelection", "text", "", "getText", "()Ljava/lang/CharSequence;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "getTextLayoutResult", "()Landroidx/compose/ui/text/TextLayoutResult;", "focused", "getFocused", "()Ljava/lang/Boolean;", "selected", "getSelected", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "horizontalScroll", "Landroidx/compose/ui/semantics/ScrollAxisRange;", "getHorizontalScroll", "()Landroidx/compose/ui/semantics/ScrollAxisRange;", "verticalScroll", "getVerticalScroll", "scrollBy", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "x", "y", "getScrollBy", "isPassword", "()Z", "toggleableState", "Landroidx/compose/ui/state/ToggleableState;", "getToggleableState", "()Landroidx/compose/ui/state/ToggleableState;", "auxiliaryChildren", "", "Ljavax/accessibility/Accessible;", "getAuxiliaryChildren", "()Ljava/util/List;", "progressBarRangeInfo", "Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "getProgressBarRangeInfo", "()Landroidx/compose/ui/semantics/ProgressBarRangeInfo;", "isContainer", "isTraversalGroup", "makeScrollbarChild", "vertical", "toComposeOffset", "Landroidx/compose/ui/geometry/Offset;", "Ljava/awt/Point;", "toComposeOffset-tuRUvjQ", "(Ljava/awt/Point;)J", "toAwtPx", "Landroidx/compose/ui/unit/Dp;", "toAwtPx-0680j_4", "(F)I", "toAwtRectangle", "Ljava/awt/Rectangle;", "Landroidx/compose/ui/geometry/Rect;", "toAwtPoint", "toAwtPoint-k-4lQ0M", "(J)Ljava/awt/Point;", "toAwtDimension", "Ljava/awt/Dimension;", "Landroidx/compose/ui/unit/IntSize;", "toAwtDimension-ozmzZPI", "(J)Ljava/awt/Dimension;", "getAccessibleName", "", "getAccessibleDescription", "getAccessibleParent", "getAccessibleComponent", "accessibleAction", "getAccessibleAction", "getAccessibleValue", "Ljavax/accessibility/AccessibleValue;", "getAccessibleIndexInParent", "getAccessibleChildrenCount", "getAccessibleChild", "i", "getLocale", "Ljava/util/Locale;", "getLocationOnScreen", "getLocation", "getBounds", "getSize", "isVisible", "isEnabled", "isShowing", "contains", "p", "getAccessibleAt", "isFocusTraversable", "requestFocus", "", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "removeFocusListener", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "addCheckedStateForCheckboxOrSwitch", "addCheckedStateForRadioButton", "addDefaultStateForToggleableState", "accessibleText", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "getAccessibleText", "()Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "accessibleText$delegate", "Lkotlin/Lazy;", "Ljavax/accessibility/AccessibleText;", "getAccessibleEditableText", "Ljavax/accessibility/AccessibleEditableText;", "setBounds", "r", "setSize", "d", "setLocation", "getBackground", "Ljava/awt/Color;", "setBackground", "c", "getForeground", "setForeground", "getCursor", "Ljava/awt/Cursor;", "setCursor", "cursor", "getFont", "Ljava/awt/Font;", "setFont", "f", "getFontMetrics", "Ljava/awt/FontMetrics;", "setEnabled", "b", "setVisible", "getAccessibleActionCount", "getAccessibleActionDescription", "doAccessibleAction", "mergeText", "ComposeAccessibleText", "ScrollBarAccessible", "ComposeAccessibleEditableText", "ui"})
    @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Rect.kt\nandroidx/compose/ui/geometry/Rect\n+ 6 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 8 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 9 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 10 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 11 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,936:1\n113#2:937\n30#3:938\n53#4,3:939\n60#4:945\n70#4:948\n85#4:951\n90#4:953\n57#5:942\n62#5:943\n65#6:944\n69#6:947\n22#7:946\n22#7:949\n54#8:950\n59#8:952\n360#9,7:954\n90#10:961\n1#11:962\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent\n*L\n217#1:937\n217#1:938\n217#1:939,3\n234#1:945\n235#1:948\n241#1:951\n242#1:953\n227#1:942\n228#1:943\n234#1:944\n235#1:947\n234#1:946\n235#1:949\n241#1:950\n242#1:952\n323#1:954,7\n359#1:961\n*E\n"})
    public class ComposeAccessibleComponent
    extends AccessibleContext
    implements AccessibleComponent,
    AccessibleAction {
        @Nullable
        private AccessibleAction accessibleAction;
        @NotNull
        private final Lazy accessibleText$delegate = LazyKt.lazy(() -> ComposeAccessibleComponent.accessibleText_delegate$lambda$14(this));

        @Nullable
        public final TextRange getTextSelectionRange-MzsxiRA() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getTextSelectionRange());
        }

        @Nullable
        public final AccessibilityAction<Function1<AnnotatedString, Boolean>> getSetText() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetText());
        }

        @Nullable
        public final AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> getSetSelection() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getSetSelection());
        }

        @Nullable
        public final CharSequence getText() {
            CharSequence charSequence;
            AnnotatedString annotatedString = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getEditableText());
            if (annotatedString != null) {
                charSequence = annotatedString;
            } else {
                List<AnnotatedString> list2 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getText());
                charSequence = list2 != null ? this.mergeText(list2) : null;
            }
            return charSequence;
        }

        @Nullable
        public final TextLayoutResult getTextLayoutResult() {
            Function1<List<TextLayoutResult>, Boolean> function1;
            List textLayoutResults = new ArrayList();
            AccessibilityAction<Function1<List<TextLayoutResult>, Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getGetTextLayoutResult());
            Boolean getLayoutResult = accessibilityAction != null && (function1 = accessibilityAction.getAction()) != null ? (Boolean)function1.invoke((Object)textLayoutResults) : null;
            return Intrinsics.areEqual(getLayoutResult, (Object)true) ? (TextLayoutResult)textLayoutResults.get(0) : null;
        }

        @Nullable
        public final Boolean getFocused() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getFocused());
        }

        @Nullable
        public final Boolean getSelected() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getSelected());
        }

        private final Density getDensity() {
            return ComposeAccessible.this.controller.getDesktopComponent().getDensity();
        }

        @Nullable
        public final ScrollAxisRange getHorizontalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getHorizontalScrollAxisRange());
        }

        @Nullable
        public final ScrollAxisRange getVerticalScroll() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getVerticalScrollAxisRange());
        }

        @Nullable
        public final AccessibilityAction<Function2<Float, Float, Boolean>> getScrollBy() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getScrollBy());
        }

        public final boolean isPassword() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getPassword()) != null;
        }

        @Nullable
        public final ToggleableState getToggleableState() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getToggleableState());
        }

        @NotNull
        public final List<Accessible> getAuxiliaryChildren() {
            List list2;
            block1: {
                ScrollAxisRange it;
                List $this$_get_auxiliaryChildren__u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                ScrollAxisRange scrollAxisRange = this.getHorizontalScroll();
                if (scrollAxisRange != null) {
                    it = scrollAxisRange;
                    boolean bl2 = false;
                    $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(false));
                }
                ScrollAxisRange scrollAxisRange2 = this.getVerticalScroll();
                if (scrollAxisRange2 == null) break block1;
                it = scrollAxisRange2;
                boolean bl3 = false;
                $this$_get_auxiliaryChildren__u24lambda_u242.add(this.makeScrollbarChild(true));
            }
            return CollectionsKt.build((List)list2);
        }

        @Nullable
        public final ProgressBarRangeInfo getProgressBarRangeInfo() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getProgressBarRangeInfo());
        }

        @Nullable
        public final Boolean isContainer() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsContainer());
        }

        @Nullable
        public final Boolean isTraversalGroup() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getIsTraversalGroup());
        }

        private final Accessible makeScrollbarChild(boolean vertical) {
            ScrollBarAccessible bar = new ScrollBarAccessible(vertical);
            AccessibleRelation controlledBy = new AccessibleRelation(AccessibleRelation.CONTROLLED_BY, bar);
            AccessibleRelation controllerFor = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, ComposeAccessible.this);
            bar.getContext().getAccessibleRelationSet().add(controllerFor);
            this.getAccessibleRelationSet().add(controlledBy);
            return bar;
        }

        /*
         * WARNING - void declaration
         */
        private final long toComposeOffset-tuRUvjQ(Point $this$toComposeOffset_u2dtuRUvjQ) {
            void x$iv;
            Density $this$toComposeOffset_tuRUvjQ_u24lambda_u243 = this.getDensity();
            boolean bl = false;
            int $this$dp$iv22 = $this$toComposeOffset_u2dtuRUvjQ.x;
            boolean $i$f$getDp = false;
            float $this$dp$iv22 = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv22));
            int $this$dp$iv = $this$toComposeOffset_u2dtuRUvjQ.y;
            boolean $i$f$getDp2 = false;
            float y$iv = $this$toComposeOffset_tuRUvjQ_u24lambda_u243.toPx-0680j_4(Dp.constructor-impl($this$dp$iv));
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            return Offset.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        }

        private final int toAwtPx-0680j_4(float $this$toAwtPx_u2d0680j_4) {
            return Float.isInfinite($this$toAwtPx_u2d0680j_4) ? Integer.MAX_VALUE : MathKt.roundToInt((float)$this$toAwtPx_u2d0680j_4);
        }

        private final Rectangle toAwtRectangle(Rect $this$toAwtRectangle) {
            Density $this$toAwtRectangle_u24lambda_u244 = this.getDensity();
            boolean bl = false;
            Rect this_$iv = $this$toAwtRectangle;
            boolean $i$f$getWidth = false;
            int n = this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getRight() - this_$iv.getLeft()));
            this_$iv = $this$toAwtRectangle;
            boolean $i$f$getHeight = false;
            return new Rectangle(this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getLeft())), this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM($this$toAwtRectangle.getTop())), n, this.toAwtPx-0680j_4($this$toAwtRectangle_u24lambda_u244.toDp-u2uoSUM(this_$iv.getBottom() - this_$iv.getTop())));
        }

        private final Point toAwtPoint-k-4lQ0M(long $this$toAwtPoint_u2dk_u2d4lQ0M) {
            Density $this$toAwtPoint_k_4lQ0M_u24lambda_u245 = this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv = $this$toAwtPoint_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            int n = this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv)));
            boolean bl3 = false;
            value$iv$iv = $this$toAwtPoint_u2dk_u2d4lQ0M;
            boolean $i$f$unpackFloat2 = false;
            bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
            $i$f$floatFromBits = false;
            return new Point(n, this.toAwtPx-0680j_4($this$toAwtPoint_k_4lQ0M_u24lambda_u245.toDp-u2uoSUM(Float.intBitsToFloat(bits$iv$iv$iv))));
        }

        private final Dimension toAwtDimension-ozmzZPI(long $this$toAwtDimension_u2dozmzZPI) {
            Density $this$toAwtDimension_ozmzZPI_u24lambda_u246 = this.getDensity();
            boolean bl = false;
            boolean bl2 = false;
            long value$iv$iv = $this$toAwtDimension_u2dozmzZPI;
            boolean $i$f$unpackInt1 = false;
            int n = this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(value$iv$iv >> 32)));
            boolean bl3 = false;
            value$iv$iv = $this$toAwtDimension_u2dozmzZPI;
            boolean $i$f$unpackInt2 = false;
            return new Dimension(n, this.toAwtPx-0680j_4($this$toAwtDimension_ozmzZPI_u24lambda_u246.toDp-u2uoSUM((int)(value$iv$iv & 0xFFFFFFFFL))));
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            CharSequence charSequence = this.getText();
            return charSequence != null ? ((Object)charSequence).toString() : null;
        }

        @Override
        @Nullable
        public String getAccessibleDescription() {
            List<String> list2 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getContentDescription());
            return list2 != null ? this.mergeText(list2) : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @Nullable
        public Accessible getAccessibleParent() {
            Accessible accessible;
            Object object = ComposeAccessible.this.getSemanticsNode().getParent();
            if (object != null) {
                int n = ((SemanticsNode)object).getId();
                ComposeAccessible composeAccessible = ComposeAccessible.this;
                int id = n;
                boolean bl = false;
                ComposeAccessible composeAccessible2 = composeAccessible.controller.accessibleByNodeId(id);
                Intrinsics.checkNotNull((Object)composeAccessible2);
                object = composeAccessible2;
                if (composeAccessible2 != null) {
                    accessible = (Accessible)object;
                    return accessible;
                }
            }
            accessible = this.accessibleParent;
            return accessible;
        }

        @Override
        @Nullable
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        @Nullable
        public AccessibleAction getAccessibleAction() {
            List actions = new ArrayList();
            AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsActions.INSTANCE.getOnClick());
            if (accessibilityAction != null) {
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions.add(new Pair((Object)"click", SemanticsActions.INSTANCE.getOnClick()));
            }
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getOnLongClick());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getExpand());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getCollapse());
            ComposeAccessibleComponent.getAccessibleAction$addActionIfExist(ComposeAccessible.this, actions, SemanticsActions.INSTANCE.getDismiss());
            if (actions.isEmpty()) {
                return null;
            }
            this.accessibleAction = new AccessibleAction(actions, ComposeAccessible.this){
                final /* synthetic */ List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> $actions;
                final /* synthetic */ ComposeAccessible this$0;
                {
                    this.$actions = $actions;
                    this.this$0 = $receiver;
                }

                public int getAccessibleActionCount() {
                    return this.$actions.size();
                }

                public String getAccessibleActionDescription(int i) {
                    String label = (String)this.$actions.get(i).component1();
                    return label;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean doAccessibleAction(int i) {
                    SemanticsPropertyKey actionKey = (SemanticsPropertyKey)this.$actions.get(i).component2();
                    AccessibilityAction accessibilityAction = (AccessibilityAction)SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(this.this$0), actionKey);
                    Object object = accessibilityAction;
                    if (accessibilityAction == null) return false;
                    AccessibilityAction it = object;
                    boolean bl = false;
                    Function0 function0 = (Function0)it.getAction();
                    if (function0 == null) return false;
                    Boolean bl2 = (Boolean)function0.invoke();
                    object = bl2;
                    if (bl2 == null) return false;
                    boolean bl3 = (Boolean)object;
                    return bl3;
                }
            };
            return this.accessibleAction;
        }

        @Override
        @Nullable
        public AccessibleValue getAccessibleValue() {
            AccessibleValue accessibleValue;
            Role role = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getRole());
            if (this.getToggleableState() != null) {
                accessibleValue = new ToggleableAccessibleValue(this);
            } else {
                int n = Role.Companion.getRadioButton-o7Vup1c();
                Role role2 = role;
                accessibleValue = (role2 == null ? false : Role.equals-impl0(role2.unbox-impl(), n)) ? (AccessibleValue)new RadioButtonAccessibleValue(this) : (this.getProgressBarRangeInfo() != null ? (AccessibleValue)new ProgressBarAccessibleValue(this) : null);
            }
            return accessibleValue;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getAccessibleIndexInParent() {
            int n;
            block4: {
                List<SemanticsNode> parentChildren;
                SemanticsNode semanticsNode = ComposeAccessible.this.getSemanticsNode().getParent();
                List<SemanticsNode> list2 = parentChildren = semanticsNode != null ? semanticsNode.getReplacedChildren$ui() : null;
                if (list2 != null) {
                    void $this$indexOfFirst$iv;
                    List<SemanticsNode> list3 = list2;
                    ComposeAccessible composeAccessible = ComposeAccessible.this;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$indexOfFirst$iv) {
                        SemanticsNode it = (SemanticsNode)item$iv;
                        boolean bl = false;
                        if (it.getId() == composeAccessible.getSemanticsNode().getId()) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = -1;
                } else {
                    n = -1;
                }
            }
            return n;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui().size() + this.getAuxiliaryChildren().size();
        }

        @Override
        @Nullable
        public Accessible getAccessibleChild(int i) {
            List<SemanticsNode> replacedChildren = ComposeAccessible.this.getSemanticsNode().getReplacedChildren$ui();
            int replacedChildrenSize = replacedChildren.size();
            return i < replacedChildrenSize ? (Accessible)ComposeAccessible.this.controller.accessibleByNodeId(replacedChildren.get(i).getId()) : this.getAuxiliaryChildren().get(i - replacedChildrenSize);
        }

        @Override
        @NotNull
        public Locale getLocale() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            return locale;
        }

        @Override
        @NotNull
        public Point getLocationOnScreen() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionOnScreen-F1C5BW0());
        }

        @Override
        @NotNull
        public Point getLocation() {
            return this.toAwtPoint-k-4lQ0M(ComposeAccessible.this.getSemanticsNode().getPositionInRoot-F1C5BW0());
        }

        @Override
        @NotNull
        public Rectangle getBounds() {
            return this.toAwtRectangle(ComposeAccessible.this.getSemanticsNode().getBoundsInRoot());
        }

        @Override
        @NotNull
        public Dimension getSize() {
            return this.toAwtDimension-ozmzZPI(ComposeAccessible.this.getSemanticsNode().getSize-YbymL2g());
        }

        @Override
        public boolean isVisible() {
            boolean bl = false;
            return !DelegatableNodeKt.requireCoordinator-64DMado(ComposeAccessible.this.getSemanticsNode().getOuterSemanticsNode$ui(), NodeKind.constructor-impl(8)).isTransparent();
        }

        @Override
        public boolean isEnabled() {
            return SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsConfig(), SemanticsProperties.INSTANCE.getDisabled()) == null;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.getBounds().contains(p);
        }

        @Override
        @Nullable
        public Accessible getAccessibleAt(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                AccessibleComponent child;
                Accessible accessible = this.getAccessibleChild(i);
                Object object = accessible != null ? accessible.getAccessibleContext() : null;
                AccessibleComponent accessibleComponent = child = object instanceof AccessibleComponent ? (AccessibleComponent)object : null;
                if (child == null || (object = child.getAccessibleAt(p)) == null) continue;
                Object it = object;
                boolean bl = false;
                return it;
            }
            if (this.contains(p)) {
                return ComposeAccessible.this;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return this.getFocused() != null;
        }

        @Override
        public void requestFocus() {
            Function0<Boolean> function0;
            AccessibilityAction<Function0<Boolean>> accessibilityAction;
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)false) && (accessibilityAction = SemanticsConfigurationKt.getOrNull(ComposeAccessible.this.getSemanticsNode().getUnmergedConfig$ui(), SemanticsActions.INSTANCE.getRequestFocus())) != null && (function0 = accessibilityAction.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)function0.invoke();
            }
        }

        @Override
        public void addFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: addFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void removeFocusListener(@Nullable FocusListener l) {
            System.out.println((Object)"Not implemented: removeFocusListener");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            block22: {
                block21: {
                    AccessibilityController.AccessibilityUsage.INSTANCE.notifyInUse();
                    var2_1 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(ComposeAccessible.this), SemanticsProperties.INSTANCE.getRole());
                    var3_2 = Role.Companion.getButton-o7Vup1c();
                    v0 = var2_1;
                    if (!(v0 == null ? false : Role.equals-impl0(v0.unbox-impl(), var3_2))) break block21;
                    v1 = AccessibleRole.PUSH_BUTTON;
                    break block22;
                }
                var3_2 = Role.Companion.getCheckbox-o7Vup1c();
                v2 = var2_1;
                if (v2 == null ? false : Role.equals-impl0(v2.unbox-impl(), var3_2)) ** GOTO lbl-1000
                var3_2 = Role.Companion.getSwitch-o7Vup1c();
                v3 = var2_1;
                if (v3 == null ? false : Role.equals-impl0(v3.unbox-impl(), var3_2)) lbl-1000:
                // 2 sources

                {
                    v1 = AccessibleRole.CHECK_BOX;
                } else {
                    var3_2 = Role.Companion.getRadioButton-o7Vup1c();
                    v4 = var2_1;
                    if (v4 == null ? false : Role.equals-impl0(v4.unbox-impl(), var3_2)) {
                        v1 = AccessibleRole.RADIO_BUTTON;
                    } else {
                        var3_2 = Role.Companion.getTab-o7Vup1c();
                        v5 = var2_1;
                        if (v5 == null ? false : Role.equals-impl0(v5.unbox-impl(), var3_2)) {
                            v1 = AccessibleRole.PAGE_TAB;
                        } else {
                            var3_2 = Role.Companion.getDropdownList-o7Vup1c();
                            v6 = var2_1;
                            v1 = (v6 == null ? false : Role.equals-impl0(v6.unbox-impl(), var3_2)) != false ? AccessibleRole.COMBO_BOX : null;
                        }
                    }
                }
            }
            fromSemanticRole = v1;
            v7 = fromSemanticRole;
            if (v7 == null) {
                if (this.isPassword()) {
                    v8 = AccessibleRole.PASSWORD_TEXT;
                    v7 = v8;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"PASSWORD_TEXT");
                } else if (this.getScrollBy() != null) {
                    v9 = AccessibleRole.SCROLL_PANE;
                    v7 = v9;
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"SCROLL_PANE");
                } else if (this.getSetText() != null) {
                    v10 = AccessibleRole.TEXT;
                    v7 = v10;
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"TEXT");
                } else if (this.getText() != null) {
                    v11 = AccessibleRole.LABEL;
                    v7 = v11;
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"LABEL");
                } else if (this.getProgressBarRangeInfo() != null) {
                    var2_1 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(ComposeAccessible.this), SemanticsActions.INSTANCE.getSetProgress()) != null ? AccessibleRole.SLIDER : AccessibleRole.PROGRESS_BAR;
                    Intrinsics.checkNotNull((Object)var2_1);
                    v7 = var2_1;
                } else if (this.isContainer() != null) {
                    v12 = AccessibleRole.GROUP_BOX;
                    v7 = v12;
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"GROUP_BOX");
                } else if (this.isTraversalGroup() != null) {
                    v13 = AccessibleRole.GROUP_BOX;
                    v7 = v13;
                    Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"GROUP_BOX");
                } else {
                    v14 = AccessibleRole.UNKNOWN;
                    v7 = v14;
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"UNKNOWN");
                }
            }
            return v7;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            var1_1 = new AccessibleStateSet();
            var2_2 = ComposeAccessible.this;
            $this$getAccessibleStateSet_u24lambda_u2413 = var1_1;
            $i$a$-apply-ComposeAccessible$ComposeAccessibleComponent$getAccessibleStateSet$1 = false;
            if (this.isEnabled()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.ENABLED);
            }
            if (this.isShowing()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.VISIBLE);
            }
            if (this.isFocusTraversable()) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.FOCUSABLE);
            }
            if (Intrinsics.areEqual((Object)this.getFocused(), (Object)true)) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.FOCUSED);
            }
            canExpand = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsActions.INSTANCE.getExpand()) != null;
            v0 = canCollapse = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsActions.INSTANCE.getCollapse()) != null;
            if (canExpand || canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.EXPANDABLE);
            }
            if (canExpand) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.COLLAPSED);
            }
            if (canCollapse) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.EXPANDED);
            }
            var7_7 = SemanticsConfigurationKt.getOrNull(ComposeAccessible.access$getSemanticsConfig(var2_2), SemanticsProperties.INSTANCE.getRole());
            var8_8 = Role.Companion.getCheckbox-o7Vup1c();
            v1 = var7_7;
            if (v1 == null ? false : Role.equals-impl0(v1.unbox-impl(), var8_8)) ** GOTO lbl-1000
            var8_8 = Role.Companion.getSwitch-o7Vup1c();
            v2 = var7_7;
            if (v2 == null ? false : Role.equals-impl0(v2.unbox-impl(), var8_8)) lbl-1000:
            // 2 sources

            {
                this.addCheckedStateForCheckboxOrSwitch($this$getAccessibleStateSet_u24lambda_u2413);
            } else {
                var8_8 = Role.Companion.getRadioButton-o7Vup1c();
                v3 = var7_7;
                if (v3 == null ? false : Role.equals-impl0(v3.unbox-impl(), var8_8)) {
                    this.addCheckedStateForRadioButton($this$getAccessibleStateSet_u24lambda_u2413);
                } else {
                    this.addDefaultStateForToggleableState($this$getAccessibleStateSet_u24lambda_u2413);
                    if (this.getSelected() != null) {
                        $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.SELECTABLE);
                    }
                    if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                        $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.SELECTED);
                    }
                }
            }
            it = this.getAccessibleRole();
            $i$a$-let-ComposeAccessible$ComposeAccessibleComponent$getAccessibleStateSet$1$1 = false;
            v4 = Intrinsics.areEqual((Object)it, (Object)AccessibleRole.SLIDER) || Intrinsics.areEqual((Object)it, (Object)AccessibleRole.PROGRESS_BAR);
            if (v4) {
                $this$getAccessibleStateSet_u24lambda_u2413.add(AccessibleState.HORIZONTAL);
            }
            return var1_1;
        }

        private final void addCheckedStateForCheckboxOrSwitch(AccessibleStateSet $this$addCheckedStateForCheckboxOrSwitch) {
            this.addDefaultStateForToggleableState($this$addCheckedStateForCheckboxOrSwitch);
        }

        private final void addCheckedStateForRadioButton(AccessibleStateSet $this$addCheckedStateForRadioButton) {
            if (Intrinsics.areEqual((Object)this.getSelected(), (Object)true)) {
                $this$addCheckedStateForRadioButton.add(AccessibleState.CHECKED);
            }
        }

        private final void addDefaultStateForToggleableState(AccessibleStateSet $this$addDefaultStateForToggleableState) {
            AccessibleState accessibleState;
            ToggleableState toggleableState = this.getToggleableState();
            switch (toggleableState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toggleableState.ordinal()]) {
                case 1: {
                    accessibleState = AccessibleState.CHECKED;
                    break;
                }
                case 2: {
                    accessibleState = AccessibleState.INDETERMINATE;
                    break;
                }
                case -1: 
                case 3: {
                    accessibleState = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AccessibleState state = accessibleState;
            if (state != null) {
                $this$addDefaultStateForToggleableState.add(state);
            }
        }

        @Override
        private final ComposeAccessibleText getAccessibleText() {
            Lazy lazy = this.accessibleText$delegate;
            return (ComposeAccessibleText)lazy.getValue();
        }

        @Override
        @Nullable
        public AccessibleText getAccessibleText() {
            return this.getAccessibleText();
        }

        @Override
        @Nullable
        public AccessibleEditableText getAccessibleEditableText() {
            ComposeAccessibleText accessibleText = this.getAccessibleText();
            return accessibleText instanceof AccessibleEditableText ? (AccessibleEditableText)((Object)accessibleText) : null;
        }

        @Override
        public void setBounds(@Nullable Rectangle r) {
            System.out.println((Object)"Not implemented: setBounds");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setSize(@Nullable Dimension d) {
            System.out.println((Object)"Not implemented: setSize");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setLocation(@Nullable Point p) {
            System.out.println((Object)"Not implemented: setLocation");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Color getBackground() {
            System.out.println((Object)"Not implemented: getBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setBackground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setBackground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Color getForeground() {
            System.out.println((Object)"Not implemented: getForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setForeground(@Nullable Color c) {
            System.out.println((Object)"Not implemented: setForeground");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            System.out.println((Object)"Not implemented: getCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setCursor(@Nullable Cursor cursor2) {
            System.out.println((Object)"Not implemented: setCursor");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Font getFont() {
            System.out.println((Object)"Not implemented: getFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setFont(@Nullable Font f) {
            System.out.println((Object)"Not implemented: setFont");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public FontMetrics getFontMetrics(@Nullable Font f) {
            System.out.println((Object)"Not implemented: getFontMetrics");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setEnabled(boolean b) {
            System.out.println((Object)"Not implemented: setEnabled");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void setVisible(boolean b) {
            System.out.println((Object)"Not implemented: setVisible");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.getAccessibleActionCount() : 0;
        }

        @Override
        @NotNull
        public String getAccessibleActionDescription(int i) {
            Object object = this.accessibleAction;
            if (object == null || (object = object.getAccessibleActionDescription(i)) == null) {
                object = "";
            }
            return object;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            AccessibleAction accessibleAction = this.accessibleAction;
            return accessibleAction != null ? accessibleAction.doAccessibleAction(i) : false;
        }

        private final String mergeText(List<? extends CharSequence> $this$mergeText) {
            return CollectionsKt.joinToString$default((Iterable)$this$mergeText, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        private static final void getAccessibleAction$addActionIfExist(ComposeAccessible this$0, List<Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>> actions, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
            block0: {
                AccessibilityAction<Function0<Boolean>> accessibilityAction = SemanticsConfigurationKt.getOrNull(this$0.getSemanticsConfig(), key);
                if (accessibilityAction == null) break block0;
                AccessibilityAction<Function0<Boolean>> it = accessibilityAction;
                boolean bl = false;
                actions.add((Pair<String, SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>>>)new Pair((Object)it.getLabel(), key));
            }
        }

        private static final ComposeAccessibleText accessibleText_delegate$lambda$14(ComposeAccessibleComponent this$0) {
            return this$0.getSetText() != null ? (ComposeAccessibleText)this$0.new ComposeAccessibleEditableText() : (this$0.getText() != null ? this$0.new ComposeAccessibleText() : null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\n0\u0001R\u00060\u0002R\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\"\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;", "Landroidx/compose/ui/platform/a11y/ComposeAccessible;", "Ljavax/accessibility/AccessibleEditableText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "setTextContents", "", "s", "", "insertTextAtIndex", "index", "", "getTextRange", "startIndex", "endIndex", "delete", "cut", "paste", "replaceText", "selectText", "setAttributes", "as", "Ljavax/swing/text/AttributeSet;", "ui"})
        @SourceDebugExtension(value={"SMAP\nComposeAccessible.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,936:1\n1574#2:937\n1574#2:938\n1574#2:939\n*S KotlinDebug\n*F\n+ 1 ComposeAccessible.kt\nandroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleEditableText\n*L\n717#1:937\n732#1:938\n750#1:939\n*E\n"})
        public final class ComposeAccessibleEditableText
        extends ComposeAccessibleText
        implements AccessibleEditableText {
            @Override
            public void setTextContents(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)new AnnotatedString(s, null, 2, null));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void insertTextAtIndex(int index2, @NotNull String s) {
                void $this$insertTextAtIndex_u24lambda_u240;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence text = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(0, index2));
                $this$insertTextAtIndex_u24lambda_u240.append(s);
                $this$insertTextAtIndex_u24lambda_u240.append(text.subSequence(index2, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence(startIndex, endIndex)).toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void delete(int startIndex, int endIndex) {
                void $this$delete_u24lambda_u241;
                AnnotatedString.Builder builder;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence text = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$delete_u24lambda_u241.append(text.subSequence(0, startIndex));
                $this$delete_u24lambda_u241.append(text.subSequence(endIndex, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void cut(int startIndex, int endIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            public void paste(int startIndex) {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void replaceText(int startIndex, int endIndex, @NotNull String s) {
                void $this$replaceText_u24lambda_u242;
                AnnotatedString.Builder builder;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                CharSequence text = charSequence;
                AccessibilityAction<Function1<AnnotatedString, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetText();
                Intrinsics.checkNotNull(accessibilityAction);
                Function1<AnnotatedString, Boolean> function1 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function1);
                boolean $i$f$buildAnnotatedString = false;
                AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
                Function1<AnnotatedString, Boolean> function12 = function1;
                boolean bl = false;
                $this$replaceText_u24lambda_u242.append(text.subSequence(0, startIndex));
                $this$replaceText_u24lambda_u242.append(s);
                $this$replaceText_u24lambda_u242.append(text.subSequence(endIndex, text.length() - 1));
                function12.invoke((Object)builder.toAnnotatedString());
            }

            @Override
            public void selectText(int startIndex, int endIndex) {
                AccessibilityAction<Function3<Integer, Integer, Boolean, Boolean>> accessibilityAction = ComposeAccessibleComponent.this.getSetSelection();
                Intrinsics.checkNotNull(accessibilityAction);
                Function3<Integer, Integer, Boolean, Boolean> function3 = accessibilityAction.getAction();
                Intrinsics.checkNotNull(function3);
                function3.invoke((Object)startIndex, (Object)endIndex, (Object)false);
            }

            @Override
            public void setAttributes(int startIndex, int endIndex, @Nullable AttributeSet as) {
                System.out.println((Object)"Not implemented: setAttributes");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0096\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016\u00a8\u0006#"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ComposeAccessibleText;", "Ljavax/accessibility/AccessibleText;", "Ljavax/accessibility/AccessibleExtendedText;", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;)V", "getIndexAtPoint", "", "p", "Ljava/awt/Point;", "getCharacterBounds", "Ljava/awt/Rectangle;", "i", "getCharCount", "getCaretPosition", "partToBreakIterator", "Lorg/jetbrains/skia/BreakIterator;", "part", "getAtIndex", "", "index", "getAfterIndex", "getBeforeIndex", "getCharacterAttribute", "Ljavax/swing/text/AttributeSet;", "getSelectionStart", "getSelectionEnd", "getSelectedText", "getTextRange", "startIndex", "endIndex", "getTextSequenceAt", "Ljavax/accessibility/AccessibleTextSequence;", "getTextSequenceAfter", "getTextSequenceBefore", "getTextBounds", "ui"})
        public class ComposeAccessibleText
        implements AccessibleText,
        AccessibleExtendedText {
            @Override
            public int getIndexAtPoint(@NotNull Point p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return textLayoutResult.getOffsetForPosition-k-4lQ0M(ComposeAccessibleComponent.this.toComposeOffset-tuRUvjQ(p));
            }

            @Override
            @NotNull
            public Rectangle getCharacterBounds(int i) {
                block3: {
                    block2: {
                        if (i < 0) break block2;
                        CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                        Intrinsics.checkNotNull((Object)charSequence);
                        if (i < charSequence.length()) break block3;
                    }
                    return new Rectangle((int)((float)ComposeAccessibleComponent.this.getLocation().x / ComposeAccessibleComponent.this.getDensity().getDensity()), (int)((float)ComposeAccessibleComponent.this.getLocation().y / ComposeAccessibleComponent.this.getDensity().getDensity()), 0, 0);
                }
                TextLayoutResult textLayoutResult = ComposeAccessibleComponent.this.getTextLayoutResult();
                Intrinsics.checkNotNull((Object)textLayoutResult);
                return ComposeAccessibleComponent.this.toAwtRectangle(textLayoutResult.getBoundingBox(i));
            }

            @Override
            public int getCharCount() {
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return charSequence.length();
            }

            @Override
            public int getCaretPosition() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : -1;
            }

            private final BreakIterator partToBreakIterator(int part) {
                BreakIterator breakIterator;
                switch (part) {
                    case 3: {
                        breakIterator = BreakIterator.Companion.makeSentenceInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 2: {
                        breakIterator = BreakIterator.Companion.makeWordInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    case 1: {
                        breakIterator = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                BreakIterator iter = breakIterator;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                iter.setText(((Object)charSequence).toString());
                return iter;
            }

            @Override
            @NotNull
            public String getAtIndex(int part, int index2) {
                String string;
                int end = this.partToBreakIterator(part).following(index2);
                if (end == -1) {
                    string = "";
                } else {
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    string = ((Object)charSequence.subSequence(index2, end)).toString();
                }
                return string;
            }

            @Override
            @NotNull
            public String getAfterIndex(int part, int index2) {
                BreakIterator iterator2 = this.partToBreakIterator(part);
                int start = index2;
                while (true) {
                    if ((start = iterator2.following(start)) == -1) {
                        return "";
                    }
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    if (charSequence.charAt(start) == ' ') continue;
                    CharSequence charSequence2 = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence2);
                    if (charSequence2.charAt(start) != '\n') break;
                }
                int end = iterator2.next();
                int end2 = end == -1 ? iterator2.last() : end;
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence(start, end2)).toString();
            }

            @Override
            @NotNull
            public String getBeforeIndex(int part, int index2) {
                String string;
                int start = this.partToBreakIterator(part).preceding(index2);
                if (start == -1) {
                    string = "";
                } else {
                    CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                    Intrinsics.checkNotNull((Object)charSequence);
                    string = ((Object)charSequence.subSequence(start, index2)).toString();
                }
                return string;
            }

            @Override
            @NotNull
            public AttributeSet getCharacterAttribute(int i) {
                System.out.println((Object)"Not implemented: getCharacterAttribute");
                return new SimpleAttributeSet();
            }

            @Override
            public int getSelectionStart() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getStart-impl(textRange.unbox-impl()) : 0;
            }

            @Override
            public int getSelectionEnd() {
                TextRange textRange = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                return textRange != null ? TextRange.getEnd-impl(textRange.unbox-impl()) : 0;
            }

            @Override
            @NotNull
            public String getSelectedText() {
                Object object;
                block3: {
                    block2: {
                        object = ComposeAccessibleComponent.this.getTextSelectionRange-MzsxiRA();
                        if (object == null) break block2;
                        TextRange textRange = object;
                        ComposeAccessibleComponent composeAccessibleComponent = ComposeAccessibleComponent.this;
                        long selection = textRange.unbox-impl();
                        boolean bl = false;
                        CharSequence charSequence = composeAccessibleComponent.getText();
                        Intrinsics.checkNotNull((Object)charSequence);
                        String string = ((Object)charSequence.subSequence(TextRange.getStart-impl(selection), TextRange.getEnd-impl(selection))).toString();
                        object = string;
                        if (string != null) break block3;
                    }
                    object = "";
                }
                return object;
            }

            @Override
            @NotNull
            public String getTextRange(int startIndex, int endIndex) {
                CharSequence charSequence = ComposeAccessibleComponent.this.getText();
                Intrinsics.checkNotNull((Object)charSequence);
                return ((Object)charSequence.subSequence(startIndex, endIndex)).toString();
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAt(int part, int index2) {
                System.out.println((Object)"Not implemented: getBeforeIndex");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceAfter(int part, int index2) {
                System.out.println((Object)"Not implemented: getTextSequenceAfter");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            @NotNull
            public AccessibleTextSequence getTextSequenceBefore(int part, int index2) {
                System.out.println((Object)"Not implemented: getTextSequenceBefore");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @Override
            @NotNull
            public Rectangle getTextBounds(int startIndex, int endIndex) {
                System.out.println((Object)"Not implemented: getTextBounds");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent$ScrollBarAccessible;", "Ljavax/accessibility/Accessible;", "vertical", "", "<init>", "(Landroidx/compose/ui/platform/a11y/ComposeAccessible$ComposeAccessibleComponent;Z)V", "getVertical", "()Z", "context", "Ljavax/accessibility/AccessibleContext;", "getContext", "()Ljavax/accessibility/AccessibleContext;", "getAccessibleContext", "ui"})
        public final class ScrollBarAccessible
        implements Accessible {
            private final boolean vertical;
            @NotNull
            private final AccessibleContext context;

            public ScrollBarAccessible(boolean vertical) {
                this.vertical = vertical;
                this.context = (AccessibleContext)((Object)new AccessibleValue(this, ComposeAccessibleComponent.this, ComposeAccessible.this){
                    private final ScrollAxisRange range;
                    final /* synthetic */ ScrollBarAccessible this$0;
                    final /* synthetic */ ComposeAccessibleComponent this$1;
                    final /* synthetic */ ComposeAccessible this$2;
                    {
                        ScrollAxisRange scrollAxisRange;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.this$2 = $receiver3;
                        if ($receiver.getVertical()) {
                            ScrollAxisRange scrollAxisRange2 = $receiver2.getVerticalScroll();
                            scrollAxisRange = scrollAxisRange2;
                            Intrinsics.checkNotNull((Object)scrollAxisRange2);
                        } else {
                            ScrollAxisRange scrollAxisRange3 = $receiver2.getHorizontalScroll();
                            scrollAxisRange = scrollAxisRange3;
                            Intrinsics.checkNotNull((Object)scrollAxisRange3);
                        }
                        this.range = scrollAxisRange;
                    }

                    public AccessibleValue getAccessibleValue() {
                        return this;
                    }

                    public AccessibleRole getAccessibleRole() {
                        AccessibleRole accessibleRole = AccessibleRole.SCROLL_BAR;
                        Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"SCROLL_BAR");
                        return accessibleRole;
                    }

                    public AccessibleStateSet getAccessibleStateSet() {
                        AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
                        ScrollBarAccessible scrollBarAccessible = this.this$0;
                        AccessibleStateSet $this$getAccessibleStateSet_u24lambda_u240 = accessibleStateSet;
                        boolean bl = false;
                        $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.ENABLED);
                        boolean bl2 = scrollBarAccessible.getVertical() ? $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.VERTICAL) : $this$getAccessibleStateSet_u24lambda_u240.add(AccessibleState.HORIZONTAL);
                        return accessibleStateSet;
                    }

                    public Accessible getAccessibleParent() {
                        return this.this$2;
                    }

                    public int getAccessibleIndexInParent() {
                        return this.this$1.getAuxiliaryChildren().indexOf(this.this$0);
                    }

                    public int getAccessibleChildrenCount() {
                        return 0;
                    }

                    public Accessible getAccessibleChild(int i) {
                        return null;
                    }

                    public Locale getLocale() {
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        return locale;
                    }

                    public Number getCurrentAccessibleValue() {
                        return (Number)this.range.getValue().invoke();
                    }

                    public boolean setCurrentAccessibleValue(Number n) {
                        boolean bl;
                        if (this.this$0.getVertical()) {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Float f = Float.valueOf(0.0f);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            bl = (Boolean)function2.invoke((Object)f, (Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()));
                        } else {
                            AccessibilityAction<Function2<Float, Float, Boolean>> accessibilityAction = this.this$1.getScrollBy();
                            Intrinsics.checkNotNull(accessibilityAction);
                            Function2<Float, Float, Boolean> function2 = accessibilityAction.getAction();
                            Intrinsics.checkNotNull(function2);
                            Number number = n;
                            Intrinsics.checkNotNull((Object)number);
                            bl = (Boolean)function2.invoke((Object)Float.valueOf(number.floatValue() - ((Number)this.range.getValue().invoke()).floatValue()), (Object)Float.valueOf(0.0f));
                        }
                        return bl;
                    }

                    public Number getMinimumAccessibleValue() {
                        return 0;
                    }

                    public Number getMaximumAccessibleValue() {
                        return (Number)this.range.getMaxValue().invoke();
                    }
                });
            }

            public final boolean getVertical() {
                return this.vertical;
            }

            @NotNull
            public final AccessibleContext getContext() {
                return this.context;
            }

            @Override
            @NotNull
            public AccessibleContext getAccessibleContext() {
                return this.context;
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ToggleableState.values().length];
                try {
                    nArray[ToggleableState.On.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Indeterminate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ToggleableState.Off.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

