/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.miginfocom.swing.MigLayout;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableBuildingUtilsKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actuallyInsertTable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "rows", "", "columns", "TableGridComponent", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInsertEmptyTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertEmptyTableAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,294:1\n7#2,6:295\n*S KotlinDebug\n*F\n+ 1 InsertEmptyTableAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction\n*L\n88#1:295,6\n*E\n"})
public final class InsertEmptyTableAction
extends DumbAwareAction {
    public InsertEmptyTableAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), InsertEmptyTableAction::_init_$lambda$0);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        TableGridComponent hintComponent = new TableGridComponent(0, 0, 0, (arg_0, arg_1) -> InsertEmptyTableAction.actionPerformed$lambda$1(this, project2, editor3, file, arg_0, arg_1), null, 23, null);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)hintComponent, (JComponent)hintComponent).setRequestFocus(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        hintComponent.setParentHint$intellij_markdown(popup2);
        popup2.showInBestPositionFor(editor3);
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        project = event.getProject();
        editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        v0 = event.getPresentation();
        if (project == null || editor == null) ** GOTO lbl-1000
        v1 = file;
        v2 = v1 != null && (v1 = v1.getLanguage()) != null ? MarkdownLanguageUtilsKt.isMarkdownLanguage((Language)v1) : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        v0.setEnabledAndVisible(v3);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final void actuallyInsertTable(Project project, Editor editor2, PsiFile file, int rows, int columns) {
        ActionsKt.runWriteAction(() -> InsertEmptyTableAction.actuallyInsertTable$lambda$4(project, editor2, rows, columns, file));
    }

    private static final String _init_$lambda$0() {
        return MarkdownBundle.message("action.Markdown.InsertEmptyTable.insert.popup.text", new Object[0]);
    }

    private static final Unit actionPerformed$lambda$1(InsertEmptyTableAction this$0, Project $project, Editor $editor, PsiFile $file, int rows, int columns) {
        this$0.actuallyInsertTable($project, $editor, $file, rows, columns);
        return Unit.INSTANCE;
    }

    private static final Unit actuallyInsertTable$lambda$4(Project $project, Editor $editor, int $rows, int $columns, PsiFile $file) {
        Project project$iv = $project;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable($editor, $rows, $columns, $project, $file){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ int $rows$inlined;
            final /* synthetic */ int $columns$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ PsiFile $file$inlined;
            {
                this.$editor$inlined = editor2;
                this.$rows$inlined = n;
                this.$columns$inlined = n2;
                this.$project$inlined = project;
                this.$file$inlined = psiFile;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void run() {
                MarkdownTable table;
                boolean bl = false;
                Caret caret = this.$editor$inlined.getCaretModel().getCurrentCaret();
                Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
                Caret caret2 = caret;
                Document document = this.$editor$inlined.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                int caretOffset = caret2.getOffset();
                int currentLine = document2.getLineNumber(caret2.getOffset());
                String text2 = TableBuildingUtilsKt.buildEmptyTable(this.$rows$inlined, this.$columns$inlined, 3);
                String content = currentLine != 0 && !DocumentUtil.isLineEmpty((Document)document2, (int)(currentLine - 1)) ? "\n" + text2 : text2;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)content);
                PsiDocumentManager.getInstance((Project)this.$project$inlined).commitDocument(document2);
                MarkdownTable markdownTable = table = TableUtils.findTable(this.$file$inlined, caretOffset);
                MarkdownCompositePsiElementBase markdownCompositePsiElementBase = markdownTable;
                if (markdownTable == null) return;
                MarkdownTable it = markdownCompositePsiElementBase;
                boolean bl2 = false;
                MarkdownTableCell markdownTableCell = (MarkdownTableCell)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)it), MarkdownTableCell.class);
                markdownCompositePsiElementBase = markdownTableCell;
                if (markdownTableCell == null) return;
                Integer n = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)markdownCompositePsiElementBase));
                Integer offsetToMove = n;
                if (offsetToMove == null) return;
                caret2.moveToOffset(offsetToMove.intValue());
            }
        }, name$iv, groupId$iv);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000 82\u00020\u0001:\u000545678B]\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u0012\u001c\b\u0002\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002J\u001e\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J\u0016\u00102\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J\b\u00103\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R>\u0010\u0012\u001a2\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00150\u0013j\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent;", "Ljavax/swing/JPanel;", "rows", "", "columns", "expandFactor", "selectedCallback", "Lkotlin/Function2;", "", "indicesUpdatedCallback", "<init>", "(IIILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "parentHint", "Lcom/intellij/openapi/ui/popup/JBPopup;", "getParentHint$intellij_markdown", "()Lcom/intellij/openapi/ui/popup/JBPopup;", "setParentHint$intellij_markdown", "(Lcom/intellij/openapi/ui/popup/JBPopup;)V", "cells", "Ljava/util/ArrayList;", "Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$Cell;", "Lkotlin/collections/ArrayList;", "value", "selectedCellRow", "getSelectedCellRow", "()I", "selectedCellColumn", "getSelectedCellColumn", "gridPanel", "Ljavax/swing/JComponent;", "label", "Lcom/intellij/ui/components/JBLabel;", "mouseListener", "Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$MyMouseListener;", "childMouseListener", "Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$MyForwardingMouseListener;", "indicesSelected", "selectedRow", "selectedColumn", "registerAction", "key", "actionKey", "", "action", "Ljavax/swing/Action;", "fillGrid", "expandGrid", "expandRows", "", "expandColumns", "updateSelection", "createCell", "ArrowAction", "MyForwardingMouseListener", "MyMouseListener", "Cell", "Companion", "intellij.markdown"})
    @ApiStatus.Internal
    public static final class TableGridComponent
    extends JPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int rows;
        private int columns;
        private final int expandFactor;
        @NotNull
        private final Function2<Integer, Integer, Unit> selectedCallback;
        @Nullable
        private final Function2<Integer, Integer, Unit> indicesUpdatedCallback;
        @Nullable
        private JBPopup parentHint;
        @NotNull
        private final ArrayList<ArrayList<Cell>> cells;
        private int selectedCellRow;
        private int selectedCellColumn;
        @NotNull
        private final JComponent gridPanel;
        @NotNull
        private final JBLabel label;
        @NotNull
        private final MyMouseListener mouseListener;
        @NotNull
        private final MyForwardingMouseListener childMouseListener;
        private static final int maxRows = 10;
        private static final int maxColumns = 10;

        public TableGridComponent(int rows, int columns, int expandFactor, @NotNull Function2<? super Integer, ? super Integer, Unit> selectedCallback, @Nullable Function2<? super Integer, ? super Integer, Unit> indicesUpdatedCallback) {
            Intrinsics.checkNotNullParameter(selectedCallback, (String)"selectedCallback");
            super((LayoutManager)new MigLayout("insets 8"));
            this.rows = rows;
            this.columns = columns;
            this.expandFactor = expandFactor;
            this.selectedCallback = selectedCallback;
            this.indicesUpdatedCallback = indicesUpdatedCallback;
            this.cells = new ArrayList();
            this.gridPanel = new JPanel((LayoutManager)new MigLayout("insets 0, gap 3"));
            this.label = new JBLabel();
            this.mouseListener = new MyMouseListener();
            this.childMouseListener = new MyForwardingMouseListener(this.gridPanel);
            int n = this.rows;
            for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                this.cells.add((ArrayList<Cell>)SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Cell>((Object)this){

                    public final Cell invoke() {
                        return ((TableGridComponent)this.receiver).createCell();
                    }
                })), (int)this.columns), (Collection)new ArrayList(this.columns)));
            }
            this.fillGrid();
            this.add((Component)this.gridPanel, "wrap");
            this.add((Component)this.label, "align center");
            this.gridPanel.addMouseMotionListener(this.mouseListener);
            this.gridPanel.addMouseListener(this.mouseListener);
            this.registerAction(39, "selectRight", new ArrowAction((Function0<Pair<Integer, Integer>>)((Function0)TableGridComponent::_init_$lambda$0)));
            this.registerAction(37, "selectLeft", new ArrowAction((Function0<Pair<Integer, Integer>>)((Function0)TableGridComponent::_init_$lambda$1)));
            this.registerAction(38, "selectUp", new ArrowAction((Function0<Pair<Integer, Integer>>)((Function0)TableGridComponent::_init_$lambda$2)));
            this.registerAction(40, "selectDown", new ArrowAction((Function0<Pair<Integer, Integer>>)((Function0)TableGridComponent::_init_$lambda$3)));
            this.registerAction(10, "confirmSelection", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.indicesSelected(this.getSelectedCellRow(), this.getSelectedCellColumn());
                }
            });
            this.updateSelection(0, 0);
        }

        public /* synthetic */ TableGridComponent(int n, int n2, int n3, Function2 function2, Function2 function22, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 4;
            }
            if ((n4 & 2) != 0) {
                n2 = 4;
            }
            if ((n4 & 4) != 0) {
                n3 = 2;
            }
            if ((n4 & 0x10) != 0) {
                function22 = null;
            }
            this(n, n2, n3, (Function2<? super Integer, ? super Integer, Unit>)function2, (Function2<? super Integer, ? super Integer, Unit>)function22);
        }

        @Nullable
        public final JBPopup getParentHint$intellij_markdown() {
            return this.parentHint;
        }

        public final void setParentHint$intellij_markdown(@Nullable JBPopup jBPopup) {
            this.parentHint = jBPopup;
        }

        public final int getSelectedCellRow() {
            return this.selectedCellRow;
        }

        public final int getSelectedCellColumn() {
            return this.selectedCellColumn;
        }

        private final void indicesSelected(int selectedRow, int selectedColumn) {
            JBPopup jBPopup = this.parentHint;
            if (jBPopup != null) {
                jBPopup.closeOk(null);
            }
            this.selectedCallback.invoke((Object)selectedRow, (Object)(selectedColumn + 1));
        }

        public final void registerAction(int key, @NotNull String actionKey, @NotNull Action action) {
            Intrinsics.checkNotNullParameter((Object)actionKey, (String)"actionKey");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(key, 0), actionKey);
            this.getActionMap().put(actionKey, action);
        }

        private final void fillGrid() {
            int n = this.rows;
            for (int row = 0; row < n; ++row) {
                int n2 = this.columns;
                for (int column = 0; column < n2; ++column) {
                    Cell cell;
                    Intrinsics.checkNotNullExpressionValue((Object)this.cells.get(row).get(column), (String)"get(...)");
                    if (column == this.columns - 1 && row != this.rows - 1) {
                        this.gridPanel.add((Component)cell, "wrap");
                        continue;
                    }
                    this.gridPanel.add(cell);
                }
            }
        }

        private final void expandGrid(boolean expandRows, boolean expandColumns) {
            this.gridPanel.removeAll();
            if (expandRows) {
                int n = this.expandFactor;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    this.cells.add((ArrayList<Cell>)SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Cell>((Object)this){

                        public final Cell invoke() {
                            return TableGridComponent.access$createCell((TableGridComponent)this.receiver);
                        }
                    })), (int)this.columns), (Collection)new ArrayList(this.columns)));
                }
                this.rows += this.expandFactor;
            }
            if (expandColumns) {
                Iterator<ArrayList<Cell>> iterator = this.cells.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator<ArrayList<Cell>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), (String)"next(...)");
                    int n = this.expandFactor;
                    int n3 = 0;
                    while (n3 < n) {
                        ArrayList<Cell> row;
                        int it = n3++;
                        boolean bl = false;
                        row.add(this.createCell());
                    }
                }
                this.columns += this.expandFactor;
            }
            this.fillGrid();
        }

        public final void updateSelection(int selectedRow, int selectedColumn) {
            boolean shouldExpandColumns;
            this.selectedCellRow = selectedRow;
            this.selectedCellColumn = selectedColumn;
            Function2<Integer, Integer, Unit> function2 = this.indicesUpdatedCallback;
            if (function2 != null) {
                function2.invoke((Object)this.selectedCellRow, (Object)this.selectedCellColumn);
            }
            this.label.setText(selectedRow + 1 + "\u00d7" + (selectedColumn + 1));
            int n = this.rows;
            for (int row = 0; row < n; ++row) {
                int n2 = this.columns;
                for (int column = 0; column < n2; ++column) {
                    this.cells.get(row).get(column).setSelected(row <= this.selectedCellRow && column <= this.selectedCellColumn);
                }
            }
            this.repaint();
            boolean shouldExpandRows = this.rows < 10 && selectedRow + 1 == this.rows;
            boolean bl = shouldExpandColumns = this.columns < 10 && selectedColumn + 1 == this.columns;
            if (shouldExpandRows || shouldExpandColumns) {
                this.expandGrid(shouldExpandRows, shouldExpandColumns);
                JBPopup jBPopup = this.parentHint;
                AbstractPopup abstractPopup = jBPopup instanceof AbstractPopup ? (AbstractPopup)jBPopup : null;
                if (abstractPopup == null) {
                    return;
                }
                AbstractPopup hint = abstractPopup;
                hint.pack(true, true);
                hint.getComponent().revalidate();
                hint.getComponent().repaint();
            }
        }

        private final Cell createCell() {
            Cell cell;
            Cell $this$createCell_u24lambda_u246 = cell = new Cell();
            boolean bl = false;
            $this$createCell_u24lambda_u246.addMouseListener(this.childMouseListener);
            $this$createCell_u24lambda_u246.addMouseMotionListener(this.childMouseListener);
            return cell;
        }

        private static final Pair _init_$lambda$0() {
            return TuplesKt.to((Object)0, (Object)1);
        }

        private static final Pair _init_$lambda$1() {
            return TuplesKt.to((Object)0, (Object)-1);
        }

        private static final Pair _init_$lambda$2() {
            return TuplesKt.to((Object)-1, (Object)0);
        }

        private static final Pair _init_$lambda$3() {
            return TuplesKt.to((Object)1, (Object)0);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$ArrowAction;", "Ljavax/swing/AbstractAction;", "calcDiff", "Lkotlin/Function0;", "Lkotlin/Pair;", "", "<init>", "(Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent;Lkotlin/jvm/functions/Function0;)V", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "intellij.markdown"})
        private final class ArrowAction
        extends AbstractAction {
            @NotNull
            private final Function0<Pair<Integer, Integer>> calcDiff;

            public ArrowAction(Function0<Pair<Integer, Integer>> calcDiff) {
                Intrinsics.checkNotNullParameter(calcDiff, (String)"calcDiff");
                this.calcDiff = calcDiff;
            }

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Pair pair = (Pair)this.calcDiff.invoke();
                int rowDiff = ((Number)pair.component1()).intValue();
                int columnDiff = ((Number)pair.component2()).intValue();
                int row = TableGridComponent.this.getSelectedCellRow() + rowDiff;
                int column = TableGridComponent.this.getSelectedCellColumn() + columnDiff;
                row = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)row, (int)(TableGridComponent.this.rows - 1)), (int)0);
                column = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)column, (int)(TableGridComponent.this.columns - 1)), (int)0);
                TableGridComponent.this.updateSelection(row, column);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$Cell;", "Ljavax/swing/JPanel;", "<init>", "()V", "value", "", "isSelected", "()Z", "setSelected", "(Z)V", "intellij.markdown"})
        private static final class Cell
        extends JPanel {
            private boolean isSelected;

            public Cell() {
                this.setBackground(UIUtil.getTextFieldBackground());
                this.setSize(new Dimension(15, 15));
                this.setPreferredSize(this.getSize());
                this.setBorder(IdeBorderFactory.createBorder());
            }

            public final boolean isSelected() {
                return this.isSelected;
            }

            public final void setSelected(boolean value) {
                this.isSelected = value;
                this.setBackground(value ? UIUtil.getFocusedFillColor() : UIUtil.getEditorPaneBackground());
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$Companion;", "", "<init>", "()V", "maxRows", "", "maxColumns", "intellij.markdown"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$MyForwardingMouseListener;", "Ljava/awt/event/MouseAdapter;", "targetComponent", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "dispatch", "", "event", "Ljava/awt/event/MouseEvent;", "mouseMoved", "mouseClicked", "intellij.markdown"})
        private static final class MyForwardingMouseListener
        extends MouseAdapter {
            @NotNull
            private final Component targetComponent;

            public MyForwardingMouseListener(@NotNull Component targetComponent) {
                Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
                this.targetComponent = targetComponent;
            }

            private final void dispatch(MouseEvent event) {
                MouseEvent translated = SwingUtilities.convertMouseEvent(event.getComponent(), event, this.targetComponent);
                this.targetComponent.dispatchEvent(translated);
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.dispatch(event);
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.dispatch(event);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lorg/intellij/plugins/markdown/editor/tables/actions/InsertEmptyTableAction$TableGridComponent;)V", "obtainIndices", "Lkotlin/Pair;", "", "point", "Ljava/awt/Point;", "mouseMoved", "", "event", "Ljava/awt/event/MouseEvent;", "mouseClicked", "intellij.markdown"})
        private final class MyMouseListener
        extends MouseAdapter {
            private final Pair<Integer, Integer> obtainIndices(Point point) {
                float panelWidth = TableGridComponent.this.gridPanel.getWidth();
                float panelHeight = TableGridComponent.this.gridPanel.getHeight();
                float tileWidth = panelWidth / (float)TableGridComponent.this.columns;
                float tileHeight = panelHeight / (float)TableGridComponent.this.rows;
                int column = RangesKt.coerceIn((int)((int)Math.floor((float)point.x / tileWidth)), (int)0, (int)(TableGridComponent.this.columns - 1));
                int row = RangesKt.coerceIn((int)((int)Math.floor((float)point.y / tileHeight)), (int)0, (int)(TableGridComponent.this.rows - 1));
                return TuplesKt.to((Object)row, (Object)column);
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Point point = event.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                Pair<Integer, Integer> pair = this.obtainIndices(point);
                int row = ((Number)pair.component1()).intValue();
                int column = ((Number)pair.component2()).intValue();
                TableGridComponent.this.updateSelection(row, column);
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (SwingUtilities.isLeftMouseButton(event)) {
                    Point point = event.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    Pair<Integer, Integer> pair = this.obtainIndices(point);
                    int row = ((Number)pair.component1()).intValue();
                    int column = ((Number)pair.component2()).intValue();
                    TableGridComponent.this.updateSelection(row, column);
                    TableGridComponent.this.indicesSelected(row, column);
                }
            }
        }
    }
}

