/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementList;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSRedundantSwitchStatementInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSRedundantSwitchStatementInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSRedundantSwitchStatementInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSSwitchStatement(@NotNull JSSwitchStatement switchStatement) {
                JSExpression expression;
                if (switchStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expression = switchStatement.getSwitchExpression()) == null) {
                    return;
                }
                JSCaseClause[] clauses = switchStatement.getCaseClauses();
                if (clauses.length == 0) {
                    boolean mayHaveSideEffects = SideEffectChecker.mayHaveSideEffects(expression);
                    String message = JavaScriptBundle.message("js.redundant.switch.problems.inspection.empty", new Object[0]);
                    RemoveSwitchStatementFix fix = new RemoveSwitchStatementFix(mayHaveSideEffects);
                    if (!mayHaveSideEffects) {
                        holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{fix});
                    } else {
                        TextRange expressionInnerRange = expression.getTextRange().shiftLeft(switchStatement.getTextOffset());
                        holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(0, expressionInnerRange.getStartOffset()), new LocalQuickFix[]{fix});
                        holder.registerProblem((PsiElement)switchStatement, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new TextRange(expressionInnerRange.getEndOffset(), switchStatement.getTextLength()), new LocalQuickFix[]{fix});
                    }
                } else if (clauses.length == 1) {
                    JSCaseClause clause = clauses[0];
                    if (clause.isDefault()) {
                        boolean mayHaveSideEffects = SideEffectChecker.mayHaveSideEffects(expression);
                        holder.registerProblem((PsiElement)switchStatement, switchStatement.getFirstChild().getTextRange().shiftLeft(switchStatement.getTextOffset()), JavaScriptBundle.message("js.redundant.switch.problems.inspection.default", new Object[0]), new LocalQuickFix[]{new UnwrapSwitchStatementFix(mayHaveSideEffects)});
                    } else if (clause.getCaseExpression() != null) {
                        this.registerSwitchToIfProblem(switchStatement);
                    }
                } else if (JSRedundantSwitchStatementInspection.isCaseDefaultWithProperExits(clauses)) {
                    this.registerSwitchToIfProblem(switchStatement);
                }
            }

            private void registerSwitchToIfProblem(JSSwitchStatement switchStatement) {
                holder.registerProblem((PsiElement)switchStatement, switchStatement.getFirstChild().getTextRange().shiftLeft(switchStatement.getTextOffset()), JavaScriptBundle.message("js.redundant.switch.problems.inspection.single", new Object[0]), new LocalQuickFix[]{new ReplaceWithIfStatement()});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$1", "visitJSSwitchStatement"));
            }
        };
    }

    public static boolean isCaseDefaultWithProperExits(JSCaseClause[] clauses) {
        JSCaseClause nonDefaultClause;
        if (clauses.length != 2 || !clauses[0].isDefault() && !clauses[1].isDefault()) {
            return false;
        }
        JSCaseClause jSCaseClause = nonDefaultClause = clauses[0].isDefault() ? clauses[1] : clauses[0];
        if (nonDefaultClause.getCaseExpression() == null) {
            return false;
        }
        JSSourceElement lastElement = (JSSourceElement)ArrayUtil.getLastElement((Object[])nonDefaultClause.getStatementListItems());
        return lastElement instanceof JSBreakStatement && ((JSBreakStatement)lastElement).getLabel() == null || lastElement instanceof JSReturnStatement;
    }

    private static void addStatementsToBlockNoBreak(JSSourceElement[] statements, PsiElement blockStatement, PsiElement initialAnchor) {
        if (statements.length == 0 || statements[0] instanceof JSBreakStatement) {
            return;
        }
        PsiElement element2 = blockStatement.addAfter((PsiElement)statements[0], initialAnchor != null ? initialAnchor : blockStatement.getFirstChild());
        for (int i = 1; i < statements.length; ++i) {
            if (statements[i] instanceof JSBreakStatement) {
                return;
            }
            element2 = blockStatement.addAfter((PsiElement)statements[i], element2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceWithIfStatement
    implements LocalQuickFix {
        private ReplaceWithIfStatement() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.redundant.switch.problems.inspection.single.replace", new Object[0]);
            if (string == null) {
                ReplaceWithIfStatement.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JSCaseClause nonDefaultClause;
            if (project == null) {
                ReplaceWithIfStatement.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ReplaceWithIfStatement.$$$reportNull$$$0(2);
            }
            JSSwitchStatement switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), JSSwitchStatement.class, (boolean)false);
            assert (switchStatement != null);
            JSCaseClause[] clauses = switchStatement.getCaseClauses();
            JSCaseClause jSCaseClause = clauses.length == 1 ? clauses[0] : (nonDefaultClause = clauses[0].isDefault() ? clauses[1] : clauses[0]);
            assert (nonDefaultClause != null);
            JSCaseClause defaultClause = clauses.length == 1 ? null : (clauses[0].isDefault() ? clauses[0] : clauses[1]);
            JSExpression caseExpression = nonDefaultClause.getCaseExpression();
            JSExpression expression = switchStatement.getSwitchExpression();
            assert (expression != null);
            assert (caseExpression != null);
            String text = "if (" + expression.getText() + " === " + caseExpression.getText() + ") {}";
            if (defaultClause != null) {
                text = text + "else {}";
            }
            JSIfStatement ifStatement = JSPsiElementFactory.createJSStatement(text, (PsiElement)switchStatement, JSIfStatement.class);
            JSStatement then = (JSStatement)ifStatement.getThenBranch();
            assert (then != null);
            JSRedundantSwitchStatementInspection.addStatementsToBlockNoBreak(nonDefaultClause.getStatementListItems(), (PsiElement)then, null);
            if (defaultClause != null) {
                JSStatement anElse = (JSStatement)ifStatement.getElseBranch();
                assert (anElse != null);
                JSRedundantSwitchStatementInspection.addStatementsToBlockNoBreak(defaultClause.getStatementListItems(), (PsiElement)anElse, null);
            }
            switchStatement.replace(ifStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$ReplaceWithIfStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$ReplaceWithIfStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class UnwrapSwitchStatementFix
    implements LocalQuickFix {
        private final boolean myMayHaveSideEffects;

        private UnwrapSwitchStatementFix(boolean mayHaveSideEffects) {
            this.myMayHaveSideEffects = mayHaveSideEffects;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.redundant.switch.problems.inspection.default.unwrap", new Object[0]) + (String)(this.myMayHaveSideEffects ? " " + JavaScriptBundle.message("js.redundant.switch.problems.inspection.side.effects", new Object[0]) : "");
            if (string == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JSBlockStatement blockStatement;
            if (project == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                UnwrapSwitchStatementFix.$$$reportNull$$$0(2);
            }
            JSSwitchStatement switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), JSSwitchStatement.class, (boolean)false);
            assert (switchStatement != null);
            JSCaseClause clause = switchStatement.getCaseClauses()[0];
            JSSourceElement[] statements = clause.getStatementListItems();
            boolean empty2 = statements.length == 0 || statements.length == 1 && statements[0] instanceof JSBreakStatement;
            JSBlockStatement jSBlockStatement = blockStatement = empty2 || !UnwrapSwitchStatementFix.hasScopeConflicts(statements, switchStatement) ? null : JSPsiElementFactory.createJSStatement("{}", clause, JSBlockStatement.class);
            if (blockStatement != null) {
                JSRedundantSwitchStatementInspection.addStatementsToBlockNoBreak(statements, blockStatement, null);
            }
            if (this.myMayHaveSideEffects) {
                String semi = JSCodeStyleSettings.getSemicolon((PsiElement)switchStatement);
                switchStatement.addStatementBefore(JSPsiElementFactory.createJSStatement(switchStatement.getSwitchExpression().getText() + semi, (PsiElement)switchStatement));
            }
            if (!empty2) {
                if (blockStatement != null) {
                    switchStatement.replace(blockStatement);
                } else {
                    JSRedundantSwitchStatementInspection.addStatementsToBlockNoBreak(statements, switchStatement.getParent(), (PsiElement)switchStatement);
                    switchStatement.delete();
                }
            } else {
                switchStatement.delete();
            }
        }

        private static boolean hasScopeConflicts(JSSourceElement[] statements, JSSwitchStatement switchStatement) {
            HashSet<String> names = new HashSet<String>();
            for (JSSourceElement statement : statements) {
                UnwrapSwitchStatementFix.collectAllBlockScopeNames(names, statement);
            }
            HashSet<String> otherNames = new HashSet<String>();
            JSStatementList statementsRange = (JSStatementList)PsiTreeUtil.getParentOfType((PsiElement)switchStatement, JSStatementList.class);
            while (statementsRange != null) {
                for (JSSourceElement element2 : statementsRange.getStatementListItems()) {
                    UnwrapSwitchStatementFix.collectAllBlockScopeNames(otherNames, element2);
                }
                statementsRange = (JSStatementList)PsiTreeUtil.getParentOfType((PsiElement)statementsRange, JSStatementList.class);
            }
            names.retainAll(otherNames);
            return !names.isEmpty();
        }

        private static void collectAllBlockScopeNames(Set<String> names, JSSourceElement statement) {
            ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)statement).forceIgnore(Conditions.instanceOf(JSBlockStatement.class))).filter(JSVarStatement.class).filter(v -> v.getVarKeyword() != JSVarStatement.VarKeyword.VAR).flatMap(s -> JBIterable.of((Object[])s.getVariables())).map(v -> v.getName()).addAllTo(names);
            ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)statement).forceIgnore(Conditions.instanceOf(JSBlockStatement.class))).filter(Conditions.instanceOf((Class[])new Class[]{JSClass.class, JSFunction.class}))).traverse().map(f -> ((PsiNamedElement)f).getName()).addAllTo(names);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$UnwrapSwitchStatementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$UnwrapSwitchStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class RemoveSwitchStatementFix
    implements LocalQuickFix {
        private final boolean myMayHaveSideEffects;

        private RemoveSwitchStatementFix(boolean mayHaveSideEffects) {
            this.myMayHaveSideEffects = mayHaveSideEffects;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.redundant.switch.problems.inspection.empty.remove", new Object[0]) + (String)(this.myMayHaveSideEffects ? " " + JavaScriptBundle.message("js.redundant.switch.problems.inspection.side.effects", new Object[0]) : "");
            if (string == null) {
                RemoveSwitchStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveSwitchStatementFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveSwitchStatementFix.$$$reportNull$$$0(2);
            }
            JSSwitchStatement element2 = (JSSwitchStatement)descriptor.getPsiElement();
            if (this.myMayHaveSideEffects) {
                element2.addStatementBefore(JSPsiElementFactory.createJSStatement(element2.getSwitchExpression().getText() + JSCodeStyleSettings.getSemicolon((PsiElement)element2), (PsiElement)element2));
            }
            element2.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$RemoveSwitchStatementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRedundantSwitchStatementInspection$RemoveSwitchStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

