/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.formatter.chainedMethods.ParameterBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBinaryExpressionBlock
extends JSBlock
implements ParameterBlock {
    private final boolean myShouldIndentChildren;
    private final CommonCodeStyleSettings myCommonSettings;
    private Wrap myWrap;
    private Alignment myAlignment;

    public JSBinaryExpressionBlock(@NotNull ASTNode child, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, boolean shouldIndentChildren, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (child == null) {
            JSBinaryExpressionBlock.$$$reportNull$$$0(0);
        }
        if (jsBlockContext == null) {
            JSBinaryExpressionBlock.$$$reportNull$$$0(1);
        }
        super(child, alignment, indent, wrap, alignmentFactory, jsBlockContext);
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myShouldIndentChildren = shouldIndentChildren;
        this.myCommonSettings = jsBlockContext.getCommonSettings();
    }

    @Override
    @NotNull
    public List<Block> buildChildren() {
        ArrayList<ASTNode> subExpressions = new ArrayList<ASTNode>();
        JSBinaryExpressionBlock.collectExpressions(this.myNode, subExpressions);
        Indent childIndent = this.myShouldIndentChildren ? Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION) : Indent.getNoneIndent();
        Wrap sharedWrap = JSFormatterUtil.shouldWrapEveryItem(this.myCommonSettings.BINARY_OPERATION_WRAP) ? Wrap.createWrap((int)4, (boolean)true) : null;
        ASTNode first = subExpressions.get(0);
        List list = ContainerUtil.map(subExpressions, child -> {
            boolean isFirst = child == first;
            Alignment childAlignment = this.mySharedAlignmentFactory != null ? this.mySharedAlignmentFactory.getAlignment((ASTNode)child) : null;
            Wrap childWrap = this.getChildWrap((ASTNode)child, isFirst, sharedWrap);
            return this.myBlockContext.createBlock((ASTNode)child, childWrap, childAlignment, childIndent, this.mySharedAlignmentFactory, this);
        });
        if (list == null) {
            JSBinaryExpressionBlock.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    private Wrap getChildWrap(@NotNull ASTNode child, boolean isFirst, @Nullable Wrap sharedWrap) {
        if (child == null) {
            JSBinaryExpressionBlock.$$$reportNull$$$0(3);
        }
        boolean isOperationSign = JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(child.getElementType());
        if (isFirst || isOperationSign != this.myCommonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
            return null;
        }
        return (Wrap)ObjectUtils.coalesce((Object)sharedWrap, (Object)Wrap.createWrap((int)this.myCommonSettings.BINARY_OPERATION_WRAP, (boolean)true));
    }

    public void setParameterWrap(@Nullable Wrap parameterWrap) {
        this.myWrap = parameterWrap;
    }

    public void setAlignment(@Nullable Alignment alignment) {
        this.myAlignment = alignment;
    }

    @Override
    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Override
    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    private static void collectExpressions(@NotNull ASTNode rootNode2, @NotNull ArrayList<ASTNode> results) {
        if (rootNode2 == null) {
            JSBinaryExpressionBlock.$$$reportNull$$$0(4);
        }
        if (results == null) {
            JSBinaryExpressionBlock.$$$reportNull$$$0(5);
        }
        for (ASTNode child = rootNode2.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (JSElementTypes.BINARY_EXPRESSION == child.getElementType()) {
                JSBinaryExpressionBlock.collectExpressions(child, results);
                continue;
            }
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
            results.add(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsBlockContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBinaryExpressionBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildWrap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

