/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.javascript.testFramework.jasmine.JestTestNamePatternUtil;
import com.intellij.javascript.testFramework.util.JSTestNamePattern;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/testFramework/util/JSTestNamePatternBuilder;", "", "withEachGenerator", "", "callExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "<init>", "(ZLcom/intellij/lang/javascript/psi/JSCallExpression;)V", "build", "Lcom/intellij/javascript/testFramework/util/JSTestNamePattern;", "expr", "Lcom/intellij/lang/javascript/psi/JSExpression;", "getLiteralExpressionPattern", "literalExpr", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "getTemplateStringPattern", "templateExpr", "Lcom/intellij/lang/javascript/psi/ecma6/JSStringTemplateExpression;", "getReferencePattern", "referenceExpr", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "getSystemDependentPathLiteralPattern", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolveStrictly", "Lcom/intellij/psi/PsiElement;", "getPlusOperationPattern", "binaryExpr", "Lcom/intellij/lang/javascript/psi/JSBinaryExpression;", "createLiteralPattern", "unescapedString", "", "Companion", "intellij.javascript.testing"})
@SourceDebugExtension(value={"SMAP\nJSTestNamePatternBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTestNamePatternBuilder.kt\ncom/intellij/javascript/testFramework/util/JSTestNamePatternBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n14#2:153\n11228#3:154\n11563#3,3:155\n11546#3,9:158\n13472#3:167\n13473#3:169\n11555#3:170\n1#4:168\n1056#5:171\n1374#5:172\n1460#5,5:173\n*S KotlinDebug\n*F\n+ 1 JSTestNamePatternBuilder.kt\ncom/intellij/javascript/testFramework/util/JSTestNamePatternBuilder\n*L\n53#1:153\n70#1:154\n70#1:155,3\n73#1:158,9\n73#1:167\n73#1:169\n73#1:170\n73#1:168\n76#1:171\n77#1:172\n77#1:173,5\n*E\n"})
public final class JSTestNamePatternBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean withEachGenerator;
    @NotNull
    private final JSCallExpression callExpression;
    private static final ThreadLocal<Boolean> ourExtractInitPerformed = ThreadLocal.withInitial(JSTestNamePatternBuilder::ourExtractInitPerformed$lambda$8);

    public JSTestNamePatternBuilder(boolean withEachGenerator, @NotNull JSCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        this.withEachGenerator = withEachGenerator;
        this.callExpression = callExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSTestNamePattern build(@NotNull JSExpression expr) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        JSTestNamePattern jSTestNamePattern = this.getLiteralExpressionPattern(expr instanceof JSLiteralExpression ? (JSLiteralExpression)expr : null);
        if (jSTestNamePattern != null) {
            JSTestNamePattern it = jSTestNamePattern;
            boolean bl = false;
            return it;
        }
        jSTestNamePattern = this.getReferencePattern(expr instanceof JSReferenceExpression ? (JSReferenceExpression)expr : null);
        if (jSTestNamePattern != null) {
            JSTestNamePattern it = jSTestNamePattern;
            boolean bl = false;
            return it;
        }
        jSTestNamePattern = this.getPlusOperationPattern(expr instanceof JSBinaryExpression ? (JSBinaryExpression)expr : null);
        if (jSTestNamePattern != null) {
            JSTestNamePattern it = jSTestNamePattern;
            boolean bl = false;
            return it;
        }
        if (!ourExtractInitPerformed.get().booleanValue()) {
            try {
                ourExtractInitPerformed.set(true);
                if (expr instanceof JSReferenceExpression) {
                    JSExpression initializer = JsPsiUtils.extractInitExpression((JSReferenceExpression)expr);
                    object = this.getLiteralExpressionPattern(initializer instanceof JSLiteralExpression ? (JSLiteralExpression)initializer : null);
                    if (object != null) {
                        Object it = object;
                        boolean bl = false;
                        Object object2 = it;
                        return object2;
                    }
                }
            }
            finally {
                ourExtractInitPerformed.set(false);
            }
        }
        object = new JSTestNamePattern.Range[]{JSTestNamePattern.anyRange(expr.getText())};
        JSTestNamePattern jSTestNamePattern2 = JSTestNamePattern.pattern(object);
        Intrinsics.checkNotNullExpressionValue((Object)jSTestNamePattern2, (String)"pattern(...)");
        return jSTestNamePattern2;
    }

    private final JSTestNamePattern getLiteralExpressionPattern(JSLiteralExpression literalExpr) {
        if (literalExpr == null) {
            return null;
        }
        if (literalExpr.isStringLiteral()) {
            String stringValue = literalExpr.getStringValue();
            if (stringValue == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(JSTestNamePatternBuilder.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unexpected null string value for " + literalExpr.getText());
                return null;
            }
            return this.createLiteralPattern(stringValue);
        }
        if (literalExpr instanceof JSStringTemplateExpression) {
            return this.getTemplateStringPattern((JSStringTemplateExpression)literalExpr);
        }
        if (literalExpr.isNumericLiteral()) {
            String string = literalExpr.getText();
            Intrinsics.checkNotNull((Object)string);
            return JSTestNamePattern.literalPattern(string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final JSTestNamePattern getTemplateStringPattern(JSStringTemplateExpression templateExpr) {
        void $this$flatMapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        int n;
        void $this$mapTo$iv$iv;
        String templateText = templateExpr.getText();
        TextRange templateTextRange = templateExpr.getTextRange();
        JSExpression[] jSExpressionArray = templateExpr.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
        Object[] $this$map$iv = jSExpressionArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JSExpression jSExpression = (JSExpression)item$iv$iv;
            Object[] objectArray2 = destination$iv$iv;
            n = 0;
            objectArray2.add(TuplesKt.to((Object)it, (Object)it.getTextRange().shiftLeft(templateTextRange.getStartOffset())));
        }
        List argumentPairs = (List)destination$iv$iv;
        TextRange[] textRangeArray = templateExpr.getStringRanges();
        Intrinsics.checkNotNullExpressionValue((Object)textRangeArray, (String)"getStringRanges(...)");
        Object[] $this$mapNotNull$iv = textRangeArray;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            TextRange it = (TextRange)element$iv$iv;
            boolean bl2 = false;
            if ((it.isEmpty() ? null : TuplesKt.to(null, (Object)it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List textRanges = (List)destination$iv$iv2;
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)argumentPairs, (Iterable)textRanges);
        boolean $i$f$sortedBy = false;
        List chunks = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((TextRange)it.getSecond()).getStartOffset());
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextRange)it.getSecond()).getStartOffset()));
            }
        });
        Iterable $this$flatMap$iv = chunks;
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapNotNullTo22 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<JSTestNamePattern.Range> list;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            JSExpression expr = (JSExpression)it.getFirst();
            if (expr == null) {
                String escapedLiteral;
                Intrinsics.checkNotNullExpressionValue((Object)((TextRange)it.getSecond()).substring(templateText), (String)"substring(...)");
                String string = JSStringUtil.unescapeStringLiteralValue(escapedLiteral);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringLiteralValue(...)");
                list = this.createLiteralPattern(string).getRanges();
            } else {
                list = this.build(expr).getRanges();
            }
            List<JSTestNamePattern.Range> list2 = list;
            Intrinsics.checkNotNull(list2);
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List ranges = (List)destination$iv$iv3;
        JSTestNamePattern jSTestNamePattern = JSTestNamePattern.normalizeAndCreate(ranges);
        Intrinsics.checkNotNullExpressionValue((Object)jSTestNamePattern, (String)"normalizeAndCreate(...)");
        return jSTestNamePattern;
    }

    private final JSTestNamePattern getReferencePattern(JSReferenceExpression referenceExpr) {
        String className;
        PsiElement resolvedQualifier;
        JSReferenceExpression qualifier;
        Object object = referenceExpr;
        if (object == null || (object = object.getReferenceName()) == null) {
            return null;
        }
        Object referenceName = object;
        if (referenceExpr.getQualifier() == null && Intrinsics.areEqual((Object)referenceName, (Object)"__filename")) {
            return this.getSystemDependentPathLiteralPattern(PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)referenceExpr)));
        }
        if (referenceExpr.getQualifier() == null && Intrinsics.areEqual((Object)referenceName, (Object)"__dirname")) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)referenceExpr));
            return this.getSystemDependentPathLiteralPattern((VirtualFile)(virtualFile != null ? virtualFile.getParent() : null));
        }
        PsiElement resolvedElement = this.resolveStrictly(referenceExpr);
        if (resolvedElement instanceof JSClassBase || resolvedElement instanceof JSFunction) {
            return JSTestNamePattern.literalPattern((String)referenceName);
        }
        JSExpression jSExpression = referenceExpr.getQualifier();
        JSReferenceExpression jSReferenceExpression = qualifier = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
        if (Intrinsics.areEqual((Object)referenceName, (Object)"name") && qualifier != null && (resolvedQualifier = this.resolveStrictly(qualifier)) instanceof JSClassBase && (className = ((JSClassBase)resolvedQualifier).getName()) != null) {
            return JSTestNamePattern.literalPattern(className);
        }
        return null;
    }

    private final JSTestNamePattern getSystemDependentPathLiteralPattern(VirtualFile file) {
        VirtualFile virtualFile = file;
        return virtualFile != null ? JSTestNamePattern.literalPattern(FileUtil.toSystemDependentName((String)virtualFile.getPath())) : null;
    }

    private final PsiElement resolveStrictly(JSReferenceExpression referenceExpr) {
        ResolveResult[] resolveResultArray = referenceExpr.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        ResolveResult[] resolveResults = resolveResultArray;
        if (resolveResults.length == 1 && JSResolveUtil.isResolveStrict((PsiReference)referenceExpr, resolveResults)) {
            return resolveResults[0].getElement();
        }
        return null;
    }

    private final JSTestNamePattern getPlusOperationPattern(JSBinaryExpression binaryExpr) {
        JSBinaryExpression jSBinaryExpression = binaryExpr;
        if (jSBinaryExpression == null || (jSBinaryExpression = jSBinaryExpression.getOperationSign()) == null) {
            return null;
        }
        JSBinaryExpression operationType = jSBinaryExpression;
        if (operationType == JSTokenTypes.PLUS) {
            JSExpression leftOperand = binaryExpr.getLOperand();
            JSExpression rightOperand = binaryExpr.getROperand();
            if (leftOperand != null && rightOperand != null) {
                JSTestNamePattern leftPattern = this.build(leftOperand);
                JSTestNamePattern rightPattern = this.build(rightOperand);
                return JSTestNamePattern.normalizeAndCreate(ContainerUtil.concat(leftPattern.getRanges(), rightPattern.getRanges()));
            }
        }
        return null;
    }

    private final JSTestNamePattern createLiteralPattern(String unescapedString) {
        if (this.withEachGenerator) {
            return JestTestNamePatternUtil.INSTANCE.parseEachPattern(this.callExpression, unescapedString);
        }
        JSTestNamePattern jSTestNamePattern = JSTestNamePattern.literalPattern(unescapedString);
        Intrinsics.checkNotNullExpressionValue((Object)jSTestNamePattern, (String)"literalPattern(...)");
        return jSTestNamePattern;
    }

    private static final Boolean ourExtractInitPerformed$lambda$8() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/testFramework/util/JSTestNamePatternBuilder$Companion;", "", "<init>", "()V", "ourExtractInitPerformed", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "intellij.javascript.testing"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

