/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterAttachment;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAttachments;", "", "cellNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "attachmentKey", "", "<init>", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/String;)V", "getAttachment", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAttachment;", "key", "putAttachment", "", "mimeType", "Lcom/intellij/jupyter/core/jupyter/nbformat/MimeType;", "data", "intellij.jupyter.core"})
public final class JupyterAttachments {
    @NotNull
    private final JsonNode cellNode;
    @NotNull
    private final String attachmentKey;

    public JupyterAttachments(@NotNull JsonNode cellNode, @NotNull String attachmentKey) {
        Intrinsics.checkNotNullParameter((Object)cellNode, (String)"cellNode");
        Intrinsics.checkNotNullParameter((Object)attachmentKey, (String)"attachmentKey");
        this.cellNode = cellNode;
        this.attachmentKey = attachmentKey;
    }

    @Nullable
    public final JupyterAttachment getAttachment(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonNode jsonNode = this.cellNode.get(this.attachmentKey);
        if (jsonNode == null) {
            return null;
        }
        JsonNode attachmentsNode = jsonNode;
        JsonNode jsonNode2 = attachmentsNode.get(key);
        if (jsonNode2 == null) {
            return null;
        }
        JsonNode attachmentNode = jsonNode2;
        return new JupyterAttachment((ObjectNode)attachmentNode);
    }

    public final void putAttachment(@NotNull String key, @NotNull MimeType mimeType, @NotNull String data) {
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)((Object)mimeType), (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        JsonNode jsonNode = this.cellNode.get(this.attachmentKey);
        if (jsonNode == null) {
            jsonNode = (JsonNode)this.cellNode.withObjectProperty(this.attachmentKey);
        }
        JsonNode attachmentsNode = jsonNode;
        ObjectNode $this$putAttachment_u24lambda_u240 = objectNode = attachmentsNode.withObjectProperty(key);
        boolean bl = false;
        $this$putAttachment_u24lambda_u240.put(mimeType.getMimeType(), data);
    }
}

