/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.SqlValuesExtractor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.Out;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlUpdateValuesExtractor
extends SqlValuesExtractor {
    private final Dbms myDbms;

    public SqlUpdateValuesExtractor(ObjectFormatter converter, @Nullable DasObject databaseTable, @NotNull Dbms dbms) {
        if (dbms == null) {
            SqlUpdateValuesExtractor.$$$reportNull$$$0(0);
        }
        super(converter, databaseTable);
        this.myDbms = dbms;
    }

    @Override
    public SqlUpdateExtraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (out == null) {
            SqlUpdateValuesExtractor.$$$reportNull$$$0(1);
        }
        if (allColumns == null) {
            SqlUpdateValuesExtractor.$$$reportNull$$$0(2);
        }
        if (query == null) {
            SqlUpdateValuesExtractor.$$$reportNull$$$0(3);
        }
        if (config == null) {
            SqlUpdateValuesExtractor.$$$reportNull$$$0(4);
        }
        return new SqlUpdateExtraction(out, this.myDbms, config, allColumns, selectedColumns);
    }

    @Nullable
    private static GridColumn getColumnByName(String name2, List<? extends GridColumn> columns) {
        for (GridColumn gridColumn : columns) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)gridColumn.getName(), (CharSequence)name2)) continue;
            return gridColumn;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/SqlUpdateValuesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startExtraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SqlUpdateExtraction
    extends SqlValuesExtractor.SqlExtractionBase {
        SqlUpdateExtraction(Out output, @NotNull Dbms dbms, ExtractionConfig config, List<? extends GridColumn> allColumns, int[] selectedColumnIndices) {
            if (config == null) {
                SqlUpdateExtraction.$$$reportNull$$$0(0);
            }
            super(output, dbms, config, allColumns, selectedColumnIndices);
        }

        protected void appendData(List<? extends GridRow> rows) {
            DasTableKey key;
            LinkedHashSet<GridColumn> pkColumns = new LinkedHashSet<GridColumn>();
            DasTableKey dasTableKey = key = SqlUpdateValuesExtractor.this.myDatabaseTable == null ? null : DasUtil.getPrimaryKey((DasObject)SqlUpdateValuesExtractor.this.myDatabaseTable);
            if (key != null) {
                for (String pkName : key.getColumnsRef().names()) {
                    ContainerUtil.addIfNotNull(pkColumns, (Object)SqlUpdateValuesExtractor.getColumnByName(pkName, this.myAllColumns));
                }
            }
            if (pkColumns.isEmpty()) {
                for (GridColumn column2 : this.myAllColumns) {
                    if (!GridUtilCore.isRowId((GridColumn)column2)) continue;
                    pkColumns.add(column2);
                }
            }
            int[] selectedColumns = GridExtractorsUtilCore.getNonEmptySelection((List)this.myAllColumns, (int[])this.mySelectedColumnIndices);
            Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping((List)this.myAllColumns);
            for (GridColumn gridColumn : this.myAllColumns) {
                if (!GridUtilCore.isRowId((GridColumn)gridColumn)) continue;
                columnsMap.remove(gridColumn.getColumnNumber());
            }
            for (GridRow gridRow : rows) {
                this.myDdlBuilder.keyword("UPDATE").space();
                if (SqlUpdateValuesExtractor.this.myDatabaseTable != null) {
                    this.myDdlBuilder.qualifiedRef(SqlUpdateValuesExtractor.this.myDatabaseTable);
                } else {
                    this.myDdlBuilder.identifier("MY_TABLE");
                }
                this.myDdlBuilder.space().keyword("SET").space();
                boolean first2 = true;
                for (int selectedColumn : selectedColumns) {
                    GridColumn column4 = (GridColumn)columnsMap.get(selectedColumn);
                    if (column4 == null || pkColumns.contains(column4)) continue;
                    if (first2) {
                        first2 = false;
                    } else {
                        this.myDdlBuilder.symbol(",").space();
                    }
                    this.myDdlBuilder.columnRef(column4.getName()).space().symbol("=").space().literal(SqlUpdateValuesExtractor.this.getValueLiteral(gridRow, column4, ObjectFormatterMode.SQL_SCRIPT));
                }
                if (!pkColumns.isEmpty()) {
                    this.myDdlBuilder.space().keyword("WHERE").space();
                    first2 = true;
                    Object object = pkColumns.iterator();
                    while (object.hasNext()) {
                        GridColumn column5 = (GridColumn)object.next();
                        if (first2) {
                            first2 = false;
                        } else {
                            this.myDdlBuilder.space().keyword("AND").space();
                        }
                        this.myDdlBuilder.columnRef(column5.getName()).space().symbol("=").space().literal(SqlUpdateValuesExtractor.this.getValueLiteral(gridRow, column5, ObjectFormatterMode.SQL_SCRIPT));
                    }
                }
                this.myDdlBuilder.symbol(";").newLine();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/extractors/SqlUpdateValuesExtractor$SqlUpdateExtraction", "<init>"));
        }
    }
}

