/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.bigquery.BigQueryAuthParameter;
import com.intellij.database.dialects.bigquery.BigQueryAuthParameters;
import com.intellij.database.dialects.bigquery.BigQueryAuthProvider;
import com.intellij.database.dialects.bigquery.FieldType;
import com.intellij.database.dialects.bigquery.ParameterType;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.project.Project;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J$\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u000bH\u0016J,\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010*\u001a\u0004\u0018\u00010#2\u0006\u0010&\u001a\u00020\u000bH\u0016J&\u0010+\u001a\u00020\u0014*\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/database/dialects/bigquery/BigQueryAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "Lcom/intellij/database/run/ConsoleConfigurationParamProvider;", "parameters", "", "Lcom/intellij/database/dialects/bigquery/BigQueryAuthParameter;", "authType", "", "<init>", "(Ljava/util/List;I)V", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyCredentials", "values", "Lcom/intellij/database/dialects/bigquery/BigQueryAuthParameters;", "populate", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/ParametersList;", "env", "", "", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "saveAuthConfig", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "configureWidget", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.bigquery"})
@SourceDebugExtension(value={"SMAP\nBigQueryAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryAuthProvider.kt\ncom/intellij/database/dialects/bigquery/BigQueryAuthProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,161:1\n1#2:162\n1255#3,2:163\n19#4:165\n*S KotlinDebug\n*F\n+ 1 BigQueryAuthProvider.kt\ncom/intellij/database/dialects/bigquery/BigQueryAuthProvider\n*L\n36#1:163,2\n75#1:165\n*E\n"})
public abstract class BigQueryAuthProvider
implements DatabaseAuthProvider,
ConsoleConfigurationParamProvider {
    @NotNull
    private final List<BigQueryAuthParameter> parameters;
    private final int authType;

    public BigQueryAuthProvider(@NotNull List<BigQueryAuthParameter> parameters, int authType) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.parameters = parameters;
        this.authType = authType;
    }

    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        return BigQueryAuthProvider.interceptConnection$suspendImpl(this, proto2, silent, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object interceptConnection$suspendImpl(BigQueryAuthProvider $this, DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof interceptConnection.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ BigQueryAuthProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BigQueryAuthProvider.interceptConnection$suspendImpl(this.this$0, null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)proto);
                $continuation.Z$0 = silent;
                $continuation.label = 1;
                v0 = DatabaseCredentialsAuthProvider.Companion.applyInitialCredentials(proto, (DatabaseAuthProvider)$this, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, interceptConnection$lambda$0(com.intellij.database.dialects.bigquery.BigQueryAuthProvider com.intellij.database.dataSource.DatabaseConnectionInterceptor$ProtoConnection java.lang.Object ), (Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;Ljava/lang/Object;)Ljava/lang/Boolean;)((BigQueryAuthProvider)$this), silent != false, (Continuation)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                silent = $continuation.Z$0;
                proto = (DatabaseConnectionInterceptor.ProtoConnection)$continuation.L$1;
                $this = (BigQueryAuthProvider)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean applyCredentials(DatabaseConnectionInterceptor.ProtoConnection proto2, BigQueryAuthParameters values) {
        boolean bl;
        BigQueryAuthParameters bigQueryAuthParameters = values;
        if (bigQueryAuthParameters != null) {
            boolean bl2;
            block4: {
                BigQueryAuthParameters it = bigQueryAuthParameters;
                boolean bl3 = false;
                Sequence $this$any$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.parameters), BigQueryAuthProvider::applyCredentials$lambda$3$lambda$1);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    BigQueryAuthParameter it2 = (BigQueryAuthParameter)element$iv;
                    boolean bl4 = false;
                    CharSequence charSequence = values.getParams().get(it2);
                    boolean bl5 = charSequence == null || charSequence.length() == 0;
                    if (!bl5) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            bl = !bl2;
        } else {
            bl = false;
        }
        boolean isEmpty = !bl;
        DbImplUtilCore.putOrRemove((Map)proto2.getConnectionProperties(), (Object)"OAuthType", (Object)String.valueOf(this.authType));
        for (BigQueryAuthParameter parameter : this.parameters) {
            if (parameter.getParameterType() != ParameterType.URL) continue;
            Object object = parameter.loadImpl(proto2.getConnectionPoint(), proto2.getCredentials());
            String value = object != null ? object.toString() : null;
            DbImplUtilCore.putOrRemove((Map)proto2.getConnectionProperties(), (Object)parameter.getJdbcParameter(), (Object)value);
        }
        return isEmpty;
    }

    public void populate(@NotNull LocalDataSource dataSource, @NotNull ParametersList params, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        for (BigQueryAuthParameter parameter : this.parameters) {
            if (parameter.getParameterType() != ParameterType.VM_OPTION) continue;
            Object object = parameter.loadImpl((DatabaseConnectionPoint)dataSource, null);
            String v = object != null ? object.toString() : null;
            DbImplUtilCore.putOrRemove(env, (Object)parameter.getJdbcParameter(), (Object)v);
        }
    }

    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        JdbcUrlParser parsed;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!point.getDbms().eq(Dbms.BIGQUERY)) {
            return DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE;
        }
        if (level.compareTo((Enum)DatabaseAuthProvider.ApplicabilityLevel.PREFERRED) < 0) {
            return DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
        }
        JdbcUrlParser jdbcUrlParser = parsed = JdbcUrlParserUtil.parsed((RawConnectionConfig)((RawConnectionConfig)point));
        return Intrinsics.areEqual((Object)(jdbcUrlParser != null ? jdbcUrlParser.getParameter("OAuthType") : null), (Object)String.valueOf(this.authType)) ? DatabaseAuthProvider.ApplicabilityLevel.Result.PREFERRED : DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT;
    }

    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        LinkedHashMap map2 = new LinkedHashMap();
        for (BigQueryAuthParameter parameter : this.parameters) {
            if (external && parameter.getType() != FieldType.PASSWORD) continue;
            Object object = parameter.loadImpl(point, credentials);
            if (object == null || (object = object.toString()) == null) continue;
            Object it = object;
            boolean bl = false;
            ((Map)map2).put(parameter, it);
        }
        return map2.isEmpty() ? null : new BigQueryAuthParameters(map2);
    }

    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        BigQueryAuthParameters bigQueryAuthParameters;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object object = data;
        if (object != null) {
            Object $this$asSafely$iv = object;
            boolean $i$f$asSafely = false;
            Object object2 = $this$asSafely$iv;
            if (!(object2 instanceof BigQueryAuthParameters)) {
                object2 = null;
            }
            bigQueryAuthParameters = (BigQueryAuthParameters)object2;
        } else {
            bigQueryAuthParameters = null;
        }
        BigQueryAuthParameters params = bigQueryAuthParameters;
        for (BigQueryAuthParameter parameter : this.parameters) {
            if (external && parameter.getType() != FieldType.PASSWORD) continue;
            Object object3 = params;
            parameter.saveImpl(config, credentials, object3 != null && (object3 = ((BigQueryAuthParameters)object3).getParams()) != null ? (String)object3.get(parameter) : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureWidget(@NotNull AuthWidgetBuilder $this$configureWidget, @Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$configureWidget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean storageAdded = false;
        for (BigQueryAuthParameter parameter : this.parameters) {
            AuthWidgetBuilder authWidgetBuilder;
            AuthWidgetBuilder.UrlHandler urlHandler;
            AuthWidgetBuilder.UrlHandler urlHandler2 = urlHandler = parameter.getParameterType() == ParameterType.URL ? AuthWidgetBuilder.removeParameterHandler((String)parameter.getJdbcParameter()) : null;
            if (parameter.getType() == FieldType.FILE) {
                authWidgetBuilder = $this$configureWidget.addFileField(parameter.getTitle(), parameter.getTitle(), parameter.stringSerialiser(), urlHandler);
                continue;
            }
            if (parameter.getType() == FieldType.PASSWORD) {
                AuthWidgetBuilder.UrlHandler urlHandler3;
                AuthWidgetBuilder authWidgetBuilder2 = $this$configureWidget;
                Supplier<String> supplier = parameter.getTitle();
                AuthWidgetBuilder.Serialiser<OneTimeString> serialiser = parameter.oneTimeStringSerialiser();
                boolean bl = !storageAdded;
                if (urlHandler != null) {
                    void it;
                    boolean bl2 = bl;
                    AuthWidgetBuilder.Serialiser<OneTimeString> serialiser2 = serialiser;
                    Supplier<String> supplier2 = supplier;
                    AuthWidgetBuilder authWidgetBuilder3 = authWidgetBuilder2;
                    boolean bl3 = false;
                    AuthWidgetBuilder.UrlHandler urlHandler4 = AuthWidgetBuilder.adapt((AuthWidgetBuilder.UrlHandler)it, null);
                    authWidgetBuilder2 = authWidgetBuilder3;
                    supplier = supplier2;
                    serialiser = serialiser2;
                    bl = bl2;
                    urlHandler3 = urlHandler4;
                } else {
                    urlHandler3 = null;
                }
                authWidgetBuilder2.addPasswordField(supplier, serialiser, bl, urlHandler3);
                storageAdded = true;
                authWidgetBuilder = Unit.INSTANCE;
                continue;
            }
            authWidgetBuilder = $this$configureWidget.addTextField(parameter.getTitle(), parameter.stringSerialiser(), urlHandler);
        }
        $this$configureWidget.addHandler(null, null, AuthWidgetBuilder.removeParameterHandler((String)"OAuthType"));
    }

    private static final Boolean interceptConnection$lambda$0(BigQueryAuthProvider this$0, DatabaseConnectionInterceptor.ProtoConnection p2, Object c2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
        return this$0.applyCredentials(p2, c2 instanceof BigQueryAuthParameters ? (BigQueryAuthParameters)c2 : null);
    }

    private static final boolean applyCredentials$lambda$3$lambda$1(BigQueryAuthParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() == FieldType.PASSWORD;
    }
}

