/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.model.state;

import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dbimport.editor.model.state.DbAutoReferenceModelState;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbAutoDefinitionState
extends DbEditorModelBase.StateBase {
    public static final BasicMetaId ID = BasicMetaId.create((String)"DbAutoTableState");
    private final Set<ElementIdentity<?>> myAutoDefinitionSources = new LinkedHashSet();
    private boolean myInManualMode = false;

    public boolean isInManualMode() {
        return this.myInManualMode;
    }

    public void setInManualMode(boolean inManualMode) {
        if (this.myInManualMode == inManualMode) {
            return;
        }
        this.myInManualMode = inManualMode;
        this.modified();
    }

    @Nullable
    public ElementIdentity<?> getAutoDefinitionSource(@NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbAutoDefinitionState.$$$reportNull$$$0(0);
        }
        return (ElementIdentity)ContainerUtil.find(this.myAutoDefinitionSources, id -> {
            DbReferenceModelState state = controller.resolveState((ElementIdentity<?>)id, (BasicMetaId)MappingData.TABLE_REF, DbReferenceModelState.class);
            if (state instanceof DbAutoReferenceModelState) {
                DbAutoReferenceModelState as = (DbAutoReferenceModelState)state;
                return as.getDefinesTable();
            }
            return false;
        });
    }

    @NotNull
    public Set<ElementIdentity<?>> getAutoDefinitionSources() {
        Set<ElementIdentity<?>> set = this.myAutoDefinitionSources;
        if (set == null) {
            DbAutoDefinitionState.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    public boolean register(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbAutoDefinitionState.$$$reportNull$$$0(2);
        }
        if (!super.register(model)) {
            return false;
        }
        LinkedHashSet sources = new LinkedHashSet();
        for (DbModelRef<?, ?> ref2 : model.getController().getAllModelsRefs()) {
            DbAutoReferenceModelState s2;
            Object obj = ref2.getState();
            if (!(obj instanceof DbAutoReferenceModelState) || (s2 = (DbAutoReferenceModelState)obj).getTargetId() != model.getIdentity()) continue;
            sources.add(ref2.getIdentity());
        }
        this.setAutoDefinitionSources(sources);
        return true;
    }

    @Override
    public boolean unregister(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbAutoDefinitionState.$$$reportNull$$$0(3);
        }
        if (!super.unregister(model)) {
            return false;
        }
        this.setAutoDefinitionSources(Collections.emptySet());
        return true;
    }

    public void setAutoDefinitionSources(@NotNull Set<ElementIdentity<?>> sources) {
        if (sources == null) {
            DbAutoDefinitionState.$$$reportNull$$$0(4);
        }
        if (sources.equals(this.myAutoDefinitionSources)) {
            return;
        }
        this.myAutoDefinitionSources.clear();
        this.myAutoDefinitionSources.addAll(sources);
        this.modified();
    }

    @Nullable
    public static DbAutoDefinitionState resolve(@NotNull DbEditorModelController controller, @Nullable ElementIdentity<?> id) {
        if (controller == null) {
            DbAutoDefinitionState.$$$reportNull$$$0(5);
        }
        DbEditorModel model = id == null ? null : controller.resolveRegisteredOrCachedModel(new DbModelIdentity(id, ID));
        return (DbAutoDefinitionState)ObjectUtils.tryCast(model == null ? null : model.getState(), DbAutoDefinitionState.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/model/state/DbAutoDefinitionState";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/model/state/DbAutoDefinitionState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoDefinitionSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutoDefinitionSource";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAutoDefinitionSources";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

