/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class DdlMappingSourceValidator
extends DatabaseConfigValidator<DdlMapping> {
    @Override
    public Class<? extends DdlMapping> getTargetClass() {
        return DdlMapping.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull DdlMapping target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            DdlMappingSourceValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            DdlMappingSourceValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            DdlMappingSourceValidator.$$$reportNull$$$0(2);
        }
        if (target.getScope() == null) {
            problems.consume((Object)new DataSourceProblem(target, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.incomplete.mapping", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.no.scope.configured", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.no.scope.configured", (Object[])new Object[0]), new Object[0]), null));
        }
        DdlMappingSourceValidator.validateDsReference(project, target, configInfoProvider, problems, target.getDataSourceId(), "notification.content.no.data.source.specified", "notification.content.non.existing.data.source.specified");
        DdlMappingSourceValidator.validateDsReference(project, target, configInfoProvider, problems, target.getDdlDataSourceId(), "notification.content.no.ddl.data.source.specified", "notification.content.non.existing.ddl.data.source.specified");
    }

    private static void validateDsReference(@NotNull Project project, @NotNull DdlMapping target, @Nullable ActualConfigInfoProvider configInfoProvider, @NotNull Consumer<? super DataSourceProblem> problems, String dataSourceId, @PropertyKey(resourceBundle="messages.DatabaseBundle") @PropertyKey(resourceBundle="messages.DatabaseBundle") String keyUnspecified, @PropertyKey(resourceBundle="messages.DatabaseBundle") @PropertyKey(resourceBundle="messages.DatabaseBundle") String keyMissing) {
        DbDataSource dataSource;
        if (project == null) {
            DdlMappingSourceValidator.$$$reportNull$$$0(3);
        }
        if (target == null) {
            DdlMappingSourceValidator.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            DdlMappingSourceValidator.$$$reportNull$$$0(5);
        }
        if (dataSourceId == null) {
            problems.consume((Object)new DataSourceProblem(target, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.incomplete.mapping", (Object[])new Object[0]), DatabaseBundle.message((String)keyUnspecified, (Object[])new Object[0]), DatabaseBundle.message((String)keyUnspecified, (Object[])new Object[0]), new Object[0]), null));
            return;
        }
        DbDataSource dbDataSource = dataSource = configInfoProvider == null ? DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId) : (DbDataSource)ContainerUtil.find(configInfoProvider.getDataSources(), ds -> ds.getUniqueId().equals(dataSourceId));
        if (dataSource == null) {
            problems.consume((Object)new DataSourceProblem(target, null, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.incomplete.mapping", (Object[])new Object[0]), DatabaseBundle.message((String)keyMissing, (Object[])new Object[0]), DatabaseBundle.message((String)keyMissing, (Object[])new Object[0]), new Object[0]), null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/DdlMappingSourceValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validateDsReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

