/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.util.ObjectPath;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcChangeUtils {
    private static final Logger LOG = Logger.getInstance(DbSrcChangeUtils.class);

    public static void merge(@NotNull Project project, @NotNull VirtualFile file) throws IOException {
        DbSrcFileSystem fs;
        VirtualFile base;
        if (project == null) {
            DbSrcChangeUtils.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DbSrcChangeUtils.$$$reportNull$$$0(1);
        }
        if (!DbSrcUtilsCore.isDbSrcFile((VirtualFile)file)) {
            return;
        }
        if (!DbSrcFileSystemCore.ItemType.SRC.is(file.getName())) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        if ((base = (fs = DbSrcFileSystem.getInstance()).getSatelliteFile(file, DbSrcFileSystemCore.ItemType.USER_BASE, true)) == null) {
            return;
        }
        VirtualFile original = fs.getSatelliteFile(file, DbSrcFileSystemCore.ItemType.ORIG, true);
        ArrayList<byte[]> contents = new ArrayList<byte[]>(3);
        ArrayList<String> titles = new ArrayList<String>(3);
        contents.add(file.contentsToByteArray());
        titles.add(ChangeDiffRequestProducer.getYourVersion());
        contents.add(base.contentsToByteArray());
        titles.add(ChangeDiffRequestProducer.getBaseVersion());
        contents.add(original == null ? ArrayUtil.EMPTY_BYTE_ARRAY : original.contentsToByteArray());
        titles.add(ChangeDiffRequestProducer.getServerVersion());
        ObjectPath path = DbSrcUtilsCore.getFullPath((String)file.getPath());
        try {
            MergeRequest request2 = DiffRequestFactory.getInstance().createMergeRequest(project, file, contents, path == null ? file.getPresentableUrl() : path.getDisplayName(), titles, r -> {
                if (r == MergeResult.CANCEL) {
                    return;
                }
                DbSrcFileSystem.processPath((VirtualFile)file, (DbSrcFileSystemCore.ItemProcessor)new DbSrcFileSystemCore.ItemProcessor<Void>(){

                    public Void processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                        if (dataSourceId == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (path == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (type == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
                        try {
                            if (r == MergeResult.RIGHT) {
                                storage.putUserContent(path, storage.getContent(path, DbSrcFileSystemCore.ItemType.ORIG));
                            }
                            storage.removeBaseContent(path);
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                        }
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "dataSourceId";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "path";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[0] = "type";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangeUtils$1";
                        objectArray[2] = "processFile";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            });
            DiffManager.getInstance().showMerge(project, request2);
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangeUtils";
        objectArray[2] = "merge";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

