/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.chrome.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.protocol.log.LogEntryValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/chrome/wip/WipLogEntry;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/log/LogEntryValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "<init>", "(Lorg/jetbrains/wip/protocol/log/LogEntryValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "printFailedNetworkRequestMessage", "intellij.javascript.debugger"})
public final class WipLogEntry
implements ConsoleMessage {
    @NotNull
    private final LogEntryValue message;
    @Nullable
    private final RequestInfo request;

    public WipLogEntry(@NotNull LogEntryValue message, @Nullable RequestInfo request) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void print(@NotNull ConsoleMessageBuilder printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        url = this.message.getUrl();
        line = this.message.getLineNumber();
        v0 = this.message.getStackTrace();
        stackTrace = v0 != null ? v0.callFrames() : null;
        switch (WhenMappings.$EnumSwitchMapping$0[this.message.level().ordinal()]) {
            case 1: {
                v1 = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                break;
            }
            case 2: {
                v1 = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                break;
            }
            case 3: {
                v1 = ConsoleViewContentType.LOG_INFO_OUTPUT;
                break;
            }
            case 4: {
                v1 = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                break;
            }
            default: {
                v1 = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        contentType = v1;
        Intrinsics.checkNotNull((Object)contentType);
        printer.startMessage(contentType, this.message.source().toString());
        v2 = isFromNetwork = this.message.source() == LogEntryValue.Source.NETWORK;
        if (isFromNetwork) {
            if (this.request == null) {
                ConsoleMessageBuilder.append$default(printer, this.message.text(), null, null, 6, null);
                v3 = this.message.getUrl();
                Intrinsics.checkNotNull((Object)v3);
                ConsoleMessageBuilder.addMessageLink$default(printer, v3, -1, -1, null, false, null, 32, null);
            } else {
                if (this.request.getInitiator() != null) {
                    v4 = this.request.getInitiator();
                    Intrinsics.checkNotNull((Object)v4);
                    v5 = v4.getStack();
                    stackTrace = v5 != null ? v5.callFrames() : null;
                    v6 = this.request.getInitiator();
                    Intrinsics.checkNotNull((Object)v6);
                    if (!StringUtil.isEmpty((String)v6.getUrl())) {
                        v7 = this.request.getInitiator();
                        Intrinsics.checkNotNull((Object)v7);
                        url = v7.getUrl();
                        v8 = this.request.getInitiator();
                        Intrinsics.checkNotNull((Object)v8);
                        line = (int)v8.getLineNumber();
                    }
                }
                if (this.message.level() == LogEntryValue.Level.ERROR) {
                    this.printFailedNetworkRequestMessage(printer);
                } else {
                    ConsoleMessageBuilder.append$default(printer, this.message.text(), null, null, 6, null);
                }
            }
        } else {
            ConsoleMessageBuilder.append$default(printer, this.message.text(), null, null, 6, null);
        }
        if (!isFromNetwork || this.request != null) {
            v9 = stackTrace;
            v10 = callFrame = v9 != null ? (CallFrameValue)CollectionsKt.firstOrNull(v9) : null;
            if (callFrame != null && !(((CharSequence)callFrame.url()).length() == 0) && !Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined")) {
                ConsoleMessageBuilder.addMessageLink$default(printer, callFrame.url(), callFrame.getLineNumber(), callFrame.getColumnNumber(), callFrame.functionName(), isFromNetwork == false, null, 32, null);
            } else {
                var8_9 = url;
                if (!(var8_9 == null || var8_9.length() == 0) && !Intrinsics.areEqual((Object)url, (Object)"undefined")) {
                    ConsoleMessageBuilder.addMessageLink$default(printer, url, line, 0, null, isFromNetwork == false, null, 32, null);
                }
            }
        }
        if (!isFromNetwork && this.message.level() != LogEntryValue.Level.ERROR) ** GOTO lbl-1000
        v11 = stackTrace;
        if (!(v11 != null ? v11.isEmpty() : true)) {
            v12 = true;
        } else lbl-1000:
        // 2 sources

        {
            v12 = willPrintStackTrace = false;
        }
        if (willPrintStackTrace) {
            printer.printStackTrace(contentType, this.message.getStackTrace());
        }
        printer.endMessage();
    }

    private final void printFailedNetworkRequestMessage(ConsoleMessageBuilder printer) {
        RequestInfo requestInfo = this.request;
        Intrinsics.checkNotNull((Object)requestInfo);
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            Intrinsics.checkNotNull((Object)string);
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                Intrinsics.checkNotNull((Object)string);
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LogEntryValue.Level.values().length];
            try {
                nArray[LogEntryValue.Level.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogEntryValue.Level.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogEntryValue.Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogEntryValue.Level.VERBOSE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

